/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.constant.PACommonConstans;
import kd.fi.pa.dataAdjust.DataAdjustUtils;
import kd.fi.pa.dto.PADynamicEntryDTO;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.MeasureTypeEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PADataAdjustFormPlugin
extends AbstractBillPlugIn {
    private static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
    private static final Set<String> baseEntityIdSet = new HashSet<String>(16);
    private static final String summaryDetailCache = "summaryDetailMapping";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        OperationStatus status = e.getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            Object pkId = ((BillShowParameter)e.getSource()).getPkId();
            if (pkId == null) {
                return;
            }
            String errMsg = DataAdjustUtils.existDBTable((Object)pkId);
            if (!StringUtils.isEmpty((String)errMsg)) {
                e.setCancel(true);
                e.setCancelMessage(errMsg);
                return;
            }
            if (!DataAdjustUtils.getWrongAdjustJsonDataBillno((Object[])new Object[]{pkId}).isEmpty()) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u8c03\u6574\u5355\u7ef4\u5ea6\u6216\u5ea6\u91cf\u4e0e\u5206\u6790\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u4ec5\u53ef\u5220\u9664\u3002", (String)"PADataAdjustFormPlugin_26", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        IDataEntityProperty property = model.getProperty("billstatus");
        if (property != null) {
            String billstatus;
            switch (billstatus = (String)model.getValue("billstatus")) {
                case "A": {
                    showParameter.setBillStatus(BillOperationStatus.EDIT);
                    break;
                }
                case "B": {
                    showParameter.setBillStatus(BillOperationStatus.SUBMIT);
                    break;
                }
                case "C": 
                case "D": {
                    showParameter.setBillStatus(BillOperationStatus.VIEW);
                    break;
                }
                case "E": {
                    showParameter.setBillStatus(BillOperationStatus.AUDIT);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.processDefaultData(model, view);
            this.setAdjustJsonColumn(model);
        }
    }

    public void beforeBindData(EventObject e) {
        Object periodId;
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        this.setPeriodBaseEntityId(model, view);
        String baseEntityId = (String)model.getValue("periodbasetype");
        if ("bd_period".equals(baseEntityId)) {
            return;
        }
        model.beginInit();
        if (StringUtils.isNotEmpty((String)baseEntityId) && model.getValue("period") == null && (periodId = model.getValue("period_id")) != null) {
            model.setValue("period", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)baseEntityId));
        }
        model.endInit();
        view.updateView("fs_baseinfo");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        this.showDataAdjustShow(model, view);
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            model.beginInit();
            Object periodId = view.getFormShowParameter().getCustomParams().get("customParamPeriodId");
            model.setValue("period", periodId);
            Object orgId = view.getFormShowParameter().getCustomParams().get("customParamOrgId");
            if (orgId != null) {
                model.setValue("createorg", orgId);
            }
            view.updateView("fs_baseinfo");
            model.endInit();
        }
        model.setDataChanged(false);
        String checkConditionId = (String)this.getView().getFormShowParameter().getCustomParam("checkconditionid");
        if (StringUtils.isNotEmpty((String)checkConditionId)) {
            this.setVisibleAndEnableByDataCheck();
        }
    }

    private void setVisibleAndEnableByDataCheck() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"billno", "analysissystem", "analysismodel", "createorg", "periodtype", "periodbasetype", "period"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"advsel", "advadd"});
    }

    private void setPeriodBaseEntityId(IDataModel model, IFormView view) {
        DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
        if (anaModel == null) {
            model.setValue("period", null);
            return;
        }
        FormPluginUtil.setItemClassTypeEntityId(baseEntityIdSet, anaModel, "1", "periodbasetype", model, view);
        QFilter qFilter = FormPluginUtil.getBaseQFilter(anaModel, "1");
        ItemClassEdit period = (ItemClassEdit)this.getControl("period");
        period.setQFilter(qFilter);
    }

    private void processDefaultData(IDataModel model, IFormView view) {
        FormPluginUtil.processDefaultSysAndModel(model, view);
        this.setPeriodBaseEntityId(model, view);
        String checkConditionId = (String)this.getView().getFormShowParameter().getCustomParam("checkconditionid");
        if (StringUtils.isNotEmpty((String)checkConditionId)) {
            this.getModel().setValue("checkconditionid", (Object)Long.parseLong(checkConditionId));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.initF7();
    }

    private void initF7() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object analysisSystem = model.getValue("analysissystem");
        BasedataEdit analysisModelF7 = (BasedataEdit)this.getControl("analysismodel");
        analysisModelF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (analysisSystem == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PADataAdjustFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("analysis_system", "=", ((DynamicObject)analysisSystem).get("id"));
            qFilter.and(PARuleHelper.getAnalysisPeriodFilter());
            qFilter.and(PARuleHelper.getDateTimeFilterInModel());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("period");
        periodF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
            if (anaModel == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADataAdjustFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object oldValue = changeData.getOldValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propertyName) {
            case "analysissystem": 
            case "analysismodel": {
                if (this.checkAdjustData(model)) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5206\u6790\u4f53\u7cfb\u6216\u5206\u6790\u6a21\u578b\u4f1a\u6e05\u7a7a\u8c03\u6574\u8868\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PADataAdjustFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackAnalysis", (IFormPlugin)this), null, propertyName + ',' + (oldValue == null ? "0" : ((DynamicObject)oldValue).get("id")));
                    break;
                }
                if ("analysissystem".equals(propertyName)) {
                    this.setAnalysisModelDefault(model, view);
                }
                this.setPeriodBaseEntityId(model, view);
                this.setAdjustJsonColumn(model);
                this.showDataAdjustShow(model, view);
                break;
            }
            case "period": {
                if (!this.checkAdjustData(model)) break;
                view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u671f\u95f4\u4f1a\u6e05\u7a7a\u8c03\u6574\u8868\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PADataAdjustFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackAnalysis", (IFormPlugin)this), null, propertyName + ',' + (oldValue == null ? "0" : ((DynamicObject)oldValue).get("id")));
                break;
            }
            case "periodbasetype": {
                model.beginInit();
                model.setValue("period", null);
                model.endInit();
                view.updateView("fs_baseinfo");
            }
        }
    }

    private void setAdjustJsonColumn(IDataModel model) {
        model.setValue("adjustjson_tag", null);
        DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
        if (anaModel == null) {
            return;
        }
        Map columnMap = PAAnalysisModelHelper.queryDimensionAndMeasureById((Object)anaModel.get("id"));
        DynamicObject[] dims = (DynamicObject[])columnMap.get("dimensionmapentry");
        DynamicObject[] meas = (DynamicObject[])columnMap.get("measuremapentry");
        meas = (DynamicObject[])Arrays.stream(meas).filter(mea -> MeasureTypeEnum.ORDINARY == MeasureTypeEnum.getEnum((String)mea.getString("measuretype"))).toArray(DynamicObject[]::new);
        String[][] columns = new String[dims.length + meas.length + 5][];
        int i = 0;
        columns[i] = new String[8];
        columns[i][0] = "3";
        columns[i][1] = "adjustseq";
        columns[i][2] = ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"PADataAdjustFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        columns[i][4] = "false";
        columns[i][5] = "false";
        columns[i][6] = "true";
        columns[i++][7] = "false";
        columns[i] = new String[8];
        columns[i][0] = "3";
        columns[i][1] = "adjustdatastate";
        columns[i][2] = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"PADataAdjustFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        columns[i][4] = "false";
        columns[i][5] = "false";
        columns[i][6] = "true";
        columns[i++][7] = "false";
        DynamicObjectCollection dimEntryCol = anaModel.getDynamicObjectCollection("dimension_entry");
        HashMap<String, LinkedHashMap> dimenumsMap = new HashMap<String, LinkedHashMap>(2);
        for (DynamicObject dim : dims) {
            DimensionNecessityEnum necessityEnum;
            String dimnumber;
            DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dim.getString("dimensiontype"));
            columns[i] = new String[8];
            columns[i][0] = String.valueOf(dimType.getType());
            columns[i][1] = dimnumber = dim.getString("number").toLowerCase(Locale.ENGLISH);
            columns[i][2] = dim.getString("name");
            if (DimensionTypeEnum.ASSISTANTDATA == dimType || DimensionTypeEnum.DATABASE == dimType) {
                String string = columns[i][3] = DimensionTypeEnum.ASSISTANTDATA == dimType ? dim.getDynamicObject("assistantsource").get("id").toString() : dim.getDynamicObject("dimensionsource").getString("number");
            }
            if ((necessityEnum = DimensionNecessityEnum.getEnum((String)((DynamicObject)dimEntryCol.get(i - 2)).getString("necessity_dim"))) == null) {
                columns[i][4] = "false";
                columns[i][5] = "true";
            } else if (necessityEnum == DimensionNecessityEnum.ACCOUNT) {
                columns[i][4] = "true";
                columns[i][5] = "true";
            } else {
                columns[i][4] = "true";
                columns[i][5] = "false";
            }
            columns[i][6] = "true";
            columns[i++][7] = "false";
            DynamicObjectCollection entryentityenums = dim.getDynamicObjectCollection("entryentityenums");
            if (CollectionUtils.isEmpty((Collection)entryentityenums)) continue;
            dimenumsMap.put(dimnumber, entryentityenums.stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title"), (o1, o2) -> o1, LinkedHashMap::new)));
        }
        for (DynamicObject mea2 : meas) {
            String notCalculate;
            String meaType;
            columns[i] = new String[9];
            columns[i][0] = "99";
            columns[i][1] = mea2.getString("number").toLowerCase(Locale.ENGLISH);
            columns[i][2] = mea2.getString("name");
            columns[i][3] = meaType = mea2.getString("measuretype");
            columns[i][4] = notCalculate = String.valueOf(!"2".equals(meaType));
            columns[i][5] = notCalculate;
            columns[i][6] = "true";
            columns[i][7] = "false";
            columns[i++][8] = String.valueOf(10);
        }
        columns[i] = new String[8];
        columns[i][0] = "3";
        columns[i][1] = "remark";
        columns[i][2] = ResManager.loadKDString((String)"\u6458\u8981", (String)"PADataAdjustFormPlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        columns[i][4] = "true";
        columns[i][5] = "true";
        columns[i][6] = "true";
        columns[i++][7] = "false";
        columns[i] = new String[8];
        columns[i][0] = "3";
        columns[i][1] = "valid";
        columns[i][2] = ResManager.loadKDString((String)"\u72b6\u6001", (String)"PADataAdjustFormPlugin_22", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        columns[i][4] = "false";
        columns[i][5] = "false";
        columns[i][6] = "false";
        columns[i++][7] = "false";
        columns[i] = new String[8];
        columns[i][0] = "3";
        columns[i][1] = "id";
        columns[i][2] = "fid";
        columns[i][4] = "false";
        columns[i][5] = "false";
        columns[i][6] = "false";
        columns[i][7] = "false";
        Object[][] data = null;
        HashMap<String, String> dataStyleMap = null;
        String checkConditionId = (String)this.getView().getFormShowParameter().getCustomParam("checkconditionid");
        if (StringUtils.isNotEmpty((String)checkConditionId)) {
            int i1;
            JSONArray dataArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("entry_data");
            data = new Object[dataArray.size()][];
            for (i1 = 0; i1 < dataArray.size(); ++i1) {
                JSONArray array = dataArray.getJSONArray(i1);
                data[i1] = new Object[array.size()];
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    data[i1][i2] = array.get(i2);
                }
            }
            if (ArrayUtils.isNotEmpty((Object[])data)) {
                dataStyleMap = new HashMap<String, String>(data.length);
                for (i1 = 0; i1 < data.length; ++i1) {
                    dataStyleMap.put("adjustdatastate," + i1, "gray");
                }
            }
        }
        PADynamicEntryDTO paDynamicEntryDTO = new PADynamicEntryDTO(true, false, "adjusttreeentry", columns, data, dataStyleMap, null, dimenumsMap);
        List<PADynamicEntryDTO> dynamicEntryDTOS = Collections.singletonList(paDynamicEntryDTO);
        model.setValue("adjustjson_tag", (Object)JSON.toJSONString(dynamicEntryDTOS));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("closeCallbackSourceData".equalsIgnoreCase(actionId)) {
            if (result == null) {
                return;
            }
            Map resultMap = (Map)result;
            String opeType = (String)resultMap.get("opeType");
            Map dynamicEntryDTOMap = (Map)resultMap.get("data");
            String adjustJson = (String)model.getValue("adjustjson_tag");
            List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
            PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
            Object[][] columns = dynamicEntryDTO.getColumns();
            Object[][] oldData = dynamicEntryDTO.getData();
            int adjustSeq = 0;
            if (oldData == null) {
                oldData = new Object[][]{};
            } else {
                for (int i = oldData.length - 1; i >= 0; --i) {
                    String lastSeq = (String)oldData[i][0];
                    if (!StringUtils.isNotEmpty((String)lastSeq)) continue;
                    adjustSeq = Integer.parseInt(lastSeq);
                    break;
                }
            }
            HashMap<String, String> dataStyleMap = dynamicEntryDTO.getDataStyle();
            switch (opeType) {
                case "1": 
                case "2": {
                    boolean selectFlag = "1".equals(opeType);
                    PADynamicEntryDTO addDTO = (PADynamicEntryDTO)dynamicEntryDTOMap.get(selectFlag ? "sourcedataentry" : "adjustresultentry");
                    Object[][] addData = addDTO.getData();
                    int validIndex = DataAdjustUtils.getValidFieldIndex((Object[][])addDTO.getColumns());
                    if (validIndex != -1 && "1".equals(opeType)) {
                        IntStream.iterate(0, seed -> seed + 1).limit(addData.length).forEach(index -> {
                            addData[index][validIndex] = ResManager.loadKDString((String)"\u6709\u6548", (String)"PADataAdjustFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        });
                    }
                    this.saveSummaryDetailToCache(addData);
                    Object[][] newData = new Object[oldData.length + addData.length][columns.length];
                    System.arraycopy(oldData, 0, newData, 0, oldData.length);
                    long[] ids = null;
                    if (!selectFlag) {
                        ids = DB.genGlobalLongIds((int)addData.length);
                    }
                    int idx = 0;
                    for (int i = oldData.length; i < newData.length; ++i) {
                        System.arraycopy(addData[idx], 0, newData[i], 2, addData[idx++].length);
                        newData[i][0] = String.valueOf(++adjustSeq);
                        Object object = newData[i][1] = selectFlag ? ResManager.loadKDString((String)"\u8c03\u6574\u524d", (String)"PADataAdjustFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65b0\u589e", (String)"PADataAdjustFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        if (!selectFlag && ids != null) {
                            newData[i][columns.length - 1] = ids[i - oldData.length];
                        }
                        if (dataStyleMap == null) {
                            dataStyleMap = new HashMap<String, String>(16);
                        }
                        dataStyleMap.put("adjustdatastate," + i, selectFlag ? "gray" : "red");
                    }
                    dynamicEntryDTO.setData(newData);
                    dynamicEntryDTO.setDataStyle((Map)dataStyleMap);
                    break;
                }
                case "3": {
                    int styleIdx;
                    String[] keyAndIdx;
                    HashMap supSonMap = dynamicEntryDTO.getSupSonMap();
                    if (supSonMap == null) {
                        supSonMap = new HashMap(2);
                    }
                    String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
                    IFormView subView = view.getView(subPageId);
                    IDataModel subModel = subView.getModel();
                    int curIdx = subModel.getEntryCurrentRowIndex("adjusttreeentry");
                    int value = curIdx = supSonMap.getOrDefault(curIdx, curIdx).intValue();
                    Set subIdxSet = supSonMap.entrySet().stream().filter(p -> Objects.equals(p.getValue(), value)).map(Map.Entry::getKey).collect(Collectors.toSet());
                    PADynamicEntryDTO modifyDTO = (PADynamicEntryDTO)dynamicEntryDTOMap.get("adjustresultentry");
                    Object[][] modifyData = modifyDTO.getData();
                    Map modifyDataStyleMap = modifyDTO.getDataStyle();
                    int validIndex = DataAdjustUtils.getValidFieldIndex((Object[][])modifyDTO.getColumns());
                    if (validIndex != -1) {
                        IntStream.iterate(0, seed -> seed + 1).limit(modifyData.length).forEach(index -> {
                            modifyData[index][validIndex] = " ";
                        });
                    }
                    int addDataCnt = modifyData.length - subIdxSet.size();
                    Object[][] newData = new Object[oldData.length + addDataCnt][columns.length];
                    System.arraycopy(oldData, 0, newData, 0, curIdx + 1);
                    System.arraycopy(oldData, curIdx + 1 + subIdxSet.size(), newData, curIdx + 1 + modifyData.length, oldData.length - subIdxSet.size() - curIdx - 1);
                    HashMap<Integer, Integer> newSupSonMap = new HashMap<Integer, Integer>(16);
                    for (Map.Entry entry : supSonMap.entrySet()) {
                        Integer subIdx = (Integer)entry.getKey();
                        if (subIdxSet.contains(subIdx)) continue;
                        Integer supIdx = (Integer)entry.getValue();
                        newSupSonMap.put(subIdx <= curIdx ? subIdx : subIdx + addDataCnt, supIdx <= curIdx ? supIdx : supIdx + addDataCnt);
                    }
                    HashMap newDataStyleMap = new HashMap(16);
                    for (Map.Entry entry : dataStyleMap.entrySet()) {
                        keyAndIdx = ((String)entry.getKey()).split(",");
                        styleIdx = Integer.parseInt(keyAndIdx[1]);
                        if (subIdxSet.contains(styleIdx)) continue;
                        styleIdx = styleIdx <= curIdx ? styleIdx : styleIdx + addDataCnt;
                        newDataStyleMap.put(keyAndIdx[0] + ',' + styleIdx, entry.getValue());
                    }
                    long[] ids = DB.genGlobalLongIds((int)modifyData.length);
                    int idx = 0;
                    for (int i = curIdx + 1; i < curIdx + 1 + modifyData.length; ++i) {
                        System.arraycopy(modifyData[idx], 0, newData[i], 2, modifyData[idx++].length);
                        newData[i][1] = ResManager.loadKDString((String)"\u8c03\u6574\u540e", (String)"PADataAdjustFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        newData[i][columns.length - 1] = ids[i - curIdx - 1];
                        newDataStyleMap.put("adjustdatastate," + i, "orange");
                        newSupSonMap.put(i, curIdx);
                    }
                    if (modifyDataStyleMap != null) {
                        for (Map.Entry entry : modifyDataStyleMap.entrySet()) {
                            keyAndIdx = ((String)entry.getKey()).split(",");
                            styleIdx = Integer.parseInt(keyAndIdx[1]);
                            String styleColumn = keyAndIdx[0].substring(0, keyAndIdx[0].length() - 1);
                            newDataStyleMap.put(styleColumn + ',' + (styleIdx + curIdx + 1), entry.getValue());
                        }
                    }
                    dynamicEntryDTO.setData(newData);
                    dynamicEntryDTO.setSupSonMap(newSupSonMap);
                    dynamicEntryDTO.setDataStyle(newDataStyleMap);
                    break;
                }
                case "3_2": {
                    String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
                    IFormView subView = view.getView(subPageId);
                    IDataModel subModel = subView.getModel();
                    PADynamicEntryDTO modifyDTO = (PADynamicEntryDTO)dynamicEntryDTOMap.get("adjustresultentry");
                    Object[][] data = modifyDTO.getData();
                    int curIdx = subModel.getEntryCurrentRowIndex("adjusttreeentry");
                    System.arraycopy(data[0], 0, oldData[curIdx], 2, data[0].length);
                    break;
                }
                case "4": {
                    PADynamicEntryDTO sourcedataentry = (PADynamicEntryDTO)dynamicEntryDTOMap.get("sourcedataentry");
                    Object[][] replaceData = sourcedataentry.getData();
                    int[] adjustEntrySelectRows = this.getAdjustEntrySelectRows();
                    if (adjustEntrySelectRows.length != 1) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5355\u9009\u4e00\u884c\u9700\u8981\u66ff\u6362\u7684\u6e90\u6570\u636e\u3002", (String)"PADataAdjustFormPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    view.getFormShowParameter().setCustomParam("closeCallBackActionId", (Object)actionId);
                    int adjustEntrySelectRowIndex = adjustEntrySelectRows[0];
                    System.arraycopy(replaceData[0], 0, oldData[adjustEntrySelectRowIndex], 2, replaceData[0].length);
                    int validIndex = DataAdjustUtils.getValidFieldIndex((Object[][])columns);
                    oldData[adjustEntrySelectRowIndex][validIndex] = ResManager.loadKDString((String)"\u6709\u6548", (String)"PADataAdjustFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                    Map supSonMap = dynamicEntryDTO.getSupSonMap();
                    if (supSonMap == null || supSonMap.isEmpty()) break;
                    ArrayList supIndexs = new ArrayList(1);
                    if (supSonMap.containsValue(adjustEntrySelectRowIndex)) {
                        for (Map.Entry entry : supSonMap.entrySet()) {
                            if (((Integer)entry.getValue()).compareTo(adjustEntrySelectRowIndex) != 0) continue;
                            supIndexs.add(entry.getKey());
                        }
                    }
                    List<String> skipFields = Arrays.asList("id", "adjustseq", "adjustdatastate", "valid");
                    dataStyleMap.entrySet().removeIf(entrySet -> {
                        String[] fieldAndIndex = ((String)entrySet.getKey()).split(",");
                        return supIndexs.contains(Integer.valueOf(fieldAndIndex[1])) && !skipFields.contains(fieldAndIndex[0]);
                    });
                    for (Integer supIndex : supIndexs) {
                        Object[] supData = oldData[supIndex];
                        for (int i = 0; i < columns.length; ++i) {
                            Object field = columns[i][1];
                            if (skipFields.contains(field) || this.equals(supData[i], oldData[adjustEntrySelectRowIndex][i])) continue;
                            dataStyleMap.put((String)field + "," + supIndex, "red");
                        }
                    }
                    break;
                }
            }
            view.getFormShowParameter().setCustomParam("closeCallBackActionId", (Object)actionId);
            model.setValue("adjustjson_tag", (Object)JSON.toJSONString((Object)dynamicEntryDTOs));
            this.showDataAdjustShow(model, view);
        }
    }

    private boolean equals(Object i, Object j) {
        if (i == null || j == null) {
            return i == j;
        }
        if (i.getClass() != j.getClass()) {
            return false;
        }
        if (i instanceof Integer) {
            return ((Integer)i).compareTo((Integer)j) == 0;
        }
        if (i instanceof Long) {
            return ((Long)i).compareTo((Long)j) == 0;
        }
        if (i instanceof BigDecimal) {
            return ((BigDecimal)i).compareTo((BigDecimal)j) == 0;
        }
        return i.equals(j);
    }

    private int[] getAdjustEntrySelectRows() {
        IFormView view = this.getView();
        String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
        IFormView subView = view.getView(subPageId);
        EntryGrid grid = (EntryGrid)subView.getControl("adjusttreeentry");
        return grid.getSelectRows();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxResult) {
            if ("confirmCallbackAnalysis".equalsIgnoreCase(actionId)) {
                String oldValue = messageBoxClosedEvent.getCustomVaule();
                String[] oldValueArr = oldValue.split(",");
                if ("analysissystem".equals(oldValueArr[0])) {
                    this.setAnalysisModelDefault(model, view);
                }
                this.setPeriodBaseEntityId(model, view);
                this.setAdjustJsonColumn(model);
                this.showDataAdjustShow(model, view);
            } else if ("customAdjustDeleteAdjustData".equalsIgnoreCase(actionId)) {
                String adjustJson = (String)model.getValue("adjustjson_tag");
                String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
                IFormView subView = view.getView(subPageId);
                IDataModel subModel = subView.getModel();
                int curIdx = subModel.getEntryCurrentRowIndex("adjusttreeentry");
                model.setValue("adjustjson_tag", (Object)this.deleteAdjustRows(adjustJson, curIdx));
                this.showDataAdjustShow(model, view);
            } else if ("confirmCallbackSubmit".equalsIgnoreCase(actionId)) {
                view.getPageCache().put("pageCacheSubmitMark", "mark");
                view.invokeOperation("submit");
            }
        } else if ("confirmCallbackAnalysis".equalsIgnoreCase(actionId)) {
            model.beginInit();
            String oldValue = messageBoxClosedEvent.getCustomVaule();
            String[] oldValueArr = oldValue.split(",");
            model.setValue(oldValueArr[0], "0".equals(oldValueArr[1]) ? null : Long.valueOf(Long.parseLong(oldValueArr[1])));
            model.endInit();
            view.updateView("fs_baseinfo");
        }
    }

    /*
     * WARNING - void declaration
     */
    private String deleteAdjustRows(String oldAdjustJson, int curIdx) {
        List dynamicEntryDTOs = (List)JSON.parseObject((String)oldAdjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
        String[][] columns = dynamicEntryDTO.getColumns();
        Object[][] data = dynamicEntryDTO.getData();
        HashMap supSonMap = dynamicEntryDTO.getSupSonMap();
        Map dataStyleMap = dynamicEntryDTO.getDataStyle();
        if (supSonMap == null) {
            supSonMap = new HashMap(2);
        }
        int value = curIdx = supSonMap.getOrDefault(curIdx, curIdx).intValue();
        Set subIdxSet = supSonMap.entrySet().stream().filter(p -> Objects.equals(p.getValue(), value)).map(Map.Entry::getKey).collect(Collectors.toSet());
        subIdxSet.add(curIdx);
        int deleteSize = subIdxSet.size();
        if (data.length == deleteSize) {
            dynamicEntryDTO.setData((Object[][])null);
            dynamicEntryDTO.setSupSonMap(null);
            dynamicEntryDTO.setDataStyle(null);
        } else {
            void var15_19;
            HashMap<Integer, Integer> newSupSonMap = new HashMap<Integer, Integer>(16);
            for (Map.Entry entry : supSonMap.entrySet()) {
                Integer n = (Integer)entry.getKey();
                if (subIdxSet.contains(n)) continue;
                Integer supIdx = (Integer)entry.getValue();
                newSupSonMap.put(n < curIdx ? n : n - deleteSize, supIdx < curIdx ? supIdx : supIdx - deleteSize);
            }
            HashMap newDataStyleMap = new HashMap(16);
            for (Map.Entry entry : dataStyleMap.entrySet()) {
                String[] keyAndIdx = ((String)entry.getKey()).split(",");
                int styleIdx = Integer.parseInt(keyAndIdx[1]);
                if (subIdxSet.contains(styleIdx)) continue;
                styleIdx = styleIdx < curIdx ? styleIdx : styleIdx - deleteSize;
                newDataStyleMap.put(keyAndIdx[0] + ',' + styleIdx, entry.getValue());
            }
            Object[][] dataCopy = new Object[data.length - deleteSize][columns.length];
            System.arraycopy(data, curIdx + deleteSize, data, curIdx, data.length - (curIdx + deleteSize));
            System.arraycopy(data, 0, dataCopy, 0, data.length - deleteSize);
            int n = curIdx;
            while (var15_19 < dataCopy.length) {
                String oldSeq = (String)dataCopy[var15_19][0];
                if (StringUtils.isNotEmpty((String)oldSeq)) {
                    dataCopy[var15_19][0] = String.valueOf(Integer.parseInt(oldSeq) - 1);
                }
                ++var15_19;
            }
            dynamicEntryDTO.setData(dataCopy);
            dynamicEntryDTO.setSupSonMap(newSupSonMap.isEmpty() ? null : newSupSonMap);
            dynamicEntryDTO.setDataStyle(newDataStyleMap);
        }
        return JSON.toJSONString((Object)dynamicEntryDTOs);
    }

    private boolean checkAdjustData(IDataModel model) {
        String adjustJson = (String)model.getValue("adjustjson_tag");
        if (StringUtils.isEmpty((String)adjustJson)) {
            return false;
        }
        List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        return dynamicEntryDTOs != null && !dynamicEntryDTOs.isEmpty() && ((PADynamicEntryDTO)dynamicEntryDTOs.get(0)).getData() != null;
    }

    private void setAnalysisModelDefault(IDataModel model, IFormView view) {
        DynamicObject anaSystem = (DynamicObject)model.getValue("analysissystem");
        model.beginInit();
        if (anaSystem == null) {
            model.setValue("analysismodel", null);
        } else {
            DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", anaSystem.get("id")).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter()).and(PARuleHelper.getDateTimeFilterInModel())}, (String)"number", (int)1);
            if (anaModel == null || anaModel.isEmpty()) {
                model.setValue("analysismodel", null);
            } else {
                model.setValue("analysismodel", ((DynamicObject)anaModel.get(0)).get("id"));
            }
        }
        model.endInit();
        view.updateView("fs_baseinfo");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
        IFormView subView = view.getView(subPageId);
        EntryGrid grid = (EntryGrid)subView.getControl("adjusttreeentry");
        int[] selectRows = grid.getSelectRows();
        switch (itemKey) {
            case "advsel": 
            case "advadd": 
            case "advrep": {
                if (model.getValue("period") == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4\u3002", (String)"PADataAdjustFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                String caption = "";
                String openType = "";
                if (itemKey.equals("advsel")) {
                    caption = ResManager.loadKDString((String)"\u9009\u62e9\u6e90\u6570\u636e", (String)"PADataAdjustFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                    openType = "1";
                } else if (itemKey.equals("advadd")) {
                    caption = ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u884c", (String)"PADataAdjustFormPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                    openType = "2";
                } else {
                    DynamicObjectCollection entryEntity = subView.getModel().getEntryEntity("adjusttreeentry");
                    String adjustDataStatus = ResManager.loadKDString((String)"\u8c03\u6574\u524d", (String)"PADataAdjustFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                    if (selectRows.length == 1 && adjustDataStatus.equals(((DynamicObject)entryEntity.get(selectRows[0])).getString("adjustdatastate"))) {
                        caption = ResManager.loadKDString((String)"\u66ff\u6362\u6e90\u6570\u636e", (String)"PADataAdjustFormPlugin_27", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        openType = "4";
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5355\u9009\u4e00\u884c\u9700\u8981\u66ff\u6362\u7684\u6e90\u6570\u636e\u3002", (String)"PADataAdjustFormPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                this.showSelectSourceData(model, view, openType, caption);
                break;
            }
            case "advmod": {
                if (selectRows.length < 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4fee\u6539\u7684\u8c03\u6574\u8868\u6570\u636e\u3002", (String)"PADataAdjustFormPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                String adjustJson = (String)model.getValue("adjustjson_tag");
                List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
                PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
                Map dataStyleMap = dynamicEntryDTO.getDataStyle();
                if ("red".equals(dataStyleMap.get("adjustdatastate," + selectRows[0]))) {
                    this.showSelectSourceData(model, view, "3_2", ResManager.loadKDString((String)"\u4fee\u6539\u65b0\u589e\u6570\u636e", (String)"PADataAdjustFormPlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showSelectSourceData(model, view, "3", ResManager.loadKDString((String)"\u4fee\u6539\u6e90\u6570\u636e", (String)"PADataAdjustFormPlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "advdel": {
                if (selectRows.length < 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8c03\u6574\u8868\u6570\u636e\u3002", (String)"PADataAdjustFormPlugin_28", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                view.showConfirm(ResManager.loadKDString((String)"\u5220\u884c\u4f1a\u5bfc\u81f4\u8fd9\u4e00\u884c\u7684\u6570\u636e\u4fe1\u606f\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"PADataAdjustFormPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("customAdjustDeleteAdjustData", (IFormPlugin)this));
            }
        }
    }

    private void showSelectSourceData(IDataModel model, IFormView view, String opeType, String caption) {
        if (this.checkAnaModel(model, view)) {
            List<PADynamicEntryDTO> dynamicEntryDTOS = this.getSelectSourceDataDTO(model, view, opeType);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pa_select_sourcedata");
            showParameter.setCaption(caption);
            showParameter.setCustomParam("customAdjustDataOperateType", (Object)opeType);
            showParameter.setCustomParam("customEntryInfo", (Object)JSON.toJSONString(dynamicEntryDTOS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            showParameter.setCustomParam("analysismodel", model.getValue("analysismodel_id"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallbackSourceData"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        }
    }

    private List<PADynamicEntryDTO> getSelectSourceDataDTO(IDataModel model, IFormView view, String opeType) {
        String adjustJson = (String)model.getValue("adjustjson_tag");
        List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
        Map dimEnumMap = dynamicEntryDTO.getDimEnumMap();
        String[][] columns = dynamicEntryDTO.getColumns();
        String[][] columnsCopy = new String[columns.length - 2][];
        System.arraycopy(columns, 2, columnsCopy, 0, columnsCopy.length);
        switch (opeType) {
            case "1": 
            case "4": {
                String selectColumn = "";
                for (String[] column2 : columnsCopy) {
                    List<String> excludeFields = Arrays.asList("remark", "valid");
                    if (excludeFields.contains(column2[1])) {
                        column2[6] = "false";
                        continue;
                    }
                    column2[7] = "true";
                    selectColumn = "".equals(selectColumn) ? column2[1] : selectColumn + ',' + column2[1];
                }
                DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
                String entityNumber = PACommonConstans.buildEntityName((String)anaModel.getString("tablenumber"));
                DynamicObjectCollection dimEntryCol = anaModel.getDynamicObjectCollection("dimension_entry");
                QFilter filter = new QFilter("collectstatus", "=", (Object)1).and("situationtype", "=", (Object)0).and("del", "!=", (Object)1).and("id", "not in", this.getSelectedId(model));
                for (DynamicObject dyo : dimEntryCol) {
                    if (DimensionNecessityEnum.ORG.getCode().equals(dyo.getString("necessity_dim"))) {
                        filter.and(dyo.getDynamicObject("dimension").getString("number"), "=", model.getValue("createorg_id"));
                        continue;
                    }
                    if (!DimensionNecessityEnum.PERIOD.getCode().equals(dyo.getString("necessity_dim"))) continue;
                    filter.and(dyo.getDynamicObject("dimension").getString("number"), "=", model.getValue("period_id"));
                }
                return Collections.singletonList(new PADynamicEntryDTO(false, true, "sourcedataentry", columnsCopy, (Object[][])null, null, null, dimEnumMap, entityNumber, selectColumn, filter.toSerializedString()));
            }
            case "2": {
                for (String[] column3 : columnsCopy) {
                    if ("99".equals(column3[0]) && "2".equals(column3[3])) continue;
                    if ("valid".equals(column3[1])) {
                        column3[6] = "false";
                        continue;
                    }
                    column3[5] = "true";
                }
                return Collections.singletonList(new PADynamicEntryDTO(false, true, "adjustresultentry", columnsCopy, (Object[][])null, null, null, dimEnumMap));
            }
            case "3_2": {
                String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
                IFormView subView = view.getView(subPageId);
                IDataModel subModel = subView.getModel();
                Object[][] data = dynamicEntryDTO.getData();
                int curIdx = subModel.getEntryCurrentRowIndex("adjusttreeentry");
                Object[][] sourceDataCopy = new Object[1][columnsCopy.length];
                System.arraycopy(data[curIdx], 2, sourceDataCopy[0], 0, sourceDataCopy[0].length);
                PADynamicEntryDTO adjustResultDataDTO = new PADynamicEntryDTO(false, true, "adjustresultentry", columnsCopy, sourceDataCopy, null, null, dimEnumMap);
                return Collections.singletonList(adjustResultDataDTO);
            }
            case "3": {
                Object[][] resultDataCopy;
                String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
                IFormView subView = view.getView(subPageId);
                IDataModel subModel = subView.getModel();
                int curIdx = subModel.getEntryCurrentRowIndex("adjusttreeentry");
                HashMap supSonMap = dynamicEntryDTO.getSupSonMap();
                if (supSonMap == null) {
                    supSonMap = new HashMap(2);
                }
                curIdx = supSonMap.getOrDefault(curIdx, curIdx);
                Object[][] data = dynamicEntryDTO.getData();
                Object[][] sourceDataCopy = new Object[1][columnsCopy.length];
                System.arraycopy(data[curIdx], 2, sourceDataCopy[0], 0, sourceDataCopy[0].length);
                List hideColumnOps = Arrays.stream(columnsCopy).filter(column -> "remark".equals(column[1]) || "valid".equals(column[1])).collect(Collectors.toList());
                if (!hideColumnOps.isEmpty()) {
                    for (String[] hideColumnOp : hideColumnOps) {
                        hideColumnOp[6] = "false";
                    }
                }
                PADynamicEntryDTO sourceDataDTO = new PADynamicEntryDTO(false, true, "sourcedataentry1", columnsCopy, sourceDataCopy, null, null, dimEnumMap);
                String[][] columnsCopy1 = new String[columnsCopy.length][];
                HashMap<String, LinkedHashMap> entry = new HashMap<String, LinkedHashMap>(dimEnumMap.size());
                for (int i = 0; i < columnsCopy.length; ++i) {
                    String[] column4 = columnsCopy[i];
                    String[] column1 = new String[column4.length];
                    System.arraycopy(column4, 0, column1, 0, column4.length);
                    String oldName = column1[1];
                    column1[1] = column1[1] + '?';
                    LinkedHashMap stringStringLinkedHashMap = (LinkedHashMap)dimEnumMap.get(oldName);
                    if (stringStringLinkedHashMap != null) {
                        entry.put(column1[1], stringStringLinkedHashMap);
                    }
                    if ("remark".equals(oldName)) {
                        column1[6] = "true";
                    }
                    columnsCopy1[i] = column1;
                }
                int value = curIdx;
                Set subIdxSet = supSonMap.entrySet().stream().filter(p -> Objects.equals(p.getValue(), value)).map(Map.Entry::getKey).collect(Collectors.toSet());
                Map dataStyleMap = dynamicEntryDTO.getDataStyle();
                HashMap dataStyleModMap = new HashMap(8);
                if (!subIdxSet.isEmpty()) {
                    resultDataCopy = new Object[subIdxSet.size()][columnsCopy1.length];
                    int subIdx = 0;
                    for (Integer idx : subIdxSet) {
                        System.arraycopy(data[idx], 2, resultDataCopy[subIdx], 0, resultDataCopy[subIdx].length);
                        for (int i = 1; i < columns.length; ++i) {
                            String[] column5 = columns[i];
                            String styleKey = column5[1] + ',' + idx;
                            if (!dataStyleMap.containsKey(styleKey)) continue;
                            dataStyleModMap.put(column5[1] + "?," + subIdx, dataStyleMap.get(styleKey));
                        }
                        ++subIdx;
                    }
                } else {
                    resultDataCopy = sourceDataCopy;
                }
                PADynamicEntryDTO adjustResultDataDTO = new PADynamicEntryDTO(false, true, "adjustresultentry", columnsCopy1, resultDataCopy, dataStyleModMap.isEmpty() ? null : dataStyleModMap, null, entry);
                return Arrays.asList(sourceDataDTO, adjustResultDataDTO);
            }
        }
        return null;
    }

    private void showDataAdjustShow(IDataModel model, IFormView view) {
        String subPageId = view.getPageCache().get("pageCacheDataAdjustShowPageId");
        if (StringUtils.isNotEmpty((String)subPageId)) {
            view.getView(subPageId).close();
        }
        this.adjustJsonValidCheck();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pa_dataadjust_show");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("advconchildcanelap");
        showParameter.setCustomParam("customEntryInfo", model.getValue("adjustjson_tag"));
        view.showForm(showParameter);
        view.getPageCache().put("pageCacheDataAdjustShowPageId", showParameter.getPageId());
    }

    private boolean executeAdjustJsonValidCheck() {
        IDataModel model = this.getModel();
        if (model.getDataEntity().getDataEntityType().getProperties().get((Object)"billstatus") == null) {
            return false;
        }
        String closeCallBackActionId = (String)this.getView().getFormShowParameter().getCustomParam("closeCallBackActionId");
        if (closeCallBackActionId != null && !closeCallBackActionId.isEmpty() || "closeCallbackSourceData".equals(closeCallBackActionId)) {
            return false;
        }
        String adjustJson = (String)model.getValue("adjustjson_tag");
        return adjustJson != null && !StringUtils.isBlank((String)adjustJson);
    }

    private String[][] validStyleDefaultValueSet(int validIndex, String[][] columns) {
        if (validIndex == -1) {
            int orgColumnLength = columns.length;
            String[][] newColums = new String[orgColumnLength + 1][];
            validIndex = orgColumnLength - 1;
            System.arraycopy(columns, 0, newColums, 0, validIndex);
            newColums[validIndex] = new String[8];
            newColums[validIndex][0] = "3";
            newColums[validIndex][1] = "valid";
            newColums[validIndex][2] = ResManager.loadKDString((String)"\u72b6\u6001", (String)"PADataAdjustFormPlugin_22", (String)"fi-pa-formplugin", (Object[])new Object[0]);
            newColums[validIndex][4] = "false";
            newColums[validIndex][5] = "false";
            newColums[validIndex][6] = "true";
            newColums[validIndex][7] = "false";
            System.arraycopy(columns, validIndex, newColums, orgColumnLength, 1);
            return newColums;
        }
        return null;
    }

    private void validFieldShowControl(List<PADynamicEntryDTO> dynamicEntryDTOs, String[][] columns, int validIndex) {
        IDataModel model = this.getModel();
        if (validIndex != -1) {
            OperationStatus billStatus = this.getView().getFormShowParameter().getStatus();
            if ("A".equals(model.getValue("billstatus")) && OperationStatus.EDIT.equals((Object)billStatus)) {
                columns[validIndex][6] = "true";
            } else {
                columns[validIndex][6] = "false";
                model.setValue("adjustjson_tag", (Object)JSON.toJSONString(dynamicEntryDTOs));
                model.setDataChanged(false);
            }
        }
    }

    private void adjustJsonValidCheck() {
        IDataModel model = this.getModel();
        if (!this.executeAdjustJsonValidCheck()) {
            return;
        }
        String adjustJson = (String)model.getValue("adjustjson_tag");
        List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
        Object[][] columns = dynamicEntryDTO.getColumns();
        int validIndex = DataAdjustUtils.getValidFieldIndex((Object[][])columns);
        this.validFieldShowControl(dynamicEntryDTOs, (String[][])columns, validIndex);
        Object[][] columnDatas = dynamicEntryDTO.getData();
        if (columnDatas == null) {
            return;
        }
        String excludeFields = String.join((CharSequence)",", "remark", "valid", "adjustseq", "adjustdatastate");
        List excludeIndexs = IntStream.iterate(0, seed -> seed + 1).limit(columns.length).filter(arg_0 -> PADataAdjustFormPlugin.lambda$adjustJsonValidCheck$17(excludeFields, (String[][])columns, arg_0)).boxed().collect(Collectors.toList());
        Object[][] newColumn = this.validStyleDefaultValueSet(validIndex, (String[][])columns);
        if (newColumn != null) {
            dynamicEntryDTO.setColumns((String[][])newColumn);
            validIndex = DataAdjustUtils.getValidFieldIndex((Object[][])newColumn);
        }
        int idIndex = DataAdjustUtils.getIdFieldIndex((Object[][])dynamicEntryDTO.getColumns());
        String entityNumber = PACommonConstans.buildEntityName((String)((DynamicObject)model.getValue("analysismodel")).getString("tablenumber"));
        QFilter commonQfilter = new QFilter("collectstatus", "=", (Object)1).and("situationtype", "=", (Object)0).and("del", "!=", (Object)1);
        int oriColumnDatasLength = columnDatas.length;
        HashSet<Integer> unvalidIndexs = new HashSet<Integer>(oriColumnDatasLength);
        HashMap<Integer, Long> validIndexs = new HashMap<Integer, Long>(oriColumnDatasLength);
        List sourceDataRow = DataAdjustUtils.getSourceDataRow((Map)dynamicEntryDTO.getDataStyle());
        for (int i = 0; i < oriColumnDatasLength; ++i) {
            Object[] columnData = columnDatas[i];
            if (!sourceDataRow.contains(i)) continue;
            QFilter rowcolumnData = commonQfilter.copy();
            for (int j = 0; j < columnData.length; ++j) {
                if (excludeIndexs.contains(j)) continue;
                rowcolumnData.and(new QFilter((String)columns[j][1], "=", columnData[j]));
            }
            DynamicObject validData = DataAdjustUtils.isValidRowData((String)entityNumber, (QFilter[])new QFilter[]{rowcolumnData});
            if (validData == null) {
                unvalidIndexs.add(i);
                continue;
            }
            validIndexs.put(i, validData.getLong("id"));
        }
        if (columnDatas[0].length != dynamicEntryDTO.getColumns().length) {
            Object[][] newColumnDatas = new Object[oriColumnDatasLength][];
            for (int i = 0; i < oriColumnDatasLength; ++i) {
                Object[] columnData = columnDatas[i];
                Object[] newColumnData = new Object[columnData.length + 1];
                for (int j = 0; j < newColumnData.length; ++j) {
                    if (j == validIndex) {
                        if (validIndexs.containsKey(i)) {
                            newColumnData[validIndex] = ResManager.loadKDString((String)"\u6709\u6548", (String)"PADataAdjustFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                            newColumnData[idIndex] = validIndexs.get(i);
                            continue;
                        }
                        if (unvalidIndexs.contains(i)) {
                            newColumnData[validIndex] = ResManager.loadKDString((String)"\u5931\u6548", (String)"PADataAdjustFormPlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                            continue;
                        }
                        newColumnData[validIndex] = " ";
                        continue;
                    }
                    newColumnData[j] = j < validIndex ? columnData[j] : columnData[j - 1];
                }
                newColumnDatas[i] = newColumnData;
            }
            dynamicEntryDTO.setData(newColumnDatas);
        } else {
            Object[][] data = dynamicEntryDTO.getData();
            sourceDataRow = DataAdjustUtils.getSourceDataRow((Map)dynamicEntryDTO.getDataStyle());
            for (int i = 0; i < data.length; ++i) {
                Object[] rowData = data[i];
                String validStr = " ";
                if (sourceDataRow.contains(i)) {
                    if (validIndexs.containsKey(i)) {
                        validStr = ResManager.loadKDString((String)"\u6709\u6548", (String)"PADataAdjustFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                        rowData[idIndex] = validIndexs.get(i);
                    }
                    if (unvalidIndexs.contains(i)) {
                        validStr = ResManager.loadKDString((String)"\u5931\u6548", (String)"PADataAdjustFormPlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                    }
                }
                rowData[validIndex] = validStr;
            }
        }
        Map dataStyle = dynamicEntryDTO.getDataStyle();
        this.setValidDataStyle(dataStyle, unvalidIndexs, "red");
        model.setValue("adjustjson_tag", (Object)JSON.toJSONString((Object)dynamicEntryDTOs));
    }

    private void setValidDataStyle(Map<String, String> dataStyle, Collection collection, String color) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        collection.forEach(index -> dataStyle.put("valid," + index, color));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String modelNewVersionMsg;
        DynamicObject analysisModel;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (("save".equals(operateKey) || "submit".equals(operateKey) || "unaudit".equals(operateKey)) && (analysisModel = (DynamicObject)model.getValue("analysismodel")) != null && StringUtils.isNotEmpty((String)(modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(analysisModel.getLong("id"))))) {
            view.showTipNotification(modelNewVersionMsg);
            args.setCancel(true);
            return;
        }
        switch (operateKey) {
            case "save": 
            case "submit": {
                String adjustJson = (String)model.getValue("adjustjson_tag");
                List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
                PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
                Object[][] data = dynamicEntryDTO.getData();
                if (data == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PADataAdjustFormPlugin_17", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String adjustStatus = (String)model.getValue("adjuststatus");
                boolean expectedStatus = "2".equals(adjustStatus) || "4".equals(adjustStatus);
                HashMap<Long, String> rowDataIdAndSeq = new HashMap<Long, String>(data.length);
                Map dataStyleMap = dynamicEntryDTO.getDataStyle();
                Map supSonMap = dynamicEntryDTO.getSupSonMap();
                Collection<Object> supIdxCol = supSonMap == null ? Collections.emptyList() : supSonMap.values();
                ArrayList<String> errorSeqList = new ArrayList<String>(8);
                String currentRowSeq = null;
                for (int i = 0; i < data.length; ++i) {
                    String idStrValue;
                    String seq = (String)data[i][0];
                    boolean seqEmpty = StringUtils.isEmpty((String)seq);
                    if (!seqEmpty) {
                        currentRowSeq = seq;
                    }
                    String adjustColor = (String)dataStyleMap.get("adjustdatastate," + i);
                    if ((expectedStatus || "gray".equals(adjustColor)) && (idStrValue = String.valueOf(data[i][data[i].length - 1])) != null && idStrValue.length() > 1) {
                        rowDataIdAndSeq.put(Long.parseLong(idStrValue), currentRowSeq);
                    }
                    if (supIdxCol.contains(i) || seqEmpty || !"gray".equals(adjustColor)) continue;
                    errorSeqList.add(seq);
                }
                String detailRowIndexIfDelete = this.getDetailRowIndexIfDelete(data, rowDataIdAndSeq);
                if (StringUtils.isNotEmpty((String)detailRowIndexIfDelete)) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7 %s \u884c\u7684\u6570\u636e\u5728\u5206\u6790\u6a21\u578b\u7684\u5bfc\u5165\u6570\u636e\u5217\u8868\u4e2d\u5df2\u5220\u9664\uff0c\u8bf7\u5220\u9664\u6b64\u6570\u636e\u540e\u91cd\u65b0\u4fdd\u5b58\u6216\u63d0\u4ea4\u3002", (String)"PADataAdjustFormPlugin_18", (String)"fi-pa-formplugin", (Object[])new Object[0]), detailRowIndexIfDelete));
                    args.setCancel(true);
                    return;
                }
                if (!errorSeqList.isEmpty()) {
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7 %s \u884c\u7684\u6570\u636e\u8fd8\u672a\u8c03\u6574\u8fc7\u3002", (String)"PADataAdjustFormPlugin_19", (String)"fi-pa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorSeqList)));
                    args.setCancel(true);
                    return;
                }
                String submitMark = view.getPageCache().get("pageCacheSubmitMark");
                if (!"submit".equals(operateKey)) break;
                if (StringUtils.isEmpty((String)submitMark)) {
                    QFilter curFilter = new QFilter("analysissystem", "=", model.getValue("analysissystem_id")).and("analysismodel", "=", model.getValue("analysismodel_id")).and("createorg", "=", model.getValue("createorg_id")).and("period", "=", model.getValue("period_id")).and("billstatus", "in", (Object)new String[]{"B", "C", "E"}).and("adjuststatus", "=", (Object)"1");
                    Object id = model.getValue("id");
                    if (id != null && Long.parseLong(id.toString()) != 0L) {
                        curFilter.and("id", "!=", id);
                    }
                    if (!QueryServiceHelper.exists((String)"pa_dataadjust", (QFilter[])curFilter.toArray())) break;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u6709\u5728\u9014\u6216\u5df2\u5ba1\u6838\u4f46\u672a\u8c03\u6574\u5b9e\u9645\u6570\u7684\u8c03\u6574\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PADataAdjustFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackSubmit", (IFormPlugin)this));
                    args.setCancel(true);
                    return;
                }
                view.getPageCache().remove("pageCacheSubmitMark");
            }
        }
    }

    private boolean checkAnaModel(IDataModel model, IFormView view) {
        DynamicObject anaModel = (DynamicObject)model.getValue("analysismodel");
        if (anaModel == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADataAdjustFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)anaModel.getString("tablenumber"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6a21\u578b\u8fd8\u672a\u751f\u6210\u6570\u636e\u8868\uff0c\u8bf7\u5148\u53bb\u5206\u6790\u6a21\u578b\u4e2d\u751f\u6210\u6570\u636e\u8868\u3002", (String)"PADataAdjustFormPlugin_21", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Set<Long> getSelectedId(IDataModel model) {
        String adjustJson = (String)model.getValue("adjustjson_tag");
        List dynamicEntryDTOs = (List)JSON.parseObject((String)adjustJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOs.get(0);
        Object[][] data = dynamicEntryDTO.getData();
        if (data == null) {
            return Collections.emptySet();
        }
        int validFieldIndex = DataAdjustUtils.getValidFieldIndex((Object[][])dynamicEntryDTO.getColumns());
        Map dataStyleMap = dynamicEntryDTO.getDataStyle();
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (int i = 0; i < data.length; ++i) {
            if (StringUtils.isEmpty((String)((String)data[i][0])) || ResManager.loadKDString((String)"\u5931\u6548", (String)"PADataAdjustFormPlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]).equals(data[i][validFieldIndex]) || !"gray".equals(dataStyleMap.get("adjustdatastate," + i))) continue;
            Object id = data[i][data[i].length - 1];
            if (id instanceof Long) {
                idSet.add((Long)id);
            }
            if (!(id instanceof String)) continue;
            idSet.add(Long.parseLong(id.toString()));
        }
        return idSet;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("unaudit".equals(operateKey) && operationResult.isSuccess()) {
            PADataAdjustFormPlugin.unauditUpdate(afterDoOperationEventArgs);
        }
    }

    public static void unauditUpdate(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        List successPkIds = operationResult.getSuccessPkIds();
        MainEntityType pa_dataadjust1 = EntityMetadataCache.getDataEntityType((String)"pa_dataadjust");
        Map pa_dataadjust = BusinessDataReader.loadFromCache((Object[])successPkIds.toArray(), (DynamicObjectType)pa_dataadjust1);
        Collection values = pa_dataadjust.values();
        Object[] dynamicObjects = new DynamicObject[values.size()];
        int index = 0;
        for (DynamicObject value : values) {
            value.set("adjuststatus", (Object)"1");
            dynamicObjects[index] = value;
            ++index;
        }
        if (dynamicObjects.length > 0) {
            BusinessDataWriter.update((IDataEntityType)pa_dataadjust1, (Object[])dynamicObjects);
        }
    }

    private void saveSummaryDetailToCache(Object[][] newAddSummaryData) {
        Map<Long, Set<Long>> summaryDetailFromCache = this.getSummaryDetailFromCache();
        Map<Long, Set<Long>> summaryDetailRealTime = this.getSummaryDetailMappingRealTime(newAddSummaryData);
        if (summaryDetailRealTime != null) {
            if (summaryDetailFromCache != null) {
                for (Map.Entry<Long, Set<Long>> entry : summaryDetailFromCache.entrySet()) {
                    Long summaryId = entry.getKey();
                    Set<Long> detailIdSetCache = entry.getValue();
                    Set<Long> detailIdSetRealTime = summaryDetailRealTime.get(summaryId);
                    if (detailIdSetCache == null || detailIdSetRealTime == null) continue;
                    detailIdSetCache.clear();
                    detailIdSetCache.addAll(detailIdSetRealTime);
                }
                this.getPageCache().put(summaryDetailCache, JSON.toJSONString(summaryDetailFromCache));
            } else {
                this.getPageCache().put(summaryDetailCache, JSON.toJSONString(summaryDetailRealTime));
            }
        }
    }

    private Map<Long, Set<Long>> getSummaryDetailFromCache() {
        String summaryDetailCacheJson = this.getPageCache().get(summaryDetailCache);
        if (StringUtils.isNotEmpty((String)summaryDetailCacheJson)) {
            return (Map)JSON.parseObject((String)summaryDetailCacheJson, (TypeReference)new TypeReference<Map<Long, Set<Long>>>(){}, (Feature[])new Feature[0]);
        }
        return null;
    }

    private Map<Long, Set<Long>> getSummaryDetailMappingRealTime(Object[][] summaryData) {
        QFilter summaryIdFilter;
        DynamicObject analysisModelObj;
        String detailEntityNumber;
        DynamicObjectCollection detailDataCol;
        HashSet<Long> summaryIdSet = new HashSet<Long>(summaryData.length);
        for (Object[] addDatum : summaryData) {
            String summaryIdStr;
            if (addDatum == null || (summaryIdStr = String.valueOf(addDatum[addDatum.length - 1])).length() <= 1) continue;
            summaryIdSet.add(Long.parseLong(summaryIdStr));
        }
        if (!summaryIdSet.isEmpty() && (detailDataCol = QueryServiceHelper.query((String)(detailEntityNumber = PACommonConstans.buildDetailEntityName((String)(analysisModelObj = (DynamicObject)this.getModel().getValue("analysismodel")).getString("tablenumber"))), (String)"id,summaryid", (QFilter[])(summaryIdFilter = new QFilter("summaryid", "in", summaryIdSet)).toArray())) != null && !detailDataCol.isEmpty()) {
            HashMap<Long, Set<Long>> summaryDetailMapping = new HashMap<Long, Set<Long>>(detailDataCol.size());
            for (DynamicObject detailData : detailDataCol) {
                Long detailId = detailData.getLong("id");
                Long summaryId = detailData.getLong("summaryid");
                HashSet<Long> summaryDetailIdSet = (HashSet<Long>)summaryDetailMapping.get(summaryId);
                if (summaryDetailIdSet == null) {
                    summaryDetailIdSet = new HashSet<Long>(1);
                }
                summaryDetailIdSet.add(detailId);
                summaryDetailMapping.put(summaryId, summaryDetailIdSet);
            }
            return summaryDetailMapping;
        }
        return null;
    }

    private String getDetailRowIndexIfDelete(Object[][] currentSummaryData, Map<Long, String> rowDataIdAndSeq) {
        Map<Long, Set<Long>> summaryDetailFromCache = this.getSummaryDetailFromCache();
        Map<Long, Set<Long>> summaryDetailMappingRealTime = this.getSummaryDetailMappingRealTime(currentSummaryData);
        if (summaryDetailFromCache != null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Long, String> entry : rowDataIdAndSeq.entrySet()) {
                Set<Long> detailIdSetFromCache;
                Long summaryId = entry.getKey();
                String summarySeq = entry.getValue();
                if (!StringUtils.isNotEmpty((String)summarySeq) || (detailIdSetFromCache = summaryDetailFromCache.get(summaryId)) == null) continue;
                if (summaryDetailMappingRealTime == null) {
                    builder.append(',').append(summarySeq);
                    continue;
                }
                Set<Long> detailIdSetFromRealTime = summaryDetailMappingRealTime.get(summaryId);
                if (detailIdSetFromRealTime != null && detailIdSetFromRealTime.containsAll(detailIdSetFromCache)) continue;
                builder.append(',').append(summarySeq);
            }
            return builder.length() > 0 ? builder.substring(1) : null;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$adjustJsonValidCheck$17(String excludeFields, String[][] columns, int seed) {
        return excludeFields.contains(columns[seed][1]);
    }
}

