/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.cache.DistributeCache;
import kd.fi.pa.common.cache.IDataCacheModule;
import kd.fi.pa.dataAdjust.DataAdjustUtils;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.ExecuteEngineService;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.ExecutionTypeEnum;
import kd.fi.pa.formplugin.PABusinessListPlugin;
import kd.fi.pa.formplugin.PADataAdjustFormPlugin;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.helper.OrgHelper;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.servicehelper.PeriodServiceHelper;
import kd.fi.pa.utils.ExecutionLogUtil;

public class PADataAdjustListPlugin
extends PABusinessListPlugin {
    private static final DistributeCache DISTRIBUTE_CACHE = DistributeCache.getCache((IDataCacheModule)IDataCacheModule.PA);
    private static final Log logger = LogFactory.getLog(PADataAdjustListPlugin.class);
    private static final String cacheKeyPrefix = "adjustConfirm_";

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        int cnt = pageData.size();
        ArrayList<Long> dimIdList = new ArrayList<Long>(cnt);
        block0: for (DynamicObject data : pageData) {
            DynamicObject anaModel = data.getDynamicObject("analysismodel");
            if (anaModel == null) {
                dimIdList.add(null);
                continue;
            }
            DynamicObjectCollection dimCol = anaModel.getDynamicObjectCollection("dimension_entry");
            for (Object dyo : dimCol) {
                if (!DimensionNecessityEnum.PERIOD.getCode().equals(dyo.getString("necessity_dim"))) continue;
                dimIdList.add(dyo.getLong("dimension_id"));
                continue block0;
            }
        }
        HashSet dimIdSet = new HashSet(dimIdList);
        dimIdSet.remove(null);
        Map dimMap = BusinessDataServiceHelper.loadFromCache((Object[])dimIdSet.toArray(), (String)"pa_dimension");
        HashMap<String, Set<Object>> periodIdMap = new HashMap<String, Set<Object>>(dimMap.size());
        String[] baseEntityIdArr = new String[cnt];
        int i = 0;
        for (DynamicObject data : pageData) {
            String baseEntityId = FormPluginUtil.getBaseEntityIdByDimension((DynamicObject)dimMap.get(dimIdList.get(i)));
            baseEntityIdArr[i++] = baseEntityId;
            if (StringUtils.isEmpty((String)baseEntityId) || "bd_period".equals(baseEntityId)) continue;
            Set periodIdSet = periodIdMap.computeIfAbsent(baseEntityId, k -> new HashSet(8));
            if (data.get("period") != null) continue;
            periodIdSet.add(data.get("period_id"));
        }
        Map<String, Map<Object, DynamicObject>> periodMap = FormPluginUtil.getBaseEntityDataMap(periodIdMap);
        i = 0;
        for (DynamicObject data : pageData) {
            String baseEntityId;
            Map<Object, DynamicObject> periodDataMap;
            if ((periodDataMap = periodMap.get(baseEntityId = baseEntityIdArr[i++])) == null || periodDataMap.isEmpty()) continue;
            data.set("period", (Object)periodDataMap.get(data.get("period_id")));
        }
    }

    private String getValidateMark(String key) {
        return DISTRIBUTE_CACHE.get(key);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String modelNewVersionMsg;
        List anaModIdList;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        String submitMark = view.getPageCache().get("pageCacheSubmitMark");
        if (("submit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey) || "new".equals(operateKey) || "copy".equals(operateKey)) && (anaModIdList = ((IListView)this.getView()).getControlFilters().getFilter("analysismodel.id")) != null && !anaModIdList.isEmpty() && StringUtils.isNotEmpty((String)(modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(Long.parseLong(anaModIdList.get(0).toString()))))) {
            view.showTipNotification(modelNewVersionMsg);
            args.setCancel(true);
            return;
        }
        if ("submit".equals(operateKey)) {
            Object[] idArr = this.getSelectedRows().stream().filter(row -> row.getPrimaryKeyValue() != null).map(ListSelectedRow::getPrimaryKeyValue).toArray();
            List wrongAdjustJsonDataBillno = DataAdjustUtils.getWrongAdjustJsonDataBillno((Object[])idArr);
            if (!wrongAdjustJsonDataBillno.isEmpty()) {
                view.showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u8c03\u6574\u5355\u7ef4\u5ea6\u6216\u5ea6\u91cf\u4e0e\u5206\u6790\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u4ec5\u53ef\u5220\u9664\u3002", (String)"PADataAdjustListPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.listMsgFormat(wrongAdjustJsonDataBillno), MessageTypes.Default);
                args.setCancel(true);
                return;
            }
            List unValidRowBillNo = DataAdjustUtils.getUnValidRowBillNo((Object[])idArr);
            if (!unValidRowBillNo.isEmpty()) {
                view.showMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u8c03\u6574\u5355\u5b58\u5728\u6e90\u6570\u636e\u5931\u6548\u884c\uff0c\u8bf7\u66ff\u6362\u6b63\u786e\u7684\u6e90\u6570\u636e\u3002", (String)"PADataAdjustListPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]), this.listMsgFormat(unValidRowBillNo), MessageTypes.Default);
                args.setCancel(true);
                return;
            }
            if (StringUtils.isEmpty((String)submitMark)) {
                QFilter filter = new QFilter("id", "not in", (Object)idArr);
                Map dyoMap = BusinessDataServiceHelper.loadFromCache((Object[])idArr, (String)"pa_dataadjust");
                QFilter connectFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
                for (DynamicObject dyo : dyoMap.values()) {
                    QFilter curFilter = new QFilter("analysissystem", "=", dyo.get("analysissystem_id")).and("analysismodel", "=", dyo.get("analysismodel_id")).and("createorg", "=", dyo.get("createorg_id")).and("period", "=", dyo.get("period_id")).and("billstatus", "in", (Object)new String[]{"B", "C", "E"}).and("adjuststatus", "=", (Object)"1");
                    connectFilter.or(curFilter);
                }
                filter.and(connectFilter);
                if (QueryServiceHelper.exists((String)"pa_dataadjust", (QFilter[])filter.toArray())) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u6709\u5728\u9014\u6216\u5df2\u5ba1\u6838\u4f46\u672a\u8c03\u6574\u5b9e\u9645\u6570\u7684\u8c03\u6574\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PADataAdjustListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackSubmit", (IFormPlugin)this));
                    args.setCancel(true);
                }
            } else {
                view.getPageCache().remove("pageCacheSubmitMark");
            }
        }
    }

    private String listMsgFormat(List<String> list) {
        return list.toString().substring(1, list.toString().length() - 1).replace(", ", "\n");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List successPkIds;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        if ("dataadjust".equals(operateKey)) {
            Object[] idArr = this.getSelectedRows().getPrimaryKeyValues();
            if (idArr.length == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8c03\u6574\u7684\u6570\u636e\u3002", (String)"PADataAdjustListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            Map dyoMap = BusinessDataServiceHelper.loadFromCache((Object[])idArr, (String)"pa_dataadjust");
            Long modelId = null;
            for (DynamicObject dyo : dyoMap.values()) {
                modelId = dyo.getLong("analysismodel_id");
                OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)"pa_dataadjust");
                if (!permOrgResult.hasAllOrgPerm() && !permOrgResult.getPermOrgs().contains(dyo.getLong("createorg_id"))) {
                    return;
                }
                String billStatus = dyo.getString("billstatus");
                if (!"E".equals(billStatus)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5355\u636e\u72b6\u6001\u4e3a\u5ba1\u6838\u901a\u8fc7\u540e\u53ef\u8c03\u6574\uff0c\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5b58\u5728\u975e\u5ba1\u6838\u901a\u8fc7\u7684\u6570\u636e\u3002", (String)"PADataAdjustListPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                String adjustStatus = dyo.getString("adjuststatus");
                if ("0".equals(adjustStatus) || "1".equals(adjustStatus)) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u8c03\u6574\u72b6\u6001\u4e3a\u672a\u8c03\u6574\u6216\u8c03\u6574\u5931\u8d25\u65f6\u53ef\u8c03\u6574\u3002", (String)"PADataAdjustListPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean checkPeriod = this.checkPeriod(idArr);
            if (!checkPeriod) {
                if (idArr.length == 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5904\u4e8e\u201c\u5173\u95ed\u201d\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u6570\u636e\u671f\u95f4\u3002", (String)"PADataAdjustListPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u7684\u8c03\u6574\u5355\u4e2d\uff0c\u6709\u671f\u95f4\u662f\u5904\u4e8e\u201c\u5173\u95ed\u201d\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u6570\u636e\u671f\u95f4\u3002", (String)"PADataAdjustListPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId);
            if (StringUtils.isNotEmpty((String)modelNewVersionMsg)) {
                view.showTipNotification(modelNewVersionMsg);
                return;
            }
            LinkedHashSet<String> errorSet = new LinkedHashSet<String>(dyoMap.size());
            LinkedHashSet<String> successSet = new LinkedHashSet<String>(dyoMap.size());
            for (DynamicObject dyo : dyoMap.values()) {
                try {
                    long id = dyo.getLong("id");
                    ExecutionLogDTO executionLog = ExecutionLogUtil.buildLogDTO((DynamicObject)dyo, (String)ExecutionTypeEnum.MANUAL.getCode(), Collections.singletonList(id), (ExecutionModeEnum)ExecutionModeEnum.adjust);
                    ExecuteEngineService executeEngineService = (ExecuteEngineService)EngineServiceFactory.getExecuteEngineService();
                    executeEngineService.work(executionLog);
                    String validateMark = this.getValidateMark(cacheKeyPrefix + id);
                    if ("confirmMark".equals(validateMark)) {
                        Long logId = executionLog.getId();
                        if (logId != null) {
                            DeleteServiceHelper.delete((String)"pa_executionlog", (QFilter[])new QFilter("id", "=", (Object)logId).toArray());
                        }
                        view.showConfirm(String.format(ResManager.loadKDString((String)"%s \u6570\u636e\u5728\u8c03\u6574\u8fc7\u7a0b\u4e2d\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u6062\u590d\u540e\u6309\u7167\u8c03\u6574\u5355\u8fdb\u884c\u8c03\u6574\uff1f", (String)"PADataAdjustListPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), dyo.getString("billno")), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("confirmCallbackChargeAgainst", (IFormPlugin)this), null, String.valueOf(id));
                        continue;
                    }
                    successSet.add(dyo.getString("billno"));
                }
                catch (Exception ex) {
                    errorSet.add(dyo.getString("billno"));
                }
            }
            if (!successSet.isEmpty()) {
                view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u7684\u5355\u636e\u7f16\u53f7\uff1a%s\u3002", (String)"PADataAdjustListPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", successSet)));
            }
            if (!errorSet.isEmpty()) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u7684\u5355\u636e\u7f16\u53f7\uff1a%s\u3002", (String)"PADataAdjustListPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorSet)));
            }
            view.invokeOperation("refresh");
        } else if ("unaudit".equals(operateKey) && (successPkIds = args.getOperationResult().getSuccessPkIds()).size() > 0) {
            PADataAdjustFormPlugin.unauditUpdate(args);
        }
    }

    private boolean checkPeriod(Object[] idArr) {
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])idArr, (String)"pa_dataadjust");
        Map collect = objectDynamicObjectMap.values().stream().collect(Collectors.groupingBy(p -> p.getLong("analysismodel_id"), Collectors.mapping(p -> new Tuple((Object)p.getLong("createorg_id"), (Object)p.getLong("period_id")), Collectors.toList())));
        for (Map.Entry next : collect.entrySet()) {
            Long analysismodel_id = next.getKey();
            List value = next.getValue();
            Boolean aBoolean = PeriodServiceHelper.checkPeriodOrgTuple((long)analysismodel_id, value);
            String logMsg = value.stream().map(p -> "[" + p.item1 + "," + p.item2 + "]").collect(Collectors.joining(","));
            if (aBoolean != null && aBoolean.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String actionId = messageBoxClosedEvent.getCallBackId();
        IFormView view = this.getView();
        if (MessageBoxResult.Yes == messageBoxResult) {
            if ("confirmCallbackSubmit".equalsIgnoreCase(actionId)) {
                view.getPageCache().put("pageCacheSubmitMark", "mark");
                view.invokeOperation("submit");
            } else if ("confirmCallbackChargeAgainst".equals(actionId)) {
                String adjustId = messageBoxClosedEvent.getCustomVaule();
                DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(adjustId), (String)"pa_dataadjust");
                try {
                    DISTRIBUTE_CACHE.put(cacheKeyPrefix + adjustId, (Object)"yesMark");
                    ExecutionLogDTO executionLog = ExecutionLogUtil.buildLogDTO((DynamicObject)dyo, (String)ExecutionTypeEnum.MANUAL.getCode(), Collections.singletonList(Long.parseLong(adjustId)), (ExecutionModeEnum)ExecutionModeEnum.adjust);
                    ExecuteEngineService executeEngineService = (ExecuteEngineService)EngineServiceFactory.getExecuteEngineService();
                    executeEngineService.work(executionLog);
                    view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u7684\u5355\u636e\u7f16\u53f7\uff1a%s\u3002", (String)"PADataAdjustListPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]), dyo.getString("billno")));
                }
                catch (Exception e) {
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u7684\u5355\u636e\u7f16\u53f7\uff1a%s\u3002", (String)"PADataAdjustListPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]), dyo.getString("billno")));
                }
                view.invokeOperation("refresh");
            }
        } else if ("confirmCallbackChargeAgainst".equals(actionId)) {
            String adjustId = messageBoxClosedEvent.getCustomVaule();
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(adjustId), (String)"pa_dataadjust");
            dyo.set("adjuststatus", (Object)"3");
            SaveServiceHelper.update((DynamicObject)dyo);
            DISTRIBUTE_CACHE.remove(cacheKeyPrefix + adjustId);
            view.invokeOperation("refresh");
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IListView listView = (IListView)this.getView();
        if (((ListShowParameter)listView.getFormShowParameter()).isLookUp()) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        Date beginDate = calendar.getTime();
        calendar.add(2, 6);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        Date endDate = calendar.getTime();
        QFilter periodDateFilter1 = new QFilter("begindate", ">=", (Object)beginDate).and("enddate", "<=", (Object)endDate);
        QFilter periodDateFilter2 = new QFilter("begindate", "<", (Object)beginDate).or("enddate", ">", (Object)endDate);
        ControlFilters controlFilters = listView.getControlFilters();
        FilterColumn periodFilterColumn = args.getFilterColumn("period.name");
        SchemeFilterColumn schemeFilterColumn = null;
        CommonFilterColumn commonFilterColumn = null;
        if (periodFilterColumn instanceof SchemeFilterColumn) {
            schemeFilterColumn = (SchemeFilterColumn)periodFilterColumn;
        } else if (periodFilterColumn instanceof CommonFilterColumn) {
            commonFilterColumn = (CommonFilterColumn)periodFilterColumn;
        }
        if (controlFilters == null) {
            this.setComboItems(schemeFilterColumn, commonFilterColumn, new ArrayList<ComboItem>(0));
            periodFilterColumn.setDefaultValue(null);
            return;
        }
        List anaModIdList = controlFilters.getFilter("analysismodel.id");
        if (anaModIdList != null && !anaModIdList.isEmpty()) {
            boolean periodNotEmpty;
            DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(anaModIdList.get(0).toString()), (String)"pa_analysismodel");
            String baseEntityId = FormPluginUtil.getBaseEntityId(anaModel, "1");
            String columnStr = FormPluginUtil.getBaseEntityColumn(anaModel, "1");
            List<String> columnList = Arrays.asList(columnStr.split(","));
            boolean hasColumn = columnList.contains("begindate") && columnList.contains("enddate");
            QFilter qFilter = FormPluginUtil.getBaseQFilter(anaModel, "1");
            QFilter dateFilter1 = hasColumn ? periodDateFilter1 : QFilter.of((String)"1=1", (Object[])new Object[0]);
            QFilter dateFilter2 = hasColumn ? periodDateFilter2 : QFilter.of((String)"1!=1", (Object[])new Object[0]);
            Map periodMap1 = BusinessDataServiceHelper.loadFromCache((String)baseEntityId, (String)"id,name,number", (QFilter[])new QFilter[]{qFilter, dateFilter1}, (String)"id");
            Map periodMap2 = BusinessDataServiceHelper.loadFromCache((String)baseEntityId, (String)"id,name,number", (QFilter[])new QFilter[]{qFilter, dateFilter2}, (String)"id");
            LinkedHashSet period = new LinkedHashSet(periodMap1.size() + periodMap2.size());
            period.addAll(periodMap1.values());
            period.addAll(periodMap2.values());
            ArrayList<ComboItem> periodCmbList = new ArrayList<ComboItem>(period.size());
            boolean bl = periodNotEmpty = !period.isEmpty();
            if (periodNotEmpty) {
                for (DynamicObject dyo : period) {
                    ComboItem item = new ComboItem();
                    item.setCaption(new LocaleString(dyo.getString("name")));
                    item.setValue(dyo.get("id").toString());
                    periodCmbList.add(item);
                }
            }
            this.setComboItems(schemeFilterColumn, commonFilterColumn, periodCmbList);
            List createPeriod = controlFilters.getFilter("period.id");
            if (CollectionUtils.isNotEmpty((Collection)createPeriod) && "true".equals(this.getPageCache().get("useDefaultValue"))) {
                FilterColumn orgFilterColumn = args.getFilterColumn("period.name");
                orgFilterColumn.setDefaultValue(createPeriod.get(0).toString());
            } else {
                periodFilterColumn.setDefaultValue(periodNotEmpty ? ((ComboItem)periodCmbList.get(0)).getValue() : null);
            }
            List createOrg = controlFilters.getFilter("createorg.id");
            if (CollectionUtils.isNotEmpty((Collection)createOrg) && "true".equals(this.getPageCache().get("useDefaultValue"))) {
                FilterColumn orgFilterColumn = args.getFilterColumn("createorg.name");
                orgFilterColumn.setDefaultValue(createOrg.get(0).toString());
            }
            this.getPageCache().put("useDefaultValue", "false");
        } else {
            this.setComboItems(schemeFilterColumn, commonFilterColumn, new ArrayList<ComboItem>(0));
            periodFilterColumn.setDefaultValue(null);
        }
    }

    private void setComboItems(SchemeFilterColumn schemeFilter, CommonFilterColumn commonFilter, List<ComboItem> comboItemList) {
        if (schemeFilter != null) {
            schemeFilter.setComboItems(comboItemList);
        } else if (commonFilter != null) {
            commonFilter.setComboItems(comboItemList);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if ("period.id".equals(fieldName)) {
            List anaModIdList = ((IListView)this.getView()).getControlFilters().getFilter("analysismodel.id");
            if (anaModIdList != null && !anaModIdList.isEmpty()) {
                DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(anaModIdList.get(0).toString()), (String)"pa_analysismodel");
                args.setRefEntityId(FormPluginUtil.getBaseEntityId(anaModel, "1"));
                args.getQfilters().add(FormPluginUtil.getBaseQFilter(anaModel, "1"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADataAdjustListPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("period.name".equals(fieldName)) {
            List anaModNameList = ((IListView)this.getView()).getControlFilters().getFilter("analysismodel.name");
            if (anaModNameList == null || anaModNameList.isEmpty() || anaModNameList.size() == 1 && "".equals(anaModNameList.get(0))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADataAdjustListPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysismodel", (QFilter[])new QFilter("name", "=", anaModNameList.get(0)).toArray());
            args.setRefEntityId(FormPluginUtil.getBaseEntityId(anaModel, "1"));
            args.getQfilters().add(FormPluginUtil.getBaseQFilter(anaModel, "1"));
        } else if ("analysismodel.id".equals(fieldName)) {
            List anaSys = ((IListView)this.getView()).getControlFilters().getFilter("analysissystem.id");
            if (anaSys != null && !anaSys.isEmpty()) {
                args.getQfilters().add(new QFilter("analysis_system", "=", (Object)Long.parseLong(anaSys.get(0).toString())).and(enableFilter).and(this.getModelQFilters()));
            }
        } else {
            super.filterContainerBeforeF7Select(args);
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter showParam = e.getParameter();
        BillOperationStatus billStatus = showParam.getBillStatus();
        if (BillOperationStatus.ADDNEW == billStatus) {
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            List anaModIdList = controlFilters.getFilter("analysismodel.id");
            if (anaModIdList != null && !anaModIdList.isEmpty()) {
                DynamicObject anaModel = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(anaModIdList.get(0).toString()), (String)"pa_analysismodel");
                this.setCustomParam(anaModel, showParam, controlFilters);
            } else {
                Map anaModelMap;
                List anaModelNameList = controlFilters.getFilter("analysismodel.name");
                if (anaModelNameList != null && !anaModelNameList.isEmpty() && !(anaModelMap = BusinessDataServiceHelper.loadFromCache((String)"pa_analysismodel", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)anaModelNameList.get(0).toString()).and(enableFilter)})).isEmpty()) {
                    this.setCustomParam((DynamicObject)anaModelMap.values().iterator().next(), showParam, controlFilters);
                }
            }
        } else if (BillOperationStatus.EDIT == billStatus) {
            Object pkId = showParam.getPkId();
            IFormView view = this.getView();
            if (pkId == null) {
                return;
            }
            String errMsg = DataAdjustUtils.existDBTable((Object)pkId);
            if (!StringUtils.isEmpty((String)errMsg)) {
                e.setCancel(true);
                view.showErrorNotification(errMsg);
                return;
            }
            if (!DataAdjustUtils.getWrongAdjustJsonDataBillno((Object[])new Object[]{pkId}).isEmpty()) {
                e.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8c03\u6574\u5355\u7ef4\u5ea6\u6216\u5ea6\u91cf\u4e0e\u5206\u6790\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u4ec5\u53ef\u5220\u9664\u3002", (String)"PADataAdjustListPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setCustomParam(DynamicObject anaModel, BillShowParameter showParam, ControlFilters controlFilters) {
        String baseEntityId = FormPluginUtil.getBaseEntityId(anaModel, "1");
        QFilter qFilter = FormPluginUtil.getBaseQFilter(anaModel, "1");
        List periodIdList = controlFilters.getFilter("period.id");
        String periodId = null;
        if (periodIdList != null && !periodIdList.isEmpty()) {
            DynamicObjectCollection period = QueryServiceHelper.query((String)baseEntityId, (String)"id", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(periodIdList.get(0).toString())).and(qFilter).toArray());
            if (period != null && !period.isEmpty()) {
                periodId = periodIdList.get(0).toString();
            }
        } else {
            DynamicObjectCollection period;
            List periodNameList = controlFilters.getFilter("period.name");
            if (periodNameList != null && !periodNameList.isEmpty() && (period = QueryServiceHelper.query((String)baseEntityId, (String)"id", (QFilter[])new QFilter("name", "=", periodNameList.get(0)).and(qFilter).toArray())) != null && !period.isEmpty()) {
                periodId = ((DynamicObject)period.get(0)).get("id").toString();
            }
        }
        showParam.setCustomParam("customParamPeriodId", periodId);
    }

    @Override
    public QFilter getModelQFilters() {
        return PARuleHelper.getOnlyPeriodFilter();
    }
}

