/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PADataAdjustValidate
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new UnAuditValidator());
    }

    static class PADataAdjustModel {
        Long id;
        String billstatus;
        String adjuststatus;

        public PADataAdjustModel(Long id, String billstatus, String adjuststatus) {
            this.id = id;
            this.billstatus = billstatus;
            this.adjuststatus = adjuststatus;
        }
    }

    static class UnAuditValidator
    extends AbstractValidator {
        UnAuditValidator() {
        }

        public void validate() {
            if ("unaudit".equals(this.getOperateKey())) {
                Map<Long, ExtendedDataEntity> collect = Arrays.stream(this.dataEntities).filter(p -> p.getBillPkId() != null).collect(Collectors.toMap(p -> (Long)p.getBillPkId(), p -> p));
                Set<Long> ids = collect.keySet();
                if (ids.isEmpty()) {
                    return;
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", ids)};
                ArrayList<PADataAdjustModel> list = new ArrayList<PADataAdjustModel>(ids.size());
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UnAuditValidator", (String)"pa_dataadjust", (String)"id,billstatus,adjuststatus", (QFilter[])qFilters, null);){
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        Long id = next.getLong("id");
                        String billstatus = next.getString("billstatus");
                        String adjuststatus = next.getString("adjuststatus");
                        PADataAdjustModel paDataAdjustModel = new PADataAdjustModel(id, billstatus, adjuststatus);
                        list.add(paDataAdjustModel);
                    }
                }
                for (PADataAdjustModel paDataAdjustModel : list) {
                    String adjuststatus;
                    if (!"E".equals(paDataAdjustModel.billstatus) || "1".equals(adjuststatus = paDataAdjustModel.adjuststatus) || "0".equals(adjuststatus)) continue;
                    this.addMessage(collect.get(paDataAdjustModel.id), ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u53cd\u5ba1\u6838\u672a\u8c03\u6574\u6216\u8c03\u6574\u5931\u8d25\u7684\u5355\u636e\u3002", (String)"PADataAdjustValidate_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

