/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.enums.DerivationTypeEnum;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.enums.DataReviewBusinessTypeEnum;
import kd.fi.pa.enums.DataReviewNodeTypeEnum;
import kd.fi.pa.enums.DataReviewRuleTypeEnum;
import kd.fi.pa.formplugin.PADataTraceShareMoreSelectFormPlugin;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PAMeasureHelper;
import kd.fi.pa.review.DataReviewHelper;
import kd.fi.pa.review.PADataReviewBuilder;
import kd.fi.pa.review.dto.PADerivationRuleInfoDTO;
import kd.fi.pa.review.dto.PAShareRuleInfoDTO;
import kd.fi.pa.review.dto.PASummaryDataByStampDTO;
import kd.fi.pa.review.model.Node;

public class PADataTraceCustomControlFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_CUSTOM_CONTROL = "custom_control";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detaillabel", "rulelabel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodeinfoflex"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("detaillabel".equals(key)) {
            Node currentSelectNode = this.getCurrentSelectNode();
            Object[] detailsBySummaryId = DataReviewHelper.getDetailsBySummaryId((Long)Long.parseLong(currentSelectNode.getDataId()), (Long)Long.parseLong(currentSelectNode.getModelId()));
            if (ArrayUtils.isEmpty((Object[])detailsBySummaryId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u7684\u8ba1\u7b97\u578b\u5ea6\u91cf\u6570\u636e\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u660e\u7ec6\u3002", (String)"PADataTraceCustomControlFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportQueryParam reportQueryOfDetails = this.getReportQueryOfDetails();
            if (reportQueryOfDetails == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u636e\u4e3a\u96f6\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u660e\u7ec6\u3002", (String)"PADataTraceCustomControlFormPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("faf_dataquery_d");
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            reportShowParameter.setQueryParam(reportQueryOfDetails);
            reportShowParameter.setCustomParam("needNotPeriod", (Object)"1");
            this.getView().showForm((FormShowParameter)reportShowParameter);
        } else if ("rulelabel".equals(key)) {
            Tuple<Object, Integer> currentNodeRulePkIdAndStepIndex = this.getCurrentNodeRulePkIdAndStepIndex();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setBillStatus(BillOperationStatus.VIEW);
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setFormId("pa_businessrule");
            billShowParameter.setPkId(currentNodeRulePkIdAndStepIndex.item1);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setCustomParam("stepIndex", (Object)String.valueOf(currentNodeRulePkIdAndStepIndex.item2));
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private Tuple<Object, Integer> getCurrentNodeRulePkIdAndStepIndex() {
        Node currentSelectNode = this.getCurrentSelectNode();
        DataReviewBusinessTypeEnum reviewBusinessTypeEnum = DataReviewBusinessTypeEnum.getEnumByCode((String)currentSelectNode.getData().getTypeValue());
        Long subExecLogId = 0L;
        Long businessRulePkId = 0L;
        switch (reviewBusinessTypeEnum) {
            case DERIVATION_DETAIL: 
            case SHARE_DETAIL: {
                Long modelId = Long.parseLong(currentSelectNode.getModelId());
                Long detailId = Long.parseLong(currentSelectNode.getDataId());
                String measureNumber = currentSelectNode.getData().getMeasureNumber();
                DynamicObject detail = DataReviewHelper.getDetailById((Long)modelId, (Long)detailId, (String)measureNumber);
                subExecLogId = detail.getLong("subexeclogid");
                if (DataReviewBusinessTypeEnum.DERIVATION_DETAIL == reviewBusinessTypeEnum) {
                    PADerivationRuleInfoDTO derivationRuleInfoDTO = DataReviewHelper.getDerivationRuleInfoByExeLogId((Long)subExecLogId);
                    businessRulePkId = derivationRuleInfoDTO.getBusinessRuleId();
                    break;
                }
                PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId((Long)subExecLogId);
                businessRulePkId = shareRuleInfoDTO.getBusinessRuleId();
                break;
            }
            case DERIVATION_SUMMARY: 
            case SHARE_SUMMARY: {
                subExecLogId = Long.parseLong(currentSelectNode.getData().getSubExecLogId());
                if (DataReviewBusinessTypeEnum.DERIVATION_SUMMARY == reviewBusinessTypeEnum) {
                    PADerivationRuleInfoDTO derivationRuleInfoDTO = DataReviewHelper.getDerivationRuleInfoByExeLogId((Long)subExecLogId);
                    businessRulePkId = derivationRuleInfoDTO.getBusinessRuleId();
                    break;
                }
                PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId((Long)subExecLogId);
                businessRulePkId = shareRuleInfoDTO.getBusinessRuleId();
                break;
            }
        }
        DynamicObject ruleExecLog = BusinessDataServiceHelper.loadSingleFromCache((Object)subExecLogId, (String)"pa_ruleexeclog");
        DynamicObject businessRule = BusinessDataServiceHelper.loadSingleFromCache((Object)businessRulePkId, (String)"pa_businessrule");
        DynamicObjectCollection stepEntry = businessRule.getDynamicObjectCollection("stepentry");
        int stepIndex = 0;
        for (DynamicObject step : stepEntry) {
            String cardHandleType = step.getString("cardhandletype");
            if (cardHandleType.equals(ruleExecLog.getString("rule_type"))) {
                DataReviewRuleTypeEnum cardHandleTypeEnum = DataReviewRuleTypeEnum.getEnumByCode((String)cardHandleType);
                switch (cardHandleTypeEnum) {
                    case DERIVATION: {
                        if (step.getDynamicObject("cardderivationmodel").getLong("id") != ruleExecLog.getLong("rule_pk")) break;
                        return new Tuple((Object)businessRulePkId, (Object)stepIndex);
                    }
                    case SHARE: {
                        if (step.getDynamicObject("cardsharemodel").getLong("id") != ruleExecLog.getLong("rule_pk")) break;
                        return new Tuple((Object)businessRulePkId, (Object)stepIndex);
                    }
                }
            }
            ++stepIndex;
        }
        return new Tuple((Object)businessRulePkId, (Object)0);
    }

    private ReportQueryParam getReportQueryOfDetails() {
        Node currentSelectNode = this.getCurrentSelectNode();
        Long modelId = Long.parseLong(currentSelectNode.getModelId());
        Long summaryId = Long.parseLong(currentSelectNode.getDataId());
        String measureNumber = currentSelectNode.getData().getMeasureNumber();
        Long dateStamp = Long.parseLong(currentSelectNode.getDetailDatestamp());
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject anaModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)modelId);
        filterInfo.addFilterItem("anasystem", (Object)anaModel.getDynamicObject("analysis_system"), "67");
        filterInfo.addFilterItem("anamodel", (Object)anaModel, "67");
        filterInfo.addFilterItem("datatype", (Object)"2", "105");
        PASummaryDataByStampDTO paSummaryDataByStampDTO = new PASummaryDataByStampDTO(modelId, summaryId, measureNumber, dateStamp);
        Object[] detailIds = paSummaryDataByStampDTO.getDetailsOfSummaryByCurrentDateStamp().stream().map(dy -> dy.getLong("id")).toArray();
        if (ArrayUtils.isEmpty((Object[])detailIds)) {
            return null;
        }
        filterInfo.addFilterItem("detailids", (Object)JSON.toJSONString((Object)detailIds), "105");
        return reportQueryParam;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String eventData = e.getEventArgs();
        try {
            CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL);
            block6 : switch (eventName) {
                case "mounted": {
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    Long modelId = (Long)formShowParameter.getCustomParam("modelId");
                    Long summaryId = (Long)formShowParameter.getCustomParam("summaryId");
                    String measureNumber = (String)formShowParameter.getCustomParam("measureNumber");
                    String initNodeData = PADataReviewBuilder.init((Long)modelId, (Long)summaryId, (String)measureNumber);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("date", new Date().getTime());
                    data.put("init", JSONObject.parseObject((String)initNodeData));
                    data.put("event", "init");
                    JSONArray nodes = (JSONArray)JSONObject.parseObject((String)initNodeData).get((Object)"nodes");
                    if (nodes != null) {
                        data.put("highlight", nodes.getJSONObject(0).get((Object)"id"));
                    }
                    customControl.setData(data);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nodeinfoflex"});
                    break;
                }
                case "nodeClick": {
                    JSONObject eventDataJson = JSONObject.parseObject((String)eventData);
                    DataReviewNodeTypeEnum dataReviewNodeTypeEnum = DataReviewNodeTypeEnum.getEnumByCode((String)eventDataJson.getString("type"));
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("date", new Date().getTime());
                    switch (dataReviewNodeTypeEnum) {
                        case NODE: {
                            this.getView().getPageCache().put("currentSelectNode", eventData);
                            Node node = (Node)JSONObject.parseObject((String)eventData, Node.class);
                            this.initNodeInfoFlex(node);
                            this.getView().setVisible(Boolean.TRUE, new String[]{"nodeinfoflex"});
                            this.getView().updateView("nodeinfoflex");
                            break block6;
                        }
                        case SOURCE_NODE: {
                            Node node = (Node)JSONObject.parseObject((String)eventDataJson.getString("relative"), Node.class);
                            String sourceNodeReviewResultData = PADataReviewBuilder.leftTrace((Node)node);
                            params.put("add", JSONObject.parseObject((String)sourceNodeReviewResultData));
                            params.put("replace", eventDataJson.getString("id"));
                            params.put("event", "replace");
                            customControl.setData(params);
                            break block6;
                        }
                        case MORE_NODE: {
                            Long moreNodeId = eventDataJson.getLong("id");
                            ArrayList<Object> selectedDetailIds = new ArrayList<Object>((Collection<Object>)eventDataJson.getJSONArray("brothers"));
                            Node shareSummaryNode = (Node)JSONObject.parseObject((String)eventDataJson.getString("relative"), Node.class);
                            PADataTraceShareMoreSelectFormPlugin.openBy(moreNodeId, selectedDetailIds, shareSummaryNode, this);
                            break block6;
                        }
                    }
                    break;
                }
                case "nodeClearClick": {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nodeinfoflex"});
                }
            }
        }
        catch (Exception exception) {
            throw new KDBizException((Throwable)exception, new ErrorCode("DataTraceError", exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()), new Object[]{exception.getMessage()});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("shareDetailSelect".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            String parentNodeId = (String)returnData.get("parentNodeId");
            Long modelId = Long.parseLong((String)returnData.get("modelId"));
            List selectedDetailIds = (List)returnData.get("newSelectedDetailIds");
            String measureNumber = (String)returnData.get("measureNumber");
            Long moreNodeId = (Long)returnData.get("moreNodeId");
            String trunkDetailNodeId = (String)returnData.get("trunkDetailNodeId");
            Long trunkDetailDataId = Long.parseLong((String)returnData.get("trunkDetailDataId"));
            List oldSelectedNodeIds = (List)returnData.get("oldSelectedNodeIds");
            String removeNodeData = PADataReviewBuilder.buildRemoveShareDetailsBy((String)parentNodeId, (List)oldSelectedNodeIds, (Long)moreNodeId, (String)trunkDetailNodeId);
            String nodeData = PADataReviewBuilder.buildShareDetailsBy((String)parentNodeId, (Long)modelId, (List)selectedDetailIds, (String)measureNumber, (Long)trunkDetailDataId);
            CustomControl customControl = (CustomControl)this.getControl(KEY_CUSTOM_CONTROL);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("date", new Date().getTime());
            params.put("add", JSONObject.parseObject((String)nodeData));
            params.put("remove", JSONObject.parseObject((String)removeNodeData));
            params.put("event", "remove");
            customControl.setData(params);
        }
    }

    private Node getCurrentSelectNode() {
        String currentSelectNodeJson = this.getView().getPageCache().get("currentSelectNode");
        return (Node)JSONObject.parseObject((String)currentSelectNodeJson, Node.class);
    }

    private void initNodeInfoFlex(Node node) {
        Long modelId = Long.parseLong(node.getModelId());
        Long dataId = Long.parseLong(node.getDataId());
        Long detailDatestamp = Long.parseLong(node.getDetailDatestamp());
        String measureNumber = node.getData().getMeasureNumber();
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        DataReviewBusinessTypeEnum reviewBusinessTypeEnum = DataReviewBusinessTypeEnum.getEnumByCode((String)node.getData().getTypeValue());
        switch (reviewBusinessTypeEnum) {
            case DETAIL: {
                DynamicObject detail = DataReviewHelper.getDetailById((Long)modelId, (Long)dataId, (String)measureNumber);
                this.initDetailBaseInfo(model, detail, measureNumber);
                this.getView().setVisible(Boolean.FALSE, new String[]{"ruleflex"});
                break;
            }
            case SUMMARY: {
                this.initSummaryBaseInfo(model, dataId, detailDatestamp, measureNumber);
                this.getView().setVisible(Boolean.FALSE, new String[]{"ruleflex"});
                break;
            }
            case DERIVATION_DETAIL: 
            case SHARE_DETAIL: {
                DynamicObject detail = DataReviewHelper.getDetailById((Long)modelId, (Long)dataId, (String)measureNumber);
                this.initDetailBaseInfo(model, detail, measureNumber);
                Long subExecLogId = detail.getLong("subexeclogid");
                this.initBusinessRuleInfo(subExecLogId, detail, reviewBusinessTypeEnum);
                this.getView().setVisible(Boolean.TRUE, new String[]{"ruleflex"});
                break;
            }
            case DERIVATION_SUMMARY: 
            case SHARE_SUMMARY: {
                this.initSummaryBaseInfo(model, dataId, detailDatestamp, measureNumber);
                Long subExecLogId = Long.parseLong(node.getData().getSubExecLogId());
                DynamicObject summary = DataReviewHelper.getSummaryById((Long)modelId, (Long)dataId, (String)measureNumber);
                this.initBusinessRuleInfo(subExecLogId, summary, reviewBusinessTypeEnum);
                this.getView().setVisible(Boolean.TRUE, new String[]{"ruleflex"});
                break;
            }
        }
        this.getView().updateView("nodeinfoflex");
    }

    private void initBusinessRuleInfo(Long subExecLogId, DynamicObject modelData, DataReviewBusinessTypeEnum dataReviewBusinessTypeEnum) {
        IDataModel model = this.getModel();
        model.deleteEntryData("sourceentry");
        model.deleteEntryData("targetentry");
        String ruleTitle = "";
        Label modelLabel = (Label)this.getView().getControl("modelabel");
        Label sourceLabel = (Label)this.getView().getControl("sourcelabel");
        Label targetLabel = (Label)this.getView().getControl("targetlabel");
        switch (dataReviewBusinessTypeEnum) {
            case DERIVATION_DETAIL: 
            case DERIVATION_SUMMARY: {
                int i;
                ruleTitle = ResManager.loadKDString((String)"\u63a8\u5bfc\u4fe1\u606f", (String)"PADataTraceCustomControlFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                modelLabel.setText(ResManager.loadKDString((String)"\u63a8\u5bfc\u65b9\u5f0f", (String)"PADataTraceCustomControlFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                sourceLabel.setText(ResManager.loadKDString((String)"\u6e90\u7ef4\u5ea6", (String)"PADataTraceCustomControlFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                targetLabel.setText(ResManager.loadKDString((String)"\u76ee\u6807\u7ef4\u5ea6", (String)"PADataTraceCustomControlFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                PADerivationRuleInfoDTO derivationRuleInfoDTO = DataReviewHelper.getDerivationRuleInfoByExeLogId((Long)subExecLogId);
                DerivationTypeEnum derivationModeEnum = derivationRuleInfoDTO.getDerivationModeEnum();
                List sourceDimensionList = derivationRuleInfoDTO.getSourceDimensionList();
                List targetDimensionList = derivationRuleInfoDTO.getTargetDimensionList();
                Label ruleLabel = (Label)this.getControl("rulelabel");
                ruleLabel.setText(derivationRuleInfoDTO.getBusinessRuleName());
                model.beginInit();
                ComboProp derivationModeCombo = (ComboProp)EntityMetadataCache.getDataEntityType((String)"pa_derivationrule").getProperty("derivationmode");
                LocaleString derivationName = derivationModeCombo.getComboItems().stream().filter(item -> item.getValue().equals(derivationModeEnum.getType())).map(ValueMapItem::getName).findFirst().orElseGet(LocaleString::new);
                ((Label)this.getView().getControl("label_name")).setText(derivationName.toString());
                switch (derivationModeEnum) {
                    case DERIVATION_MAPPING_TABLE: {
                        ((Label)this.getView().getControl("label_value")).setText(derivationRuleInfoDTO.getSourceBaseData().getString("name"));
                        break;
                    }
                    case DERIVATION_MAPPING_RELATIONSHIP: {
                        ((Label)this.getView().getControl("label_value")).setText(derivationRuleInfoDTO.getMappingRelationship().getString("name"));
                        break;
                    }
                    case DERIVATION_CUSTOM: {
                        ((Label)this.getView().getControl("label_value")).setText("");
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)sourceDimensionList)) {
                    model.batchCreateNewEntryRow("sourceentry", sourceDimensionList.size());
                    DynamicObjectCollection sourceEntryEntity = this.getModel().getEntryEntity("sourceentry");
                    DynamicProperty sourceName = sourceEntryEntity.getDynamicObjectType().getProperty("sourcename");
                    DynamicProperty sourceValue = sourceEntryEntity.getDynamicObjectType().getProperty("sourcevalue");
                    for (i = 0; i < sourceDimensionList.size(); ++i) {
                        DynamicObject sourceDimension = (DynamicObject)sourceDimensionList.get(i);
                        DynamicObject sourceEntry = (DynamicObject)sourceEntryEntity.get(i);
                        sourceName.setValueFast((Object)sourceEntry, (Object)sourceDimension.getString("name"));
                        sourceValue.setValueFast((Object)sourceEntry, (Object)DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)sourceDimension, (DynamicObject)modelData));
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)targetDimensionList)) {
                    model.batchCreateNewEntryRow("targetentry", targetDimensionList.size());
                    DynamicObjectCollection targetEntryEntity = this.getModel().getEntryEntity("targetentry");
                    DynamicProperty targetName = targetEntryEntity.getDynamicObjectType().getProperty("targetname");
                    DynamicProperty targetValue = targetEntryEntity.getDynamicObjectType().getProperty("targetvalue");
                    for (i = 0; i < targetDimensionList.size(); ++i) {
                        DynamicObject targetDimension = (DynamicObject)targetDimensionList.get(i);
                        DynamicObject targetEntry = (DynamicObject)targetEntryEntity.get(i);
                        targetName.setValueFast((Object)targetEntry, (Object)targetDimension.getString("name"));
                        targetValue.setValueFast((Object)targetEntry, (Object)DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)targetDimension, (DynamicObject)modelData));
                    }
                }
                model.endInit();
                break;
            }
            case SHARE_DETAIL: 
            case SHARE_SUMMARY: {
                LocaleString conditionName;
                int i;
                ruleTitle = ResManager.loadKDString((String)"\u5206\u644a\u4fe1\u606f", (String)"PADataTraceCustomControlFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                modelLabel.setText(ResManager.loadKDString((String)"\u5206\u644a\u65b9\u5f0f", (String)"PADataTraceCustomControlFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                sourceLabel.setText(ResManager.loadKDString((String)"\u53d1\u9001\u65b9\u6761\u4ef6", (String)"PADataTraceCustomControlFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                targetLabel.setText(ResManager.loadKDString((String)"\u63a5\u6536\u65b9\u6761\u4ef6", (String)"PADataTraceCustomControlFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId((Long)subExecLogId);
                ShareTypeEnum shareTypeEnum = shareRuleInfoDTO.getShareTypeEnum();
                List sendDimensionInfos = shareRuleInfoDTO.getSendDimensionInfos();
                List receiveDimensionInfos = shareRuleInfoDTO.getReceiveDimensionInfos();
                Label ruleLabel = (Label)this.getControl("rulelabel");
                ruleLabel.setText(shareRuleInfoDTO.getBusinessRuleName());
                model.beginInit();
                ComboProp derivationModeCombo = (ComboProp)EntityMetadataCache.getDataEntityType((String)"pa_sharerulenew").getProperty("receiverule");
                LocaleString derivationName = derivationModeCombo.getComboItems().stream().filter(item -> item.getValue().equals(shareTypeEnum.getType())).map(ValueMapItem::getName).findFirst().orElseGet(LocaleString::new);
                ((Label)this.getView().getControl("label_name")).setText(derivationName.toString());
                switch (shareTypeEnum) {
                    case SHARE_FACTOR: {
                        ((Label)this.getView().getControl("label_value")).setText(shareRuleInfoDTO.getShareFactor().getString("name"));
                        break;
                    }
                    case SHARE_SUBJECT: {
                        ((Label)this.getView().getControl("label_value")).setText(shareRuleInfoDTO.getMeasure().getString("name"));
                        break;
                    }
                    case SHARE_FIXED: {
                        ((Label)this.getView().getControl("label_value")).setText("");
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)sendDimensionInfos)) {
                    model.batchCreateNewEntryRow("sourceentry", sendDimensionInfos.size());
                    DynamicObjectCollection sourceEntryEntity = this.getModel().getEntryEntity("sourceentry");
                    DynamicProperty sourceName = sourceEntryEntity.getDynamicObjectType().getProperty("sourcename");
                    DynamicProperty sourceValue = sourceEntryEntity.getDynamicObjectType().getProperty("sourcevalue");
                    block37: for (i = 0; i < sendDimensionInfos.size(); ++i) {
                        ThreeTuple sendDimensionInfo = (ThreeTuple)sendDimensionInfos.get(i);
                        DynamicObject sourceEntry = (DynamicObject)sourceEntryEntity.get(i);
                        sourceName.setValueFast((Object)sourceEntry, (Object)((DynamicObject)sendDimensionInfo.item1).getString("name"));
                        switch ((String)sendDimensionInfo.item2) {
                            case "A": {
                                sourceValue.setValueFast((Object)sourceEntry, sendDimensionInfo.item3);
                                continue block37;
                            }
                            case "B": {
                                sourceValue.setValueFast((Object)sourceEntry, (Object)String.format(ResManager.loadKDString((String)"\u4e0d\u5728%s\u4e2d", (String)"PADataTraceCustomControlFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]), sendDimensionInfo.item3));
                                continue block37;
                            }
                            case "C": 
                            case "D": 
                            case "E": {
                                ComboProp sendDimensionConditionCombo = (ComboProp)((EntryProp)EntityMetadataCache.getDataEntityType((String)"pa_sharerulenew").getProperty("sendentryentity")).getDynamicCollectionItemPropertyType().getProperty("combofield");
                                conditionName = sendDimensionConditionCombo.getComboItems().stream().filter(item -> item.getValue().equals(sendDimensionInfo.item2)).map(ValueMapItem::getName).findFirst().orElseGet(LocaleString::new);
                                sourceValue.setValueFast((Object)sourceEntry, (Object)conditionName.toString());
                            }
                        }
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)receiveDimensionInfos)) {
                    model.batchCreateNewEntryRow("targetentry", receiveDimensionInfos.size());
                    DynamicObjectCollection targetEntryEntity = this.getModel().getEntryEntity("targetentry");
                    DynamicProperty targetName = targetEntryEntity.getDynamicObjectType().getProperty("targetname");
                    DynamicProperty targetValue = targetEntryEntity.getDynamicObjectType().getProperty("targetvalue");
                    block38: for (i = 0; i < receiveDimensionInfos.size(); ++i) {
                        ThreeTuple receiveDimensionInfo = (ThreeTuple)receiveDimensionInfos.get(i);
                        DynamicObject targetEntry = (DynamicObject)targetEntryEntity.get(i);
                        targetName.setValueFast((Object)targetEntry, (Object)((DynamicObject)receiveDimensionInfo.item1).getString("name"));
                        switch ((String)receiveDimensionInfo.item2) {
                            case "A": {
                                targetValue.setValueFast((Object)targetEntry, receiveDimensionInfo.item3);
                                continue block38;
                            }
                            case "D": 
                            case "E": {
                                ComboProp receiveDimensionConditionCombo = (ComboProp)((EntryProp)EntityMetadataCache.getDataEntityType((String)"pa_sharerulenew").getProperty("receiveentryentity")).getDynamicCollectionItemPropertyType().getProperty("comboreceive");
                                conditionName = receiveDimensionConditionCombo.getComboItems().stream().filter(item -> item.getValue().equals(receiveDimensionInfo.item2)).map(ValueMapItem::getName).findFirst().orElseGet(LocaleString::new);
                                targetValue.setValueFast((Object)targetEntry, (Object)conditionName.toString());
                            }
                        }
                    }
                }
                model.endInit();
                break;
            }
        }
        HashMap<String, LocaleString> param = new HashMap<String, LocaleString>(1);
        param.put("text", new LocaleString(ruleTitle));
        this.getView().updateControlMetadata("ruleflex", param);
    }

    private void initDetailBaseInfo(DynamicObject anaModel, DynamicObject dataModel, String measureNumber) {
        LinkedHashMap<String, String> dimensionAndMeasureNameValueMap = new LinkedHashMap<String, String>();
        for (DynamicObject entry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            DynamicObject dimension = entry.getDynamicObject("dimension");
            String dimensionName = dimension.getString("name");
            String dimensionValue = DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)dimension, (DynamicObject)dataModel);
            dimensionAndMeasureNameValueMap.put(dimensionName, dimensionValue);
        }
        for (DynamicObject entry : anaModel.getDynamicObjectCollection("measure_entry")) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String number = measure.getString("number");
            if (!number.equals(measureNumber)) continue;
            int measureScale = PAMeasureHelper.getMeasureScale((Long)anaModel.getDynamicObject("analysis_system").getLong("id"), (String)number);
            BigDecimal measureValue = (dataModel.getBigDecimal(number) != null ? dataModel.getBigDecimal(number) : BigDecimal.ZERO).setScale(measureScale, 4);
            dimensionAndMeasureNameValueMap.put(measure.getString("name"), measureValue.toString());
            break;
        }
        this.initBaseInfoEntry(dimensionAndMeasureNameValueMap);
        this.getView().setVisible(Boolean.FALSE, new String[]{"detailflex"});
        this.getView().setVisible(Boolean.valueOf(dimensionAndMeasureNameValueMap.size() > 10), new String[]{"moreflex"});
    }

    private void initSummaryBaseInfo(DynamicObject anaModel, Long summaryId, Long detailDatestamp, String measureNumber) {
        DynamicObject summary = DataReviewHelper.getSummaryById((Long)anaModel.getLong("id"), (Long)summaryId, (String)measureNumber);
        LinkedHashMap<String, String> dimensionAndMeasureNameValueMap = new LinkedHashMap<String, String>();
        for (DynamicObject entry : anaModel.getDynamicObjectCollection("dimension_entry")) {
            DynamicObject dimension = entry.getDynamicObject("dimension");
            String dimensionName = dimension.getString("name");
            String dimensionValue = DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)dimension, (DynamicObject)summary);
            dimensionAndMeasureNameValueMap.put(dimensionName, dimensionValue);
        }
        List allOrderlyDetailsOfSummaryId = DataReviewHelper.getAllOrderlyDetailsOfSummaryId((Long)anaModel.getLong("id"), (Long)summaryId, (String)measureNumber);
        ArrayList detailsOfSummaryByStamp = new ArrayList(4);
        List detailsByDatestamp = DataReviewHelper.getDetailsByDatestamp((List)allOrderlyDetailsOfSummaryId, (Long)detailDatestamp);
        if (!CollectionUtils.isEmpty((Collection)detailsByDatestamp)) {
            detailsOfSummaryByStamp.addAll(detailsByDatestamp);
        }
        detailsOfSummaryByStamp.addAll(DataReviewHelper.getDetailsOfLastStepSummary((List)allOrderlyDetailsOfSummaryId, (Long)detailDatestamp));
        for (DynamicObject entry : anaModel.getDynamicObjectCollection("measure_entry")) {
            DynamicObject measure = entry.getDynamicObject("measure");
            String number = measure.getString("number");
            if (!number.equals(measureNumber)) continue;
            int measureScale = PAMeasureHelper.getMeasureScale((Long)anaModel.getDynamicObject("analysis_system").getLong("id"), (String)number);
            if (!CollectionUtils.isEmpty((Collection)allOrderlyDetailsOfSummaryId)) {
                String measureValue = detailsOfSummaryByStamp.stream().map(detail -> {
                    BigDecimal detailMeasureValue = detail.getBigDecimal(measureNumber);
                    return detailMeasureValue != null ? detailMeasureValue : BigDecimal.ZERO;
                }).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).setScale(measureScale, 4).toString();
                dimensionAndMeasureNameValueMap.put(measure.getString("name"), measureValue);
                break;
            }
            BigDecimal measureValue = summary.getBigDecimal(number) != null ? summary.getBigDecimal(number) : BigDecimal.ZERO;
            dimensionAndMeasureNameValueMap.put(measure.getString("name"), measureValue.setScale(measureScale, 4).toString());
            break;
        }
        this.initBaseInfoEntry(dimensionAndMeasureNameValueMap);
        this.getView().setVisible(Boolean.TRUE, new String[]{"detailflex"});
        this.getView().setVisible(Boolean.valueOf(dimensionAndMeasureNameValueMap.size() > 10), new String[]{"moreflex"});
        Label detailInfoLabel = (Label)this.getControl("detaillabel");
        detailInfoLabel.setText(String.format(ResManager.loadKDString((String)"%s\u6761", (String)"PADataTraceCustomControlFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]), detailsOfSummaryByStamp.size()));
    }

    private void initBaseInfoEntry(Map<String, String> dimensionAndMeasureNameValueMap) {
        IDataModel model = this.getModel();
        this.getModel().deleteEntryData("basedataentry");
        model.beginInit();
        this.getModel().batchCreateNewEntryRow("basedataentry", dimensionAndMeasureNameValueMap.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("basedataentry");
        DynamicObjectType baseDataEntryType = ((DynamicObject)entryEntity.get(0)).getDynamicObjectType();
        int index = 0;
        for (Map.Entry<String, String> entry : dimensionAndMeasureNameValueMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            baseDataEntryType.getProperty("dimensionname").setValueFast((Object)dynamicObject, (Object)entry.getKey());
            baseDataEntryType.getProperty("dimensionvalue").setValueFast((Object)dynamicObject, (Object)entry.getValue());
            ++index;
        }
        model.endInit();
    }
}

