/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PAMeasureHelper;
import kd.fi.pa.review.DataReviewHelper;
import kd.fi.pa.review.dto.PAShareRuleInfoDTO;
import kd.fi.pa.review.dto.PASummaryDataByStampDTO;
import kd.fi.pa.review.model.Node;

public class PADataTraceShareMoreSelectFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String FORM_ID = "pa_data_review_select";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry cardentry = (CardEntry)this.getControl("cardentry");
        cardentry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"confirm"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCardEntry();
    }

    private void initCardEntry() {
        Long subExecLogId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = Long.parseLong((String)formShowParameter.getCustomParam("modelId"));
        String measureNumber = (String)formShowParameter.getCustomParam("measureNumber");
        Long parentSummaryId = Long.parseLong((String)formShowParameter.getCustomParam("summaryId"));
        List detailsByExecLogId = DataReviewHelper.getDetailsByExecLogId((Long)modelId, (Long)parentSummaryId, (Long)(subExecLogId = Long.valueOf(Long.parseLong((String)formShowParameter.getCustomParam("subExecLogId")))), (String)measureNumber, (DataStatusEnum)DataStatusEnum.ALLOCATE, (Long[])new Long[0]).stream().sorted(Comparator.comparing(detail -> detail.getBigDecimal(measureNumber), Comparator.reverseOrder())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(detailsByExecLogId)) {
            this.getModel().batchCreateNewEntryRow("cardentry", detailsByExecLogId.size());
            DynamicObjectCollection cardentry = this.getModel().getEntryEntity("cardentry");
            DynamicProperty detailId = cardentry.getDynamicObjectType().getProperty("detailid");
            DynamicProperty cardAmount = cardentry.getDynamicObjectType().getProperty("cardamount");
            DynamicProperty cardOrg = cardentry.getDynamicObjectType().getProperty("cardorg");
            DynamicProperty cardAccount = cardentry.getDynamicObjectType().getProperty("cardaccount");
            DynamicProperty cardDimension = cardentry.getDynamicObjectType().getProperty("carddimension");
            DynamicProperty proportion = cardentry.getDynamicObjectType().getProperty("proportion");
            DynamicObject anaModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)modelId);
            Map dimensionNecessityMap = DataReviewHelper.getDimensionNecessityMap((DynamicObject)anaModel);
            BigDecimal totalMeasureValue = detailsByExecLogId.stream().map(detail -> detail.getBigDecimal(measureNumber)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            int measureScale = PAMeasureHelper.getMeasureScale((Long)anaModel.getDynamicObject("analysis_system").getLong("id"), (String)measureNumber);
            String measureName = anaModel.getDynamicObjectCollection("measure_entry").stream().filter(measureEntry -> measureEntry.getDynamicObject("measure").getString("number").equals(measureNumber)).map(measureEntry -> measureEntry.getDynamicObject("measure").getString("name")).findFirst().orElse("");
            DynamicObject firstDimensionInShareRule = this.getFirstDimensionWhichNotOrgInShareRule(subExecLogId, anaModel);
            int i = 0;
            for (DynamicObject detail2 : detailsByExecLogId) {
                DynamicObject accountDimension;
                DynamicObject cardEntity = (DynamicObject)cardentry.get(i);
                BigDecimal measureValue = detail2.getBigDecimal(measureNumber) != null ? detail2.getBigDecimal(measureNumber).setScale(measureScale, 4) : BigDecimal.ZERO.setScale(measureScale, 4);
                detailId.setValueFast((Object)cardEntity, (Object)detail2.getLong("id"));
                cardAmount.setValueFast((Object)cardEntity, (Object)String.format(ResManager.loadKDString((String)"%1$s %2$s", (String)"PADataTraceShareMoreSelectFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), measureName, measureValue));
                DynamicObject orgDimension = (DynamicObject)dimensionNecessityMap.get(DimensionNecessityEnum.ORG);
                if (orgDimension != null) {
                    cardOrg.setValueFast((Object)cardEntity, (Object)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7 : %s", (String)"PADataTraceShareMoreSelectFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)orgDimension, (DynamicObject)detail2)));
                }
                if ((accountDimension = (DynamicObject)dimensionNecessityMap.get(DimensionNecessityEnum.ACCOUNT)) != null) {
                    cardAccount.setValueFast((Object)cardEntity, (Object)String.format(ResManager.loadKDString((String)"\u79d1\u76ee : %s", (String)"PADataTraceShareMoreSelectFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)accountDimension, (DynamicObject)detail2)));
                }
                cardDimension.setValueFast((Object)cardEntity, (Object)String.format("%1$s : %2$s", firstDimensionInShareRule.getString("name"), DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)firstDimensionInShareRule, (DynamicObject)detail2)));
                if (totalMeasureValue.compareTo(BigDecimal.ZERO) != 0) {
                    proportion.setValueFast((Object)cardEntity, (Object)(String.format(ResManager.loadKDString((String)"\u5360\u6bd4%s", (String)"PADataTraceShareMoreSelectFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), detail2.getBigDecimal(measureNumber).multiply(new BigDecimal("100")).divide(totalMeasureValue, 2, 4)) + "%"));
                } else {
                    proportion.setValueFast((Object)cardEntity, (Object)"0.00%");
                }
                ++i;
            }
        }
    }

    private DynamicObject getFirstDimensionWhichNotOrgInShareRule(Long subExecLogId, DynamicObject anaModel) {
        PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId((Long)subExecLogId);
        String orgDimensionNumber = ((DynamicObject)DataReviewHelper.getDimensionNecessityMap((DynamicObject)anaModel).get(DimensionNecessityEnum.ORG)).getString("number");
        List receiveDimensions = shareRuleInfoDTO.getReceiveDimensionInfos().stream().map(t -> (DynamicObject)t.item1).collect(Collectors.toList());
        return receiveDimensions.stream().filter(dimension -> !orgDimensionNumber.equals(dimension.getString("number"))).findFirst().orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u63a8\u5bfc\u4e1a\u52a1\u6d41\u7a0b\u4e0d\u5b58\u5728\u975e\u7ec4\u7ec7\u5916\u7684\u6e90\u7ef4\u5ea6", (String)"PADataTraceShareMoreSelectFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0])));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPanelInfo();
        this.initDefaultSelectedCard();
        this.getView().setVisible(Boolean.TRUE, new String[]{"dimensionentry"});
    }

    private int[] getSelectedCardRow() {
        CardEntry cardEntry = (CardEntry)this.getControl("cardEntry");
        return cardEntry.getEntryState().getSelectedRows();
    }

    private void initPanelInfo() {
        Tuple accountNameAndValue;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = Long.parseLong((String)formShowParameter.getCustomParam("modelId"));
        Long summaryId = Long.parseLong((String)formShowParameter.getCustomParam("summaryId"));
        String measureNumber = (String)formShowParameter.getCustomParam("measureNumber");
        Long dateStamp = Long.parseLong((String)formShowParameter.getCustomParam("dateStamp"));
        PASummaryDataByStampDTO paSummaryDataByStampDTO = new PASummaryDataByStampDTO(modelId, summaryId, measureNumber, dateStamp);
        Tuple measureNameAndValue = paSummaryDataByStampDTO.getMeasureNameAndValue();
        Label amountLabel = (Label)this.getControl("amountlabel");
        amountLabel.setText(String.format("%1$s : %2$s", measureNameAndValue.item1, measureNameAndValue.item2));
        Tuple orgNameAndValue = paSummaryDataByStampDTO.getNecessaryDimensionNameAndValue(DimensionNecessityEnum.ORG);
        if (orgNameAndValue != null) {
            Label orgLabel = (Label)this.getControl("orglabel");
            orgLabel.setText(String.format("%1$s : %2$s", orgNameAndValue.item1, orgNameAndValue.item2));
        }
        if ((accountNameAndValue = paSummaryDataByStampDTO.getNecessaryDimensionNameAndValue(DimensionNecessityEnum.ACCOUNT)) != null) {
            Label accountLabel = (Label)this.getControl("accountlabel");
            accountLabel.setText(String.format("%1$s : %2$s", accountNameAndValue.item1, accountNameAndValue.item2));
        }
        Long subExecLogId = Long.parseLong((String)formShowParameter.getCustomParam("subExecLogId"));
        DynamicObject firstDimensionWhichNotOrgInShareRule = this.getFirstDimensionWhichNotOrgInShareRule(subExecLogId, paSummaryDataByStampDTO.getAnaModel());
        String firstDimensionName = firstDimensionWhichNotOrgInShareRule.getString("name");
        String firstDimensionValue = DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)firstDimensionWhichNotOrgInShareRule, (DynamicObject)paSummaryDataByStampDTO.getSummary());
        Label firstDimensionLabel = (Label)this.getControl("dimensionlabel");
        firstDimensionLabel.setText(String.format("%1$s : %2$s", firstDimensionName, firstDimensionValue));
        PAShareRuleInfoDTO shareRuleInfoDTO = DataReviewHelper.getShareRuleInfoByExeLogId((Long)subExecLogId);
        LocaleString shareTypeName = ((ComboProp)EntityMetadataCache.getDataEntityType((String)"pa_sharerulenew").getProperty("receiverule")).getComboItems().stream().filter(item -> shareRuleInfoDTO.getShareTypeEnum().getType().equals(item.getValue())).map(ValueMapItem::getName).findFirst().orElse(null);
        Label shareRuleLabel = (Label)this.getControl("sharerulelabel");
        shareRuleLabel.setText(shareTypeName == null ? "" : shareTypeName.toString());
    }

    private void initDefaultSelectedCard() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List selectedDetailIds = (List)formShowParameter.getCustomParam("selectedDetailIds");
        DynamicObjectCollection cardEntry = this.getModel().getEntryEntity("cardentry");
        int index = 0;
        int[] selectedIndexes = new int[selectedDetailIds.size()];
        for (int i = 0; i < cardEntry.size(); ++i) {
            DynamicObject detailEntity = (DynamicObject)cardEntry.get(i);
            if (!selectedDetailIds.contains(detailEntity.getString("detailid"))) continue;
            selectedIndexes[index++] = i;
        }
        CardEntry cardEntryControl = (CardEntry)this.getControl("cardEntry");
        cardEntryControl.selectRows(selectedIndexes, cardEntryControl.getEntryState().getFocusRow());
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm".equals(key)) {
            if (this.getSelectedCardRow().length > 10) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u5c55\u793a10\u4e2a\u5206\u644a\u660e\u7ec6\u5361\u7247\u3002", (String)"PADataTraceShareMoreSelectFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            HashMap<String, Object> returnParamMap = new HashMap<String, Object>(7);
            returnParamMap.put("modelId", formShowParameter.getCustomParam("modelId"));
            returnParamMap.put("newSelectedDetailIds", this.getDetailIdsByRows());
            returnParamMap.put("parentNodeId", formShowParameter.getCustomParam("parentNodeId"));
            returnParamMap.put("summaryId", formShowParameter.getCustomParam("summaryId"));
            returnParamMap.put("measureNumber", formShowParameter.getCustomParam("measureNumber"));
            returnParamMap.put("moreNodeId", formShowParameter.getCustomParam("moreNodeId"));
            returnParamMap.put("oldSelectedNodeIds", formShowParameter.getCustomParam("selectedNodeIds"));
            returnParamMap.put("trunkDetailNodeId", formShowParameter.getCustomParam("trunkDetailNodeId"));
            returnParamMap.put("trunkDetailDataId", formShowParameter.getCustomParam("trunkDetailDataId"));
            this.getView().returnDataToParent(returnParamMap);
            this.getView().close();
        }
    }

    private List<Long> getDetailIdsByRows() {
        int[] selectedCardRow = this.getSelectedCardRow();
        int cardIndex = 0;
        ArrayList<Long> detailIds = new ArrayList<Long>(selectedCardRow.length);
        for (DynamicObject detailCard : this.getModel().getEntryEntity("cardentry")) {
            if (ArrayUtils.contains((int[])selectedCardRow, (int)cardIndex)) {
                detailIds.add(detailCard.getLong("detailid"));
            }
            ++cardIndex;
        }
        return detailIds;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        CardEntry cardEntry = (CardEntry)this.getControl("cardEntry");
        AbstractGrid.GridState entryState = cardEntry.getEntryState();
        int focusRow = entryState.getFocusRow();
        int[] selectedRows = entryState.getSelectedRows();
        if (focusRow == this.getTrunkDetailCardIndex() && !ArrayUtils.contains((int[])selectedRows, (int)focusRow)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u8ffd\u6eaf\u7684\u6570\u636e\u4e0d\u80fd\u9690\u85cf\u3002", (String)"PADataTraceShareMoreSelectFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            int[] ints = new int[selectedRows.length + 1];
            ints[0] = focusRow;
            System.arraycopy(selectedRows, 0, ints, 1, selectedRows.length);
            CardEntry cardEntryControl = (CardEntry)this.getControl("cardEntry");
            cardEntryControl.selectRows(ints, focusRow);
            return;
        }
        if (ArrayUtils.contains((int[])selectedRows, (int)focusRow)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_detail"});
            this.initDimensionEntryInfo(focusRow);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_detail"});
        }
    }

    private int getTrunkDetailCardIndex() {
        String trunkDetailDataId = (String)this.getView().getFormShowParameter().getCustomParam("trunkDetailDataId");
        if (StringUtils.isBlank((CharSequence)trunkDetailDataId)) {
            throw new KDBizException("trunkDetailDataId is null.");
        }
        DynamicObjectCollection cardEntry = this.getModel().getEntryEntity("cardentry");
        for (int i = 0; i < cardEntry.size(); ++i) {
            DynamicObject detailEntity = (DynamicObject)cardEntry.get(i);
            if (!detailEntity.getString("detailid").equals(trunkDetailDataId)) continue;
            return i;
        }
        throw new KDBizException("trunkDetailDataId is not exist.");
    }

    private void initDimensionEntryInfo(int focusRow) {
        this.getModel().deleteEntryData("dimensionentry");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = Long.parseLong((String)formShowParameter.getCustomParam("modelId"));
        String measureNumber = (String)formShowParameter.getCustomParam("measureNumber");
        DynamicObject card = (DynamicObject)this.getModel().getEntryEntity("cardentry").get(focusRow);
        DynamicObject detailById = DataReviewHelper.getDetailById((Long)modelId, (Long)card.getLong("detailId"), (String)measureNumber);
        DynamicObject anaModel = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)modelId);
        DynamicObjectCollection dimensionEntryInModel = anaModel.getDynamicObjectCollection("dimension_entry");
        DynamicObjectCollection measureEntryInModel = anaModel.getDynamicObjectCollection("measure_entry");
        this.getModel().batchCreateNewEntryRow("dimensionentry", dimensionEntryInModel.size() + 1);
        DynamicObjectCollection dimensionEntry = this.getModel().getEntryEntity("dimensionentry");
        DynamicProperty dimensionName = dimensionEntry.getDynamicObjectType().getProperty("dimensionname");
        DynamicProperty dimensionValue = dimensionEntry.getDynamicObjectType().getProperty("dimensionvalue");
        int index = 0;
        this.getModel().beginInit();
        for (DynamicObject entry : dimensionEntryInModel) {
            DynamicObject dynamicObject = (DynamicObject)dimensionEntry.get(index++);
            DynamicObject dimension = entry.getDynamicObject("dimension");
            dimensionName.setValueFast((Object)dynamicObject, (Object)dimension.getString("name"));
            dimensionValue.setValueFast((Object)dynamicObject, (Object)DataReviewHelper.translateDataValueToDimensionValue((DynamicObject)dimension, (DynamicObject)detailById));
        }
        for (DynamicObject entry : measureEntryInModel) {
            DynamicObject measure = entry.getDynamicObject("measure");
            if (!measure.getString("number").equals(measureNumber)) continue;
            DynamicObject dynamicObject = (DynamicObject)dimensionEntry.get(index);
            int measureScale = PAMeasureHelper.getMeasureScale((Long)anaModel.getDynamicObject("analysis_system").getLong("id"), (String)measureNumber);
            dimensionName.setValueFast((Object)dynamicObject, (Object)measure.getString("name"));
            dimensionValue.setValueFast((Object)dynamicObject, (Object)detailById.getBigDecimal(measureNumber).setScale(measureScale, 4));
            break;
        }
        this.getModel().endInit();
        this.getView().updateView("dimensionentry");
    }

    public static void openBy(Long moreNodeId, List<Object> selectedDetailIds, Node shareSummaryNode, AbstractFormPlugin plugin) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(FORM_ID);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("moreNodeId", (Object)moreNodeId);
        formShowParameter.setCustomParam("selectedNodeIds", selectedDetailIds.stream().map(json -> ((JSONObject)json).getString("id")).collect(Collectors.toList()));
        formShowParameter.setCustomParam("selectedDetailIds", selectedDetailIds.stream().map(json -> ((JSONObject)json).getString("dataId")).collect(Collectors.toList()));
        formShowParameter.setCustomParam("trunkDetailNodeId", (Object)shareSummaryNode.getData().getTrunkDetailNodeId());
        formShowParameter.setCustomParam("trunkDetailDataId", (Object)shareSummaryNode.getData().getTrunkDetailDataId());
        formShowParameter.setCustomParam("parentNodeId", (Object)shareSummaryNode.getId());
        formShowParameter.setCustomParam("summaryId", (Object)shareSummaryNode.getDataId());
        formShowParameter.setCustomParam("modelId", (Object)shareSummaryNode.getModelId());
        formShowParameter.setCustomParam("subExecLogId", (Object)shareSummaryNode.getData().getSubExecLogId());
        formShowParameter.setCustomParam("measureNumber", (Object)shareSummaryNode.getData().getMeasureNumber());
        formShowParameter.setCustomParam("dateStamp", (Object)shareSummaryNode.getDetailDatestamp());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "shareDetailSelect"));
        plugin.getView().showForm(formShowParameter);
    }
}

