/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class PADerivationRulePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log logger = LogFactory.getLog(PADerivationRulePlugin.class);
    private static final String ALGO_KEY = PADerivationRulePlugin.class.getName();
    private static final String ENTRY_SENDER = "sendentryentity";
    private static final String FIELD_SEND_DIMENSION = "senddimension";
    private static final String FIELD_COMBOFIELD = "combofield";
    private static final String FIELD_DIMENSIONTEXT = "dimensiontext";
    private static final String FIELD_DIMENSIONVALUE_E = "dimensionvalue_e";
    private static final String FIELD_DIMENSIONVALUE = "dimensionvalue";
    private static final String FIELD_COMBO = "derivationmode";
    private static final String DERIVATION_MODE_MAPPING_MAP = "A";
    private static final String DERIVATION_MODE_MAPPING_RELATIONSHIP = "B";
    private static final String DERIVATION_MODE_CUSTOM = "C";
    private static final String DERIVATION_MODE_SCRIPT = "X";
    private static final String PANEL_MAPPING_MAP = "mappingmappanel";
    private static final String DIMENSION_MAPPING_TABLE_SOURCE = "mt_source";
    private static final String DIMENSION_MAPPING_TABLE_TARGET = "mt_target";
    private static final String ENTRY_MAPPING_TABLE_TARGET = "mt_target_entryentity";
    private static final String ENTRY_MAPPING_TABLE_SOURCE = "mt_source_entryentity";
    private static final String FIELD_MAPPING_MAP = "mappingmap";
    private static final String FIELD_MAPPING_MAP_TYPE = "mappingmaptype";
    private static final String FIELD_MAPPING_TABLE_SOURCE = "mt_sourcefield";
    private static final String FIELD_MAPPING_TABLE_M_SOURCE = "mt_m_sourcefield";
    private static final String FIELD_MAPPING_TABLE_TARGET = "mt_targetfield";
    private static final String FIELD_MAPPING_TABLE_M_TARGET = "mt_m_targetfield";
    private static final String FIELD_MAPPING_TABLE_M_DEFAULT_TEXT = "mt_m_default_text";
    private static final String FIELD_MAPPING_TABLE_M_DEFAULT_TEXT_E = "mt_m_default_text_e";
    private static final String FIELD_MAPPING_TABLE_M_DEFAULT_TYPE_BASE_DATA = "mt_m_fieldtype_basedata";
    private static final String FIELD_MAPPING_TABLE_M_DEFAULT_TYPE_ASSISTANT = "mt_m_fieldtype_assistant";
    private static final String FIELD_MAPPING_TABLE_SOURCE_TYPE = "mt_sourcefield_type";
    private static final String FIELD_MAPPING_TABLE_M_SOURCE_TYPE = "mt_m_sourcefield_type";
    private static final String FIELD_MAPPING_TABLE_SOURCE_NUMBER = "mt_sourcefield_number";
    private static final String FIELD_MAPPING_TABLE_M_SOURCE_NUMBER = "mt_m_sourcefield_number";
    private static final String FIELD_MAPPING_TABLE_TARGET_NUMBER = "mt_targetfield_number";
    private static final String FIELD_MAPPING_TABLE_M_TARGET_NUMBER = "mt_m_targetfield_number";
    private static final String FIELD_MAPPING_TABLE_TARGET_TYPE = "mt_targetfield_type";
    private static final String FIELD_MAPPING_TABLE_M_TARGET_TYPE = "mt_m_targetfield_type";
    private static final String PANEL_MAPPING_STRUCTURE = "mappingstructurepanel";
    private static final String ENTRY_SOURCE = "source_entryentity";
    private static final String ENTRY_TARGET = "target_entryentity";
    private static final String FIELD_MAPPING_RELATIONSHIP = "mappingrelationship";
    private static final String FIELD_MAPPING = "sourcefield";
    private static final String FIELD_TARGET = "targetfield";
    private static final String FIELD_DEFAULT_TARGET_TEXT = "default_text";
    private static final String FIELD_DEFAULT_TARGET_TEXT_E = "default_text_e";
    private static final String FIELD_TARGET_TYPE_BASE_DATA = "fieldtype_basedata";
    private static final String FIELD_TARGET_TYPE_ASSISTANT = "fieldtype_assistant";
    private static final String PANEL_CUSTOM = "custompanel";
    private static final String ENTRY_CUSTOM = "custom_entryentity";
    private static final String FIELD_CUSTOM_FILTERCONDITION = "filtercondition";
    private static final String FIELD_CUSTOM_FILTERCONDITIONJSON = "filterconditionjson";
    private static final String FIELD_CUSTOM_SOURCEDIM = "sourcedim";
    private static final String FIELD_CUSTOM_SOURCEDIMFIELD = "sourcedimfield";
    private static final String FIELD_CUSTOM_SOURCEDIMFIELDNUM = "sourcedimfieldnum";
    private static final String FIELD_CUSTOM_SOURCEDIMFIELDTYPE = "sourcedimfieldtype";
    private static final String FIELD_CUSTOM_TARGETDIM = "targetdim";
    private static final String FIELD_CUSTOM_TARGETDIMFIELD = "targetdimfield";
    private static final String FIELD_CUSTOM_TARGETDIMFIELDNUM = "targetdimfieldnum";
    private static final String FIELD_CUSTOM_TARGETDIMFIELDTYPE = "targetdimfieldtype";
    private static final String FIELD_CUSTOM_DEFAULTTEXT = "defaulttext";
    private static final String FIELD_CUSTOM_DEFAULTTEXTVALUE = "defaulttextvalue";
    private static final String FIELD_CUSTOM_DEFAULTTEXTENUM = "defaulttextenum";
    private static final String PANEL_SCRIPT = "scriptpanel";
    private static final String FIELD_CODE_EDIT = "usercodeeditap";

    public void afterCreateNewData(EventObject e) {
        this.processEntryEntity(DERIVATION_MODE_MAPPING_MAP);
        this.processDefaultData();
        this.processMustInput();
    }

    public void afterBindData(EventObject e) {
        String type = this.getModel().getValue(FIELD_COMBO).toString();
        this.processEntryEntity(type);
        this.processShowFormData();
        this.processInit();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FIELD_SEND_DIMENSION, FIELD_COMBOFIELD, FIELD_DIMENSIONVALUE_E});
        this.addClickListeners(new String[]{FIELD_MAPPING_MAP, DIMENSION_MAPPING_TABLE_SOURCE, DIMENSION_MAPPING_TABLE_TARGET, FIELD_MAPPING_TABLE_M_SOURCE, FIELD_MAPPING_TABLE_M_TARGET, FIELD_MAPPING_TABLE_SOURCE, FIELD_MAPPING_TABLE_TARGET, FIELD_MAPPING_TABLE_M_DEFAULT_TEXT_E});
        this.addClickListeners(new String[]{FIELD_MAPPING, FIELD_TARGET, FIELD_DEFAULT_TARGET_TEXT_E});
        this.addClickListeners(new String[]{FIELD_CUSTOM_FILTERCONDITION, FIELD_CUSTOM_SOURCEDIMFIELD, FIELD_CUSTOM_TARGETDIMFIELD, FIELD_CUSTOM_DEFAULTTEXT});
        BasedataEdit analysisModelEdit = (BasedataEdit)this.getControl("analysismodel");
        analysisModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sendDimensionEdit = (BasedataEdit)this.getControl(FIELD_SEND_DIMENSION);
        sendDimensionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mtSourceEdit = (BasedataEdit)this.getControl(DIMENSION_MAPPING_TABLE_SOURCE);
        mtSourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        mtSourceEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit mtTargetEdit = (BasedataEdit)this.getControl(DIMENSION_MAPPING_TABLE_TARGET);
        mtTargetEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mappingRelationShipEdit = (BasedataEdit)this.getControl(FIELD_MAPPING_RELATIONSHIP);
        mappingRelationShipEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit customSourceEdit = (BasedataEdit)this.getControl(FIELD_CUSTOM_SOURCEDIM);
        customSourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit customTargetEdit = (BasedataEdit)this.getControl(FIELD_CUSTOM_TARGETDIM);
        customTargetEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int entryRowCount;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            if (!this.validateData()) {
                args.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"mc_newentry", (CharSequence)operateKey) && (entryRowCount = this.getModel().getEntryRowCount(ENTRY_CUSTOM)) >= 5) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6761\u4ef6\u5206\u5f55\u6700\u591a\u53ef\u65b0\u589e5\u884c\u3002", (String)"PADerivationRulePlugin_21", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)fieldKey)) {
            DynamicObject analysisSystemDy = model.getDataEntity().getDynamicObject("analysissystem");
            if (analysisSystemDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PADerivationRulePlugin_22", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            long id = (Long)analysisSystemDy.getPkValue();
            QFilter idFilter = new QFilter("analysis_system", "=", (Object)id);
            evt.addCustomQFilter(idFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_SEND_DIMENSION, (CharSequence)fieldKey)) {
            DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADerivationRulePlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
            Set dimIdSet = dys.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", dimIdSet);
            evt.addCustomQFilter(idFilter);
            evt.addCustomQFilter(PADimensionHelper.getNoDateTimeDimFilter());
            DynamicObjectCollection entry = model.getEntryEntity(ENTRY_SENDER);
            if (entry != null && !entry.isEmpty()) {
                Set dimNotIdSet = entry.stream().filter(dy -> !ObjectUtils.isEmpty((Object)dy.get(FIELD_SEND_DIMENSION))).map(dy -> dy.getLong("senddimension_id")).collect(Collectors.toSet());
                QFilter filter = new QFilter("id", "not in", dimNotIdSet);
                evt.addCustomQFilter(filter);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)DIMENSION_MAPPING_TABLE_SOURCE, (CharSequence)fieldKey)) {
            DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADerivationRulePlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
            Set dimIdSet = dys.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", dimIdSet);
            evt.addCustomQFilter(idFilter);
            evt.addCustomQFilter(PADimensionHelper.getNoDateTimeDimFilter());
            evt.addCustomQFilter(PADimensionHelper.getNoEnumDimFilter());
            return;
        }
        if (StringUtils.equals((CharSequence)DIMENSION_MAPPING_TABLE_TARGET, (CharSequence)fieldKey)) {
            DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADerivationRulePlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
            Set dimIdSet = dys.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", dimIdSet);
            evt.addCustomQFilter(idFilter);
            evt.addCustomQFilter(PADimensionHelper.getNoDateTimeDimFilter());
            evt.addCustomQFilter(PADimensionHelper.getNoEnumDimFilter());
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_MAPPING_RELATIONSHIP, (CharSequence)fieldKey)) {
            DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADerivationRulePlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dimensionEntry = analysisModelDy.getDynamicObjectCollection("dimension_entry");
            List dimIdList = dimensionEntry.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toList());
            QFilter srcDimFilter = new QFilter("sourcedim.fbasedataid", "in", dimIdList);
            QFilter targetDimFilter = new QFilter("targetdim.fbasedataid", "in", dimIdList);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            Map relationDyMap = BusinessDataServiceHelper.loadFromCache((String)"pa_mappingrelationship", (String)"id,sourcedim.fbasedataid,targetdim.fbasedataid", (QFilter[])new QFilter[]{srcDimFilter, targetDimFilter, enableFilter});
            Set selectIdSet = relationDyMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            QFilter otherDimFilter = new QFilter("sourcedim.fbasedataid", "not in", dimIdList).or(new QFilter("targetdim.fbasedataid", "not in", dimIdList));
            QFilter selectIdFilter = new QFilter("id", "in", selectIdSet);
            Map otherRelationDyMap = BusinessDataServiceHelper.loadFromCache((String)"pa_mappingrelationship", (String)"id,sourcedim.fbasedataid,targetdim.fbasedataid", (QFilter[])new QFilter[]{otherDimFilter, selectIdFilter});
            Set otherIdSet = otherRelationDyMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            selectIdSet.removeAll(otherIdSet);
            QFilter idFilter = new QFilter("id", "in", selectIdSet);
            evt.addCustomQFilter(idFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_SOURCEDIM, (CharSequence)fieldKey)) {
            int customTargetIndex;
            Long targetDimId;
            DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADerivationRulePlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
            Set dimIdSet = dys.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
            if (!dimIdSet.isEmpty()) {
                QFilter idFilter = new QFilter("id", "in", dimIdSet);
                evt.addCustomQFilter(idFilter);
            }
            if ((targetDimId = (Long)model.getValue("targetdim_id", customTargetIndex = model.getEntryCurrentRowIndex(ENTRY_CUSTOM))) != null && targetDimId != 0L) {
                QFilter specialDimFilter = PADimensionHelper.getSpecialDimFilter((Long)targetDimId);
                evt.addCustomQFilter(specialDimFilter);
            } else {
                QFilter defaultDimFilter = PADimensionHelper.getDefaultDimFilter();
                evt.addCustomQFilter(defaultDimFilter);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_TARGETDIM, (CharSequence)fieldKey)) {
            DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PADerivationRulePlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
            Set dimIdSet = dys.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", dimIdSet);
            evt.addCustomQFilter(idFilter);
            int customTargetIndex = model.getEntryCurrentRowIndex(ENTRY_CUSTOM);
            Long sourceDimId = (Long)model.getValue("sourcedim_id", customTargetIndex);
            if (sourceDimId != null && sourceDimId != 0L) {
                QFilter specialDimFilter = PADimensionHelper.getSpecialDimFilter((Long)sourceDimId);
                evt.addCustomQFilter(specialDimFilter);
            } else {
                QFilter defaultDimFilter = PADimensionHelper.getDefaultDimFilter();
                evt.addCustomQFilter(defaultDimFilter);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)DIMENSION_MAPPING_TABLE_SOURCE, (CharSequence)fieldKey)) {
            DynamicObjectCollection dys = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_MAPPING_TABLE_SOURCE);
            for (int i = 0; i < dys.size(); ++i) {
                DimensionTypeEnum dimensionType;
                DynamicObject dimensionDy = ((DynamicObject)dys.get(i)).getDynamicObject(DIMENSION_MAPPING_TABLE_SOURCE);
                if (dimensionDy == null || DimensionTypeEnum.OTHER != (dimensionType = DimensionTypeEnum.getEnum((String)dimensionDy.getString("dimensiontype")))) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELD_MAPPING_TABLE_SOURCE});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = view.getPageCache();
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        switch (key) {
            case "analysissystem": 
            case "analysismodel": {
                Long oldPk;
                Long newPk;
                if (newValue != null && oldValue != null && (newPk = Long.valueOf(((DynamicObject)newValue).getLong("id"))).equals(oldPk = Long.valueOf(((DynamicObject)oldValue).getLong("id")))) {
                    return;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"analysismodel") && newValue != null && !ObjectUtils.isEmpty((Object)newValue)) {
                    Map<String, QFilter> dimensionFilters = this.processNecessityDimFilter(((DynamicObject)newValue).getPkValue());
                    pageCache.put("dimensionFilters", SerializationUtils.toJsonString(dimensionFilters));
                }
                if (StringUtils.equals((CharSequence)"analysissystem", (CharSequence)key)) {
                    model.setValue("analysismodel", null);
                }
                model.deleteEntryData(ENTRY_SENDER);
                model.deleteEntryData(ENTRY_MAPPING_TABLE_SOURCE);
                model.deleteEntryData(ENTRY_MAPPING_TABLE_TARGET);
                model.deleteEntryData(ENTRY_CUSTOM);
                model.createNewEntryRow(ENTRY_MAPPING_TABLE_SOURCE);
                model.createNewEntryRow(ENTRY_MAPPING_TABLE_TARGET);
                model.createNewEntryRow(ENTRY_CUSTOM);
                break;
            }
            case "derivationmode": {
                this.processEntryEntity(newValue.toString());
                this.processMustInput();
                break;
            }
            case "mappingmap": {
                if (StringUtils.isBlank((Object)newValue)) {
                    model.setValue(FIELD_MAPPING_MAP_TYPE, (Object)"");
                    this.processInitEntry(DERIVATION_MODE_MAPPING_MAP);
                }
                int size = model.getEntryEntity(ENTRY_MAPPING_TABLE_SOURCE).size();
                for (int i = 0; i < size; ++i) {
                    model.setValue(FIELD_MAPPING_TABLE_M_SOURCE, (Object)"", i);
                    model.setValue(FIELD_MAPPING_TABLE_M_SOURCE_NUMBER, (Object)"", i);
                    model.setValue(FIELD_MAPPING_TABLE_M_SOURCE_TYPE, (Object)"", i);
                }
                model.setValue(FIELD_MAPPING_TABLE_M_TARGET, (Object)"");
                model.setValue(FIELD_MAPPING_TABLE_M_TARGET_NUMBER, (Object)"");
                model.setValue(FIELD_MAPPING_TABLE_M_TARGET_TYPE, (Object)"");
                break;
            }
            case "mappingrelationship": {
                this.processMappingEntry();
                break;
            }
            case "senddimension": {
                this.processMappingFieldDefaultValue((DynamicObject)newValue, rowIndex, "dimensiontype_basedata", "dimensiontype_assistant", FIELD_DIMENSIONVALUE_E, FIELD_DIMENSIONVALUE);
                model.setValue(FIELD_DIMENSIONTEXT, (Object)"", rowIndex);
                model.setValue("dimensiontext_tag", (Object)"", rowIndex);
                break;
            }
            case "combofield": {
                model.setValue(FIELD_DIMENSIONVALUE_E, (Object)"", rowIndex);
                model.setValue(FIELD_DIMENSIONTEXT, (Object)"", rowIndex);
                model.setValue("dimensiontext_tag", (Object)"", rowIndex);
                if (StringUtils.equals((CharSequence)DERIVATION_MODE_MAPPING_MAP, (CharSequence)newValue.toString()) || StringUtils.equals((CharSequence)DERIVATION_MODE_MAPPING_RELATIONSHIP, (CharSequence)newValue.toString())) {
                    view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{FIELD_DIMENSIONVALUE_E});
                    break;
                }
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{FIELD_DIMENSIONVALUE_E});
                break;
            }
            case "mt_source": {
                this.processDimensionField(ENTRY_MAPPING_TABLE_SOURCE, key, FIELD_MAPPING_TABLE_SOURCE);
                this.getModel().setValue(FIELD_MAPPING_TABLE_SOURCE, (Object)"", rowIndex);
                this.getModel().setValue(FIELD_MAPPING_TABLE_SOURCE_NUMBER, (Object)"", rowIndex);
                this.getModel().setValue(FIELD_MAPPING_TABLE_SOURCE_TYPE, (Object)"", rowIndex);
                break;
            }
            case "mt_target": {
                this.processMappingFieldDefaultValue((DynamicObject)newValue, rowIndex, FIELD_MAPPING_TABLE_M_DEFAULT_TYPE_BASE_DATA, FIELD_MAPPING_TABLE_M_DEFAULT_TYPE_ASSISTANT, FIELD_MAPPING_TABLE_M_DEFAULT_TEXT, FIELD_MAPPING_TABLE_M_DEFAULT_TEXT_E);
                this.processDimensionField(ENTRY_MAPPING_TABLE_TARGET, key, FIELD_MAPPING_TABLE_TARGET);
                model.setValue(FIELD_MAPPING_TABLE_TARGET, (Object)"", rowIndex);
                model.setValue(FIELD_MAPPING_TABLE_TARGET_NUMBER, (Object)"", rowIndex);
                model.setValue(FIELD_MAPPING_TABLE_TARGET_TYPE, (Object)"", rowIndex);
                break;
            }
            case "mt_sourcefield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(FIELD_MAPPING_TABLE_SOURCE_NUMBER, (Object)"", rowIndex);
                model.setValue(FIELD_MAPPING_TABLE_SOURCE_TYPE, (Object)"", rowIndex);
                break;
            }
            case "mt_targetfield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(FIELD_MAPPING_TABLE_TARGET_NUMBER, (Object)"", rowIndex);
                model.setValue(FIELD_MAPPING_TABLE_TARGET_TYPE, (Object)"", rowIndex);
                break;
            }
            case "mt_m_sourcefield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(FIELD_MAPPING_TABLE_M_SOURCE_NUMBER, (Object)"", rowIndex);
                model.setValue(FIELD_MAPPING_TABLE_M_SOURCE_TYPE, (Object)"", rowIndex);
                break;
            }
            case "mt_m_targetfield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(FIELD_MAPPING_TABLE_M_TARGET_NUMBER, (Object)"", rowIndex);
                model.setValue(FIELD_MAPPING_TABLE_M_TARGET_TYPE, (Object)"", rowIndex);
                break;
            }
            case "default_text_e": 
            case "mt_m_default_text_e": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(key.substring(0, key.length() - 2), (Object)"");
                break;
            }
            case "filtercondition": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue("filterconditionjson_tag", (Object)"");
                break;
            }
            case "sourcedim": {
                model.setValue(FIELD_CUSTOM_SOURCEDIMFIELD, (Object)"", rowIndex);
                break;
            }
            case "sourcedimfield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(FIELD_CUSTOM_SOURCEDIMFIELDNUM, (Object)"", rowIndex);
                model.setValue(FIELD_CUSTOM_SOURCEDIMFIELDTYPE, (Object)"", rowIndex);
                break;
            }
            case "targetdim": {
                model.setValue(FIELD_CUSTOM_TARGETDIMFIELD, (Object)"", rowIndex);
                model.setValue(FIELD_CUSTOM_DEFAULTTEXT, (Object)"", rowIndex);
                break;
            }
            case "targetdimfield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                model.setValue(FIELD_CUSTOM_TARGETDIMFIELDNUM, (Object)"", rowIndex);
                model.setValue(FIELD_CUSTOM_TARGETDIMFIELDTYPE, (Object)"", rowIndex);
                break;
            }
            case "defaulttext": {
                if (StringUtils.isBlank((Object)newValue)) {
                    model.setValue(FIELD_CUSTOM_DEFAULTTEXTVALUE, (Object)"", rowIndex);
                    break;
                }
                model.beginInit();
                DynamicObject targetDimDy = (DynamicObject)model.getValue(FIELD_CUSTOM_TARGETDIM, rowIndex);
                if (targetDimDy != null) {
                    String dimensionType = targetDimDy.getString("dimensiontype");
                    DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
                    if (DimensionTypeEnum.OTHER == dimensionTypeEnum) {
                        model.setValue(FIELD_CUSTOM_DEFAULTTEXT, newValue, rowIndex);
                        model.setValue(FIELD_CUSTOM_DEFAULTTEXTVALUE, newValue, rowIndex);
                    } else {
                        model.setValue(FIELD_CUSTOM_DEFAULTTEXT, null, rowIndex);
                        model.setValue(FIELD_CUSTOM_DEFAULTTEXTVALUE, null, rowIndex);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u7ef4\u5ea6\u201d\u7684\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u662f\u6587\u672c\u3002", (String)"PADerivationRulePlugin_36", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    model.setValue(FIELD_CUSTOM_DEFAULTTEXT, null, rowIndex);
                    model.setValue(FIELD_CUSTOM_DEFAULTTEXTVALUE, null, rowIndex);
                    view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u76ee\u6807\u7ef4\u5ea6\u201d\u4e3a\u7a7a\u3002", (String)"PADerivationRulePlugin_37", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
                model.endInit();
                view.updateView(ENTRY_CUSTOM);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey()) {
            case "dimensionvalue_e": {
                this.processSenderDimF7();
                break;
            }
            case "mappingmap": {
                QFilter typeFilter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
                PARuleHelper.showF7ListView((AbstractFormPlugin)this, (String)"bos_listf7", (String)"bos_entityobject", (String)key, (String)key, (String)key, null, (QFilter)typeFilter, (boolean)false, null);
                break;
            }
            case "mt_sourcefield": 
            case "mt_targetfield": {
                this.processDimensionDisplay(key);
                break;
            }
            case "mt_m_sourcefield": 
            case "mt_m_targetfield": {
                String type = (String)model.getValue(FIELD_MAPPING_MAP_TYPE);
                if (StringUtils.isNotEmpty((CharSequence)type)) {
                    boolean needPKFlag = FIELD_MAPPING_TABLE_M_SOURCE.equals(key);
                    this.showFieldForm(type, null, key, needPKFlag);
                    break;
                }
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u57fa\u7840\u8d44\u6599\u3002", (String)"PADerivationRulePlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "mt_m_default_text_e": {
                int tableIndex = model.getEntryCurrentRowIndex(ENTRY_MAPPING_TABLE_TARGET);
                Object tableTargetDim = model.getValue(DIMENSION_MAPPING_TABLE_TARGET, tableIndex);
                Object tableBdFieldType = model.getValue(FIELD_MAPPING_TABLE_M_DEFAULT_TYPE_BASE_DATA, tableIndex);
                Object tableAssFieldType = model.getValue(FIELD_MAPPING_TABLE_M_DEFAULT_TYPE_ASSISTANT, tableIndex);
                PARuleHelper.processInteractiveDisplay((AbstractFormPlugin)this, (Object)tableBdFieldType, (Object)tableAssFieldType, (Object)tableTargetDim, (String)ENTRY_MAPPING_TABLE_TARGET, (String)FIELD_MAPPING_TABLE_M_DEFAULT_TEXT, (String)FIELD_MAPPING_TABLE_M_DEFAULT_TEXT, (String)"receiverdimensioninfo", null, (boolean)false, null);
                break;
            }
            case "default_text_e": {
                int shipIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_TARGET);
                Object shipTargetDim = model.getValue(FIELD_TARGET, shipIndex);
                Object shipBdFieldType = model.getValue(FIELD_TARGET_TYPE_BASE_DATA, shipIndex);
                Object shipAssFieldType = model.getValue(FIELD_TARGET_TYPE_ASSISTANT, shipIndex);
                PARuleHelper.processInteractiveDisplay((AbstractFormPlugin)this, (Object)shipBdFieldType, (Object)shipAssFieldType, (Object)shipTargetDim, (String)ENTRY_TARGET, (String)FIELD_DEFAULT_TARGET_TEXT, (String)FIELD_DEFAULT_TARGET_TEXT, (String)"receiverdimensioninfo", null, (boolean)false, null);
                break;
            }
            case "filtercondition": {
                DynamicObject analysisModelDy = (DynamicObject)model.getValue("analysismodel");
                String filterStr = (String)model.getValue("filterconditionjson_tag");
                Long analysisModelId = analysisModelDy.getLong("id");
                String entityNumber = AnalysisModelUtil.buildEntityNumber((String)analysisModelDy.getString("tablenumber"));
                this.showFilterForm(analysisModelId, entityNumber, filterStr);
                break;
            }
            case "sourcedimfield": {
                int sourceIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_CUSTOM);
                DynamicObject sourceDimDy = (DynamicObject)model.getValue(FIELD_CUSTOM_SOURCEDIM, sourceIndex);
                this.processCustomDimDisplay(sourceDimDy, FIELD_CUSTOM_SOURCEDIMFIELD);
                break;
            }
            case "targetdimfield": {
                int targetIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_CUSTOM);
                DynamicObject targetDimDy = (DynamicObject)model.getValue(FIELD_CUSTOM_TARGETDIM, targetIndex);
                this.processCustomDimDisplay(targetDimDy, FIELD_CUSTOM_TARGETDIMFIELD);
                break;
            }
            case "defaulttext": {
                int defaultIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_CUSTOM);
                DynamicObject defaultDimDy = (DynamicObject)model.getValue(FIELD_CUSTOM_TARGETDIM, defaultIndex);
                this.processCustomDefaultTextDisplay(defaultDimDy);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"senderdimensioninfo", (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            PARuleHelper.processDimensionInfoCloseBack((AbstractFormPlugin)this, (Object)result, (String)ENTRY_SENDER, (String)FIELD_DIMENSIONVALUE, (String)FIELD_DIMENSIONVALUE_E, (String)FIELD_DIMENSIONTEXT);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_DIMENSIONVALUE, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)result;
            StringBuilder name = new StringBuilder();
            HashMap<Object, String> map = new HashMap<Object, String>(rows.size());
            for (ListSelectedRow row : rows) {
                map.put(row.getPrimaryKeyValue(), row.getName());
                name.append(row.getName()).append(",");
            }
            String nameStr = name.substring(0, name.length() - 1);
            String text = SerializationUtils.toJsonString(map);
            model.setValue(FIELD_DIMENSIONTEXT, (Object)(text.length() > 255 ? text.substring(0, 255) : text));
            model.setValue("dimensiontext_tag", (Object)text);
            model.setValue(FIELD_DIMENSIONVALUE_E, (Object)(nameStr.length() > 1024 ? nameStr.substring(0, 1024) : nameStr));
            return;
        }
        if (StringUtils.equals((CharSequence)"otherCallBack", (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            int senderIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SENDER);
            String res = result.toString().replace("\n", ",");
            model.setValue(FIELD_DIMENSIONVALUE_E, (Object)(res.length() > 1024 ? res.substring(0, 1024) : res), senderIndex);
            model.setValue(FIELD_DIMENSIONTEXT, result.toString().length() > 255 ? result.toString().substring(0, 255) : result, senderIndex);
            model.setValue("dimensiontext_tag", result, senderIndex);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_MAPPING_MAP, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)result).get(0);
            model.setValue(FIELD_MAPPING_MAP, (Object)listSelectedRow.getName());
            model.setValue(FIELD_MAPPING_MAP_TYPE, listSelectedRow.getPrimaryKeyValue());
            return;
        }
        if ((StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_M_SOURCE, (CharSequence)actionId) || StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_M_TARGET, (CharSequence)actionId) || StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_SOURCE, (CharSequence)actionId) || StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_TARGET, (CharSequence)actionId)) && !ObjectUtils.isEmpty((Object)result)) {
            this.processMappingField((String[][])result, actionId);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_M_DEFAULT_TEXT, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)result).get(0);
            model.setValue(FIELD_MAPPING_TABLE_M_DEFAULT_TEXT_E, (Object)listSelectedRow.getName());
            model.setValue(FIELD_MAPPING_TABLE_M_DEFAULT_TEXT, listSelectedRow.getPrimaryKeyValue());
            return;
        }
        if (StringUtils.equals((CharSequence)"receiverdimensioninfo", (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            PARuleHelper.processDimensionInfoCloseBack((AbstractFormPlugin)this, (Object)result, (String)ENTRY_TARGET, (String)FIELD_DEFAULT_TARGET_TEXT, (String)FIELD_DEFAULT_TARGET_TEXT_E, null);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_DEFAULT_TARGET_TEXT, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)result).get(0);
            model.setValue(FIELD_DEFAULT_TARGET_TEXT_E, (Object)listSelectedRow.getName());
            model.setValue(FIELD_DEFAULT_TARGET_TEXT, listSelectedRow.getPrimaryKeyValue());
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_FILTERCONDITION, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            FilterCondition filterCondition;
            String resultStr = result.toString();
            if (StringUtils.isNotEmpty((CharSequence)resultStr) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)resultStr, FilterCondition.class)) != null) {
                String filterStr = filterCondition.getFilter();
                String filterFormat = filterStr.replaceAll("\\.id", "");
                model.setValue("filterconditionjson_tag", (Object)resultStr);
                model.setValue(FIELD_CUSTOM_FILTERCONDITION, (Object)(filterFormat.length() > 200 ? filterFormat.substring(0, 200) : filterFormat));
            }
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_SOURCEDIMFIELD, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            this.processCustomDimField(FIELD_CUSTOM_SOURCEDIMFIELD, (String[][])result);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_TARGETDIMFIELD, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            this.processCustomDimField(FIELD_CUSTOM_TARGETDIMFIELD, (String[][])result);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_DEFAULTTEXTVALUE, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)result).get(0);
            model.beginInit();
            model.setValue(FIELD_CUSTOM_DEFAULTTEXT, (Object)listSelectedRow.getName());
            model.setValue(FIELD_CUSTOM_DEFAULTTEXTVALUE, listSelectedRow.getPrimaryKeyValue());
            model.endInit();
            view.updateView(ENTRY_CUSTOM);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_DEFAULTTEXTENUM, (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
            Map resultMap = (Map)SerializationUtils.fromJsonString((String)result.toString(), Map.class);
            model.beginInit();
            model.setValue(FIELD_CUSTOM_DEFAULTTEXT, resultMap.get("title"));
            model.setValue(FIELD_CUSTOM_DEFAULTTEXTVALUE, resultMap.get("value"));
            model.endInit();
            view.updateView(ENTRY_CUSTOM);
        }
    }

    private void processInit() {
        DynamicObjectCollection sendDyCol;
        DynamicObjectCollection targetDyCol;
        DynamicObjectCollection sourceDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_MAPPING_TABLE_SOURCE);
        if (sourceDyCol != null && !sourceDyCol.isEmpty()) {
            for (int i = 0; i < sourceDyCol.size(); ++i) {
                this.getModel().setValue("mt_condition", (Object)"=", i);
                this.processDimensionField(DIMENSION_MAPPING_TABLE_SOURCE, FIELD_MAPPING_TABLE_SOURCE, i);
            }
        }
        if ((targetDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_MAPPING_TABLE_TARGET)) != null && !targetDyCol.isEmpty()) {
            for (int i = 0; i < targetDyCol.size(); ++i) {
                this.getModel().setValue("mt_target_condition", (Object)"=", i);
                this.processDimensionField(DIMENSION_MAPPING_TABLE_TARGET, FIELD_MAPPING_TABLE_TARGET, i);
            }
        }
        if ((sendDyCol = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY_SENDER)) == null || sendDyCol.isEmpty()) {
            return;
        }
        for (int i = 0; i < sendDyCol.size(); ++i) {
            Object conditionObject = this.getModel().getValue(FIELD_COMBOFIELD, i);
            if (Objects.isNull(conditionObject)) continue;
            String condition = conditionObject.toString();
            if (!Arrays.asList(ShareTypeEnum.SHARE_FACTOR.getType(), ShareTypeEnum.SHARE_SUBJECT.getType()).contains(condition)) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{FIELD_DIMENSIONVALUE_E});
            }
            String text = this.getModel().getValue("dimensiontext_tag", i).toString();
            String name = "";
            String dimensionType = ((DynamicObject)this.getModel().getValue(FIELD_SEND_DIMENSION, i)).getString("dimensiontype");
            DimensionTypeEnum typeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.OTHER == typeEnum) {
                name = text.replace("\n", ",");
            } else if (StringUtils.isNotBlank((CharSequence)text) && (StringUtils.equals((CharSequence)DERIVATION_MODE_MAPPING_MAP, (CharSequence)condition) || StringUtils.equals((CharSequence)DERIVATION_MODE_MAPPING_RELATIONSHIP, (CharSequence)condition))) {
                Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                name = String.join((CharSequence)",", map.values());
            }
            this.getModel().setValue(FIELD_DIMENSIONVALUE_E, (Object)(name.length() > 1024 ? name.substring(0, 1024) : name), i);
        }
    }

    private void processShowFormData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object analysisSystem = parameter.getCustomParam("analysissystem");
        Object analysisModel = parameter.getCustomParam("analysismodel");
        Object showTBMain = parameter.getCustomParam("showTBMain");
        Object source = parameter.getCustomParam("showSource");
        Object name = parameter.getCustomParam("name");
        Object enable = parameter.getCustomParam("showEnable");
        if (ObjectUtils.isEmpty((Object)source) || !StringUtils.equals((CharSequence)source.toString(), (CharSequence)"pa_businessrule")) {
            return;
        }
        if (analysisSystem != null) {
            this.getModel().setValue("analysissystem", analysisSystem);
        }
        if (analysisModel != null) {
            this.getModel().setValue("analysismodel", analysisModel);
        }
        if (name != null) {
            this.getModel().setValue("name", name);
        }
        if (enable != null && ((Boolean)enable).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tabsend"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap2", "advcontoolbarap21"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"tabreceiver"});
        }
        if (showTBMain != null && !((Boolean)showTBMain).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"titleapanel", "fs_baseinfo"});
        }
    }

    private void processDefaultData() {
        List systemIds = QueryServiceHelper.queryPrimaryKeys((String)"pa_anasystemsetting", null, (String)"number", (int)1);
        if (systemIds.isEmpty()) {
            return;
        }
        Object systemId = systemIds.get(0);
        List modelIds = QueryServiceHelper.queryPrimaryKeys((String)"pa_analysismodel", (QFilter[])new QFilter("analysis_system", "=", systemId).toArray(), (String)"number", (int)1);
        if (!modelIds.isEmpty()) {
            this.getModel().setValue("analysismodel", modelIds.get(0));
        }
        this.getModel().setValue("analysissystem", systemId);
    }

    private void processEntryEntity(String val) {
        switch (val) {
            case "A": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_MAPPING_RELATIONSHIP, PANEL_MAPPING_STRUCTURE, PANEL_CUSTOM, PANEL_SCRIPT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_MAPPING_MAP, PANEL_MAPPING_MAP, FIELD_MAPPING_MAP_TYPE});
                this.getModel().setValue(FIELD_MAPPING_RELATIONSHIP, (Object)"");
                this.processInitEntry(DERIVATION_MODE_MAPPING_RELATIONSHIP);
                this.processInitEntry(DERIVATION_MODE_CUSTOM);
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_MAPPING_MAP, FIELD_MAPPING_MAP_TYPE, PANEL_MAPPING_MAP, PANEL_CUSTOM, PANEL_SCRIPT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FIELD_MAPPING_RELATIONSHIP, PANEL_MAPPING_STRUCTURE});
                this.getModel().setValue(FIELD_MAPPING_MAP, (Object)"");
                this.getModel().setValue(FIELD_MAPPING_MAP_TYPE, (Object)"");
                this.processInitEntry(DERIVATION_MODE_MAPPING_MAP);
                this.processInitEntry(DERIVATION_MODE_CUSTOM);
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FIELD_MAPPING_RELATIONSHIP, FIELD_MAPPING_MAP, FIELD_MAPPING_MAP_TYPE, PANEL_MAPPING_MAP, PANEL_MAPPING_STRUCTURE, PANEL_SCRIPT});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{PANEL_CUSTOM});
                this.getModel().setValue(FIELD_MAPPING_RELATIONSHIP, (Object)"");
                this.getModel().setValue(FIELD_MAPPING_MAP, (Object)"");
                this.getModel().setValue(FIELD_MAPPING_MAP_TYPE, (Object)"");
                this.processInitEntry(DERIVATION_MODE_MAPPING_MAP);
                this.processInitEntry(DERIVATION_MODE_MAPPING_RELATIONSHIP);
                break;
            }
        }
    }

    private void processInitEntry(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return;
        }
        switch (type) {
            case "A": {
                this.getModel().deleteEntryData(ENTRY_MAPPING_TABLE_SOURCE);
                this.getModel().deleteEntryData(ENTRY_MAPPING_TABLE_TARGET);
                this.getModel().createNewEntryRow(ENTRY_MAPPING_TABLE_SOURCE);
                this.getModel().createNewEntryRow(ENTRY_MAPPING_TABLE_TARGET);
                break;
            }
            case "B": {
                this.getModel().deleteEntryData(ENTRY_SOURCE);
                this.getModel().deleteEntryData(ENTRY_TARGET);
                this.getModel().createNewEntryRow(ENTRY_SOURCE);
                this.getModel().createNewEntryRow(ENTRY_TARGET);
                break;
            }
            case "C": {
                this.getModel().deleteEntryData(ENTRY_CUSTOM);
                this.getModel().createNewEntryRow(ENTRY_CUSTOM);
                break;
            }
        }
    }

    private void processMappingFieldDefaultValue(DynamicObject dy, int rowIndex, String baseDataTypeNumber, String assistantTypeNumber, String defaultText, String defaultTextE) {
        this.getModel().setValue(defaultText, (Object)"", rowIndex);
        this.getModel().setValue(defaultTextE, (Object)"", rowIndex);
        String baseDataNumber = "";
        String assistantNumber = "";
        if (dy == null) {
            this.getModel().setValue(baseDataTypeNumber, (Object)baseDataNumber, rowIndex);
            this.getModel().setValue(assistantTypeNumber, (Object)assistantNumber, rowIndex);
            return;
        }
        DimensionTypeEnum dimensiontypeenum = DimensionTypeEnum.getEnum((String)dy.getString("dimensiontype"));
        if (DimensionTypeEnum.DATABASE == dimensiontypeenum) {
            baseDataNumber = dy.get("dimensionsource.number").toString();
        } else if (DimensionTypeEnum.ASSISTANTDATA == dimensiontypeenum) {
            assistantNumber = dy.get("assistantsource.number").toString();
        }
        this.getModel().setValue(baseDataTypeNumber, (Object)baseDataNumber, rowIndex);
        this.getModel().setValue(assistantTypeNumber, (Object)assistantNumber, rowIndex);
    }

    private DynamicObject processDimensionField(String entry, String key, String numberField) {
        return this.processDimensionField(key, numberField, this.getModel().getEntryCurrentRowIndex(entry));
    }

    private DynamicObject processDimensionField(String key, String numberField, int i) {
        DynamicObject sourceDy = (DynamicObject)this.getModel().getValue(key, i);
        if (sourceDy == null) {
            return sourceDy;
        }
        String dimensionType = sourceDy.getString("dimensiontype");
        boolean flag = !"3".equals(dimensionType);
        this.getView().setEnable(Boolean.valueOf(flag), i, new String[]{numberField});
        return sourceDy;
    }

    private void processMappingEntry() {
        DynamicObject entry;
        DynamicObject dy;
        int i;
        IDataModel model = this.getModel();
        DynamicObject mappingRelationShipDy = model.getDataEntity().getDynamicObject(FIELD_MAPPING_RELATIONSHIP);
        if (mappingRelationShipDy == null) {
            model.deleteEntryData(ENTRY_SOURCE);
            model.deleteEntryData(ENTRY_TARGET);
            model.createNewEntryRow(ENTRY_SOURCE);
            model.createNewEntryRow(ENTRY_TARGET);
            return;
        }
        DynamicObjectCollection sourceCols = mappingRelationShipDy.getDynamicObjectCollection(FIELD_CUSTOM_SOURCEDIM);
        DynamicObjectCollection targetCols = mappingRelationShipDy.getDynamicObjectCollection(FIELD_CUSTOM_TARGETDIM);
        model.deleteEntryData(ENTRY_SOURCE);
        model.deleteEntryData(ENTRY_TARGET);
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_SOURCE, sourceCols.size());
        model.batchCreateNewEntryRow(ENTRY_TARGET, targetCols.size());
        DynamicObjectCollection sourceDys = model.getEntryEntity(ENTRY_SOURCE);
        DynamicObjectCollection targetDys = model.getEntryEntity(ENTRY_TARGET);
        DynamicProperty sourceFieldProp = sourceDys.getDynamicObjectType().getProperty(FIELD_MAPPING);
        DynamicProperty targetFieldProp = targetDys.getDynamicObjectType().getProperty(FIELD_TARGET);
        DynamicProperty defaultTargetFieldProp = targetDys.getDynamicObjectType().getProperty(FIELD_DEFAULT_TARGET_TEXT);
        DynamicProperty defaultExtTargetFieldProp = targetDys.getDynamicObjectType().getProperty(FIELD_DEFAULT_TARGET_TEXT_E);
        DynamicProperty targetBaseDataTypeProp = targetDys.getDynamicObjectType().getProperty(FIELD_TARGET_TYPE_BASE_DATA);
        DynamicProperty targetAssistantTypeProp = targetDys.getDynamicObjectType().getProperty(FIELD_TARGET_TYPE_ASSISTANT);
        for (i = 0; i < sourceCols.size(); ++i) {
            dy = (DynamicObject)sourceCols.get(i);
            entry = (DynamicObject)sourceDys.get(i);
            sourceFieldProp.setValueFast((Object)entry, (Object)dy.getDynamicObject("fbasedataid"));
        }
        for (i = 0; i < targetCols.size(); ++i) {
            dy = (DynamicObject)targetCols.get(i);
            entry = (DynamicObject)targetDys.get(i);
            DynamicObject baseDataDy = dy.getDynamicObject("fbasedataid");
            targetFieldProp.setValueFast((Object)entry, (Object)baseDataDy);
            DynamicObject dimensionDy = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataDy.getPkValue(), (String)"pa_dimension");
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimensionDy.getString("dimensiontype"));
            if (DimensionTypeEnum.DATABASE == dimensionType) {
                targetBaseDataTypeProp.setValueFast((Object)entry, (Object)dimensionDy.get("dimensionsource.number").toString());
            } else if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
                targetAssistantTypeProp.setValueFast((Object)entry, (Object)dimensionDy.get("assistantsource.number").toString());
            }
            defaultTargetFieldProp.setValueFast((Object)entry, (Object)"");
            defaultExtTargetFieldProp.setValueFast((Object)entry, (Object)"");
        }
        model.endInit();
        this.getView().updateView(ENTRY_SOURCE);
        this.getView().updateView(ENTRY_TARGET);
    }

    private void processSenderDimF7() {
        Map<Object, Object> dimensionFilters;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int sendEntryIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SENDER);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_SENDER);
        DynamicObject dy = (DynamicObject)entryEntity.get(sendEntryIndex);
        DynamicObject dim = dy.getDynamicObject(FIELD_SEND_DIMENSION);
        if (ObjectUtils.isEmpty((Object)dim)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dim.getString("dimensiontype"));
        if (DimensionTypeEnum.OTHER == dimensionType) {
            String content = StringUtils.isNotBlank((CharSequence)dy.getString(FIELD_DIMENSIONVALUE_E)) ? dy.getString("dimensiontext_tag") : "";
            PARuleHelper.openView((AbstractFormPlugin)this, (String)dy.getString("senddimension.name"), (String)content);
            return;
        }
        if (DimensionTypeEnum.DENUMS == dimensionType) {
            String text = dy.getString("dimensiontext_tag");
            if (StringUtils.isNotBlank((CharSequence)text)) {
                Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                text = String.join((CharSequence)",", map.keySet());
            }
            PARuleHelper.openDimensionInfoView((AbstractFormPlugin)this, (String)text, (long)dy.getLong("senddimension.id"), (String)dy.getString("senddimension.name"), (String)"senderdimensioninfo", (boolean)true);
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String filters = pageCache.get("dimensionFilters");
        int senderIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SENDER);
        DynamicObject senderDy = (DynamicObject)this.getModel().getEntryEntity(ENTRY_SENDER).get(senderIndex);
        String targetNum = senderDy.getString("senddimension.number");
        QFilter curFilter = null;
        if (StringUtils.isBlank((CharSequence)filters)) {
            dimensionFilters = this.processNecessityDimFilter(model.getValue("analysismodel_id"));
            pageCache.put("dimensionFilters", SerializationUtils.toJsonString(dimensionFilters));
            curFilter = (QFilter)dimensionFilters.get(targetNum);
        } else {
            dimensionFilters = new HashMap(4);
            dimensionFilters = (Map)SerializationUtils.fromJsonString((String)filters, dimensionFilters.getClass());
            for (Map.Entry<Object, Object> entry : dimensionFilters.entrySet()) {
                String number = (String)entry.getKey();
                if (!StringUtils.equals((CharSequence)number, (CharSequence)targetNum)) continue;
                curFilter = (QFilter)SerializationUtils.fromJsonString((String)JSON.toJSONString((Object)entry.getValue()), QFilter.class);
                break;
            }
        }
        DynamicObject row = (DynamicObject)model.getEntryEntity(ENTRY_SENDER).get(model.getEntryCurrentRowIndex(ENTRY_SENDER));
        String content = row.getString("dimensiontext_tag");
        HashMap map = (HashMap)JSON.parseObject((String)content, HashMap.class);
        Object bdObj = this.getModel().getValue("dimensiontype_basedata", sendEntryIndex);
        Object assObj = this.getModel().getValue("dimensiontype_assistant", sendEntryIndex);
        PARuleHelper.processInteractiveDisplay((AbstractFormPlugin)this, (Object)bdObj, (Object)assObj, (Object)dim, null, (String)FIELD_DIMENSIONVALUE, (String)FIELD_DIMENSIONVALUE, (String)"receiverdimensioninfo", (QFilter)curFilter, (boolean)true, map == null ? null : map.keySet().toArray());
    }

    private Map<String, QFilter> processNecessityDimFilter(Object modelId) {
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        DynamicObjectCollection cols = analysisModelObj.getDynamicObjectCollection("dimension_entry");
        return cols.stream().filter(dy -> StringUtils.isNotBlank((CharSequence)dy.getString("necessity_dim")) && !StringUtils.equals((CharSequence)"0", (CharSequence)dy.getString("necessity_dim")) && StringUtils.isNotBlank((CharSequence)dy.getDynamicObject("dimension").getString("typefield"))).collect(Collectors.toMap(dy -> dy.getString("dimension.number"), dy -> {
            DynamicObject dimension = dy.getDynamicObject("dimension");
            String typeField = dimension.getString("typefield");
            Object groupId = dimension.get("group_id");
            return new QFilter(typeField, "=", groupId);
        }));
    }

    private void processDimensionDisplay(String key) {
        DynamicObject sourceDy = StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_TARGET, (CharSequence)key) ? this.processDimensionField(ENTRY_MAPPING_TABLE_TARGET, DIMENSION_MAPPING_TABLE_TARGET, key) : this.processDimensionField(ENTRY_MAPPING_TABLE_SOURCE, DIMENSION_MAPPING_TABLE_SOURCE, key);
        if (sourceDy == null) {
            return;
        }
        String dimensionType = sourceDy.getString("dimensiontype");
        if (StringUtils.equals((CharSequence)"3", (CharSequence)dimensionType)) {
            return;
        }
        String dimensionNumber = sourceDy.getString("number");
        DynamicObjectCollection dimensionDys = this.getModel().getDataEntity().getDynamicObjectCollection("analysismodel.dimension_entry");
        Optional<DynamicObject> first = dimensionDys.stream().filter(dy -> StringUtils.equals((CharSequence)dimensionNumber, (CharSequence)dy.getString("dimension.number"))).findFirst();
        if (first.isPresent()) {
            String fieldName = first.get().getString("field_name");
            DynamicObjectCollection dimensionCols = sourceDy.getDynamicObjectCollection("dimensionentryentity");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fieldName", (Object)fieldName);
            jsonObject.put("dimensionCols", (Object)SerializationUtils.toJsonString((Object)dimensionCols));
            this.showFieldForm(null, jsonObject.toString(), key, false);
        }
    }

    private void processMappingField(String[][] result, String target) {
        int currentIndex;
        String targetType;
        String targetNumber;
        if (result == null || result.length == 0) {
            return;
        }
        String[][] fields = result;
        String[] field = fields[0];
        if (field == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_SOURCE, (CharSequence)target)) {
            targetNumber = FIELD_MAPPING_TABLE_SOURCE_NUMBER;
            targetType = FIELD_MAPPING_TABLE_SOURCE_TYPE;
            currentIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MAPPING_TABLE_SOURCE);
        } else if (StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_TARGET, (CharSequence)target)) {
            targetNumber = FIELD_MAPPING_TABLE_TARGET_NUMBER;
            targetType = FIELD_MAPPING_TABLE_TARGET_TYPE;
            currentIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MAPPING_TABLE_TARGET);
        } else if (StringUtils.equals((CharSequence)FIELD_MAPPING_TABLE_M_SOURCE, (CharSequence)target)) {
            targetNumber = FIELD_MAPPING_TABLE_M_SOURCE_NUMBER;
            targetType = FIELD_MAPPING_TABLE_M_SOURCE_TYPE;
            currentIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MAPPING_TABLE_SOURCE);
        } else {
            targetNumber = FIELD_MAPPING_TABLE_M_TARGET_NUMBER;
            targetType = FIELD_MAPPING_TABLE_M_TARGET_TYPE;
            currentIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MAPPING_TABLE_TARGET);
        }
        this.getModel().setValue(targetNumber, (Object)field[0], currentIndex);
        this.getModel().setValue(targetType, (Object)field[2], currentIndex);
        this.getModel().setValue(target, (Object)String.format(ResManager.loadKDString((String)"%s", (String)"PADerivationRulePlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), field[1]), currentIndex);
    }

    private void processCustomDimDisplay(DynamicObject dimDy, String actionId) {
        if (dimDy == null) {
            return;
        }
        String dimNumber = dimDy.getString("number");
        DynamicObjectCollection dimEntryDyCol = dimDy.getDynamicObjectCollection("dimensionentryentity");
        DynamicObject analysisModelDy = this.getModel().getDataEntity().getDynamicObject("analysismodel");
        DynamicObjectCollection modelDimDyCol = analysisModelDy.getDynamicObjectCollection("dimension_entry");
        DynamicObject modelDimDy = modelDimDyCol.stream().filter(dy -> StringUtils.equals((CharSequence)dimNumber, (CharSequence)dy.getString("dimension.number"))).findFirst().orElse(null);
        if (modelDimDy != null) {
            JSONObject dataJsonObj = new JSONObject();
            dataJsonObj.put("fieldName", (Object)modelDimDy.getString("field_name"));
            dataJsonObj.put("dimensionCols", (Object)SerializationUtils.toJsonString((Object)dimEntryDyCol));
            this.showFieldForm(null, dataJsonObj.toString(), actionId, false);
        }
    }

    private void processCustomDefaultTextDisplay(DynamicObject dimDy) {
        if (dimDy == null) {
            return;
        }
        String baseDataObj = "";
        DynamicObject bdDimSourceDy = dimDy.getDynamicObject("dimensionsource");
        if (bdDimSourceDy != null) {
            baseDataObj = bdDimSourceDy.getString("number");
        }
        String assDataObj = "";
        DynamicObject assDimSourceDy = dimDy.getDynamicObject("assistantsource");
        if (assDimSourceDy != null) {
            assDataObj = assDimSourceDy.getString("number");
        }
        PARuleHelper.processInteractiveDisplay((AbstractFormPlugin)this, (Object)baseDataObj, (Object)assDataObj, (Object)dimDy, (String)ENTRY_CUSTOM, (String)FIELD_CUSTOM_DEFAULTTEXTVALUE, (String)FIELD_CUSTOM_DEFAULTTEXTVALUE, (String)FIELD_CUSTOM_DEFAULTTEXTENUM, null, (boolean)false, null);
    }

    private void processCustomDimField(String key, String[][] result) {
        if (result == null || result.length == 0) {
            return;
        }
        String[] data = result[0];
        if (data == null) {
            return;
        }
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_SOURCEDIMFIELD, (CharSequence)key)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_CUSTOM);
            model.setValue(FIELD_CUSTOM_SOURCEDIMFIELDNUM, (Object)data[0], index);
            model.setValue(FIELD_CUSTOM_SOURCEDIMFIELD, (Object)data[1], index);
            model.setValue(FIELD_CUSTOM_SOURCEDIMFIELDTYPE, (Object)data[2], index);
            return;
        }
        if (StringUtils.equals((CharSequence)FIELD_CUSTOM_TARGETDIMFIELD, (CharSequence)key)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_CUSTOM);
            model.setValue(FIELD_CUSTOM_TARGETDIMFIELDNUM, (Object)data[0], index);
            model.setValue(FIELD_CUSTOM_TARGETDIMFIELD, (Object)data[1], index);
            model.setValue(FIELD_CUSTOM_TARGETDIMFIELDTYPE, (Object)data[2], index);
        }
    }

    private void processMustInput() {
        String type;
        switch (type = this.getModel().getValue(FIELD_COMBO).toString()) {
            case "A": {
                this.setFieldMustInput(FIELD_MAPPING_MAP);
                this.setFieldMustInput(DIMENSION_MAPPING_TABLE_SOURCE, FIELD_MAPPING_TABLE_M_SOURCE);
                this.setFieldMustInput(DIMENSION_MAPPING_TABLE_TARGET, FIELD_MAPPING_TABLE_M_TARGET);
                break;
            }
            case "B": {
                this.setFieldMustInput(FIELD_MAPPING_RELATIONSHIP);
                break;
            }
            case "C": {
                this.setFieldMustInput(FIELD_CUSTOM_FILTERCONDITION);
                break;
            }
        }
    }

    private boolean validateData() {
        String type;
        IDataModel model = this.getModel();
        if (!this.validateSenderEntryEntity()) {
            return false;
        }
        switch (type = model.getValue(FIELD_COMBO).toString()) {
            case "A": {
                return this.validateTableData();
            }
            case "B": {
                return this.validateRelationData();
            }
            case "C": {
                return this.validateCustomData();
            }
        }
        return true;
    }

    private boolean validateSenderEntryEntity() {
        IDataModel model = this.getModel();
        boolean flag = ObjectUtils.isEmpty((Object)model.getValue(FIELD_SEND_DIMENSION)) && ObjectUtils.isEmpty((Object)model.getValue(FIELD_COMBOFIELD)) && StringUtils.isBlank((Object)model.getValue(FIELD_DIMENSIONVALUE_E));
        PARuleHelper.processCache((AbstractFormPlugin)this, (boolean)flag);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_SENDER);
        for (DynamicObject dy : entryEntity) {
            Object dim = dy.get(FIELD_SEND_DIMENSION);
            String condition = dy.getString(FIELD_COMBOFIELD);
            String dimValue = dy.getString(FIELD_DIMENSIONVALUE_E);
            if (Objects.isNull(dim)) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53d1\u9001\u65b9\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (Objects.isNull(condition) || StringUtils.isBlank((CharSequence)condition)) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53d1\u9001\u65b9\u6761\u4ef6\u3002", (String)"PADerivationRulePlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!Arrays.asList(ShareTypeEnum.SHARE_FACTOR.getType(), ShareTypeEnum.SHARE_SUBJECT.getType()).contains(condition) || !Objects.isNull(dimValue) && !StringUtils.isBlank((CharSequence)dimValue)) continue;
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53d1\u9001\u65b9\u7ef4\u5ea6\u503c\u3002", (String)"PADerivationRulePlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateTableData() {
        IDataModel model = this.getModel();
        String mappingMap = model.getValue(FIELD_MAPPING_MAP).toString();
        String mappingMapType = model.getValue(FIELD_MAPPING_MAP_TYPE).toString();
        DynamicObjectCollection sourceList = model.getEntryEntity(ENTRY_MAPPING_TABLE_SOURCE);
        DynamicObjectCollection targetList = model.getEntryEntity(ENTRY_MAPPING_TABLE_TARGET);
        if (StringUtils.isEmpty((CharSequence)mappingMap) || StringUtils.isEmpty((CharSequence)mappingMapType)) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u57fa\u7840\u8d44\u6599\u3002", (String)"PADerivationRulePlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (sourceList == null || sourceList.isEmpty()) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u884c\u5173\u8054\u6761\u4ef6\u6570\u636e\u3002", (String)"PADerivationRulePlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject sourceDynamicObject : sourceList) {
            DynamicObject source = sourceDynamicObject.getDynamicObject(DIMENSION_MAPPING_TABLE_SOURCE);
            if (source == null) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u6761\u4ef6-\u6e90\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            String type = source.getString("dimensiontype");
            String sourceFiled = sourceDynamicObject.getString(FIELD_MAPPING_TABLE_SOURCE);
            String sourceTypeFiled = sourceDynamicObject.getString(FIELD_MAPPING_TABLE_SOURCE_TYPE);
            String mSourceFiled = sourceDynamicObject.getString(FIELD_MAPPING_TABLE_M_SOURCE);
            String mSourceTypeFiled = sourceDynamicObject.getString(FIELD_MAPPING_TABLE_M_SOURCE_TYPE);
            if (!StringUtils.equals((CharSequence)type, (CharSequence)"3") && StringUtils.isEmpty((CharSequence)sourceFiled)) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u6761\u4ef6-\u6e90\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"PADerivationRulePlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)mSourceFiled)) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u6761\u4ef6-\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"PADerivationRulePlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)"3")) {
                if (StringUtils.equals((CharSequence)mSourceTypeFiled, (CharSequence)"5")) continue;
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u5173\u8054\u6761\u4ef6\u4e2d\u6e90\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u8ddf\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"PADerivationRulePlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.equals((CharSequence)sourceTypeFiled, (CharSequence)mSourceTypeFiled)) continue;
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u5173\u8054\u6761\u4ef6\u4e2d\u6e90\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u8ddf\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"PADerivationRulePlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        List idList = sourceList.stream().map(dy -> dy.getLong("mt_source_id")).collect(Collectors.toList());
        HashSet idSet = new HashSet(idList);
        if (idList.size() != idSet.size()) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u5173\u8054\u6761\u4ef6\u4e2d\u6709\u91cd\u590d\u7684\u6e90\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (targetList == null || targetList.isEmpty()) {
            this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u884c\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u6570\u636e\u3002", (String)"PADerivationRulePlugin_19", (String)"fi-pa-formplugin", (Object[])new Object[0]), new Object[0]));
            return false;
        }
        HashSet<String> mtmtargetFieldSet = new HashSet<String>(targetList.size());
        for (DynamicObject targetDynamicObject : targetList) {
            DynamicObject target = targetDynamicObject.getDynamicObject(DIMENSION_MAPPING_TABLE_TARGET);
            if (target == null) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6-\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            String type = target.getString("dimensiontype");
            String targetFiled = targetDynamicObject.getString(FIELD_MAPPING_TABLE_TARGET);
            String targetTypeFiled = targetDynamicObject.getString(FIELD_MAPPING_TABLE_TARGET_TYPE);
            String mTargetFiled = targetDynamicObject.getString(FIELD_MAPPING_TABLE_M_TARGET);
            String mTargetFiledNumber = targetDynamicObject.getString(FIELD_MAPPING_TABLE_M_TARGET_NUMBER);
            mtmtargetFieldSet.add(mTargetFiledNumber);
            String mTargetTypeFiled = targetDynamicObject.getString(FIELD_MAPPING_TABLE_M_TARGET_TYPE);
            if (!StringUtils.equals((CharSequence)type, (CharSequence)"3") && StringUtils.isEmpty((CharSequence)targetFiled)) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6-\u76ee\u6807\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"PADerivationRulePlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)mTargetFiled)) {
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6-\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"PADerivationRulePlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.equals((CharSequence)type, (CharSequence)"3")) {
                if (StringUtils.equals((CharSequence)mTargetTypeFiled, (CharSequence)"5")) continue;
                this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u4e2d\u76ee\u6807\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u8ddf\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"PADerivationRulePlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.equals((CharSequence)targetTypeFiled, (CharSequence)mTargetTypeFiled)) continue;
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u4e2d\u76ee\u6807\u7ef4\u5ea6\u5b57\u6bb5\u7c7b\u578b\u8ddf\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"PADerivationRulePlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (mtmtargetFieldSet.size() != targetList.size()) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u4e2d\u6709\u91cd\u590d\u7684\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"PADerivationRulePlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        List targetIdList = targetList.stream().map(dy -> dy.getLong("mt_target_id")).collect(Collectors.toList());
        HashSet targetIdSet = new HashSet(targetIdList);
        if (targetIdList.size() != targetIdSet.size()) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u4e2d\u6709\u91cd\u590d\u7684\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_18", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateRelationData() {
        DynamicObject mappingRelationship = (DynamicObject)this.getModel().getValue(FIELD_MAPPING_RELATIONSHIP);
        if (mappingRelationship == null) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6620\u5c04\u5173\u7cfb\u201d\u3002", (String)"PADerivationRulePlugin_17", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateCustomData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection customEntryDyCol = model.getEntryEntity(ENTRY_CUSTOM);
        if (customEntryDyCol == null || customEntryDyCol.isEmpty()) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u884c\u201c\u81ea\u5b9a\u4e49\u6761\u4ef6\u201d\u5206\u5f55\u3002", (String)"PADerivationRulePlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (customEntryDyCol.size() > 5) {
            this.setSaveErrorMsg(ResManager.loadKDString((String)"\u201c\u8d4b\u503c\u5230\u76ee\u6807\u7ef4\u5ea6\u201d\u5206\u5f55\u5e94\u5c0f\u4e8e\u7b49\u4e8e5\u884c\u3002", (String)"PADerivationRulePlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        block4: for (int i = 0; i < customEntryDyCol.size(); ++i) {
            String targetDimType;
            DynamicObject customEntryDy = (DynamicObject)customEntryDyCol.get(i);
            int rowIndex = i + 1;
            String filterJson = customEntryDy.getString("filterconditionjson_tag");
            if (StringUtils.isEmpty((CharSequence)filterJson)) {
                this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%s\u884c-\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"PADerivationRulePlugin_26", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                return false;
            }
            DynamicObject targetDimDy = customEntryDy.getDynamicObject(FIELD_CUSTOM_TARGETDIM);
            if (targetDimDy == null || targetDimDy.getLong("id") == 0L) {
                this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u81ea\u5b9a\u4e49\u6761\u4ef6\u7b2c%s\u884c-\u76ee\u6807\u7ef4\u5ea6\u3002", (String)"PADerivationRulePlugin_27", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                return false;
            }
            DynamicObject sourceDimDy = customEntryDy.getDynamicObject(FIELD_CUSTOM_SOURCEDIM);
            if (sourceDimDy == null || sourceDimDy.getLong("id") == 0L) continue;
            String sourceDimType = sourceDimDy.getString("dimensiontype");
            if (!StringUtils.equals((CharSequence)sourceDimType, (CharSequence)(targetDimType = targetDimDy.getString("dimensiontype")))) {
                this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6e90\u7ef4\u5ea6\u8ddf\u76ee\u6807\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PADerivationRulePlugin_31", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                return false;
            }
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)sourceDimType);
            switch (dimensionTypeEnum) {
                case DATABASE: {
                    String bdDimSrcId = sourceDimDy.getString("dimensionsource_id");
                    String bdDimTargetId = targetDimDy.getString("dimensionsource_id");
                    if (!StringUtils.equals((CharSequence)bdDimSrcId, (CharSequence)bdDimTargetId)) {
                        this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6e90\u7ef4\u5ea6\u8ddf\u76ee\u6807\u7ef4\u5ea6\u6765\u6e90\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PADerivationRulePlugin_32", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                        return false;
                    }
                    long sourceDimGroup = sourceDimDy.getLong("group_id");
                    long targetDimGroup = targetDimDy.getLong("group_id");
                    if (sourceDimGroup == 0L || targetDimGroup == 0L || sourceDimGroup == targetDimGroup) continue block4;
                    this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6e90\u7ef4\u5ea6\u8ddf\u76ee\u6807\u7ef4\u5ea6\u57fa\u7840\u8d44\u6599\u7c7b\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PADerivationRulePlugin_33", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                    return false;
                }
                case ASSISTANTDATA: {
                    String assDimSrcId = sourceDimDy.getString("assistantsource_id");
                    String assDimTargetId = targetDimDy.getString("assistantsource_id");
                    if (StringUtils.equals((CharSequence)assDimSrcId, (CharSequence)assDimTargetId)) continue block4;
                    this.setSaveErrorMsg(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6e90\u7ef4\u5ea6\u8ddf\u76ee\u6807\u7ef4\u5ea6\u8d4b\u503c\u8d44\u6599\u7c7b\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PADerivationRulePlugin_34", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                    return false;
                }
            }
        }
        return true;
    }

    private void setFieldMustInput(String ... fields) {
        IFormView view = this.getView();
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(field);
            fieldEdit.setMustInput(true);
        }
    }

    private void setSaveErrorMsg(String message) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("shareRuleErrorKey", message);
    }

    private void showFieldForm(String entityNumber, String data, String callBackId, boolean needPrimaryKey) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pa_fieldlist");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        fsp.setCustomParam("needPrimaryKey", (Object)needPrimaryKey);
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            fsp.setCustomParam("entitynumber", (Object)entityNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)data)) {
            fsp.setCustomParam("data", (Object)data);
        }
        this.getView().showForm(fsp);
    }

    private void showFilterForm(Long analysisModelId, String entityNumber, String filterStr) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"PADerivationRulePlugin_35", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("pa_expression");
        fsp.setCustomParam("analysismodel", (Object)analysisModelId);
        fsp.setCustomParam("customParamFilterForm", (Object)entityNumber);
        fsp.setCustomParam("customParamConditionJson", (Object)filterStr);
        fsp.setCustomParam("PROXY_CLASS", (Object)"kd.fi.pa.formplugin.verification.PaDerivationProxy");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FIELD_CUSTOM_FILTERCONDITION));
        this.getView().showForm(fsp);
    }
}

