/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class PADimensionInfoPlugin
extends AbstractFormPlugin {
    private static final String CONTROL_BTNOK = "btnok";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_ID = "id";
    private static final String FIELD_TITLE = "title";
    private static final String FIELD_VALUE = "value";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Map map = fsp.getCustomParams();
        Object dimensionId = map.get("dimensionId");
        Object choseEnum = map.get("choseEnum");
        Object isMultiSelect = map.get("ismultiselect");
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache(dimensionId, (String)"pa_dimension");
        DynamicObjectCollection cols = dimension.getDynamicObjectCollection("entryentityenums");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, cols.size());
        DynamicObjectCollection dys = model.getDataEntity().getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicProperty titleProp = dys.getDynamicObjectType().getProperty(FIELD_TITLE);
        DynamicProperty valueProp = dys.getDynamicObjectType().getProperty(FIELD_VALUE);
        DynamicProperty idProp = dys.getDynamicObjectType().getProperty(FIELD_ID);
        ArrayList<Integer> selectRows = new ArrayList<Integer>(cols.size());
        for (int i2 = 0; i2 < cols.size(); ++i2) {
            DynamicObject dy = (DynamicObject)cols.get(i2);
            DynamicObject row = (DynamicObject)dys.get(i2);
            titleProp.setValueFast((Object)row, (Object)dy.getString(FIELD_TITLE));
            String value = dy.getString(FIELD_VALUE);
            Object id = dy.getPkValue();
            if (ObjectUtils.isNotEmpty(choseEnum) && choseEnum.toString().contains(value)) {
                selectRows.add(i2);
            }
            valueProp.setValueFast((Object)row, (Object)value);
            idProp.setValueFast((Object)row, id);
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        if (!CollectionUtils.isEmpty(selectRows)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] arr = selectRows.stream().mapToInt(i -> i).toArray();
            entryGrid.selectRows(arr, arr[0]);
        }
        HashMap<String, Boolean> param = new HashMap<String, Boolean>(4);
        param.put("ismul", Boolean.parseBoolean(isMultiSelect.toString()));
        this.getView().updateControlMetadata(ENTRY_ENTITY, param);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PADimensionInfoPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTRY_ENTITY);
            StringBuilder idSbr = new StringBuilder();
            StringBuilder nameSbr = new StringBuilder();
            StringBuilder valueSbr = new StringBuilder();
            HashMap<String, String> map = new HashMap<String, String>(selectRows.length);
            for (int row : selectRows) {
                DynamicObject dy = (DynamicObject)cols.get(row);
                idSbr.append(dy.getPkValue()).append(",");
                nameSbr.append(dy.getString(FIELD_TITLE)).append(",");
                valueSbr.append(dy.getString(FIELD_VALUE)).append(",");
                map.put(dy.getString(FIELD_VALUE), dy.getString(FIELD_TITLE));
            }
            HashMap<String, String> result = new HashMap<String, String>(4);
            result.put(FIELD_ID, idSbr.substring(0, idSbr.length() - 1));
            result.put(FIELD_TITLE, nameSbr.substring(0, nameSbr.length() - 1));
            result.put(FIELD_VALUE, valueSbr.substring(0, valueSbr.length() - 1));
            result.put("text", SerializationUtils.toJsonString(map));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(result));
            this.getView().close();
        }
    }
}

