/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.export.excel.ExcelColumn;
import kd.fi.pa.export.excel.ExportParam;
import kd.fi.pa.export.excel.ImportFile;
import kd.fi.pa.export.excel.ShareFactorEntryExportHandler;
import kd.fi.pa.model.impl.ThreeValueTuple;

public class PADownLoadEntryTemplateFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(PADownLoadEntryTemplateFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        Toolbar toolbar = (Toolbar)this.getControl("tbmain");
        toolbar.addUploadListener((UploadListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "exportentry": {
                this.exportEntry();
                break;
            }
            case "downtemplate": {
                this.downLoadTemplate();
            }
        }
    }

    private void exportEntry() {
        ShareFactorEntryExportHandler handler = new ShareFactorEntryExportHandler();
        ExportParam ep = this.createExportParam(true, handler);
        if (ep != null) {
            String url = handler.exportData(ep);
            this.getView().download(url);
        }
    }

    private ExportParam createExportParam(boolean isExport, ShareFactorEntryExportHandler handler) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        Long analysisModelId = (Long)parentModel.getValue("analysis_model_id");
        if (analysisModelId == null || analysisModelId.compareTo(0L) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u578b\u3002", (String)"PADownLoadEntryTemplateFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObjectCollection dimensionCol = (DynamicObjectCollection)parentModel.getValue("dimension");
        if (CollectionUtils.isEmpty((Collection)dimensionCol)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PADownLoadEntryTemplateFormPlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return null;
        }
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        IDataEntityProperty entryPro = parentModel.getDataEntityType().findProperty("share_factor_entry");
        String factorType = (String)parentModel.getValue("factortype");
        IDataEntityProperty curEntryPro = this.getModel().getDataEntityType().findProperty("show_entry");
        if (isExport) {
            ExportParam ep = ExportParam.createEntryTemplateExportParam((DynamicObject)analysisModelObj, (DynamicObjectCollection)dimensionCol, (String)factorType, (IDataEntityProperty)entryPro, (IDataEntityProperty)curEntryPro);
            List columnList = handler.buildExcelColumnList(ep);
            TableValueSetter tableValueSetter = this.getEntryValue(columnList);
            ep.setTableValueSetter(tableValueSetter);
            return ep;
        }
        return ExportParam.createEntryTemplateExportParam((DynamicObject)analysisModelObj, (DynamicObjectCollection)dimensionCol, (String)factorType, (IDataEntityProperty)entryPro, (IDataEntityProperty)curEntryPro);
    }

    private TableValueSetter getEntryValue(List<ExcelColumn> columnList) {
        int rowCount = this.getModel().getEntryRowCount("show_entry");
        if (rowCount <= 0) {
            return null;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("show_entry");
        int[] selectRows = entryGrid.getSelectRows();
        List<String> fieldList = columnList.stream().map(ExcelColumn::getNumber).collect(Collectors.toList());
        String[] fields = fieldList.toArray(new String[0]);
        TableValueSetter tableValueSetter = new TableValueSetter(fields);
        if (selectRows == null || selectRows.length <= 0 || selectRows.length == rowCount) {
            for (int index = 0; index < rowCount; ++index) {
                this.fillColumnValue(index, columnList, tableValueSetter);
            }
        } else {
            for (int selectRowIndex : selectRows) {
                this.fillColumnValue(selectRowIndex, columnList, tableValueSetter);
            }
        }
        return tableValueSetter;
    }

    private void fillColumnValue(int rowIndex, List<ExcelColumn> columnList, TableValueSetter tableValueSetter) {
        for (ExcelColumn excelColumn : columnList) {
            String propertyName = excelColumn.getProperty().getName();
            String field = excelColumn.getNumber();
            Object value = this.getModel().getValue(propertyName, rowIndex);
            if (propertyName.equals(field)) {
                tableValueSetter.addField(field, new Object[]{value});
                continue;
            }
            DynamicObject baseDataValue = (DynamicObject)value;
            if (baseDataValue == null) {
                tableValueSetter.addField(field, new Object[]{""});
                continue;
            }
            String subField = field.split("\\.")[1];
            String subValue = baseDataValue.getString(subField);
            tableValueSetter.addField(field, new Object[]{subValue});
        }
    }

    private void downLoadTemplate() {
        ShareFactorEntryExportHandler handler = new ShareFactorEntryExportHandler();
        ExportParam ep = this.createExportParam(false, handler);
        if (ep != null) {
            String url = handler.downloadTemplate(ep);
            this.getView().download(url);
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            ShareFactorEntryExportHandler handler = new ShareFactorEntryExportHandler();
            ExportParam ep = this.createExportParam(false, handler);
            if (ep == null) {
                return;
            }
            ImportFile importFile = ImportFile.createAttachmentFile((String)url);
            ThreeValueTuple tvp = handler.importData(importFile, ep);
            TableValueSetter tableValueSetter = (TableValueSetter)tvp.getElement();
            Map errorMessage = (Map)tvp.getValue();
            TableValueSetter newTableValueSetter = this.deleteCombinationRepeat(tableValueSetter);
            int successCount = 0;
            if (newTableValueSetter != null && newTableValueSetter.getCount() > 0) {
                AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
                abstractFormDataModel.beginInit();
                abstractFormDataModel.batchCreateNewEntryRow("show_entry", newTableValueSetter);
                abstractFormDataModel.endInit();
                this.getView().updateView("show_entry");
                successCount = newTableValueSetter.getCount();
            }
            int errorCount = errorMessage != null ? errorMessage.size() : 0;
            String message = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", (String)"PADownLoadEntryTemplateFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]), successCount, errorCount);
            if (errorCount > 0) {
                String exception = ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u5f02\u5e38\u6570\u636e\u3002", (String)"PADownLoadEntryTemplateFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                message = message + "\uff0c" + exception;
                this.getView().showMessage(message, handler.showMessage(errorMessage), MessageTypes.Commit);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private TableValueSetter deleteCombinationRepeat(TableValueSetter fileData) {
        Object combinationKey;
        DynamicObject dynamicObject;
        Object periodId;
        StringBuilder currentRowCombination;
        int i;
        int childEntryRowCount = this.getModel().getEntryRowCount("show_entry");
        int fileDataCount = fileData.getCount();
        if (childEntryRowCount < 1 && fileDataCount < 1) {
            return fileData;
        }
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel parentModel = parentView.getModel();
        boolean isPeriodType = "0".equals(parentModel.getValue("factortype"));
        DynamicObjectCollection dimensionCol = (DynamicObjectCollection)parentModel.getValue("dimension");
        LinkedHashMap<Object, void> combinationMap = new LinkedHashMap<Object, void>(1);
        for (i = 0; i < childEntryRowCount; ++i) {
            void var13_18;
            currentRowCombination = new StringBuilder();
            if (isPeriodType) {
                periodId = (Long)this.getModel().getValue("period_id", i);
                currentRowCombination.append(',').append(periodId);
            }
            for (DynamicObject dynamicObject2 : dimensionCol) {
                Object value;
                dynamicObject = (DynamicObject)dynamicObject2.get(1);
                DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dynamicObject.getString("dimensiontype"));
                String dimensionNumber = dynamicObject.getString("number");
                switch (dimensionType) {
                    case DATABASE: 
                    case ASSISTANTDATA: {
                        value = this.getModel().getValue(dimensionNumber + "_id", i);
                        break;
                    }
                    case OTHER: 
                    case DENUMS: {
                        value = this.getModel().getValue(dimensionNumber, i);
                        break;
                    }
                    default: {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"PADownLoadEntryTemplateFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                }
                currentRowCombination.append(',').append(value);
            }
            if (currentRowCombination.length() <= 0) continue;
            combinationKey = currentRowCombination.substring(1);
            List list = (List)combinationMap.get(combinationKey);
            if (list == null) {
                ArrayList arrayList = new ArrayList(1);
            }
            var13_18.add(String.valueOf(i));
            combinationMap.put(combinationKey, var13_18);
        }
        for (i = 0; i < fileDataCount; ++i) {
            void var13_23;
            currentRowCombination = new StringBuilder();
            if (isPeriodType) {
                periodId = (Long)fileData.get("period", i);
                currentRowCombination.append(',').append(periodId);
            }
            for (DynamicObject dynamicObject3 : dimensionCol) {
                dynamicObject = (DynamicObject)dynamicObject3.get(1);
                String dimensionNumber = dynamicObject.getString("number");
                Object value = fileData.get(dimensionNumber, i);
                currentRowCombination.append(',').append(value);
            }
            if (currentRowCombination.length() <= 0) continue;
            combinationKey = currentRowCombination.substring(1);
            List list = (List)combinationMap.get(combinationKey);
            if (list == null) {
                ArrayList arrayList = new ArrayList(1);
            }
            var13_23.add(String.valueOf(i + childEntryRowCount));
            combinationMap.put(combinationKey, var13_23);
        }
        if (!combinationMap.isEmpty()) {
            ArrayList deleteEntryIndexList = new ArrayList(childEntryRowCount);
            HashSet filterTableIndexSet = new HashSet(combinationMap.size());
            for (Map.Entry entry : combinationMap.entrySet()) {
                List combinationRowList2 = (List)entry.getValue();
                if (combinationRowList2 == null || combinationRowList2.size() <= 1) continue;
                for (int i2 = 0; i2 < combinationRowList2.size() - 1; ++i2) {
                    int rowIndex = Integer.parseInt((String)combinationRowList2.get(i2));
                    if (rowIndex < childEntryRowCount) {
                        deleteEntryIndexList.add(combinationRowList2.get(i2));
                        continue;
                    }
                    filterTableIndexSet.add(combinationRowList2.get(i2));
                }
            }
            if (!deleteEntryIndexList.isEmpty()) {
                void var13_27;
                int[] deleteIndexs = new int[deleteEntryIndexList.size()];
                boolean bl = false;
                while (var13_27 < deleteIndexs.length) {
                    deleteIndexs[var13_27] = Integer.parseInt((String)deleteEntryIndexList.get((int)var13_27));
                    ++var13_27;
                }
                this.getModel().deleteEntryRows("show_entry", deleteIndexs);
            }
            if (!filterTableIndexSet.isEmpty()) {
                String[] fields = fileData.getFields().toArray(new String[0]);
                TableValueSetter tableValueSetter = new TableValueSetter(fields);
                for (int tableRowIndex = 0; tableRowIndex < fileDataCount; ++tableRowIndex) {
                    String indexStr = "" + tableRowIndex + childEntryRowCount;
                    if (filterTableIndexSet.contains(indexStr)) continue;
                    int fieldIndex = 0;
                    Object[] rowValue = new Object[fields.length];
                    for (String field : fields) {
                        rowValue[fieldIndex++] = fileData.get(field, tableRowIndex);
                    }
                    tableValueSetter.addRow(rowValue);
                }
                return tableValueSetter;
            }
        }
        return fileData;
    }
}

