/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.FeatureOption;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.dto.PADynamicEntryDTO;
import kd.fi.pa.model.impl.PADimensionModel;

public class PADynamicEntryFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(PADynamicEntryFormPlugin.class);

    public void initialize() {
        this.initRunTimeColumnMeta();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildColumnUI(this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildDataToShowEntry(this.getModel(), this.getView());
    }

    protected List<PADynamicEntryDTO> getEntryColumnAndData(IFormView view) {
        String entryInfoJson = (String)view.getFormShowParameter().getCustomParam("customEntryInfo");
        if (StringUtils.isEmpty((String)entryInfoJson)) {
            return null;
        }
        return (List)JSON.parseObject((String)entryInfoJson, (TypeReference)new TypeReference<List<PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
    }

    private void initRunTimeColumnMeta() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        List<PADynamicEntryDTO> dynamicEntryDtoList = this.getEntryColumnAndData(view);
        if (dynamicEntryDtoList == null) {
            return;
        }
        MainEntityType mainType = model.getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        for (PADynamicEntryDTO dto : dynamicEntryDtoList) {
            String[][] columns = dto.getColumns();
            ArrayList<Object> controlList = new ArrayList<Object>(columns.length);
            Container entryContainer = (Container)this.getControl(dto.getEntryKey());
            block16: for (String[] column : columns) {
                String type;
                EntryFieldAp entryFieldAp = new EntryFieldAp();
                switch (type = column[0]) {
                    case "1": 
                    case "2": {
                        BasedataField basedataField = new BasedataField();
                        basedataField.setId(Uuid8.generateShortUuid());
                        basedataField.setKey(column[1]);
                        basedataField.setName(new LocaleString(column[2]));
                        basedataField.setBaseEntityId("2".equals(type) ? "bos_assistantdata_detail" : column[3]);
                        basedataField.setMustInput(Boolean.parseBoolean(column[4]));
                        basedataField.setDisplayProp("name");
                        basedataField.setEntityMetadata(entityMeta);
                        entityMeta.getItems().add(basedataField);
                        entryFieldAp.setId(Uuid8.generateShortUuid());
                        entryFieldAp.setFieldId(Uuid8.generateShortUuid());
                        entryFieldAp.setKey(column[1]);
                        entryFieldAp.setName(new LocaleString(column[2]));
                        entryFieldAp.setField((Field)basedataField);
                        entryFieldAp.setWidth(new LocaleString("100px"));
                        entryFieldAp.setQuickAddNew(false);
                        BasedataEdit bsEdit = (BasedataEdit)entryFieldAp.buildRuntimeControl();
                        bsEdit.setFieldKey(column[1]);
                        bsEdit.setModel(model);
                        bsEdit.setView(view);
                        bsEdit.setEntryKey(dto.getEntryKey());
                        bsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                        entryContainer.getItems().add(bsEdit);
                        controlList.add(bsEdit);
                        continue block16;
                    }
                    case "3": {
                        TextField textField = new TextField();
                        textField.setId(Uuid8.generateShortUuid());
                        textField.setKey(column[1]);
                        textField.setName(new LocaleString(column[2]));
                        textField.setMustInput(Boolean.parseBoolean(column[4]));
                        textField.setEntityMetadata(entityMeta);
                        if (column[1].startsWith("remark")) {
                            textField.setMaxLength(255);
                        }
                        entityMeta.getItems().add(textField);
                        entryFieldAp.setId(Uuid8.generateShortUuid());
                        entryFieldAp.setFieldId(Uuid8.generateShortUuid());
                        entryFieldAp.setKey(column[1]);
                        entryFieldAp.setName(new LocaleString(column[2]));
                        entryFieldAp.setField((Field)textField);
                        entryFieldAp.setWidth(new LocaleString("100px"));
                        TextEdit textEdit = (TextEdit)entryFieldAp.buildRuntimeControl();
                        textEdit.setFieldKey(column[1]);
                        textEdit.setModel(model);
                        textEdit.setView(view);
                        textEdit.setEntryKey(dto.getEntryKey());
                        entryContainer.getItems().add(textEdit);
                        controlList.add(textEdit);
                        continue block16;
                    }
                    case "4": {
                        DateField dateField = new DateField();
                        dateField.setId(Uuid8.generateShortUuid());
                        dateField.setKey(column[1]);
                        dateField.setName(new LocaleString(column[2]));
                        dateField.setMustInput(Boolean.parseBoolean(column[4]));
                        dateField.setEntityMetadata(entityMeta);
                        entityMeta.getItems().add(dateField);
                        entryFieldAp.setId(Uuid8.generateShortUuid());
                        entryFieldAp.setFieldId(Uuid8.generateShortUuid());
                        entryFieldAp.setKey(column[1]);
                        entryFieldAp.setName(new LocaleString(column[2]));
                        entryFieldAp.setField((Field)dateField);
                        entryFieldAp.setWidth(new LocaleString("100px"));
                        DateEdit dateEdit = (DateEdit)entryFieldAp.buildRuntimeControl();
                        dateEdit.setFieldKey(column[1]);
                        dateEdit.setModel(model);
                        dateEdit.setView(view);
                        dateEdit.setEntryKey(dto.getEntryKey());
                        entryContainer.getItems().add(dateEdit);
                        controlList.add(dateEdit);
                        continue block16;
                    }
                    case "6": {
                        LinkedHashMap stringStringLinkedHashMap;
                        ComboField comboField = new ComboField();
                        comboField.setId(Uuid8.generateShortUuid());
                        comboField.setKey(column[1]);
                        comboField.setName(new LocaleString(column[2]));
                        comboField.setMustInput(Boolean.parseBoolean(column[4]));
                        comboField.setEntityMetadata(entityMeta);
                        entityMeta.getItems().add(comboField);
                        entryFieldAp.setId(Uuid8.generateShortUuid());
                        entryFieldAp.setFieldId(Uuid8.generateShortUuid());
                        entryFieldAp.setKey(column[1]);
                        entryFieldAp.setName(new LocaleString(column[2]));
                        entryFieldAp.setField((Field)comboField);
                        entryFieldAp.setWidth(new LocaleString("100px"));
                        ComboEdit comboEdit = (ComboEdit)entryFieldAp.buildRuntimeControl();
                        comboEdit.setFieldKey(column[1]);
                        comboEdit.setModel(model);
                        comboEdit.setView(view);
                        comboEdit.setEntryKey(dto.getEntryKey());
                        Map dimEnumMap = dto.getDimEnumMap();
                        if (dimEnumMap != null && (stringStringLinkedHashMap = (LinkedHashMap)dimEnumMap.get(column[1])) != null) {
                            List comboItems = stringStringLinkedHashMap.entrySet().stream().map(p -> new ComboItem(new LocaleString((String)p.getValue()), (String)p.getKey())).collect(Collectors.toList());
                            comboEdit.setComboItems(comboItems);
                        }
                        entryContainer.getItems().add(comboEdit);
                        controlList.add(comboEdit);
                        continue block16;
                    }
                    case "99": {
                        DecimalField decimalField = new DecimalField();
                        decimalField.setId(Uuid8.generateShortUuid());
                        decimalField.setKey(column[1]);
                        decimalField.setName(new LocaleString(column[2]));
                        decimalField.setMustInput(Boolean.parseBoolean(column[4]));
                        decimalField.setEntityMetadata(entityMeta);
                        entityMeta.getItems().add(decimalField);
                        entryFieldAp.setId(Uuid8.generateShortUuid());
                        entryFieldAp.setFieldId(Uuid8.generateShortUuid());
                        entryFieldAp.setKey(column[1]);
                        entryFieldAp.setName(new LocaleString(column[2]));
                        entryFieldAp.setField((Field)decimalField);
                        entryFieldAp.setWidth(new LocaleString("100px"));
                        DecimalEdit decimalEdit = (DecimalEdit)entryFieldAp.buildRuntimeControl();
                        decimalEdit.setFieldKey(column[1]);
                        decimalEdit.setModel(model);
                        decimalEdit.setView(view);
                        decimalEdit.setEntryKey(dto.getEntryKey());
                        entryContainer.getItems().add(decimalEdit);
                        controlList.add(decimalEdit);
                    }
                }
            }
            view.createControlIndex(controlList);
        }
    }

    private void buildColumnUI(IFormView view) {
        try {
            List<PADynamicEntryDTO> dynamicEntryDtoList = this.getEntryColumnAndData(view);
            if (dynamicEntryDtoList == null) {
                return;
            }
            IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            for (PADynamicEntryDTO dto : dynamicEntryDtoList) {
                HashMap<String, Object> entryEntityMap = new HashMap<String, Object>(4);
                entryEntityMap.put("rk", "rk");
                entryEntityMap.put("fseq", "fseq");
                String[][] columns = dto.getColumns();
                ArrayList<Map<String, Object>> columnList = new ArrayList<Map<String, Object>>(columns.length + 1);
                columnList.add(this.genRKColumn(dto.isShowSeq()));
                block18: for (String[] column : columns) {
                    String type;
                    switch (type = column[0]) {
                        case "1": 
                        case "2": {
                            columnList.add(this.genColumn(column, this.genF7Editor(column)));
                            continue block18;
                        }
                        case "3": {
                            columnList.add(this.genColumn(column, this.genTextEditor(column)));
                            continue block18;
                        }
                        case "4": {
                            columnList.add(this.genColumn(column, this.getDateEditor(column)));
                            continue block18;
                        }
                        case "6": {
                            columnList.add(this.genColumn(column, this.getComboEditor(column)));
                            continue block18;
                        }
                        case "99": {
                            columnList.add(this.genColumn(column, this.genDecimalEditor(column)));
                        }
                    }
                }
                entryEntityMap.put("columns", columnList);
                clientViewProxy.preInvokeControlMethod(dto.getEntryKey(), "createGridColumns", new Object[]{entryEntityMap});
                for (String[] column : columns) {
                    view.setEnable(Boolean.valueOf(Boolean.parseBoolean(column[5])), -1, new String[]{column[1]});
                }
            }
        }
        catch (Exception ex) {
            log.error(String.format("PADynamicEntryFormPlugin.buildColumnUI error : %s", ex.getMessage()));
        }
    }

    protected void buildDataToShowEntry(IDataModel model, IFormView view) {
        List<PADynamicEntryDTO> dynamicEntryDtoList = this.getEntryColumnAndData(view);
        if (dynamicEntryDtoList == null) {
            return;
        }
        for (PADynamicEntryDTO dto : dynamicEntryDtoList) {
            TreeEntryGrid entity;
            Object[][] dataArr = dto.getData();
            if (dataArr == null) continue;
            String[][] columns = dto.getColumns();
            String entryKey = dto.getEntryKey();
            Map dataStyle = dto.getDataStyle();
            Map supSonMap = dto.getSupSonMap();
            boolean isTreeEntry = dto.isTreeEntry();
            ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(8);
            for (int idx = 0; idx < dataArr.length; ++idx) {
                Object[] data = dataArr[idx];
                if (isTreeEntry && supSonMap != null && supSonMap.containsKey(idx)) {
                    Integer supIdx = (Integer)supSonMap.get(idx);
                    model.insertEntryRow(entryKey, supIdx.intValue());
                    model.setValue("pid", (Object)Long.parseLong((String)model.getValue("id", supIdx.intValue())), idx);
                } else {
                    model.createNewEntryRow(entryKey);
                }
                for (int i = 0; i < data.length; ++i) {
                    String color;
                    model.setValue(columns[i][1], data[i], idx);
                    if (dataStyle == null || StringUtils.isEmpty((String)(color = (String)dataStyle.get(columns[i][1] + ',' + idx)))) continue;
                    CellStyle cellStyle = new CellStyle();
                    cellStyle.setRow(idx);
                    cellStyle.setForeColor(color);
                    cellStyle.setFieldKey(columns[i][1]);
                    styleList.add(cellStyle);
                }
            }
            if (isTreeEntry) {
                entity = (TreeEntryGrid)this.getControl(entryKey);
                entity.setCollapse(false);
                entity.setCellStyle(styleList);
            } else {
                entity = (EntryGrid)this.getControl(entryKey);
                entity.setCellStyle(styleList);
            }
            this.getView().updateView(entryKey);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType oldMainType = e.getOriginalEntityType();
            MainEntityType newMainType = (MainEntityType)oldMainType.clone();
            if (newMainType == null) {
                return;
            }
            IFormView view = this.getView();
            this.registerDynamicProps(newMainType, view);
            newMainType.createPropIndexsNoCache();
            e.setNewEntityType(newMainType);
        }
        catch (Exception ex) {
            log.error(String.format("PADynamicEntryFormPlugin.getEntityType error : %s", ex.getMessage()));
        }
    }

    private void registerDynamicProps(MainEntityType newMainType, IFormView view) {
        List<PADynamicEntryDTO> dynamicEntryDtoList = this.getEntryColumnAndData(view);
        if (dynamicEntryDtoList == null) {
            return;
        }
        for (PADynamicEntryDTO dto : dynamicEntryDtoList) {
            String[][] columns;
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(dto.getEntryKey());
            block16: for (String[] column : columns = dto.getColumns()) {
                String type;
                switch (type = column[0]) {
                    case "1": 
                    case "2": {
                        BasedataProp newProperty = new BasedataProp();
                        newProperty.setName(column[1]);
                        newProperty.setBaseEntityId("2".equals(type) ? "bos_assistantdata_detail" : column[3]);
                        newProperty.setDisplayName(new LocaleString(column[2]));
                        String baseEntity = "1".equals(type) ? column[3] : "bos_assistantdata_detail";
                        newProperty.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)baseEntity));
                        newProperty.setFeatures(FeatureOption.Copyable.getValue());
                        VarcharProp idProp = PADimensionModel.isStringPrimaryKeyType((String)baseEntity) ? new VarcharProp() : new LongProp();
                        idProp.setName(column[1] + "_id");
                        newProperty.setRefIdProp((IDataEntityProperty)idProp);
                        newProperty.setRefIdPropName(idProp.getName());
                        entryType.addProperty((DynamicProperty)newProperty);
                        entryType.addProperty((DynamicProperty)idProp);
                        continue block16;
                    }
                    case "3": {
                        TextProp textProp = new TextProp();
                        textProp.setName(column[1]);
                        textProp.setDisplayName(new LocaleString(column[2]));
                        textProp.setFeatures(FeatureOption.Copyable.getValue());
                        entryType.addProperty((DynamicProperty)textProp);
                        continue block16;
                    }
                    case "4": {
                        DateProp dateProp = new DateProp();
                        dateProp.setName(column[1]);
                        dateProp.setDisplayName(new LocaleString(column[2]));
                        dateProp.setFeatures(FeatureOption.Copyable.getValue());
                        entryType.addProperty((DynamicProperty)dateProp);
                        continue block16;
                    }
                    case "6": {
                        ComboProp camboProp = new ComboProp();
                        camboProp.setName(column[1]);
                        camboProp.setDisplayName(new LocaleString(column[2]));
                        camboProp.setFeatures(FeatureOption.Copyable.getValue());
                        entryType.addProperty((DynamicProperty)camboProp);
                        continue block16;
                    }
                    case "99": {
                        DecimalProp decimalProp = new DecimalProp();
                        decimalProp.setName(column[1]);
                        decimalProp.setDisplayName(new LocaleString(column[2]));
                        decimalProp.setFeatures(FeatureOption.Copyable.getValue());
                        entryType.addProperty((DynamicProperty)decimalProp);
                    }
                }
            }
        }
    }

    private Map<String, Object> genTextEditor(String[] column) {
        HashMap<String, Object> editor = new HashMap<String, Object>(4);
        editor.put("mi", Boolean.parseBoolean(column[4]));
        editor.put("type", "text");
        editor.put("showEditButton", Boolean.FALSE);
        editor.put("isshowtooltip", Boolean.TRUE);
        if (column[1].startsWith("remark")) {
            editor.put("maxlength", 255);
        }
        return editor;
    }

    private Map<String, Object> getComboEditor(String[] column) {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("mi", Boolean.parseBoolean(column[4]));
        editor.put("eb", Boolean.TRUE);
        editor.put("st", new ArrayList(4));
        editor.put("type", "combo");
        editor.put("sd", Boolean.FALSE);
        editor.put("vas", "underline");
        return editor;
    }

    private Map<String, Object> getDateEditor(String[] column) {
        HashMap<String, Object> editor = new HashMap<String, Object>(4);
        editor.put("mi", Boolean.parseBoolean(column[4]));
        editor.put("type", "date");
        editor.put("showEditButton", Boolean.FALSE);
        editor.put("isshowtooltip", Boolean.TRUE);
        return editor;
    }

    private Map<String, Object> genRKColumn(boolean showSeq) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("dataIndex", "seq");
        map.put("header", new LocaleString("#"));
        map.put("visible", showSeq);
        map.put("filter", Boolean.FALSE);
        map.put("sort", Boolean.FALSE);
        map.put("width", 50);
        return map;
    }

    private Map<String, Object> genColumn(String[] column, Map<String, Object> editor) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("dataIndex", column[1]);
        Boolean filterAndSort = Boolean.parseBoolean(column[7]);
        map.put("filter", filterAndSort);
        map.put("l", 0);
        map.put("vi", 63);
        map.put("sort", filterAndSort);
        map.put("w", new LocaleString("100px"));
        map.put("header", new LocaleString(column[2]));
        map.put("editor", editor);
        map.put("visible", Boolean.parseBoolean(column[6]));
        return map;
    }

    private Map<String, Object> genF7Editor(String[] column) {
        HashMap<String, Object> editor = new HashMap<String, Object>(8);
        editor.put("dsp", "name");
        editor.put("dst", 0);
        editor.put("ep", 0);
        editor.put("mi", Boolean.parseBoolean(column[4]));
        editor.put("type", "basedata");
        editor.put("qan", false);
        return editor;
    }

    private Map<String, Object> genDecimalEditor(String[] column) {
        HashMap<String, Object> editor = new HashMap<String, Object>(16);
        editor.put("max", 1.0E13);
        editor.put("maxm", "]");
        editor.put("mi", Boolean.parseBoolean(column[4]));
        editor.put("min", -1.0E13);
        editor.put("minm", "[");
        editor.put("nt", "D");
        editor.put("pc", 23);
        editor.put("roundMethod", 1);
        editor.put("sc", 10);
        editor.put("type", "number");
        editor.put("vas", "underline");
        editor.put("zs", Boolean.TRUE);
        return editor;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        param.setMultiSelect(false);
        IFormView view = this.getView();
        IDataModel parentModel = view.getParentView().getModel();
        BasedataProp prop = (BasedataProp)beforeF7SelectEvent.getProperty();
        String baseEntityId = prop.getBaseEntityId();
        ListFilterParameter listFilter = param.getListFilterParameter();
        Long analysisModelId = (Long)parentModel.getValue("analysismodel_id");
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        DynamicObjectCollection dimensionCol = modelDy.getDynamicObjectCollection("dimension_entry");
        BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = source.getKey();
        Long groupId = 0L;
        if ("bos_assistantdata_detail".equals(baseEntityId)) {
            for (DynamicObject obj : dimensionCol) {
                DynamicObject dimensionObj = obj.getDynamicObject("dimension");
                String number = dimensionObj.getString("number");
                if (!key.equals(number) && !key.equals(number + "?")) continue;
                groupId = (Long)dimensionObj.get("assistantsource_id");
                break;
            }
            if (groupId != 0L) {
                listFilter.setFilter(new QFilter("group", "=", (Object)groupId));
            }
        } else {
            String typeField = "";
            for (DynamicObject obj : dimensionCol) {
                DynamicObject dimensionObj = obj.getDynamicObject("dimension");
                String number = dimensionObj.getString("number");
                if (!key.equals(number) && !key.equals(number + "?")) continue;
                typeField = dimensionObj.getString("typefield");
                groupId = (Long)dimensionObj.get("group_id");
            }
            if (StringUtils.isNotEmpty((String)typeField) && groupId != 0L) {
                listFilter.setFilter(new QFilter(typeField, "=", (Object)groupId));
            }
        }
    }
}

