/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.pa.enums.DataValueTypeEnum;
import kd.fi.pa.helper.EntityMetaHelper;
import kd.fi.pa.utils.IDataValueUtil;

public class PAFieldListFormPlugin
extends AbstractFormPlugin {
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_PROPDISPLAYNAME = "propdisplayname";
    private static final String FIELD_PROPNAME = "propname";
    private static final String FIELD_PROPTYPE = "proptype";
    private static final String CONTROL_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_BTNOK});
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String billType = (String)fsp.getCustomParam("entitynumber");
        String data = (String)fsp.getCustomParam("data");
        boolean needPrimaryKey = (Boolean)fsp.getCustomParam("needPrimaryKey");
        if (StringUtils.isBlank((CharSequence)billType)) {
            billType = "er_dailyloanbill";
        }
        if (StringUtils.isBlank((CharSequence)billType)) {
            return;
        }
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(FIELD_PROPDISPLAYNAME, new Object[0]);
        tvs.addField(FIELD_PROPNAME, new Object[0]);
        tvs.addField(FIELD_PROPTYPE, new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            JSONObject obj = JSONObject.parseObject((String)data);
            String fieldName = obj.getString("fieldName");
            String dimensionCols = obj.getString("dimensionCols");
            JSONArray jsonArray = JSONObject.parseArray((String)dimensionCols);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String name = jsonObject.getString("fieldname");
                String number = jsonObject.getString("fieldnumber");
                String type = jsonObject.getString("datatype");
                if (!fieldName.contains(name)) continue;
                tvs.addRow(new Object[]{name, number, type});
            }
        } else {
            Map<String, String> idMap;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billType);
            List returnDataList = EntityMetaHelper.parseEntryeEtityFields((IDataEntityType)entityType, null, null);
            if (needPrimaryKey && !(idMap = this.genIdField(entityType)).isEmpty()) {
                returnDataList.add(idMap);
            }
            for (Map map : returnDataList) {
                String showName = (String)map.get("showname");
                String showNumber = (String)map.get("shownumber");
                String showdatatype = (String)map.get("showdatatype");
                tvs.addRow(new Object[]{showName, showNumber, showdatatype});
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        int count = tvs.getCount();
        if (count > 0) {
            model.batchCreateNewEntryRow(FIELD_ENTRYENTITY, tvs);
        }
        model.endInit();
        this.getView().updateView(FIELD_ENTRYENTITY);
    }

    private Map<String, String> genIdField(MainEntityType entityType) {
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        HashMap<String, String> idMap = new HashMap<String, String>(5);
        if (primaryKey != null) {
            LocaleString displayName = primaryKey.getDisplayName();
            String pkMsg = ResManager.loadKDString((String)"\u5185\u7801", (String)"PAFieldListFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]);
            idMap.put("showname", displayName == null ? pkMsg : String.valueOf(primaryKey.getDisplayName()));
            idMap.put("shownumber", primaryKey.getName());
            DataValueTypeEnum propertyDataType = IDataValueUtil.getDataType((IDataEntityProperty)primaryKey);
            idMap.put("showdatatype", String.valueOf(propertyDataType.getCode()));
        }
        return idMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (CONTROL_BTNOK.equalsIgnoreCase(control.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(FIELD_ENTRYENTITY);
            int[] indexes = entry.getSelectRows();
            String[][] fields = new String[indexes.length][2];
            int i = 0;
            for (int index : indexes) {
                String[] row = new String[]{(String)this.getModel().getValue(FIELD_PROPNAME, index), (String)this.getModel().getValue(FIELD_PROPDISPLAYNAME, index), (String)this.getModel().getValue(FIELD_PROPTYPE, index)};
                fields[i++] = row;
            }
            this.getView().returnDataToParent((Object)fields);
            this.getView().close();
        }
    }
}

