/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.servicehelper.PeriodServiceHelper;
import kd.fi.pa.utils.DateUtil;

public class PAPeriodManagementListPlugin
extends AbstractListPlugin {
    public static final Log logger = LogFactory.getLog(PAPeriodManagementListPlugin.class);
    private static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void setFilter(SetFilterEvent e) {
        List<Object> remainFilters;
        List filters = e.getQFilters();
        QFilter target = QFilter.of((String)"1=1", (Object[])new Object[0]);
        String orQueryMcPara = SystemPropertyUtils.getProptyByTenant((String)"orquery.enable", (String)RequestContext.get().getTenantId());
        String property = System.getProperty("orm.crossdb.enable");
        if (Boolean.parseBoolean(orQueryMcPara) || Boolean.parseBoolean(property)) {
            QFilter firstFilter = (QFilter)filters.get(0);
            ArrayList<Object> resFilters = new ArrayList<Object>();
            if (StringUtils.equals((CharSequence)"date", (CharSequence)firstFilter.getProperty())) {
                resFilters.add(firstFilter);
            }
            List arr = firstFilter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).filter(f -> StringUtils.equals((CharSequence)"date", (CharSequence)f.getProperty())).collect(Collectors.toList());
            resFilters.addAll(arr);
            if (CollectionUtils.isNotEmpty(resFilters)) {
                target = resFilters.stream().filter(q -> CollectionUtils.isNotEmpty((Collection)q.getNests(true))).findFirst().orElseGet(() -> QFilter.of((String)" 1=1 ", (Object[])new Object[0]));
            }
            if (CollectionUtils.isEmpty(remainFilters = this.processFiltersWithNest(firstFilter))) {
                remainFilters = this.processFiltersWithNoNest(firstFilter);
            }
            logger.info(String.format("'orQuery' has been opened, remainFilters:%s, target:%s", remainFilters.toString(), target.toString()));
        } else {
            List dateFilters = filters.stream().filter(filter -> StringUtils.equals((CharSequence)"date", (CharSequence)filter.getProperty())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(dateFilters)) {
                return;
            }
            remainFilters = filters.stream().filter(filter -> !StringUtils.equals((CharSequence)"date", (CharSequence)filter.getProperty())).collect(Collectors.toList());
            target = (QFilter)dateFilters.get(0);
        }
        List nests = target.getNests(true);
        QFilter.QFilterNest nest = (QFilter.QFilterNest)nests.get(0);
        QFilter inFilter = nest.getFilter();
        QFilter parent = nest.getParent();
        QFilter filter2 = this.processDateFilter(inFilter, "startdate", "enddate").and(this.processDateFilter(parent, "startdate", "enddate"));
        remainFilters.add(filter2);
        e.setQFilters(remainFilters);
    }

    private List<QFilter> processFiltersWithNest(QFilter firstFilter) {
        List<QFilter> remainFilters = firstFilter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).filter(f -> !StringUtils.equals((CharSequence)"date", (CharSequence)f.getProperty())).filter(q -> CollectionUtils.isNotEmpty((Collection)q.getNests(true))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(remainFilters)) {
            return new ArrayList<QFilter>(1);
        }
        QFilter cur = (QFilter)remainFilters.get(0);
        remainFilters = cur.getNests(true).stream().map(QFilter.QFilterNest::getFilter).filter(f -> !StringUtils.equals((CharSequence)"date", (CharSequence)f.getProperty())).collect(Collectors.toList());
        remainFilters.add(new QFilter(cur.getProperty(), cur.getCP(), cur.getOriginValue()));
        if (!StringUtils.equals((CharSequence)"date", (CharSequence)firstFilter.getProperty())) {
            remainFilters.add(new QFilter(firstFilter.getProperty(), firstFilter.getCP(), firstFilter.getOriginValue()));
        }
        return remainFilters;
    }

    private List<QFilter> processFiltersWithNoNest(QFilter firstFilter) {
        List<QFilter> remainFilters = firstFilter.getNests(true).stream().map(QFilter.QFilterNest::getFilter).filter(f -> !StringUtils.equals((CharSequence)"date", (CharSequence)f.getProperty())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(remainFilters)) {
            return new ArrayList<QFilter>(1);
        }
        remainFilters.add(new QFilter(firstFilter.getProperty(), firstFilter.getCP(), firstFilter.getOriginValue()));
        return remainFilters;
    }

    private QFilter processDateFilter(QFilter inFilter, String startDate, String endDate) {
        String inFilterCP = inFilter.getCP();
        QFilter periodFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)"<", (CharSequence)inFilterCP)) {
            Date date = (Date)inFilter.getOriginValue();
            if (!DateUtil.isFirstDayOfMonth((Date)date)) {
                date = DateUtil.getNextMonthFirstDay((Date)date);
            }
            periodFilter.and(endDate, "<", (Object)date);
        } else if (StringUtils.equals((CharSequence)">=", (CharSequence)inFilterCP)) {
            periodFilter.and(startDate, ">=", (Object)DateUtil.getMinMonthDate((Date)((Date)inFilter.getOriginValue())));
        }
        return periodFilter;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        PARuleHelper.processFilterItemSelectedByDefault((FilterContainerSearchClickArgs)args, (IPageCache)this.getPageCache(), (String)(currentCommonFilter == null ? "" : ((List)currentCommonFilter.get("FieldName")).get(0).toString()), (String)"analysissystem.id", (String)"analysismodel.id");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        IListView listView = (IListView)this.getView();
        ControlFilters controlFilters = listView.getControlFilters();
        FilterColumn systemColumn = args.getFilterColumn("analysissystem.name");
        FilterColumn modelColumn = args.getFilterColumn("analysismodel.name");
        if (controlFilters == null) {
            List systemComboItems = PARuleHelper.getComboItems((String)"pa_anasystemsetting", (QFilter)enableFilter, (String)"id,name,number,enable", (String)"createtime desc");
            if (CollectionUtils.isEmpty((Collection)systemComboItems)) {
                PARuleHelper.setComboItems((FilterColumn)systemColumn, (List)PARuleHelper.getEmptyComboItems());
                return;
            }
            String systemId = ((ComboItem)systemComboItems.get(0)).getValue();
            PARuleHelper.setComboItems((FilterColumn)systemColumn, (List)systemComboItems);
            systemColumn.setDefaultValue(systemId);
            QFilter systemFilter = new QFilter("analysis_system", "=", (Object)Long.parseLong(systemId));
            List modelComboItems = PARuleHelper.getComboItems((String)"pa_analysismodel", (QFilter)systemFilter.and(PARuleHelper.getDateTimeFilterInModel().and(enableFilter)), (String)"id,name,number,enable", (String)"createtime desc");
            PARuleHelper.setComboItems((FilterColumn)modelColumn, (List)modelComboItems);
            modelColumn.setDefaultValue(CollectionUtils.isEmpty((Collection)modelComboItems) ? null : ((ComboItem)modelComboItems.get(0)).getValue());
        } else {
            List result = controlFilters.getFilter("analysissystem.id");
            if (!CollectionUtils.isEmpty((Collection)result) && StringUtils.isNotBlank((CharSequence)result.get(0).toString())) {
                long systemId = Long.parseLong(result.get(0).toString());
                QFilter systemFilter = new QFilter("analysis_system", "=", (Object)systemId);
                List modelComboItems = PARuleHelper.getComboItems((String)"pa_analysismodel", (QFilter)systemFilter.and(PARuleHelper.getDateTimeFilterInModel()).and(enableFilter), (String)"id,name,number,enable", (String)"createtime desc");
                PARuleHelper.setComboItems((FilterColumn)modelColumn, (List)modelComboItems);
                modelColumn.setDefaultValue(CollectionUtils.isEmpty((Collection)modelComboItems) ? null : ((ComboItem)modelComboItems.get(0)).getValue());
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        IFormView view = this.getView();
        String fieldName = args.getFieldName();
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        List qFilters = args.getQfilters();
        switch (fieldName) {
            case "analysismodel.id": {
                List system = controlFilters.getFilter("analysissystem.id");
                if (!CollectionUtils.isNotEmpty((Collection)system)) break;
                long id = Long.parseLong(system.get(0).toString());
                qFilters.add(new QFilter("analysis_system", "=", (Object)id).and(enableFilter).and(PARuleHelper.getDateTimeFilterInModel()));
                break;
            }
            case "analysismodel.name": {
                List system = controlFilters.getFilter("analysissystem.name");
                if (CollectionUtils.isEmpty((Collection)system) || StringUtils.isBlank((CharSequence)system.get(0).toString())) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PAPeriodManagementListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                DynamicObjectCollection systemCols = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])new QFilter("name", "=", system.get(0)).and(enableFilter).toArray());
                List ids = systemCols.stream().map(dy -> dy.get("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("analysis_system", "in", ids).and(enableFilter));
                qFilters.add(PARuleHelper.getDateTimeFilterInModel());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection rows = this.getSelectedRows();
        switch (operateKey) {
            case "openperiod": {
                String verifyOpenMsg = ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u5f53\u524d\u72b6\u6001\u5df2\u662f\u5f00\u542f\u7684\u72b6\u6001\uff0c\u65e0\u9700\u91cd\u590d\u6253\u5f00\u8be5\u671f\u95f4\u3002", (String)"PAPeriodManagementListPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                String openMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u6253\u5f00\u4e4b\u540e\u7684\u671f\u95f4\uff0c\u518d\u6253\u5f00\u5f53\u671f\u7684\u671f\u95f4\u3002", (String)"PAPeriodManagementListPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                if (!this.processOpenAndClosePeriod(rows, true, openMsg, verifyOpenMsg)) break;
                args.setCancel(true);
                break;
            }
            case "closeperiod": {
                DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)rows.get(0).getPrimaryKeyValue(), (String)"pa_accperiodlock");
                Long modelId = dy.getLong("analysismodel_id");
                String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId);
                if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                    this.getView().showTipNotification(modelNewVersionMsg);
                    args.setCancel(true);
                    return;
                }
                String verifyCloseMsg = ResManager.loadKDString((String)"\u8be5\u671f\u95f4\u5f53\u524d\u72b6\u6001\u5df2\u662f\u5173\u95ed\u7684\u72b6\u6001\uff0c\u65e0\u9700\u91cd\u590d\u5173\u95ed\u8be5\u671f\u95f4\u3002", (String)"PAPeriodManagementListPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                String closeMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u5173\u95ed\u4e4b\u524d\u7684\u671f\u95f4\uff0c\u518d\u5173\u95ed\u5f53\u671f\u7684\u671f\u95f4\u3002", (String)"PAPeriodManagementListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                if (!this.processOpenAndClosePeriod(rows, false, closeMsg, verifyCloseMsg)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        ListSelectedRowCollection rows = this.getSelectedRows();
        switch (operateKey) {
            case "openperiod": {
                this.updatePeriodManagementInfo(rows, "1");
                this.getView().invokeOperation("refresh");
                break;
            }
            case "closeperiod": {
                boolean flag = PeriodServiceHelper.closePeriod((long)Long.parseLong(rows.get(0).getPrimaryKeyValue().toString()));
                if (!flag) break;
                this.updatePeriodManagementInfo(rows, "0");
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private boolean processOpenAndClosePeriod(ListSelectedRowCollection rows, boolean isOpenPeriod, String msg, String verifyMsg) {
        if (rows.size() > 1) {
            String notificationMsg = "";
            notificationMsg = isOpenPeriod ? ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u6253\u5f00\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u671f\u95f4\u3002", (String)"PAPeriodManagementListPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5173\u95ed\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u671f\u95f4\u3002", (String)"PAPeriodManagementListPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(notificationMsg);
            return true;
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)rows.get(0).getPrimaryKeyValue(), (String)"pa_accperiodlock");
        long modelId = dy.getLong("analysismodel_id");
        long orgId = dy.getLong("choseorg_id");
        Date startDate = dy.getDate("startdate");
        String isOpen = dy.getString("isopen");
        if (isOpenPeriod && StringUtils.equals((CharSequence)"1", (CharSequence)isOpen) || !isOpenPeriod && StringUtils.equals((CharSequence)"0", (CharSequence)isOpen)) {
            this.getView().showTipNotification(verifyMsg);
            return true;
        }
        if (this.isOpenOrClosePeriodData(modelId, orgId, startDate, isOpenPeriod)) {
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    private boolean isOpenOrClosePeriodData(long modelId, long orgId, Date startDate, boolean isOpen) {
        QFilter modelAndOrgFilter = new QFilter("analysismodel", "=", (Object)modelId).and("choseorg", "=", (Object)orgId);
        QFilter businessFilter = isOpen ? new QFilter("startdate", ">", (Object)startDate).and("isopen", "=", (Object)"0") : new QFilter("startdate", "<", (Object)startDate).and("isopen", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"pa_accperiodlock", (QFilter[])new QFilter[]{modelAndOrgFilter, businessFilter});
    }

    private void updatePeriodManagementInfo(ListSelectedRowCollection rows, String result) {
        Map map = BusinessDataServiceHelper.loadFromCache((Object[])rows.stream().map(ListSelectedRow::getPrimaryKeyValue).distinct().toArray(Object[]::new), (String)"pa_accperiodlock");
        Collection values = map.values();
        values.forEach(dy -> dy.set("isopen", (Object)result));
        SaveServiceHelper.update((DynamicObject[])values.toArray(new DynamicObject[0]));
    }
}

