/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.dto.BusinessStepSummaryItemDTO;
import kd.fi.pa.helper.PARuleHelper;

public class PARuleSummarySwitchFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initialEntry();
    }

    private void initialEntry() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "pa_businessplan".equals(parentView.getFormShowParameter().getFormId())) {
            IDataModel parentModel = parentView.getModel();
            List ruleStepSummaryItemsByRuleGroupId = PARuleHelper.getRuleStepSummaryItems((String)((String)parentModel.getValue("rulesummaryswitchdata_tag")), (DynamicObjectCollection)parentModel.getEntryEntity("pa_businessplan_rule"));
            if (!CollectionUtils.isEmpty((Collection)ruleStepSummaryItemsByRuleGroupId)) {
                Object[] ruleIds = ruleStepSummaryItemsByRuleGroupId.stream().map(BusinessStepSummaryItemDTO::getBusinessRuleId).distinct().toArray();
                DynamicObject[] businessRules = BusinessDataServiceHelper.load((Object[])ruleIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pa_businessrule"));
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                this.getModel().batchCreateNewEntryRow("entryentity", ruleStepSummaryItemsByRuleGroupId.size());
                DynamicProperty businessRule = entryEntity.getDynamicObjectType().getProperty("businessrule");
                DynamicProperty stepId = entryEntity.getDynamicObjectType().getProperty("stepid");
                DynamicProperty stepName = entryEntity.getDynamicObjectType().getProperty("stepname");
                DynamicProperty handleType = entryEntity.getDynamicObjectType().getProperty("handletype");
                DynamicProperty isSummary = entryEntity.getDynamicObjectType().getProperty("issummary");
                DynamicProperty rowEnable = entryEntity.getDynamicObjectType().getProperty("rowenable");
                int index = 0;
                for (BusinessStepSummaryItemDTO businessStepSummaryItemDTO : ruleStepSummaryItemsByRuleGroupId) {
                    DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                    businessRule.setValueFast((Object)dynamicObject, Arrays.stream(businessRules).filter(rule -> businessStepSummaryItemDTO.getBusinessRuleId().longValue() == rule.getLong("id")).findFirst().orElse(null));
                    stepId.setValueFast((Object)dynamicObject, (Object)businessStepSummaryItemDTO.getStepId());
                    stepName.setValueFast((Object)dynamicObject, (Object)businessStepSummaryItemDTO.getStepName());
                    handleType.setValueFast((Object)dynamicObject, (Object)businessStepSummaryItemDTO.getRuleTypeEnum().getCode());
                    isSummary.setValue((Object)dynamicObject, (Object)businessStepSummaryItemDTO.getSummary());
                    rowEnable.setValue((Object)dynamicObject, (Object)businessStepSummaryItemDTO.getRowEnable());
                    ++index;
                }
            }
        } else {
            throw new KDBizException("the view of parent is invalid");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if ("btnok".equals(key)) {
            LinkedHashMap<Long, Boolean> stepSummaryHistorySettingMap = new LinkedHashMap<Long, Boolean>(8);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : entryEntity) {
                stepSummaryHistorySettingMap.put(entry.getLong("stepid"), entry.getBoolean("issummary"));
            }
            this.getView().returnDataToParent(stepSummaryHistorySettingMap);
            this.getView().close();
        }
    }
}

