/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.cost.CvprofitBusinessHelper;
import kd.fi.pa.dto.PADynamicEntryDTO;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.formplugin.PADynamicEntryFormPlugin;
import kd.fi.pa.formplugin.control.AdjustSourceEntryGrid;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class PASelectSourceDataFormPlugin
extends PADynamicEntryFormPlugin {
    @Override
    public void initialize() {
        super.initialize();
        String opeType = (String)this.getView().getFormShowParameter().getCustomParam("customAdjustDataOperateType");
        if ("1".equals(opeType) || "4".equals(opeType)) {
            List<PADynamicEntryDTO> entryColumnAndData = this.getEntryColumnAndData(this.getView());
            for (PADynamicEntryDTO entryDTO : entryColumnAndData) {
                String entryKey = entryDTO.getEntryKey();
                this.getView().addCustomControls(new String[]{entryKey});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "search", "reset"});
        FilterGrid grid = (FilterGrid)this.getControl("filtergridap");
        Map<String, DynamicObject> dimensionMap = this.getDimensionsFromModelMap();
        grid.addBeforeF7SelectListener(evt -> {
            QFilter qFilter = this.getDimensionTypeQFilter(evt.getFieldName(), dimensionMap);
            if (qFilter != null) {
                evt.addCustomQFilter(qFilter);
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String opeType = (String)view.getFormShowParameter().getCustomParam("customAdjustDataOperateType");
        view.setVisible(Boolean.FALSE, new String[]{"sourcedataentry1", "filterflex", "filterbtn"});
        switch (opeType) {
            case "1": 
            case "4": {
                view.setVisible(Boolean.FALSE, new String[]{"adjustresultflex"});
                Container container = (Container)view.getControl("sourcedataflex");
                container.setCollapseable(false);
                if ("4".equals(opeType)) {
                    HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                    params.put("ismul", false);
                    view.updateControlMetadata("sourcedataentry", params);
                }
                this.initFilter();
                break;
            }
            case "2": {
                view.setVisible(Boolean.FALSE, new String[]{"sourcedataflex", "advcopy"});
                int idx = model.createNewEntryRow("adjustresultentry");
                this.processDefaultData(model, view, idx);
                Container container = (Container)view.getControl("adjustresultflex");
                container.setCollapseable(false);
                break;
            }
            case "3_2": {
                view.setVisible(Boolean.FALSE, new String[]{"sourcedataflex", "advcontoolbarap"});
                Container container = (Container)view.getControl("adjustresultflex");
                container.setCollapseable(false);
                break;
            }
            case "3": {
                view.setVisible(Boolean.FALSE, new String[]{"advadd", "sourcedataentry"});
                view.setVisible(Boolean.TRUE, new String[]{"sourcedataentry1"});
                EntryGrid entity = (EntryGrid)view.getControl("sourcedataentry1");
                entity.setSplitPage(false);
                Container container = (Container)view.getControl("adddataflex");
                container.setCollapseable(false);
                break;
            }
        }
        List<PADynamicEntryDTO> dynamicEntryDTOList = this.getEntryColumnAndData(view);
        HashMap<String, PADynamicEntryDTO> dynamicEntryDTOMap = new HashMap<String, PADynamicEntryDTO>(2);
        for (PADynamicEntryDTO dto : dynamicEntryDTOList) {
            if ("sourcedataentry".equalsIgnoreCase(dto.getEntryKey()) || "sourcedataentry1".equalsIgnoreCase(dto.getEntryKey())) {
                dto.setData((Object[][])null);
            }
            dynamicEntryDTOMap.put(dto.getEntryKey(), dto);
        }
        view.getPageCache().put("pageCacheDynamicEntryDTOMap", JSON.toJSONString(dynamicEntryDTOMap));
    }

    @Override
    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String opeType = (String)this.getView().getFormShowParameter().getCustomParam("customAdjustDataOperateType");
        if ("1".equals(opeType) || "4".equals(opeType)) {
            List<PADynamicEntryDTO> entryColumnAndData = this.getEntryColumnAndData(view);
            for (PADynamicEntryDTO entryDTO : entryColumnAndData) {
                String entryKey = entryDTO.getEntryKey();
                EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
                int startPageIndex = 0;
                int startRowIndex = 0;
                int pageRow = entryGrid.getPageRow();
                String[][] columnsCopy = entryDTO.getColumns();
                String entityNumber = entryDTO.getEntityNumber();
                String fields = entryDTO.getFields();
                QFilter filter = QFilter.fromSerializedString((String)entryDTO.getqFilterStr());
                List<String> excludeFields = Arrays.asList("remark", "valid");
                String[][] filterColumn = (String[][])Arrays.stream(columnsCopy).filter(columnArr -> !excludeFields.contains(columnArr[1])).collect(Collectors.toList()).toArray((T[])new String[0][0]);
                Object[][] dataArr = PAAnalysisModelHelper.queryModelSumPage((String[][])filterColumn, (String)entityNumber, (String)fields, (QFilter[])new QFilter[]{filter}, (int)startPageIndex, (int)pageRow);
                DynamicObject dataEntity = model.getDataEntity(true);
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(entryKey);
                entryEntity.clear();
                for (Object[] data : dataArr) {
                    DynamicObject entry = entryEntity.addNew();
                    for (int i = 0; i < data.length; ++i) {
                        entry.set(filterColumn[i][1], data[i]);
                    }
                }
                int count = PAAnalysisModelHelper.countModelSum((String)entityNumber, (QFilter[])new QFilter[]{filter});
                dataEntity.getDataEntityState().setEntryRowCount(entryKey, count);
                dataEntity.getDataEntityState().setEntryPageSize(entryKey, pageRow);
                dataEntity.getDataEntityState().setEntryStartRowIndex(entryKey, startRowIndex);
                view.updateView(entryKey);
            }
        } else {
            this.buildDataToShowEntry(model, view);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        IFormView view = this.getView();
        String key = e.getKey();
        String opeType = (String)view.getFormShowParameter().getCustomParam("customAdjustDataOperateType");
        if ("sourcedataentry".equals(key) && "1".equals(opeType) || "4".equals(opeType)) {
            List<PADynamicEntryDTO> dynamicEntryDTOList = this.getEntryColumnAndData(view);
            for (PADynamicEntryDTO entryDTO : dynamicEntryDTOList) {
                String entryKey = entryDTO.getEntryKey();
                AdjustSourceEntryGrid entryGridControl = new AdjustSourceEntryGrid(entryDTO);
                entryGridControl.setView(view);
                entryGridControl.setKey(entryKey);
                entryGridControl.setEntryKey(entryKey);
                entryGridControl.setSplitPage(true);
                Control oldGrid = e.getControl();
                if (oldGrid == null) {
                    oldGrid = this.findControl(entryKey);
                }
                if (oldGrid instanceof EntryGrid) {
                    entryGridControl.getItems().addAll(((EntryGrid)oldGrid).getItems());
                }
                e.setControl((Control)entryGridControl);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int rowIdx = changeData.getRowIndex();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int cnt = model.getEntryRowCount("adjustresultentry");
        this.setDynamicEntryDTOMap(model, view, "adjustresultentry", false, cnt, new int[0]);
        String opeType = (String)view.getFormShowParameter().getCustomParam("customAdjustDataOperateType");
        if ("3".equals(opeType)) {
            String color;
            Object resultValue;
            Object sourceValue;
            Map dynamicEntryDTOMap = (Map)JSON.parseObject((String)view.getPageCache().get("pageCacheDynamicEntryDTOMap"), (TypeReference)new TypeReference<Map<String, PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
            PADynamicEntryDTO resultDTO = (PADynamicEntryDTO)dynamicEntryDTOMap.get("adjustresultentry");
            String[][] columns = resultDTO.getColumns();
            String columnType = "3";
            for (String[] column : columns) {
                if (!propertyName.equals(column[1])) continue;
                columnType = column[0];
                break;
            }
            if ("1".equals(columnType) || "2".equals(columnType)) {
                sourceValue = model.getValue(propertyName.substring(0, propertyName.length() - 1) + "_id", 0);
                sourceValue = sourceValue == null || StringUtils.isEmpty((String)sourceValue.toString()) || "0".equals(sourceValue.toString()) ? null : sourceValue;
                resultValue = newValue != null ? ((DynamicObject)newValue).get("id") : null;
            } else {
                sourceValue = model.getValue(propertyName.substring(0, propertyName.length() - 1), 0);
                resultValue = newValue;
            }
            HashMap<String, String> dataStyleMap = resultDTO.getDataStyle();
            if (sourceValue != null && !sourceValue.equals(resultValue) || resultValue != null && !resultValue.equals(sourceValue)) {
                color = "red";
                if (dataStyleMap == null) {
                    dataStyleMap = new HashMap<String, String>(8);
                    resultDTO.setDataStyle(dataStyleMap);
                }
                dataStyleMap.put(propertyName + ',' + rowIdx, color);
            } else {
                color = "black";
                dataStyleMap.remove(propertyName + ',' + rowIdx);
            }
            view.getPageCache().put("pageCacheDynamicEntryDTOMap", JSON.toJSONString((Object)dynamicEntryDTOMap));
            ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(8);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(rowIdx);
            cellStyle.setForeColor(color);
            cellStyle.setFieldKey(propertyName);
            styleList.add(cellStyle);
            EntryGrid entity = (EntryGrid)this.getControl("adjustresultentry");
            entity.setCellStyle(styleList);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int cnt;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String opeType = (String)view.getFormShowParameter().getCustomParam("customAdjustDataOperateType");
        if ("deleteentry".equalsIgnoreCase(operateKey) && !"1".equals(opeType) && (cnt = model.getEntryRowCount("adjustresultentry")) <= 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u8981\u4e00\u884c\u6570\u636e\u3002", (String)"PASelectSourceDataFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int curIdx = model.getEntryCurrentRowIndex("adjustresultentry");
        switch (operateKey) {
            case "newentry": {
                this.processDefaultData(model, view, curIdx);
            }
            case "copyentryrow": 
            case "deleteentry": {
                Map dynamicEntryDTOMap;
                PADynamicEntryDTO dynamicEntryDTO;
                Map dataStyleMap;
                if ("copyentryrow".equals(operateKey) && (dataStyleMap = (dynamicEntryDTO = (PADynamicEntryDTO)(dynamicEntryDTOMap = (Map)JSON.parseObject((String)view.getPageCache().get("pageCacheDynamicEntryDTOMap"), (TypeReference)new TypeReference<Map<String, PADynamicEntryDTO>>(){}, (Feature[])new Feature[0])).get("adjustresultentry")).getDataStyle()) != null) {
                    ArrayList<CellStyle> styleList = new ArrayList<CellStyle>(8);
                    int copyIdx = model.getEntryRowCount("adjustresultentry") - 1;
                    HashMap<String, String> newDataStyleMap = new HashMap<String, String>(dataStyleMap.size() + 4);
                    for (Map.Entry entry : dataStyleMap.entrySet()) {
                        String[] keyArr = ((String)entry.getKey()).split(",");
                        String color = (String)entry.getValue();
                        if (Integer.parseInt(keyArr[1]) != curIdx) continue;
                        newDataStyleMap.put(keyArr[0] + ',' + copyIdx, color);
                        CellStyle cellStyle = new CellStyle();
                        cellStyle.setRow(copyIdx);
                        cellStyle.setForeColor(color);
                        cellStyle.setFieldKey(keyArr[0]);
                        styleList.add(cellStyle);
                    }
                    newDataStyleMap.putAll(dataStyleMap);
                    dynamicEntryDTO.setDataStyle(newDataStyleMap);
                    view.getPageCache().put("pageCacheDynamicEntryDTOMap", JSON.toJSONString((Object)dynamicEntryDTOMap));
                    EntryGrid entity = (EntryGrid)this.getControl("adjustresultentry");
                    entity.setCellStyle(styleList);
                }
                int cnt = model.getEntryRowCount("adjustresultentry");
                this.setDynamicEntryDTOMap(model, view, "adjustresultentry", "deleteentry".equals(operateKey), cnt, new int[0]);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        if ("btnok".equalsIgnoreCase(key)) {
            Map dynamicEntryDTOMap = (Map)JSON.parseObject((String)view.getPageCache().get("pageCacheDynamicEntryDTOMap"), (TypeReference)new TypeReference<Map<String, PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
            String opeType = (String)view.getFormShowParameter().getCustomParam("customAdjustDataOperateType");
            resultMap.put("opeType", opeType);
            switch (opeType) {
                case "1": 
                case "4": {
                    EntryGrid grid = (EntryGrid)view.getControl("sourcedataentry");
                    int[] selectRows = grid.getSelectRows();
                    if (selectRows.length <= 0) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u6570\u636e\u3002", (String)"PASelectSourceDataFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.setDynamicEntryDTOMap(model, view, "sourcedataentry", false, 0, selectRows);
                    dynamicEntryDTOMap = (Map)JSON.parseObject((String)view.getPageCache().get("pageCacheDynamicEntryDTOMap"), (TypeReference)new TypeReference<Map<String, PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
                    break;
                }
                case "2": {
                    int cnt = model.getEntryRowCount("adjustresultentry");
                    if (cnt == 0) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u589e\u6570\u636e\u884c\u3002", (String)"PASelectSourceDataFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!this.checkRequired(model, view, cnt)) break;
                    return;
                }
                case "3_2": {
                    int cnt = model.getEntryRowCount("adjustresultentry");
                    if (!this.checkRequired(model, view, cnt)) break;
                    return;
                }
                case "3": {
                    int cnt = model.getEntryRowCount("adjustresultentry");
                    Map dataStyle = ((PADynamicEntryDTO)dynamicEntryDTOMap.get("adjustresultentry")).getDataStyle();
                    if (cnt == 1 && (dataStyle == null || dataStyle.isEmpty())) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u505a\u4fee\u6539\uff0c\u8bf7\u5148\u4fee\u6539\u3002", (String)"PASelectSourceDataFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!this.checkRequired(model, view, cnt)) break;
                    return;
                }
            }
            resultMap.put("data", dynamicEntryDTOMap);
            view.returnDataToParent(resultMap);
            view.close();
        } else if ("reset".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
            filterGrid.SetValue(new FilterCondition());
            view.updateView("filtergridap");
        } else if ("search".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("sourcedataentry");
            Integer pageRows = entryGrid.getEntryState().getPageRows();
            entryGrid.setPageRows(pageRows.intValue());
        }
    }

    private Control findControl(String key) {
        FormRoot rootControl = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, rootControl.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (key.equals(ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private void processDefaultData(IDataModel model, IFormView view, int idx) {
        IFormView parentView = view.getParentView();
        IDataModel parentMode = parentView.getModel();
        DynamicObject anaModel = (DynamicObject)parentMode.getValue("analysismodel");
        DynamicObjectCollection dimEntryCol = anaModel.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dyo : dimEntryCol) {
            String necessity = dyo.getString("necessity_dim");
            if (StringUtils.isEmpty((String)necessity)) continue;
            String dimNumber = dyo.getDynamicObject("dimension").getString("number");
            if (DimensionNecessityEnum.ORG.getCode().equals(necessity)) {
                model.setValue(dimNumber, parentMode.getValue("createorg"), idx);
                view.setEnable(Boolean.FALSE, idx, new String[]{dimNumber});
                continue;
            }
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) continue;
            model.setValue(dimNumber, parentMode.getValue("period"), idx);
            view.setEnable(Boolean.FALSE, idx, new String[]{dimNumber});
        }
    }

    private boolean checkRequired(IDataModel model, IFormView view, int cnt) {
        Map dynamicEntryDTOMap = (Map)JSON.parseObject((String)view.getPageCache().get("pageCacheDynamicEntryDTOMap"), (TypeReference)new TypeReference<Map<String, PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOMap.get("adjustresultentry");
        String[][] columns = dynamicEntryDTO.getColumns();
        LinkedHashSet<String> errorColumn = new LinkedHashSet<String>(columns.length / 2);
        for (int idx = 0; idx < cnt; ++idx) {
            for (String[] column : columns) {
                Object value = model.getValue(column[1], idx);
                if (!Boolean.parseBoolean(column[4]) || value != null && !StringUtils.isEmpty((String)value.toString())) continue;
                errorColumn.add('\"' + column[2] + '\"');
            }
        }
        if (!errorColumn.isEmpty()) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"PASelectSourceDataFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorColumn)));
            return true;
        }
        return false;
    }

    private void setDynamicEntryDTOMap(IDataModel model, IFormView view, String entryKey, boolean deleteFlag, int rowCnt, int ... idxArr) {
        Object[][] data;
        boolean styleNotEmpty;
        Map dynamicEntryDTOMap = (Map)JSON.parseObject((String)view.getPageCache().get("pageCacheDynamicEntryDTOMap"), (TypeReference)new TypeReference<Map<String, PADynamicEntryDTO>>(){}, (Feature[])new Feature[0]);
        PADynamicEntryDTO dynamicEntryDTO = (PADynamicEntryDTO)dynamicEntryDTOMap.get(entryKey);
        String[][] columns = dynamicEntryDTO.getColumns();
        Map dataStyleMap = dynamicEntryDTO.getDataStyle();
        HashMap newDataStyleMap = new HashMap(8);
        boolean bl = styleNotEmpty = dataStyleMap != null;
        if (rowCnt <= 0) {
            data = new Object[idxArr.length][columns.length];
            int rowIdx = 0;
            for (int idx : idxArr) {
                for (int i = 0; i < columns.length; ++i) {
                    data[rowIdx][i] = model.getValue("1".equals(columns[i][0]) || "2".equals(columns[i][0]) ? columns[i][1] + "_id" : columns[i][1], idx);
                    if (!deleteFlag || !styleNotEmpty || !dataStyleMap.containsKey(columns[i][1] + ',' + rowIdx)) continue;
                    newDataStyleMap.put(columns[i][1] + ',' + rowIdx, dataStyleMap.get(columns[i][1] + ',' + rowIdx));
                }
                ++rowIdx;
            }
        } else {
            data = new Object[rowCnt][columns.length];
            for (int rowIdx = 0; rowIdx < rowCnt; ++rowIdx) {
                for (int i = 0; i < columns.length; ++i) {
                    data[rowIdx][i] = model.getValue("1".equals(columns[i][0]) || "2".equals(columns[i][0]) ? columns[i][1] + "_id" : columns[i][1], rowIdx);
                    if (!deleteFlag || !styleNotEmpty || !dataStyleMap.containsKey(columns[i][1] + ',' + rowIdx)) continue;
                    newDataStyleMap.put(columns[i][1] + ',' + rowIdx, dataStyleMap.get(columns[i][1] + ',' + rowIdx));
                }
            }
        }
        dynamicEntryDTO.setData(data);
        if (deleteFlag && styleNotEmpty) {
            dynamicEntryDTO.setDataStyle(newDataStyleMap.isEmpty() ? null : newDataStyleMap);
        }
        view.getPageCache().put("pageCacheDynamicEntryDTOMap", JSON.toJSONString((Object)dynamicEntryDTOMap));
    }

    private void initFilter() {
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, new String[]{"filterflex", "filterbtn"});
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("filtergridap", "setAddBtnStatus", new Object[]{false});
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        Long analysisModelId = (Long)view.getFormShowParameter().getCustomParam("analysismodel");
        DynamicObject analysisModel = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel");
        List<Object> dimensionFilterColumns = Collections.emptyList();
        if (analysisModel != null) {
            String tableNumber = analysisModel.getString("tablenumber");
            String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)tableNumber);
            dimensionFilterColumns = this.getFilterGridColumns(analysisModel, entityNumber);
            filterGrid.setEntityNumber(entityNumber);
            filterGrid.SetValue(new FilterCondition());
        }
        filterGrid.setFilterColumns(dimensionFilterColumns);
        view.updateView("filtergridap");
    }

    private List<Map<String, Object>> getFilterGridColumns(DynamicObject analysisModel, String entityNumber) {
        ArrayList<Map<String, Object>> dimensionFilterColumns = new ArrayList<Map<String, Object>>(8);
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        HashSet<String> dimensionNumberSet = new HashSet<String>(4);
        if (dimensionEntry != null && !dimensionEntry.isEmpty()) {
            for (DynamicObject dimensionRow : dimensionEntry) {
                String necessityDim = dimensionRow.getString("necessity_dim");
                if (DimensionNecessityEnum.ORG.getCode().equals(necessityDim) || DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) continue;
                DynamicObject dimension = dimensionRow.getDynamicObject("dimension");
                String dimensionNumber = dimension.getString("number").toLowerCase();
                dimensionNumberSet.add(dimensionNumber);
            }
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List allFilterColumns = entityTypeUtil.createFilterColumns((IDataEntityType)entityType, false);
        for (Map currentFilterColumn : allFilterColumns) {
            String fieldName = String.valueOf(currentFilterColumn.get("fieldName")).toLowerCase();
            if (dimensionNumberSet.contains(fieldName)) {
                dimensionFilterColumns.add(currentFilterColumn);
                continue;
            }
            int charIndex = fieldName.indexOf(".");
            String prefixFiled = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
            if (!dimensionNumberSet.contains(prefixFiled)) continue;
            dimensionFilterColumns.add(currentFilterColumn);
        }
        return dimensionFilterColumns;
    }

    private Map<String, DynamicObject> getDimensionsFromModelMap() {
        Long analysisModelId = (Long)this.getView().getFormShowParameter().getCustomParam("analysismodel");
        return PADimensionHelper.getDimensionsFromModelMap((Long)analysisModelId);
    }

    private QFilter getDimensionTypeQFilter(String fieldName, Map<String, DynamicObject> dimensionMap) {
        DynamicObject dimension = dimensionMap.get(fieldName.substring(0, fieldName.indexOf(".")));
        return CvprofitBusinessHelper.getQFilterByDimension((DynamicObject)dimension);
    }
}

