/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.export.excel.ExportParam;
import kd.fi.pa.export.excel.ShareFactorExportHandler;
import kd.fi.pa.formplugin.PAUploadFileFormPlugin;

public class PAShareFactorExportListPlugin
extends AbstractListPlugin {
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("importdatas".equals(itemKey) || "exportdatas".equals(itemKey)) {
            Long analysisSystem = this.getAnalysisSystem();
            Long analysisModel = null;
            if (analysisSystem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PAShareFactorExportListPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            analysisModel = this.getAnalysisModel(analysisSystem);
            if (analysisModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareFactorExportListPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("importdatas".equals(itemKey) && this.checkPerim("importdatas")) {
                PAUploadFileFormPlugin.openForm(analysisModel, null, (AbstractFormPlugin)this);
                return;
            }
            if ("exportdatas".equals(itemKey) && this.checkPerim("exportdatas")) {
                QFilter[] filters;
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (selectedRows != null && !selectedRows.isEmpty()) {
                    Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                    filters = new QFilter[]{new QFilter("analysis_model", "=", (Object)analysisModel), new QFilter("id", "in", (Object)primaryKeyValues)};
                } else {
                    filters = new QFilter[]{new QFilter("analysis_model", "=", (Object)analysisModel)};
                }
                DynamicObject[] shareFactorDatas = BusinessDataServiceHelper.load((String)"pa_sharefactor", (String)"id,name,number,analysis_system,analysis_model,unitfield,factortype,dimension,describe,share_factor_entry.dimensionjson,share_factor_entry.dimensionjson_tag,share_factor_entry.value", (QFilter[])filters);
                ShareFactorExportHandler handler = new ShareFactorExportHandler();
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModel, (String)"pa_analysismodel");
                ExportParam ep = ExportParam.createDataExportParam((DynamicObject)analysisModelObj, (DynamicObject[])shareFactorDatas);
                String url = handler.exportData(ep);
                String tempFileId = UrlUtil.getParam((String)url, (String)"id");
                HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
                refEntitiyMap.put("appId", "pa");
                refEntitiyMap.put("entityNum", "pa_businessrule");
                refEntitiyMap.put("permissionItemId", "4730fc9f000004ae");
                redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
                this.getView().download(url);
                return;
            }
        }
    }

    private boolean checkPerim(String operationKey) {
        OperationResult operationResult = this.getView().invokeOperation(operationKey);
        if (operationResult == null) {
            return true;
        }
        if (operationResult.isSuccess()) {
            return true;
        }
        this.getView().showOperationResult(operationResult);
        return false;
    }

    private Long getAnalysisSystem() {
        Long analysisSystem = null;
        IListView listView = (IListView)this.getView();
        ControlFilters controlFilters = listView.getControlFilters();
        if (controlFilters != null) {
            List analysisSystemSelect = controlFilters.getFilter("analysis_system.id");
            if (analysisSystemSelect != null && !analysisSystemSelect.isEmpty()) {
                analysisSystem = Long.parseLong(analysisSystemSelect.get(0).toString());
            } else {
                DynamicObjectCollection anaSys;
                List anaSysNameList = controlFilters.getFilter("analysis_system.name");
                if (anaSysNameList != null && !anaSysNameList.isEmpty() && (anaSys = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)anaSysNameList.get(0).toString())})) != null && !anaSys.isEmpty()) {
                    analysisSystem = ((DynamicObject)anaSys.get(0)).getLong("id");
                }
            }
        }
        return analysisSystem;
    }

    private Long getAnalysisModel(Long analysisSystem) {
        IListView listView = (IListView)this.getView();
        ControlFilters controlFilters = listView.getControlFilters();
        Long analysisModel = null;
        if (controlFilters != null) {
            List analysisModelSelect = controlFilters.getFilter("analysis_model.id");
            if (analysisModelSelect != null && !analysisModelSelect.isEmpty()) {
                QFilter analysisSystemFilter = new QFilter("analysis_system", "=", (Object)analysisSystem);
                Long analysisModelId = Long.parseLong(analysisModelSelect.get(0).toString());
                QFilter analysisModelFilter = new QFilter("id", "=", (Object)analysisModelId);
                if (QueryServiceHelper.exists((String)"pa_analysismodel", (QFilter[])new QFilter[]{analysisSystemFilter, analysisModelFilter})) {
                    analysisModel = analysisModelId;
                } else {
                    String defaultModelIdStr = this.getPageCache().get("modelComboItem");
                    if (StringUtils.isNotEmpty((String)defaultModelIdStr)) {
                        analysisModel = Long.valueOf(defaultModelIdStr);
                    }
                }
            } else {
                List anaModelNameList = controlFilters.getFilter("analysis_model.name");
                if (anaModelNameList != null && !anaModelNameList.isEmpty()) {
                    DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)anaModelNameList.get(0).toString())});
                    if (anaModel != null && !anaModel.isEmpty()) {
                        analysisModel = ((DynamicObject)anaModel.get(0)).getLong("id");
                    } else {
                        String defaultModelIdStr = this.getPageCache().get("modelComboItem");
                        if (StringUtils.isNotEmpty((String)defaultModelIdStr)) {
                            analysisModel = Long.valueOf(defaultModelIdStr);
                        }
                    }
                } else {
                    String defaultModelIdStr = this.getPageCache().get("modelComboItem");
                    if (StringUtils.isNotEmpty((String)defaultModelIdStr)) {
                        analysisModel = Long.valueOf(defaultModelIdStr);
                    }
                }
            }
        }
        return analysisModel;
    }
}

