/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FeatureOption;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.dto.ShareFactorDimensionDTO;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.model.impl.PADimensionModel;

public class PAShareFactorFlexFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(PAShareFactorFlexFormPlugin.class);
    private final String periodName = ResManager.loadKDString((String)"\u671f\u95f4", (String)"PAShareFactorFlexFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]);
    private final String valueName = ResManager.loadKDString((String)"\u503c", (String)"PAShareFactorFlexFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]);

    public void initialize() {
        super.initialize();
        this.initRunTimeColumnMeta();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildColumnUI();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buildDataToShowEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getPageCache().put("entryChange", Boolean.TRUE.toString());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "copy": 
            case "btn_add": 
            case "btn_del": {
                this.getPageCache().put("entryChange", Boolean.TRUE.toString());
                break;
            }
        }
    }

    private void buildDataToShowEntry() {
        try {
            String isPropertyChangeStr;
            boolean isPropertyChange;
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            IDataModel parentModel = parentView.getModel();
            OperationStatus status = parentView.getFormShowParameter().getStatus();
            if (OperationStatus.VIEW == status) {
                view.setEnable(Boolean.FALSE, new String[]{"advconap"});
            }
            if (isPropertyChange = Boolean.parseBoolean(isPropertyChangeStr = (String)view.getFormShowParameter().getCustomParam("factorChildPropertyChange"))) {
                parentModel.deleteEntryData("share_factor_entry");
                return;
            }
            model.deleteEntryData("show_entry");
            model.beginInit();
            int sourceEntryRowCount = parentModel.getEntryRowCount("share_factor_entry");
            for (int i = 0; i < sourceEntryRowCount; ++i) {
                List factorDimensionDTOList;
                model.createNewEntryRow("show_entry");
                model.setValue("value", parentModel.getValue("value", i), i);
                String jsonTag = (String)parentModel.getValue("dimensionjson_tag", i);
                if (StringUtils.isEmpty((CharSequence)jsonTag) || (factorDimensionDTOList = (List)JSON.parseObject((String)jsonTag, (TypeReference)new TypeReference<List<ShareFactorDimensionDTO>>(){}, (Feature[])new Feature[0])) == null || factorDimensionDTOList.isEmpty()) continue;
                for (ShareFactorDimensionDTO dto : factorDimensionDTOList) {
                    String number = dto.getNumber();
                    Object value = dto.getValue();
                    model.setValue(number, value, i);
                }
            }
            model.endInit();
            view.updateView("show_entry");
        }
        catch (Exception ex) {
            log.error(String.format("buildDataToShowEntry error : %s", ex.getMessage()));
        }
    }

    private void initRunTimeColumnMeta() {
        try {
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            IDataModel parentModel = parentView.getModel();
            ArrayList<Control> controlList = new ArrayList<Control>(3);
            if ("0".equals(parentModel.getValue("factortype"))) {
                Long analysisModelId = (Long)parentModel.getValue("analysis_model_id");
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
                String periodEntity = FormPluginUtil.getBaseEntityId(analysisModelObj, "1");
                controlList.add(this.buildRunTimeFieldMeta("1", "period", this.periodName, periodEntity, "12345678912345", null));
            }
            DynamicObjectCollection dimensionCol = (DynamicObjectCollection)parentModel.getValue("dimension");
            for (DynamicObject obj : dimensionCol) {
                DynamicObject dimensionObj = (DynamicObject)obj.get(1);
                String number = dimensionObj.getString("number");
                String dimensionType = (String)dimensionObj.get("dimensiontype");
                String name = dimensionObj.getString("name");
                String sourceEntity = this.getDimensionSourceNumber(DimensionTypeEnum.getEnum((String)dimensionType), dimensionObj);
                String pkId = dimensionObj.get("id").toString();
                Map<String, String> enumMap = dimensionObj.getDynamicObjectCollection("entryentityenums").stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title")));
                controlList.add(this.buildRunTimeFieldMeta(dimensionType, number, name, sourceEntity, pkId, enumMap));
            }
            controlList.add(this.buildRunTimeFieldMeta("decimal", "value", this.valueName, null, "12345678954321", null));
            view.createControlIndex(controlList);
        }
        catch (Exception ex) {
            log.error(String.format("initRunTimeColumnMeta error : %s", ex.getMessage()));
        }
    }

    private void buildColumnUI() {
        try {
            IFormView view = this.getView();
            IFormView parentView = view.getParentView();
            IDataModel parentModel = parentView.getModel();
            if (!parentModel.isDataLoaded()) {
                return;
            }
            HashMap<String, Object> entryEntityMap = new HashMap<String, Object>();
            entryEntityMap.put("rk", "rk");
            entryEntityMap.put("fseq", "fseq");
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(4);
            list.add(this.genRKColumn());
            if ("0".equals(parentModel.getValue("factortype"))) {
                Map<String, Object> periodMap = this.genColumn("period", this.periodName, this.genF7Editor(), false);
                list.add(periodMap);
            }
            DynamicObjectCollection dimensionCol = (DynamicObjectCollection)parentModel.getValue("dimension");
            for (DynamicObject obj : dimensionCol) {
                Map<String, Object> editorMap;
                DynamicObject dimensionObj = (DynamicObject)obj.get(1);
                String number = dimensionObj.getString("number");
                DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)((String)dimensionObj.get("dimensiontype")));
                String name = dimensionObj.getString("name");
                switch (dimensionType) {
                    case ASSISTANTDATA: 
                    case DATABASE: {
                        editorMap = this.genF7Editor();
                        break;
                    }
                    case DENUMS: {
                        editorMap = this.genEnumEditor();
                        break;
                    }
                    case OTHER: {
                        editorMap = this.genTextEditor();
                        break;
                    }
                    default: {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"PAShareFactorFlexFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                }
                Map<String, Object> cssMap = this.genColumn(number, name, editorMap, false);
                list.add(cssMap);
            }
            Map<String, Object> valueMap = this.genColumn("value", this.valueName, this.genDecimalEditor(), true);
            list.add(valueMap);
            entryEntityMap.put("columns", list);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod("show_entry", "createGridColumns", new Object[]{entryEntityMap});
        }
        catch (Exception ex) {
            log.error(String.format("buildColumnUI error : %s", ex.getMessage()));
        }
    }

    public Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("dataIndex", "seq");
        map.put("header", new LocaleString("#"));
        map.put("visible", Boolean.TRUE);
        map.put("filter", Boolean.FALSE);
        map.put("sort", Boolean.FALSE);
        map.put("width", 50);
        return map;
    }

    public Map<String, Object> genColumn(String key, String name, Map<String, Object> editor, boolean needSum) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", key);
        map.put("filter", Boolean.TRUE);
        map.put("l", 0);
        map.put("vi", 63);
        map.put("sort", Boolean.FALSE);
        map.put("w", new LocaleString("100px"));
        map.put("header", new LocaleString(name));
        map.put("editor", editor);
        if (needSum) {
            map.put("sum", 1);
        }
        return map;
    }

    public Map<String, Object> genF7Editor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "basedata");
        editor.put("con", "()");
        editor.put("dsp", "name,number");
        editor.put("dst", 0);
        editor.put("ep", 0);
        editor.put("mi", Boolean.TRUE);
        editor.put("qan", Boolean.FALSE);
        return editor;
    }

    public Map<String, Object> genEnumEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "combo");
        editor.put("mi", Boolean.TRUE);
        editor.put("eb", Boolean.TRUE);
        editor.put("st", new ArrayList(4));
        editor.put("sd", Boolean.FALSE);
        editor.put("vas", "underline");
        return editor;
    }

    public Map<String, Object> genTextEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "text");
        editor.put("mi", Boolean.TRUE);
        editor.put("eb", Boolean.TRUE);
        editor.put("isshowtooltip", Boolean.TRUE);
        return editor;
    }

    public Map<String, Object> genDecimalEditor() {
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "number");
        editor.put("max", 9999999999999L);
        editor.put("maxm", "]");
        editor.put("mi", Boolean.TRUE);
        editor.put("min", 0);
        editor.put("minm", "[");
        editor.put("nt", "D");
        editor.put("pc", 23);
        editor.put("roundMethod", 1);
        editor.put("sc", 2);
        editor.put("vas", "underline");
        editor.put("zs", Boolean.TRUE);
        return editor;
    }

    private Control buildRunTimeFieldMeta(String type, String columnNumber, String columnName, String sourceEntity, String pkId, Map<String, String> enumMap) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Container entryContainer = (Container)this.getControl("show_entry");
        MainEntityType mainType = model.getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        if ("decimal".equals(type)) {
            DecimalField decimalField = new DecimalField();
            decimalField.setId(Uuid8.generateShortUuid());
            decimalField.setKey(columnNumber);
            decimalField.setName(new LocaleString(columnName));
            decimalField.setMustInput(true);
            decimalField.setEntityMetadata(entityMeta);
            entityMeta.getItems().add(decimalField);
            entryFieldAp.setId(pkId);
            entryFieldAp.setFieldId(pkId);
            entryFieldAp.setKey(columnNumber);
            entryFieldAp.setName(new LocaleString(columnName));
            entryFieldAp.setField((Field)decimalField);
            entryFieldAp.setWidth(new LocaleString("100px"));
            entryFieldAp.setSummary(1);
            DecimalEdit decimalEdit = (DecimalEdit)entryFieldAp.buildRuntimeControl();
            decimalEdit.setFieldKey(columnNumber);
            decimalEdit.setModel(model);
            decimalEdit.setView(view);
            decimalEdit.setEntryKey("show_entry");
            decimalEdit.setSummary(1);
            entryContainer.getItems().add(decimalEdit);
            return decimalEdit;
        }
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)type);
        if (dimensionTypeEnum != null) {
            switch (dimensionTypeEnum) {
                case ASSISTANTDATA: 
                case DATABASE: {
                    BasedataField basedataField = new BasedataField();
                    basedataField.setId(Uuid8.generateShortUuid());
                    basedataField.setKey(columnNumber);
                    basedataField.setName(new LocaleString(columnName));
                    basedataField.setBaseEntityId(sourceEntity);
                    basedataField.setMustInput(true);
                    basedataField.setDisplayProp("name");
                    basedataField.setEntityMetadata(entityMeta);
                    entityMeta.getItems().add(basedataField);
                    entryFieldAp.setId(pkId);
                    entryFieldAp.setFieldId(pkId);
                    entryFieldAp.setKey(columnNumber);
                    entryFieldAp.setName(new LocaleString(columnName));
                    entryFieldAp.setField((Field)basedataField);
                    entryFieldAp.setWidth(new LocaleString("100px"));
                    entryFieldAp.setQuickAddNew(false);
                    BasedataEdit bsEdit = (BasedataEdit)entryFieldAp.buildRuntimeControl();
                    bsEdit.setFieldKey(columnNumber);
                    bsEdit.setModel(model);
                    bsEdit.setView(view);
                    bsEdit.setDisplayProp("name");
                    bsEdit.setEntryKey("show_entry");
                    bsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                    entryContainer.getItems().add(bsEdit);
                    return bsEdit;
                }
                case DENUMS: {
                    ComboField comboField = new ComboField();
                    comboField.setId(Uuid8.generateShortUuid());
                    comboField.setKey(columnNumber);
                    comboField.setName(new LocaleString(columnName));
                    comboField.setMustInput(true);
                    comboField.setEntityMetadata(entityMeta);
                    entityMeta.getItems().add(comboField);
                    entryFieldAp.setId(pkId);
                    entryFieldAp.setFieldId(pkId);
                    entryFieldAp.setKey(columnNumber);
                    entryFieldAp.setName(new LocaleString(columnName));
                    entryFieldAp.setField((Field)comboField);
                    entryFieldAp.setWidth(new LocaleString("100px"));
                    ComboEdit comboEdit = (ComboEdit)entryFieldAp.buildRuntimeControl();
                    comboEdit.setFieldKey(columnNumber);
                    comboEdit.setModel(model);
                    comboEdit.setView(view);
                    comboEdit.setEntryKey("show_entry");
                    List comboItemList = enumMap.entrySet().stream().map(dy -> new ComboItem(new LocaleString((String)dy.getValue()), (String)dy.getKey())).collect(Collectors.toList());
                    comboEdit.setComboItems(comboItemList);
                    entryContainer.getItems().add(comboEdit);
                    return comboEdit;
                }
                case OTHER: {
                    TextField textField = new TextField();
                    textField.setId(Uuid8.generateShortUuid());
                    textField.setKey(columnNumber);
                    textField.setName(new LocaleString(columnName));
                    textField.setMustInput(true);
                    textField.setEntityMetadata(entityMeta);
                    entityMeta.getItems().add(textField);
                    entryFieldAp.setId(pkId);
                    entryFieldAp.setFieldId(pkId);
                    entryFieldAp.setKey(columnNumber);
                    entryFieldAp.setName(new LocaleString(columnName));
                    entryFieldAp.setField((Field)textField);
                    entryFieldAp.setWidth(new LocaleString("100px"));
                    TextEdit textEdit = (TextEdit)entryFieldAp.buildRuntimeControl();
                    textEdit.setFieldKey(columnNumber);
                    textEdit.setModel(model);
                    textEdit.setView(view);
                    textEdit.setEntryKey("show_entry");
                    entryContainer.getItems().add(textEdit);
                    return textEdit;
                }
            }
        }
        return null;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            IDataModel parentModel = this.getView().getParentView().getModel();
            MainEntityType originalEntityType = e.getOriginalEntityType();
            MainEntityType newEntityType = (MainEntityType)originalEntityType.clone();
            if (newEntityType == null) {
                return;
            }
            EntryProp entry = (EntryProp)newEntityType.getProperty("show_entry");
            DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
            if ("0".equals(parentModel.getValue("factortype"))) {
                Long analysisModelId = (Long)parentModel.getValue("analysis_model_id");
                Iterator analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
                String periodEntity = FormPluginUtil.getBaseEntityId((DynamicObject)analysisModelObj, "1");
                BasedataProp periodProp = new BasedataProp();
                periodProp.setName("period");
                periodProp.setBaseEntityId(periodEntity);
                periodProp.setDisplayName(new LocaleString(this.periodName));
                periodProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)periodEntity));
                periodProp.setFeatures(FeatureOption.Copyable.getValue());
                LongProp periodIdProp = new LongProp();
                periodIdProp.setName("period_id");
                periodProp.setRefIdProp((IDataEntityProperty)periodIdProp);
                periodProp.setRefIdPropName(periodIdProp.getName());
                entryType.addProperty((DynamicProperty)periodProp);
                entryType.addProperty((DynamicProperty)periodIdProp);
                newEntityType.createPropIndexsNoCache();
                e.setNewEntityType(newEntityType);
            }
            DynamicObjectCollection dimensionCol = (DynamicObjectCollection)parentModel.getValue("dimension");
            for (DynamicObject obj : dimensionCol) {
                DynamicObject dimensionObj = (DynamicObject)obj.get(1);
                String number = dimensionObj.getString("number");
                DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)((String)dimensionObj.get("dimensiontype")));
                String name = dimensionObj.getString("name");
                Map<String, String> enumMap = dimensionObj.getDynamicObjectCollection("entryentityenums").stream().collect(Collectors.toMap(dy -> dy.getString("value"), dy -> dy.getString("title")));
                switch (dimensionType) {
                    case ASSISTANTDATA: 
                    case DATABASE: {
                        String sourceEntity = this.getDimensionSourceNumber(dimensionType, dimensionObj);
                        BasedataProp newBaseDataProperty = new BasedataProp();
                        newBaseDataProperty.setName(number);
                        newBaseDataProperty.setBaseEntityId(sourceEntity);
                        newBaseDataProperty.setDisplayName(new LocaleString(name));
                        newBaseDataProperty.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)sourceEntity));
                        newBaseDataProperty.setFeatures(FeatureOption.Copyable.getValue());
                        VarcharProp idProp = PADimensionModel.isStringPrimaryKeyType((String)sourceEntity) ? new VarcharProp() : new LongProp();
                        idProp.setName(number + "_id");
                        newBaseDataProperty.setRefIdProp((IDataEntityProperty)idProp);
                        newBaseDataProperty.setRefIdPropName(idProp.getName());
                        entryType.addProperty((DynamicProperty)newBaseDataProperty);
                        entryType.addProperty((DynamicProperty)idProp);
                        break;
                    }
                    case OTHER: {
                        TextProp newTextProperty = new TextProp();
                        newTextProperty.setName(number);
                        newTextProperty.setDisplayName(new LocaleString(name));
                        newTextProperty.setFeatures(FeatureOption.Copyable.getValue());
                        entryType.addProperty((DynamicProperty)newTextProperty);
                        break;
                    }
                    case DENUMS: {
                        ComboProp newComboProperty = new ComboProp();
                        newComboProperty.setName(number);
                        newComboProperty.setDisplayName(new LocaleString(name));
                        List comboItems = enumMap.entrySet().stream().map(dy -> new ValueMapItem(null, (String)dy.getKey(), new LocaleString((String)dy.getValue()))).collect(Collectors.toList());
                        newComboProperty.setComboItems(comboItems);
                        newComboProperty.setFeatures(FeatureOption.Copyable.getValue());
                        entryType.addProperty((DynamicProperty)newComboProperty);
                        break;
                    }
                    default: {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"PAShareFactorFlexFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                }
                newEntityType.createPropIndexsNoCache();
                e.setNewEntityType(newEntityType);
            }
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName("value");
            decimalProp.setDisplayName(new LocaleString(this.valueName));
            decimalProp.setFeatures(FeatureOption.Copyable.getValue());
            entryType.addProperty((DynamicProperty)decimalProp);
            newEntityType.createPropIndexsNoCache();
            e.setNewEntityType(newEntityType);
        }
        catch (Exception ex) {
            log.error(String.format("getEntityType error : %s", ex.getMessage()));
        }
    }

    private String getDimensionSourceNumber(DimensionTypeEnum dimensionType, DynamicObject dimensionObj) {
        if (DimensionTypeEnum.ASSISTANTDATA == dimensionType) {
            return "bos_assistantdata_detail";
        }
        if (DimensionTypeEnum.DATABASE == dimensionType || DimensionTypeEnum.PERIOD == dimensionType) {
            return dimensionObj.getString("dimensionsource.number");
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        param.setMultiSelect(true);
        IFormView view = this.getView();
        IDataModel parentModel = view.getParentView().getModel();
        BasedataProp prop = (BasedataProp)beforeF7SelectEvent.getProperty();
        String baseEntityId = prop.getBaseEntityId();
        ListFilterParameter listFilter = param.getListFilterParameter();
        BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = source.getKey();
        Long groupId = 0L;
        DynamicObjectCollection dimensionCol = (DynamicObjectCollection)parentModel.getValue("dimension");
        if ("bos_assistantdata_detail".equals(baseEntityId)) {
            for (DynamicObject obj : dimensionCol) {
                DynamicObject dimensionObj = (DynamicObject)obj.get(1);
                String number = dimensionObj.getString("number");
                if (!key.equals(number)) continue;
                groupId = (Long)dimensionObj.get("assistantsource_id");
                break;
            }
            if (groupId != 0L) {
                listFilter.setFilter(new QFilter("group", "=", (Object)groupId));
            }
        } else {
            DynamicObject analysisModel;
            DynamicObjectCollection cols;
            DynamicObject periodObj;
            for (DynamicObject obj : dimensionCol) {
                DynamicObject dimensionObj = (DynamicObject)obj.get(1);
                String number = dimensionObj.getString("number");
                if (!key.equals(number)) continue;
                String typeField = dimensionObj.getString("typefield");
                groupId = (Long)dimensionObj.get("group_id");
                if (typeField != null && !typeField.isEmpty() && groupId != 0L) {
                    listFilter.setFilter(new QFilter(typeField, "=", (Object)groupId));
                }
                return;
            }
            String factorType = (String)parentModel.getValue("factortype");
            if ("0".equals(factorType) && (periodObj = (DynamicObject)(cols = (analysisModel = BusinessDataServiceHelper.loadSingle((Object)parentModel.getValue("analysis_model_id"), (String)"pa_analysismodel")).getDynamicObjectCollection("dimension_entry")).stream().filter(dy -> DimensionNecessityEnum.PERIOD.getCode().equals(dy.getString("necessity_dim"))).findFirst().orElse(null)) != null) {
                DynamicObject dimensionPeriod = periodObj.getDynamicObject("dimension");
                String periodTypeField = dimensionPeriod.getString("typefield");
                Long periodGroupId = (Long)dimensionPeriod.get("group_id");
                if (periodTypeField != null && !periodTypeField.isEmpty() && periodGroupId != 0L) {
                    listFilter.setFilter(new QFilter(periodTypeField, "=", (Object)periodGroupId));
                }
            }
        }
    }
}

