/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.dto.ShareFactorDimensionDTO;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PAShareFactorFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        MulBasedataEdit dimensionEdit = (MulBasedataEdit)this.getControl("dimension");
        dimensionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisModelEdit = (BasedataEdit)this.getControl("analysis_model");
        analysisModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long id = (Long)model.getValue("id");
        if (id != null && id != 0L) {
            view.setEnable(Boolean.valueOf(!BaseDataRefrenceHelper.isRefrenced((String)"pa_sharefactor", (Object)id)), new String[]{"analysis_system", "analysis_model", "number", "factortype", "dimension", "unitfield", "describe"});
        } else {
            Long analysisModel;
            FormShowParameter fsp = view.getFormShowParameter();
            Long analysisSystem = (Long)fsp.getCustomParam("analysis_system");
            if (analysisSystem != null) {
                model.setValue("analysis_system", (Object)analysisSystem);
            }
            if ((analysisModel = (Long)fsp.getCustomParam("analysis_model")) != null) {
                model.setValue("analysis_model", (Object)analysisModel);
            }
        }
        view.setVisible(Boolean.FALSE, new String[]{"share_factor_entry"});
        this.initChildPage(Boolean.FALSE.toString());
    }

    private void initChildPage(String isPropertyChange) {
        this.closeChildPage();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pa_sharefactorshow");
        fsp.getOpenStyle().setTargetKey("show_factor_entry");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setCustomParam("factorChildPropertyChange", (Object)isPropertyChange);
        this.getPageCache().put("factorChildPage", fsp.getPageId());
        this.getView().showForm(fsp);
    }

    private void closeChildPage() {
        String childPageId = this.getPageCache().get("factorChildPage");
        if (StringUtils.isNotEmpty((String)childPageId)) {
            IFormView view = this.getView();
            IFormView childView = view.getView(childPageId);
            childView.close();
            view.sendFormAction(childView);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (key) {
            case "analysis_system": 
            case "analysis_model": {
                if (oldValue != null) {
                    DynamicObject obj2 = (DynamicObject)oldValue;
                    Long id = obj2.getLong("id");
                    this.confirmChange(key, String.valueOf(id));
                    break;
                }
                this.confirmChange(key, "");
                break;
            }
            case "factortype": {
                if (oldValue == null) break;
                this.confirmChange(key, oldValue.toString());
                break;
            }
            case "dimension": {
                if (oldValue == null) break;
                DynamicObjectCollection doc = (DynamicObjectCollection)oldValue;
                HashSet dimensionIdSet = new HashSet(doc.size());
                doc.forEach(obj -> dimensionIdSet.add((Long)((DynamicObject)obj.get(1)).get("id")));
                this.confirmChange(key, JSON.toJSONString(dimensionIdSet));
                break;
            }
        }
    }

    private void confirmChange(String key, String oldValue) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean needShowConfirm = false;
        Long analysisModelId = (Long)model.getValue("analysis_model_id");
        switch (key) {
            case "analysis_system": {
                DynamicObjectCollection dimensionCol = (DynamicObjectCollection)model.getValue("dimension");
                if (!(analysisModelId != null && analysisModelId > 0L || dimensionCol != null && !dimensionCol.isEmpty()) && this.getChildEntryRowCount() <= 0) break;
                needShowConfirm = true;
                break;
            }
            case "analysis_model": {
                DynamicObjectCollection dimensionCol = (DynamicObjectCollection)model.getValue("dimension");
                if ((dimensionCol == null || dimensionCol.isEmpty()) && this.getChildEntryRowCount() <= 0) break;
                needShowConfirm = true;
                break;
            }
            case "factortype": 
            case "dimension": {
                if (this.getChildEntryRowCount() <= 0) break;
                needShowConfirm = true;
                break;
            }
        }
        if (needShowConfirm) {
            view.showConfirm(ResManager.loadKDString((String)"\u66f4\u6539\u5b57\u6bb5\u5c06\u91cd\u65b0\u586b\u5199\u5173\u8054\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"PAShareFactorFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(key, (IFormPlugin)this), null, oldValue);
        } else if ("factortype".equals(key) || "dimension".equals(key)) {
            this.initChildPage(Boolean.TRUE.toString());
        }
    }

    private int getChildEntryRowCount() {
        IFormView childView = this.getView().getView(this.getPageCache().get("factorChildPage"));
        if (childView != null) {
            return childView.getModel().getEntryRowCount("show_entry");
        }
        return 0;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String actionId = messageBoxClosedEvent.getCallBackId();
        String oldValue = messageBoxClosedEvent.getCustomVaule();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes == messageBoxResult) {
            if ("entryChange".equals(actionId)) {
                IFormView childView = view.getView(this.getPageCache().get("factorChildPage"));
                childView.getPageCache().remove("entryChange");
                view.close();
            } else {
                model.beginInit();
                switch (actionId) {
                    case "analysis_system": {
                        model.setValue("analysis_model", null);
                        model.setValue("dimension", null);
                        break;
                    }
                    case "analysis_model": {
                        model.setValue("dimension", null);
                        break;
                    }
                }
                model.endInit();
                view.updateView("sharefactor");
                this.initChildPage(Boolean.TRUE.toString());
            }
        } else if (!"entryChange".equals(actionId)) {
            model.beginInit();
            if ("dimension".equals(actionId)) {
                model.setValue(actionId, JSON.parseObject((String)oldValue, Long[].class));
            } else {
                model.setValue(actionId, (Object)oldValue);
            }
            model.endInit();
            view.updateView("sharefactor");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        Object source = args.getSource();
        if (source instanceof FormOperate && "save".equals(key = ((FormOperate)source).getOperateKey())) {
            if (this.isRequiredFieldsMissing() || this.isCombinationRepeat()) {
                args.setCancel(true);
                return;
            }
            this.childDataWriteToEntry();
            IFormView view = this.getView();
            IFormView childView = view.getView(this.getPageCache().get("factorChildPage"));
            if (childView != null) {
                childView.getPageCache().remove("entryChange");
            }
        }
    }

    private boolean isRequiredFieldsMissing() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView childView = view.getView(this.getPageCache().get("factorChildPage"));
        IDataModel childModel = childView.getModel();
        int childEntryRowCount = childModel.getEntryRowCount("show_entry");
        if (childEntryRowCount < 1) {
            return false;
        }
        DynamicObjectCollection dimensionCol = (DynamicObjectCollection)model.getValue("dimension");
        ArrayList dimensionNumberList = new ArrayList(dimensionCol.size());
        dimensionCol.forEach(obj -> dimensionNumberList.add((String)((DynamicObject)obj.get(1)).get("number")));
        boolean isPeriodType = "0".equals(model.getValue("factortype"));
        for (int i = 0; i < childEntryRowCount; ++i) {
            Long periodId;
            if (isPeriodType && ((periodId = (Long)childModel.getValue("period_id", i)) == null || periodId == 0L)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\u671f\u95f4\u3002", (String)"PAShareFactorFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), i + 1));
                return true;
            }
            for (String dimensionNumber : dimensionNumberList) {
                Object value = childModel.getValue(dimensionNumber, i);
                if (value != null && !StringUtils.isEmpty((String)value.toString())) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ef4\u5ea6\u9700\u5168\u90e8\u586b\u5199\u3002", (String)"PAShareFactorFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]), i + 1));
                return true;
            }
        }
        return false;
    }

    private void childDataWriteToEntry() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.deleteEntryData("share_factor_entry");
        IFormView childView = view.getView(this.getPageCache().get("factorChildPage"));
        DynamicObjectCollection dimensionCol = (DynamicObjectCollection)model.getValue("dimension");
        if (childView != null && dimensionCol != null && !dimensionCol.isEmpty()) {
            IDataModel childModel = childView.getModel();
            int childEntryRowCount = childModel.getEntryRowCount("show_entry");
            if (childEntryRowCount < 1) {
                return;
            }
            boolean isPeriodType = "0".equals(model.getValue("factortype"));
            Long analysisModelId = (Long)model.getValue("analysis_model_id");
            DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
            DimensionTypeEnum periodEnum = FormPluginUtil.getDimensionTypeEnumByModelAndDim(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
            model.beginInit();
            for (int i = 0; i < childEntryRowCount; ++i) {
                model.createNewEntryRow("share_factor_entry");
                model.setValue("value", childModel.getValue("value", i), i);
                ArrayList<ShareFactorDimensionDTO> factorDimensionDTOList = new ArrayList<ShareFactorDimensionDTO>(dimensionCol.size());
                StringBuilder valueBuilder = new StringBuilder();
                if (isPeriodType) {
                    Long periodId = (Long)childModel.getValue("period_id", i);
                    valueBuilder.append(',').append(periodId);
                    factorDimensionDTOList.add(new ShareFactorDimensionDTO("period", periodEnum, (Object)periodId));
                }
                for (DynamicObject obj : dimensionCol) {
                    Object value;
                    DynamicObject dynamicObject = (DynamicObject)obj.get(1);
                    DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dynamicObject.getString("dimensiontype"));
                    String dimensionNumber = dynamicObject.getString("number");
                    switch (dimensionType) {
                        case DATABASE: 
                        case ASSISTANTDATA: {
                            value = childModel.getValue(dimensionNumber + "_id", i);
                            break;
                        }
                        case OTHER: 
                        case DENUMS: {
                            value = childModel.getValue(dimensionNumber, i);
                            break;
                        }
                        default: {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"PAShareFactorFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        }
                    }
                    valueBuilder.append(',').append(value);
                    ShareFactorDimensionDTO dto = new ShareFactorDimensionDTO(dimensionNumber, dimensionType, value);
                    factorDimensionDTOList.add(dto);
                }
                model.setValue("dimensionjson_tag", (Object)JSON.toJSONString(factorDimensionDTOList), i);
                if (valueBuilder.length() <= 0) continue;
                model.setValue("value_pks_tag", (Object)valueBuilder.substring(1), i);
            }
            model.endInit();
            view.updateView("share_factor_entry");
        }
    }

    private boolean isCombinationRepeat() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        boolean isPeriodType = "0".equals(model.getValue("factortype"));
        IFormView childView = view.getView(this.getPageCache().get("factorChildPage"));
        DynamicObjectCollection dimensionCol = (DynamicObjectCollection)model.getValue("dimension");
        if (childView != null && dimensionCol != null && !dimensionCol.isEmpty()) {
            List<String> combinationRowList;
            IDataModel childModel = childView.getModel();
            int childEntryRowCount = childModel.getEntryRowCount("show_entry");
            if (childEntryRowCount < 2) {
                return false;
            }
            LinkedHashMap<String, ArrayList<String>> combinationMap = new LinkedHashMap<String, ArrayList<String>>(1);
            for (int i = 0; i < childEntryRowCount; ++i) {
                StringBuilder currentRowCombination = new StringBuilder();
                if (isPeriodType) {
                    Long periodId = (Long)childModel.getValue("period_id", i);
                    currentRowCombination.append(',').append(periodId);
                }
                for (DynamicObject obj : dimensionCol) {
                    Object value;
                    DynamicObject dynamicObject = (DynamicObject)obj.get(1);
                    DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dynamicObject.getString("dimensiontype"));
                    String dimensionNumber = dynamicObject.getString("number");
                    switch (dimensionType) {
                        case DATABASE: 
                        case ASSISTANTDATA: {
                            value = childModel.getValue(dimensionNumber + "_id", i);
                            break;
                        }
                        case OTHER: 
                        case DENUMS: {
                            value = childModel.getValue(dimensionNumber, i);
                            break;
                        }
                        default: {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b", (String)"PAShareFactorFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        }
                    }
                    currentRowCombination.append(',').append(value);
                }
                if (currentRowCombination.length() <= 0) continue;
                String combinationKey = currentRowCombination.substring(1);
                combinationRowList = (List)combinationMap.get(combinationKey);
                if (combinationRowList == null) {
                    combinationRowList = new ArrayList<String>(1);
                }
                combinationRowList.add(String.valueOf(i + 1));
                combinationMap.put(combinationKey, (ArrayList<String>)combinationRowList);
            }
            if (!combinationMap.isEmpty()) {
                StringBuilder repeatMsgBuilder = new StringBuilder();
                for (Map.Entry entry : combinationMap.entrySet()) {
                    combinationRowList = (ArrayList<String>)entry.getValue();
                    if (combinationRowList == null || combinationRowList.size() <= 1) continue;
                    repeatMsgBuilder.append(',').append("[").append(String.join((CharSequence)",", combinationRowList)).append("]");
                }
                if (repeatMsgBuilder.length() > 0) {
                    if (isPeriodType) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u671f\u95f4+\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u66f4\u6539\u3002", (String)"PAShareFactorFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), repeatMsgBuilder.substring(1)));
                    } else {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u66f4\u6539\u3002", (String)"PAShareFactorFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]), repeatMsgBuilder.substring(1)));
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Long analysisSystemId = (Long)model.getValue("analysis_system_id");
        Long analysisModelId = (Long)model.getValue("analysis_model_id");
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "analysis_model": {
                if (analysisSystemId == null || analysisSystemId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PAShareFactorFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("analysis_system", "=", (Object)analysisSystemId).and(PARuleHelper.getAnalysisPeriodFilter()).and(PARuleHelper.getDateTimeFilterInModel());
                param.getListFilterParameter().setFilter(filter);
                break;
            }
            case "dimension": {
                if (analysisModelId == null || analysisModelId == 0L) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareFactorFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("system", "=", (Object)analysisSystemId);
                DynamicObject dataCollectionDyn = BusinessDataServiceHelper.loadSingle((Object)analysisModelId, (String)"pa_analysismodel", (String)"dimension_entry, dimension_entry.dimension");
                DynamicObjectCollection dataEntryCol = dataCollectionDyn.getDynamicObjectCollection("dimension_entry");
                HashSet<Long> dimensionIds = new HashSet<Long>(dataEntryCol.size());
                for (DynamicObject dataEnt : dataEntryCol) {
                    dimensionIds.add(dataEnt.getLong("dimension_id"));
                }
                filter.and(new QFilter("id", "in", dimensionIds));
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
                String periodEntity = FormPluginUtil.getBaseEntityId(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                filter.and(new QFilter("number", "!=", (Object)periodEntity));
                QFilter sourceFilter = new QFilter("dimensiontype", "=", (Object)DimensionTypeEnum.PERIOD.getTypeString()).and(new QFilter("system", "=", (Object)analysisSystemId));
                DynamicObjectCollection dimensionCol = QueryServiceHelper.query((String)"pa_dimension", (String)"id,dimensionsource.number", (QFilter[])sourceFilter.toArray());
                HashSet<Long> periodDimensionSourceSet = new HashSet<Long>(4);
                for (DynamicObject dimensionObj : dimensionCol) {
                    String dimensionSourceNumber = dimensionObj.getString("dimensionsource.number");
                    if (!"bd_period".equals(dimensionSourceNumber)) continue;
                    periodDimensionSourceSet.add(dimensionObj.getLong("id"));
                }
                if (!periodDimensionSourceSet.isEmpty()) {
                    filter.and(new QFilter("id", "not in", periodDimensionSourceSet));
                }
                param.getListFilterParameter().setFilter(filter);
                param.getListFilterParameter().setFilter(PADimensionHelper.getNoDateTimeDimFilter());
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String entryChange;
        IFormView view;
        IFormView childView;
        IDataModel model = this.getModel();
        if (!model.getDataChanged() && (childView = (view = this.getView()).getView(this.getPageCache().get("factorChildPage"))) != null && StringUtils.isNotEmpty((String)(entryChange = childView.getPageCache().get("entryChange"))) && Boolean.parseBoolean(entryChange)) {
            e.setCancel(true);
            view.showConfirm(ResManager.loadKDString((String)"\u68c0\u9a8c\u5230\u60a8\u4fee\u6539\u4e86\u5206\u5f55\u6570\u636e\uff0c\u786e\u8ba4\u653e\u5f03\u672c\u6b21\u4fee\u6539\u5417\uff1f", (String)"PAShareFactorFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("entryChange", (IFormPlugin)this));
        }
    }
}

