/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.enums.AllocationFlagEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.util.PluginExceptionHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PAShareFlagEntryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        try {
            this.processFlagEntryVisible();
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"f_valuetext"});
        BasedataEdit targetDimEdit = (BasedataEdit)this.getControl("f_targetdim");
        targetDimEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourceDimEdit = (BasedataEdit)this.getControl("f_sourcedim");
        sourceDimEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        try {
            if (StringUtils.equals((CharSequence)"f_valuetext", (CharSequence)key)) {
                int valueIndex = model.getEntryCurrentRowIndex("flagentryentity");
                DynamicObject targetDimDy = (DynamicObject)model.getValue("f_targetdim", valueIndex);
                if (targetDimDy == null) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7684\u7ef4\u5ea6\u201d\u3002", (String)"PAShareFlagEntryPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.processFlagValueTextDisplay(targetDimDy);
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        try {
            if (StringUtils.equals((CharSequence)"valueCallBack", (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
                ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)result).get(0);
                int valueIndex = model.getEntryCurrentRowIndex("flagentryentity");
                model.beginInit();
                model.setValue("f_valuetext", (Object)listSelectedRow.getName(), valueIndex);
                model.setValue("f_value", listSelectedRow.getPrimaryKeyValue(), valueIndex);
                model.endInit();
                view.updateView("flagentryentity");
                return;
            }
            if (StringUtils.equals((CharSequence)"enumValueCallBack", (CharSequence)actionId) && !ObjectUtils.isEmpty((Object)result)) {
                Map resultMap = (Map)SerializationUtils.fromJsonString((String)result.toString(), Map.class);
                int valueIndex = model.getEntryCurrentRowIndex("flagentryentity");
                model.beginInit();
                model.setValue("f_valuetext", resultMap.get("title"), valueIndex);
                model.setValue("f_value", resultMap.get("value"), valueIndex);
                model.endInit();
                view.updateView("flagentryentity");
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        try {
            if (StringUtils.equals((CharSequence)"f_targetdim", (CharSequence)fieldKey)) {
                int flagIndex;
                Long curSourceDimId;
                DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
                if (analysisModelDy == null) {
                    evt.setCancel(true);
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareFlagEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
                Set dimIdSet = dys.stream().filter(dy -> {
                    String necessityDim = dy.getString("necessity_dim");
                    return StringUtils.isEmpty((CharSequence)necessityDim);
                }).map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
                if (!dimIdSet.isEmpty()) {
                    QFilter idFilter = new QFilter("id", "in", dimIdSet);
                    evt.addCustomQFilter(idFilter);
                }
                if ((curSourceDimId = (Long)model.getValue("f_sourcedim_id", flagIndex = model.getEntryCurrentRowIndex("flagentryentity"))) != null && curSourceDimId != 0L) {
                    QFilter specialDimFilter = PADimensionHelper.getSpecialDimFilter((Long)curSourceDimId);
                    evt.addCustomQFilter(specialDimFilter);
                } else {
                    QFilter defaultDimFilter = PADimensionHelper.getDefaultDimFilter();
                    evt.addCustomQFilter(defaultDimFilter);
                }
                DynamicObjectCollection flagEntryDyCol = model.getEntryEntity("flagentryentity");
                Long curTargetDimId = (Long)model.getValue("f_targetdim_id", flagIndex);
                List targetIdList = flagEntryDyCol.stream().map(dy -> dy.getLong("f_targetdim_id")).filter(idTargetDimId -> !idTargetDimId.equals(curTargetDimId)).collect(Collectors.toList());
                if (!targetIdList.isEmpty()) {
                    QFilter notIdFilter = new QFilter("id", "not in", targetIdList);
                    evt.addCustomQFilter(notIdFilter);
                }
                return;
            }
            if (StringUtils.equals((CharSequence)"f_sourcedim", (CharSequence)fieldKey)) {
                int flagIndex;
                Long curTargetDimId;
                DynamicObject analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
                if (analysisModelDy == null) {
                    evt.setCancel(true);
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareFlagEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection dys = analysisModelDy.getDynamicObjectCollection("dimension_entry");
                Set dimIdSet = dys.stream().map(dy -> dy.getLong("dimension_id")).collect(Collectors.toSet());
                if (!dimIdSet.isEmpty()) {
                    QFilter idFilter = new QFilter("id", "in", dimIdSet);
                    evt.addCustomQFilter(idFilter);
                }
                if ((curTargetDimId = (Long)model.getValue("f_targetdim_id", flagIndex = model.getEntryCurrentRowIndex("flagentryentity"))) != null && curTargetDimId != 0L) {
                    QFilter specialDimFilter = PADimensionHelper.getSpecialDimFilter((Long)curTargetDimId);
                    evt.addCustomQFilter(specialDimFilter);
                } else {
                    QFilter defaultDimFilter = PADimensionHelper.getDefaultDimFilter();
                    evt.addCustomQFilter(defaultDimFilter);
                }
                DynamicObjectCollection flagEntryDyCol = model.getEntryEntity("flagentryentity");
                Long curSourceDimId = (Long)model.getValue("f_sourcedim_id", flagIndex);
                List sourceIdList = flagEntryDyCol.stream().map(dy -> dy.getLong("f_sourcedim_id")).filter(idSourceDimId -> !idSourceDimId.equals(curSourceDimId)).collect(Collectors.toList());
                if (!sourceIdList.isEmpty()) {
                    QFilter notIdFilter = new QFilter("id", "not in", sourceIdList);
                    evt.addCustomQFilter(notIdFilter);
                }
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String key = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        try {
            if (StringUtils.equals((CharSequence)"f_targetdim", (CharSequence)key)) {
                int curFlagEntryIndex = model.getEntryCurrentRowIndex("flagentryentity");
                model.setValue("f_valuetext", null, curFlagEntryIndex);
                return;
            }
            if (StringUtils.equals((CharSequence)"f_flagtype", (CharSequence)key)) {
                this.processFlagEntryVisible();
                int curFlagEntryIndex = model.getEntryCurrentRowIndex("flagentryentity");
                model.setValue("f_sourcedim", null, curFlagEntryIndex);
                model.setValue("f_valuetext", null, curFlagEntryIndex);
                return;
            }
            if (StringUtils.equals((CharSequence)"f_valuetext", (CharSequence)key)) {
                int curFlagEntryIndex = model.getEntryCurrentRowIndex("flagentryentity");
                if (StringUtils.isBlank((Object)newValue)) {
                    model.setValue("f_value", null, curFlagEntryIndex);
                } else {
                    model.beginInit();
                    DynamicObject targetDimDy = (DynamicObject)model.getValue("f_targetdim", curFlagEntryIndex);
                    if (targetDimDy != null) {
                        String dimensionType = targetDimDy.getString("dimensiontype");
                        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
                        if (DimensionTypeEnum.OTHER == dimensionTypeEnum) {
                            model.setValue("f_value", newValue, curFlagEntryIndex);
                            model.setValue("f_valuetext", newValue, curFlagEntryIndex);
                        } else {
                            model.setValue("f_value", null, curFlagEntryIndex);
                            model.setValue("f_valuetext", null, curFlagEntryIndex);
                            view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7684\u7ef4\u5ea6\u201d\u7684\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u662f\u6587\u672c\u3002", (String)"PAShareFlagEntryPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                        }
                    } else {
                        model.setValue("f_value", null, curFlagEntryIndex);
                        model.setValue("f_valuetext", null, curFlagEntryIndex);
                        view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7684\u7ef4\u5ea6\u201d\u3002", (String)"PAShareFlagEntryPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    }
                    model.endInit();
                    view.updateView("flagentryentity");
                }
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        try {
            int entryRowCount;
            if (StringUtils.equals((CharSequence)"newentryflag", (CharSequence)operateKey) && (entryRowCount = this.getModel().getEntryRowCount("flagentryentity")) >= 5) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u5206\u5f55\u6700\u591a\u53ef\u65b0\u589e5\u884c\u3002", (String)"PAShareFlagEntryPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        try {
            if (StringUtils.equals((CharSequence)"newentryflag", (CharSequence)operateKey)) {
                this.processFlagEntryVisible();
                return;
            }
            if (StringUtils.equals((CharSequence)"deleteentryflag", (CharSequence)operateKey)) {
                this.processFlagEntryVisible();
            }
        }
        catch (Exception e) {
            PluginExceptionHelper.throwKDBizException(e);
        }
    }

    private void processFlagEntryVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection flagEntryDyCol = model.getEntryEntity("flagentryentity");
        if (flagEntryDyCol == null || flagEntryDyCol.isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"f_sourcedim"});
            return;
        }
        long valueCount = flagEntryDyCol.stream().filter(dy -> StringUtils.equals((CharSequence)AllocationFlagEnum.VALUE.getCode(), (CharSequence)dy.getString("f_flagtype"))).count();
        long senderCount = flagEntryDyCol.stream().filter(dy -> StringUtils.equals((CharSequence)AllocationFlagEnum.SENDER.getCode(), (CharSequence)dy.getString("f_flagtype"))).count();
        if (valueCount != 0L && senderCount != 0L) {
            view.setVisible(Boolean.TRUE, new String[]{"f_valuetext"});
            view.setVisible(Boolean.TRUE, new String[]{"f_sourcedim"});
            return;
        }
        if (valueCount == 0L && senderCount != 0L) {
            view.setVisible(Boolean.FALSE, new String[]{"f_valuetext"});
            view.setVisible(Boolean.TRUE, new String[]{"f_sourcedim"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"f_valuetext"});
        view.setVisible(Boolean.FALSE, new String[]{"f_sourcedim"});
    }

    private void processFlagValueTextDisplay(DynamicObject dimDy) {
        String baseDataObj = "";
        DynamicObject bdDimSourceDy = dimDy.getDynamicObject("dimensionsource");
        if (bdDimSourceDy != null) {
            baseDataObj = bdDimSourceDy.getString("number");
        }
        String assDataObj = "";
        DynamicObject assDimSourceDy = dimDy.getDynamicObject("assistantsource");
        if (assDimSourceDy != null) {
            assDataObj = assDimSourceDy.getString("number");
        }
        PARuleHelper.processInteractiveDisplay((AbstractFormPlugin)this, (Object)baseDataObj, (Object)assDataObj, (Object)dimDy, (String)"flagentryentity", (String)"f_value", (String)"valueCallBack", (String)"enumValueCallBack", null, (boolean)false, null);
    }
}

