/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PAShareReceiveEntryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(PAShareReceiveEntryPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"receivedimvalue"});
        BasedataEdit measureBaseDataEdit = (BasedataEdit)this.getView().getControl("receivedimension");
        measureBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataModel model = this.getModel();
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (StringUtils.equals((CharSequence)"receivedimension", (CharSequence)name)) {
            DynamicObject analysisModel;
            Long analysisModelId;
            DynamicObjectCollection entryEntity = model.getEntryEntity("receiveentryentity");
            if (Objects.isNull(entryEntity) || entryEntity.isEmpty()) {
                return;
            }
            String ruleType = (String)model.getValue("receiverule");
            if ((ShareTypeEnum.SHARE_SUBJECT.getType().equals(ruleType) || ShareTypeEnum.SHARE_FIXED.getType().equals(ruleType)) && (analysisModelId = (Long)this.getView().getFormShowParameter().getCustomParam("analysismodel")) != null && (analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel")) != null) {
                DynamicObjectCollection col = analysisModel.getDynamicObjectCollection("dimension_entry");
                ArrayList<String> notSelectList = new ArrayList<String>(2);
                for (DynamicObject entryObj : col) {
                    DynamicObject dim = entryObj.getDynamicObject("dimension");
                    if (dim == null) continue;
                    String necessity = entryObj.getString("necessity_dim");
                    if (DimensionNecessityEnum.PERIOD.getCode().equals(necessity)) {
                        notSelectList.add(dim.getString("number"));
                        continue;
                    }
                    if (!ShareTypeEnum.SHARE_SUBJECT.getType().equals(ruleType) || !DimensionNecessityEnum.ACCOUNT.getCode().equals(necessity)) continue;
                    notSelectList.add(dim.getString("number"));
                }
                if (!notSelectList.isEmpty()) {
                    qFilters.add(new QFilter("number", "not in", notSelectList));
                }
            }
            ArrayList<Object> dims = new ArrayList<Object>();
            for (DynamicObject dynamicObject : entryEntity) {
                Object dim = dynamicObject.get("receivedimension");
                if (Objects.isNull(dim) || StringUtils.isBlank((CharSequence)dim.toString())) continue;
                DynamicObject dimObj = (DynamicObject)dim;
                dims.add(dimObj.get("id"));
            }
            qFilters.add(new QFilter("id", "not in", dims));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"receivedimvalue")) {
            int index = model.getEntryCurrentRowIndex("receiveentryentity");
            DynamicObject entryEntity = model.getEntryEntity("receiveentryentity", index);
            long aLong = entryEntity.getLong("receivedimension_id");
            if (aLong == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareReceiveEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject clickDimension = PADimensionHelper.loadDimension((Object)aLong);
            if (Objects.isNull(clickDimension)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareReceiveEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            String dimensionType = clickDimension.getString("dimensiontype");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            logger.info(String.format("PAShareReceiveEntryPlugin DimensionType : %s, DimensionTypeEnum: %s", dimensionType, dimensionTypeEnum));
            if (dimensionTypeEnum == null) {
                return;
            }
            switch (dimensionTypeEnum) {
                case DATABASE: {
                    Object pkValue;
                    DynamicObject dimensionsource = clickDimension.getDynamicObject("dimensionsource");
                    if (Objects.isNull(dimensionsource) || Objects.isNull(pkValue = dimensionsource.getPkValue())) break;
                    Object[] selected = null;
                    Object ids = entryEntity.get("receivedimid");
                    HashMap map = (HashMap)JSON.parseObject((String)entryEntity.get("receivedimensiontext_tag").toString(), HashMap.class);
                    if (map == null && !Objects.isNull(ids) && StringUtils.isNotBlank((CharSequence)ids.toString())) {
                        selected = ids.toString().split(",");
                    } else if (map != null) {
                        selected = map.keySet().toArray();
                    }
                    String pkStr = pkValue.toString();
                    QFilter filter = this.setFilter(pkStr);
                    QFilter dimensionTypeQFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)clickDimension);
                    if (!Objects.isNull(dimensionTypeQFilter)) {
                        filter = Objects.isNull(filter) ? dimensionTypeQFilter : filter.and(dimensionTypeQFilter);
                    }
                    this.openListView(pkStr, selected, filter);
                    break;
                }
                case ASSISTANTDATA: {
                    DynamicObject dimensionsource = (DynamicObject)clickDimension.get("assistantsource");
                    Object number = dimensionsource.get("number");
                    if (Objects.isNull(number)) break;
                    Object[] selected = null;
                    Object ids = entryEntity.get("receivedimid");
                    HashMap map = (HashMap)JSON.parseObject((String)entryEntity.get("receivedimensiontext_tag").toString(), HashMap.class);
                    if (map == null && !Objects.isNull(ids) && StringUtils.isNotBlank((CharSequence)ids.toString())) {
                        selected = ids.toString().split(",");
                    } else if (map != null) {
                        selected = map.keySet().toArray();
                    }
                    QFilter filter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
                    this.openFuListView(number.toString(), selected, filter);
                    break;
                }
                case OTHER: {
                    String dimensionValueTag = entryEntity.getString("receivedimensiontext_tag");
                    String dimensionName = entryEntity.getString("receivedimension.name");
                    String dimensionValue = entryEntity.getString("receivedimvalue");
                    if (StringUtils.isNotBlank((CharSequence)dimensionValue)) {
                        if (StringUtils.isBlank((CharSequence)dimensionValueTag)) {
                            dimensionValueTag = dimensionValue.replace(",", "\n");
                        }
                    } else {
                        dimensionValueTag = "";
                    }
                    PARuleHelper.openView((AbstractFormPlugin)this, (String)dimensionName, (String)dimensionValueTag);
                    break;
                }
                case DENUMS: {
                    logger.info("PAShareReceiveEntryPlugin dimension is enum type");
                    String text = entryEntity.getString("receivedimensiontext_tag");
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        text = String.join((CharSequence)",", map.keySet());
                    }
                    PARuleHelper.openDimensionInfoView((AbstractFormPlugin)this, (String)text, (long)clickDimension.getLong("id"), (String)clickDimension.getString("name"), (String)"receiverdimensioninfo", (boolean)true);
                    break;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "receivedimvalue": {
                this.dimensionValueChange(rowIndex, propValue);
                break;
            }
            case "receivedimension": {
                this.receivedimensionChangeReset(rowIndex, (DynamicObject)propValue);
                break;
            }
            case "sharefactor": {
                this.shareByFactor();
                break;
            }
            case "comboreceive": {
                this.changeCondition(rowIndex, (String)propValue);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object result = e.getReturnData();
        switch (actionId) {
            case "bosAssCallBack": {
                this.callBackFormula(e, false);
                break;
            }
            case "otherCallBack": {
                this.callBackFormula(e, true);
                break;
            }
            case "receiverdimensioninfo": {
                PARuleHelper.processDimensionInfoCloseBack((AbstractFormPlugin)this, (Object)result, (String)"receiveentryentity", (String)"receivedimid", (String)"receivedimvalue", (String)"receivedimensiontext");
                break;
            }
        }
    }

    private QFilter setFilter(String pkValue) {
        QFilter qFilter = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)pkValue);
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"enable")) {
            qFilter = new QFilter("enable", "=", (Object)"1");
        }
        if (properties.containsKey((Object)"status")) {
            QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
            qFilter = qFilter == null ? qFilterStatus : qFilter.and(qFilterStatus);
        }
        return qFilter;
    }

    private void callBackFormula(ClosedCallBackEvent e, boolean isStr) {
        String content;
        String dimensionValue;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("receiveentryentity");
        if (isStr) {
            dimensionValue = returnData.toString().replace("\n", ",");
            content = returnData.toString();
        } else {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            ArrayList<String> names = new ArrayList<String>(data.size());
            HashMap<Object, String> map = new HashMap<Object, String>(data.size());
            for (ListSelectedRow datum : data) {
                map.put(datum.getPrimaryKeyValue(), datum.getName());
                names.add(datum.getName());
            }
            dimensionValue = String.join((CharSequence)",", names);
            content = SerializationUtils.toJsonString(map);
        }
        this.getModel().setValue("receivedimvalue", (Object)(dimensionValue.length() > 1024 ? dimensionValue.substring(0, 1024) : dimensionValue), row);
        this.getModel().setValue("receivedimensiontext", (Object)(content.length() > 255 ? content.substring(0, 255) : content), row);
        this.getModel().setValue("receivedimensiontext_tag", (Object)content, row);
    }

    private void shareByFactor() {
        Object value = this.getModel().getValue("sharefactor");
        if (Objects.isNull(value)) {
            this.shareIsNull();
        } else {
            DynamicObject dynamicObject = (DynamicObject)value;
            Object pkValue = dynamicObject.getPkValue();
            String metaName = dynamicObject.getDataEntityType().getName();
            DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)metaName, (QFilter[])new QFilter("id", "=", pkValue).toArray());
            if (Objects.isNull(dynamicObject1)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u644a\u56e0\u5b50\u6240\u9009\u7ef4\u5ea6\u4e3a\u7a7a", (String)"PAShareReceiveEntryPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.shareSelect(dynamicObject1);
        }
    }

    private void shareSelect(DynamicObject dynamicObject) {
        DynamicObjectCollection dimList = (DynamicObjectCollection)dynamicObject.get("dimension");
        if (Objects.isNull(dimList) || dimList.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u644a\u56e0\u5b50\u6240\u9009\u7ef4\u5ea6\u4e3a\u7a7a", (String)"PAShareReceiveEntryPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("receiveentryentity");
        model.beginInit();
        model.batchCreateNewEntryRow("receiveentryentity", dimList.size());
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("receiveentryentity");
        DynamicProperty subdataid = dynamicObjects.getDynamicObjectType().getProperty("receivedimension");
        DynamicProperty mateName = dynamicObjects.getDynamicObjectType().getProperty("receivematename");
        DynamicProperty mateType = dynamicObjects.getDynamicObjectType().getProperty("receivedimtype");
        for (int i = 0; i < dimList.size(); ++i) {
            Object number;
            DynamicObject dimensionsource;
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            DynamicObject fbasedataid = (DynamicObject)((DynamicObject)dimList.get(i)).get("fbasedataid");
            subdataid.setValueFast((Object)entry, (Object)fbasedataid);
            String dimensionType = (String)fbasedataid.get("dimensiontype");
            mateType.setValue((Object)entry, (Object)dimensionType);
            DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.DATABASE == anEnum) {
                Object pkValue;
                dimensionsource = (DynamicObject)fbasedataid.get("dimensionsource");
                if (Objects.isNull(dimensionsource) || Objects.isNull(pkValue = dimensionsource.getPkValue())) continue;
                mateName.setValueFast((Object)entry, pkValue);
                continue;
            }
            if (DimensionTypeEnum.ASSISTANTDATA != anEnum || Objects.isNull(number = (dimensionsource = (DynamicObject)fbasedataid.get("assistantsource")).get("number"))) continue;
            mateName.setValueFast((Object)entry, (Object)"bos_assistantdata_detail");
        }
        model.endInit();
        this.getView().updateView("receiveentryentity");
    }

    private void shareIsNull() {
        this.getModel().deleteEntryData("receiveentryentity");
        this.getModel().setValue("inputratiobox", (Object)false);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"receivesubflex"});
    }

    private void dimensionValueChange(int rowIndex, Object propValue) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (Objects.isNull(propValue) || StringUtils.isBlank((CharSequence)propValue.toString())) {
            model.setValue("receivedimid", null, rowIndex);
            model.setValue("receivedimvalue", null, rowIndex);
            model.setValue("receivedimensiontext", null, rowIndex);
            model.setValue("receivedimensiontext_tag", null, rowIndex);
            view.updateView("receivedimid", rowIndex);
            view.updateView("receivedimvalue", rowIndex);
            view.updateView("receivedimensiontext", rowIndex);
            view.updateView("receivedimensiontext_tag", rowIndex);
            return;
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)model;
        DynamicObject entryEntity = abstractFormDataModel.getEntryEntity("receiveentryentity", rowIndex);
        long aLong = entryEntity.getLong("receivedimension_id");
        if (aLong == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareReceiveEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject clickDimension = PADimensionHelper.loadDimension((Object)aLong);
        if (Objects.isNull(clickDimension)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareReceiveEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void receivedimensionChangeReset(int rowIndex, DynamicObject newDimension) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        model.setValue("receivedimid", null, rowIndex);
        model.setValue("receivedimvalue", null, rowIndex);
        if (newDimension == null) {
            model.setValue("receivematename", null, rowIndex);
            model.setValue("receivedimtype", null, rowIndex);
        } else {
            String dimensionType = (String)newDimension.get("dimensiontype");
            model.setValue("receivedimtype", (Object)dimensionType, rowIndex);
            view.updateView("receivedimtype", rowIndex);
            DimensionTypeEnum anEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (DimensionTypeEnum.DATABASE == anEnum) {
                Object pkValue;
                DynamicObject dimensionsource = (DynamicObject)newDimension.get("dimensionsource");
                if (!Objects.isNull(dimensionsource) && !Objects.isNull(pkValue = dimensionsource.getPkValue())) {
                    model.setValue("receivematename", pkValue, rowIndex);
                }
            } else if (DimensionTypeEnum.ASSISTANTDATA == anEnum) {
                DynamicObject dimensionsource = (DynamicObject)newDimension.get("assistantsource");
                Object number = dimensionsource.get("number");
                if (!Objects.isNull(number)) {
                    model.setValue("receivematename", (Object)"bos_assistantdata_detail", rowIndex);
                }
            } else {
                model.setValue("receivematename", null, rowIndex);
            }
        }
        model.setValue("receivedimensiontext", null, rowIndex);
        model.setValue("receivedimensiontext_tag", null, rowIndex);
        view.updateView("receivedimid", rowIndex);
        view.updateView("receivedimvalue", rowIndex);
        view.updateView("receivematename", rowIndex);
        view.updateView("receivedimtype", rowIndex);
        view.updateView("receivedimensiontext", rowIndex);
        view.updateView("receivedimensiontext_tag", rowIndex);
    }

    private void changeCondition(int rowIndex, String propValue) {
        this.getModel().setValue("receivedimvalue", null, rowIndex);
        this.getModel().setValue("receivedimid", null, rowIndex);
        this.getModel().setValue("receivedimensiontext", null, rowIndex);
        this.getModel().setValue("receivedimensiontext_tag", null, rowIndex);
    }

    private void openFuListView(String name, Object[] selected, QFilter orgFilter) {
        ListShowParameter para = CoreShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)true);
        para.setHasRight(true);
        para.setLookUp(true);
        para.setUseOrgId(0L);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setShowQuickFilter(true);
        para.setIsolationOrg(true);
        if (!Objects.isNull(selected)) {
            para.setSelectedRows(selected);
        }
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bosAssCallBack"));
        orgFilter.and("group.number", "=", (Object)name);
        para.getListFilterParameter().getQFilters().add(orgFilter);
        this.getView().showForm((FormShowParameter)para);
    }

    private void openListView(String name, Object[] selected, QFilter filter) {
        ListShowParameter para = CoreShowFormHelper.createShowListForm((String)name, (boolean)true);
        para.setHasRight(true);
        para.setLookUp(true);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setShowQuickFilter(true);
        para.setIsolationOrg(true);
        if (!Objects.isNull(selected)) {
            para.setSelectedRows(selected);
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        para.setListFilterParameter(listFilterParameter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bosAssCallBack"));
        this.getView().showForm((FormShowParameter)para);
    }
}

