/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.common.enums.ShareTypeEnum;
import kd.fi.pa.enums.AllocationFlagEnum;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.FilterConditionEnum;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.enums.ShareFactorTypeEnum;
import kd.fi.pa.formplugin.verification.VerificationHelper;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PAFilterHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PAShareRuleFormPlugin
extends AbstractBasePlugIn
implements TabSelectListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(PAShareRuleFormPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.processShowFormData();
        this.showAccountFilter();
        this.showSubFlexInfo();
        this.showSubLimitFlexInfo();
        this.setAddShareFlag();
        this.setComboReceiveEdit((String)this.getModel().getValue("receiverule"));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.processDefaultData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"senddimension", "receivedimension", "mulbasedatafield", "account", "measure", "analysismodel", "sharefactor", "receivebutton", "accfilterclick"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tab = (Tab)this.getControl("receovetabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit analysisModelEdit = (BasedataEdit)this.getControl("analysismodel");
        analysisModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mtSourceEdit = (BasedataEdit)this.getControl("senddimension");
        mtSourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit mtTargetEdit = (BasedataEdit)this.getControl("receivedimension");
        mtTargetEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit shareMeasureEdit = (BasedataEdit)this.getControl("mulbasedatafield");
        shareMeasureEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit conMeasureEdit = (BasedataEdit)this.getControl("measure");
        conMeasureEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit shareFactorEdit = (BasedataEdit)this.getControl("sharefactor");
        shareFactorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit relatedGroupDimEdit = (BasedataEdit)this.getControl("relatedgroupdim");
        relatedGroupDimEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Set ids;
        long modelId;
        DynamicObject analysisModelDy;
        QFilter idFilter;
        String fieldKey = evt.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)fieldKey)) {
            DynamicObject analysisSystemDy = model.getDataEntity().getDynamicObject("analysissystem");
            if (analysisSystemDy == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PAShareRuleFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long id = (Long)analysisSystemDy.getPkValue();
            idFilter = new QFilter("analysis_system", "=", (Object)id);
            evt.addCustomQFilter(idFilter);
        }
        if (StringUtils.equals((CharSequence)"senddimension", (CharSequence)fieldKey)) {
            analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            modelId = model.getDataEntity().getLong("analysismodel_id");
            ids = PAAnalysisModelHelper.queryModelDimensions((Long)modelId).stream().map(dy -> dy.get("dimension.id")).collect(Collectors.toSet());
            QFilter idFilter2 = new QFilter("id", "in", ids);
            evt.addCustomQFilter(idFilter2);
            evt.addCustomQFilter(PAFilterHelper.dimensionTypeNotEqualsDateFilter());
            return;
        }
        if (StringUtils.equals((CharSequence)"receivedimension", (CharSequence)fieldKey)) {
            analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            modelId = model.getDataEntity().getLong("analysismodel_id");
            ids = PAAnalysisModelHelper.queryModelDimensions((Long)modelId).stream().map(dy -> dy.get("dimension.id")).collect(Collectors.toSet());
            QFilter idFilter3 = new QFilter("id", "in", ids);
            evt.addCustomQFilter(idFilter3);
            evt.addCustomQFilter(PAFilterHelper.dimensionTypeNotEqualsDateFilter());
            return;
        }
        if (StringUtils.equals((CharSequence)"mulbasedatafield", (CharSequence)fieldKey)) {
            analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            modelId = model.getDataEntity().getLong("analysismodel_id");
            ids = PAAnalysisModelHelper.queryModelMeasures((Long)modelId).stream().map(dy -> dy.get("measure.id")).collect(Collectors.toSet());
            QFilter idFilter4 = new QFilter("id", "in", ids);
            QFilter meaType = new QFilter("measuretype", "=", (Object)"1");
            QFilter sitTypeFilter = new QFilter("situationtype", "=", (Object)"0");
            evt.addCustomQFilter(idFilter4);
            evt.addCustomQFilter(meaType);
            evt.addCustomQFilter(sitTypeFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)"measure", (CharSequence)fieldKey)) {
            analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            modelId = model.getDataEntity().getLong("analysismodel_id");
            ids = PAAnalysisModelHelper.queryModelMeasures((Long)modelId).stream().map(dy -> dy.get("measure.id")).collect(Collectors.toSet());
            QFilter idFilter5 = new QFilter("id", "in", ids);
            QFilter sitTypeFilter = new QFilter("situationtype", "=", (Object)"0");
            evt.addCustomQFilter(idFilter5);
            evt.addCustomQFilter(sitTypeFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)"sharefactor", (CharSequence)fieldKey)) {
            analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            modelId = model.getDataEntity().getLong("analysismodel_id");
            idFilter = new QFilter("analysis_model", "=", (Object)modelId);
            evt.addCustomQFilter(idFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)"relatedgroupdim", (CharSequence)fieldKey)) {
            analysisModelDy = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModelDy == null) {
                evt.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_20", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            String ruleType = model.getDataEntity().getString("receiverule");
            if (StringUtils.equals((CharSequence)ShareTypeEnum.SHARE_SUBJECT.getType(), (CharSequence)ruleType)) {
                long modelId2 = model.getDataEntity().getLong("analysismodel_id");
                DynamicObjectCollection dimEntryDyCol = PAAnalysisModelHelper.loadAnalysisModel((Object)modelId2).getDynamicObjectCollection("dimension_entry");
                Set dimIds = dimEntryDyCol.stream().filter(dimRow -> !"bd_period".equals(dimRow.get("dimension.dimensionsource.number")) && !"pa_analysisperiod".equals(dimRow.get("dimension.dimensionsource.number")) && !String.valueOf(DimensionTypeEnum.PERIOD.getCode()).equals(dimRow.get("dimension.dimensiontype")) && !String.valueOf(DimensionTypeEnum.DATE.getCode()).equals(dimRow.get("dimension.dimensiontype"))).map(dy -> dy.get("dimension.id")).collect(Collectors.toSet());
                QFilter idFilter6 = new QFilter("id", "in", dimIds);
                evt.addCustomQFilter(idFilter6);
            }
            if (StringUtils.equals((CharSequence)ShareTypeEnum.SHARE_FACTOR.getType(), (CharSequence)ruleType)) {
                DynamicObject factorDy = model.getDataEntity().getDynamicObject("sharefactor");
                if (factorDy == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u644a\u56e0\u5b50\u3002", (String)"PAShareRuleFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long factorId = factorDy.getLong("id");
                DynamicObject shareFactorDy = BusinessDataServiceHelper.loadSingle((Object)factorId, (String)"pa_sharefactor");
                Set dimIds = shareFactorDy.getDynamicObjectCollection("dimension").stream().filter(dimRow -> !String.valueOf(DimensionTypeEnum.PERIOD.getCode()).equals(dimRow.get("fbasedataid.dimensiontype")) && !"pa_analysisperiod".equals(dimRow.get("fbasedataid.dimensionsource.number"))).map(dy -> dy.get("fbasedataid_id")).collect(Collectors.toSet());
                QFilter idFilter7 = new QFilter("id", "in", dimIds);
                evt.addCustomQFilter(idFilter7);
            }
            evt.addCustomQFilter(PAFilterHelper.dimensionTypeNotEqualsDateFilter());
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)"tablimit")) {
            boolean limit = (Boolean)this.getModel().getValue("limitbox");
            if (!limit) {
                model.setValue("limitbox", (Object)Boolean.TRUE);
                model.deleteEntryData("savesublimit");
                view.setVisible(Boolean.TRUE, new String[]{"limitsubflex"});
                this.showSubLimitFlexInfo();
            }
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"toolbarap")) {
            this.changeRate();
            return;
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"receivebutton")) {
            String ruleType = this.getModel().getValue("receiverule").toString();
            if (!ShareTypeEnum.SHARE_FIXED.getType().equalsIgnoreCase(ruleType)) {
                return;
            }
            this.openRuleView(null);
            view.setVisible(Boolean.TRUE, new String[]{"receivesubflex"});
            model.setValue("inputratiobox", (Object)Boolean.TRUE);
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"accfilterclick")) {
            DynamicObject analysisModel = model.getDataEntity().getDynamicObject("analysismodel");
            if (analysisModel == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u578b\u3002", (String)"PAShareRuleFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = VerificationHelper.getEntityNumber((Long)analysisModel.getPkValue());
            if ("pa_".equals(entityNumber)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u672a\u521b\u5efa\u6570\u636e\u8868\uff0c\u8bf7\u5148\u521b\u5efa\u6570\u636e\u8868\u3002", (String)"PAShareRuleFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showConditionForm(entityNumber, analysisModel);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "analysissystem": {
                this.getModel().setValue("analysismodel", null);
                this.getView().updateView("analysismodel");
                this.deleteData();
                break;
            }
            case "analysismodel": {
                this.deleteData();
                break;
            }
            case "receiverule": {
                this.updateData((String)newValue);
                break;
            }
            case "sharefactor": {
                this.changeShareFactor();
                break;
            }
            case "mulbasedatafield": {
                this.changeMeasure();
                break;
            }
            case "accfilterclick": {
                this.changeAccount((String)newValue);
                break;
            }
            case "inputratiobox": {
                this.updateInputRatio();
                break;
            }
            case "limittype": {
                this.updateLimitType();
                break;
            }
            case "receivedimension": 
            case "receivedimvalue": 
            case "comboreceive": {
                this.changeRate();
                break;
            }
            case "addshareflag": {
                this.setAddShareFlag();
                this.changeAddShareFlag();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            this.delFormCache();
            String shareType = this.getModel().getValue("receiverule").toString();
            try {
                if (!this.checkSendEntity()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkRelatedGroupDim()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkReceiveEntity()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkFlagEntry()) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkSubjects(shareType)) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkShareFactor(shareType, args)) {
                    args.setCancel(true);
                    return;
                }
                this.checkAndSaveSubLimitData();
                this.checkAndSaveSubData(shareType, args);
            }
            catch (Exception e) {
                logger.error("[FI-PA] PAShareRuleFormPlugin save error", (Throwable)e);
                args.setCancel(true);
                this.addFormCache(e.getMessage());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String filterJson;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object result = closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        if ("closeCallbackFilter".equalsIgnoreCase(actionId) && StringUtils.isNotEmpty((CharSequence)(filterJson = (String)result))) {
            model.setValue("accfilterclick", (Object)this.getFilterDesc(filterJson));
            model.setValue("accountfilter_tag", result);
        }
    }

    private void processShowFormData() {
        Object objName;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object analysisSystem = parameter.getCustomParam("analysissystem");
        Object analysisModel = parameter.getCustomParam("analysismodel");
        Object showTBMain = parameter.getCustomParam("showTBMain");
        Object source = parameter.getCustomParam("showSource");
        Object name = parameter.getCustomParam("name");
        Object enable = parameter.getCustomParam("showEnable");
        if (ObjectUtils.isEmpty((Object)source) || !StringUtils.equals((CharSequence)source.toString(), (CharSequence)"pa_businessrule")) {
            return;
        }
        if (analysisSystem != null) {
            this.getModel().setValue("analysissystem", analysisSystem);
        }
        if (analysisModel != null) {
            this.getModel().setValue("analysismodel", analysisModel);
        }
        if (name != null && (Objects.isNull(objName = this.getModel().getValue("name")) || !StringUtils.equals((CharSequence)((OrmLocaleValue)objName).getLocaleValue(), (CharSequence)name.toString()))) {
            this.getModel().setValue("name", name);
        }
        if (enable != null && ((Boolean)enable).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap", "advcontoolbarap"});
        }
        if (!((Boolean)showTBMain).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"titleapanel", "fs_baseinfo"});
        }
    }

    private void showAccountFilter() {
        Object filterJson = this.getModel().getValue("accountfilter_tag");
        if (Objects.isNull(filterJson)) {
            return;
        }
        String filter = filterJson.toString();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            this.getModel().setValue("accfilterclick", (Object)this.getFilterDesc(filter));
        }
    }

    private void showConditionForm(String entityNumber, DynamicObject analysisModel) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pa_expression");
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d6\u503c\u6761\u4ef6", (String)"PAShareRuleFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        showParameter.getCustomParams().put("customParamFilterForm", entityNumber);
        showParameter.getCustomParams().put("customParamConditionJson", this.getModel().getValue("accountfilter_tag"));
        showParameter.getCustomParams().put("analysismodel", analysisModel.getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeCallbackFilter"));
        showParameter.getCustomParams().put("PROXY_CLASS", "kd.fi.pa.formplugin.verification.PaAllocationProxy");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String getFilterDesc(String filterJson) {
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
        return new LocaleString(filterCondition.getFilter()).toString();
    }

    private void showSubLimitFlexInfo() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("savesublimit");
        if (Objects.isNull(dynamicObjects) || dynamicObjects.size() <= 0) {
            this.openLimitView(null);
            return;
        }
        ArrayList<Map> params = new ArrayList<Map>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Map subvaluelimit_tag = (Map)SerializationUtils.fromJsonString((String)dynamicObject.get("subvaluelimit_tag").toString(), Map.class);
            params.add(subvaluelimit_tag);
        }
        this.openLimitView(SerializationUtils.toJsonString(params));
    }

    private void showSubFlexInfo() {
        boolean inputRate = (Boolean)this.getModel().getValue("inputratiobox");
        if (!inputRate) {
            return;
        }
        String ruleType = this.getModel().getValue("receiverule").toString();
        ShareTypeEnum shareTypeEnum = ShareTypeEnum.getShareTypeEnum((String)ruleType);
        switch (shareTypeEnum) {
            case SHARE_FACTOR: {
                this.openRuleView(this.getShareFactorParam());
                break;
            }
            case SHARE_FIXED: 
            case SHARE_SUBJECT: {
                DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("savesubflexdata");
                if (Objects.isNull(dynamicObjects) || dynamicObjects.isEmpty()) {
                    return;
                }
                ArrayList<Map> params = new ArrayList<Map>();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Map subvalue_tag = (Map)SerializationUtils.fromJsonString((String)dynamicObject.get("subvalue_tag").toString(), Map.class);
                    params.add(subvalue_tag);
                }
                this.openRuleView(SerializationUtils.toJsonString(params));
                break;
            }
        }
    }

    private void processDefaultData() {
        Object value = this.getModel().getValue("analysissystem");
        if (!Objects.isNull(value)) {
            return;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PAShareRuleFormPlugin.class.getName(), (String)"pa_anasystemsetting", (String)"id", null, (String)"number", (int)1);){
            List analysisSystemIds = StreamSupport.stream(Spliterators.spliteratorUnknownSize(dataSet, 4), false).map(row -> row.getLong("id")).collect(Collectors.toList());
            if (analysisSystemIds.isEmpty()) {
                return;
            }
            this.getModel().setValue("analysissystem", analysisSystemIds.get(0));
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)PAShareRuleFormPlugin.class.getName(), (String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter("analysis_system", "=", analysisSystemIds.get(0)).toArray(), (String)"number", (int)1);){
                List ids = StreamSupport.stream(Spliterators.spliteratorUnknownSize(rows, 4), false).map(row -> row.getLong("id")).collect(Collectors.toList());
                if (!ids.isEmpty()) {
                    this.getModel().setValue("analysismodel", ids.get(0));
                }
            }
        }
    }

    private void changeMeasure() {
        DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("mulbasedatafield");
        if (value.size() == 1) {
            Object measure = this.getModel().getValue("measure");
            if (!Objects.isNull(measure)) {
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)value.get(0);
            this.getModel().setValue("measure", (Object)dynamicObject.getDynamicObject("fbasedataid"));
        }
        this.getView().updateView("measure");
    }

    private void changeAccount(String newValue) {
        if (newValue == null || newValue.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().setValue("accountfilter_tag", null);
            this.getModel().endInit();
            this.getView().updateView("accountfilter_tag");
        }
    }

    private void changeRate() {
        this.getView().getModel().setValue("inputratiobox", (Object)Boolean.FALSE);
        this.getView().updateView("inputratiobox");
        this.getView().getModel().setValue("limitbox", (Object)Boolean.FALSE);
        this.getView().updateView("limitbox");
        this.getView().setVisible(Boolean.FALSE, new String[]{"receivesubflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"limitsubflex"});
        this.closeChildPage("showPage");
        this.closeChildPage("showPageLimit");
    }

    private void changeShareFactor() {
        this.getView().getModel().setValue("inputratiobox", (Object)Boolean.FALSE);
        this.getView().getModel().setValue("relatedgroupdim", null);
        this.getView().updateView("inputratiobox");
        this.closeChildPage("showPage");
        this.closeChildPage("showPageLimit");
    }

    private void changeAddShareFlag() {
        this.getModel().deleteEntryData("flagentryentity");
        this.getView().updateView("flagentryentity");
    }

    private void deleteData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.setValue("mulbasedatafield", null);
        model.setValue("sharefactor", null);
        model.setValue("measure", null);
        model.deleteEntryData("sendentryentity");
        model.deleteEntryData("receiveentryentity");
        model.deleteEntryData("flagentryentity");
        model.setValue("inputratiobox", (Object)Boolean.FALSE);
        view.updateView("inputratiobox");
        model.setValue("limitbox", (Object)Boolean.FALSE);
        view.updateView("limitbox");
        view.setVisible(Boolean.FALSE, new String[]{"receivesubflex"});
        view.setVisible(Boolean.FALSE, new String[]{"limitsubflex"});
        this.closeChildPage("showPage");
        this.closeChildPage("showPageLimit");
    }

    private void updateData(String newShareType) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String shareType = (String)model.getValue("receiverule");
        ShareTypeEnum shareTypeEnum = ShareTypeEnum.getShareTypeEnum((String)shareType);
        if (ShareTypeEnum.SHARE_FACTOR == shareTypeEnum) {
            view.setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        } else {
            model.setValue("sharefactor", null);
            view.setVisible(Boolean.TRUE, new String[]{"toolbarap"});
        }
        model.setValue("relatedgroupdim", null);
        model.deleteEntryData("receiveentryentity");
        model.deleteEntryData("flagentryentity");
        model.setValue("inputratiobox", (Object)Boolean.FALSE);
        view.updateView("inputratiobox");
        model.setValue("limitbox", (Object)Boolean.FALSE);
        view.updateView("limitbox");
        view.setVisible(Boolean.FALSE, new String[]{"receivesubflex"});
        this.closeChildPage("showPage");
        this.closeChildPage("showPageLimit");
        this.setComboReceiveEdit(newShareType);
    }

    private void updateLimitType() {
        this.getModel().deleteEntryData("savesubflexdata");
        this.closeChildPage("showPage");
    }

    private void updateInputRatio() {
        boolean checkboxfield = (Boolean)this.getModel().getValue("inputratiobox");
        if (!checkboxfield) {
            this.closeChildPage("showPage");
            this.getModel().deleteEntryData("savesubflexdata");
            this.getView().setVisible(Boolean.FALSE, new String[]{"receivesubflex"});
        }
    }

    private String getShareFactorParam() {
        Object shareFactor = this.getModel().getValue("sharefactor");
        if (Objects.isNull(shareFactor)) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)shareFactor;
        Object pkValue = dynamicObject.getPkValue();
        String metaName = dynamicObject.getDataEntityType().getName();
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)metaName, (QFilter[])new QFilter("id", "=", pkValue).toArray());
        if (Objects.isNull(dynamicObject1)) {
            return null;
        }
        DynamicObjectCollection dynamicObjectCollection = dynamicObject1.getDynamicObjectCollection("share_factor_entry");
        ArrayList params = new ArrayList(dynamicObjectCollection.size());
        for (DynamicObject dy : dynamicObjectCollection) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            Object idKey = dy.get("value_pks_tag");
            Object value = dy.get("value");
            param.put("shareKeyIds", idKey);
            param.put("sharevalue", value);
            params.add(param);
        }
        return SerializationUtils.toJsonString(params);
    }

    private String getShareFactorType() {
        String ruleType = this.getModel().getValue("receiverule").toString();
        if (!ShareTypeEnum.SHARE_FACTOR.getType().equals(ruleType)) {
            return null;
        }
        Object shareFactor = this.getModel().getValue("sharefactor");
        if (Objects.isNull(shareFactor)) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)shareFactor;
        Object pkValue = dynamicObject.getPkValue();
        String metaName = dynamicObject.getDataEntityType().getName();
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)metaName, (QFilter[])new QFilter("id", "=", pkValue).toArray());
        if (Objects.isNull(dynamicObject1)) {
            return null;
        }
        return dynamicObject1.get("factortype").toString();
    }

    private void setComboReceiveEdit(String newShareType) {
        ComboEdit comboReceiveEdit = (ComboEdit)this.getControl("comboreceive");
        ComboProp comboReceiveProp = (ComboProp)comboReceiveEdit.getProperty();
        List srcItemList = comboReceiveProp.getComboItems();
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(srcItemList.size());
        for (ValueMapItem valueMapItem : srcItemList) {
            boolean hidden = ShareTypeEnum.SHARE_FIXED.getType().equals(newShareType) && (FilterConditionEnum.ALL.getCode().equals(valueMapItem.getValue()) || FilterConditionEnum.IS_NOTNULL.getCode().equals(valueMapItem.getValue())) || ShareTypeEnum.SHARE_FACTOR.getType().equals(newShareType) && FilterConditionEnum.IS_NOTNULL.getCode().equals(valueMapItem.getValue());
            ComboItem item = new ComboItem();
            item.setValue(valueMapItem.getValue());
            item.setCaption(valueMapItem.getName());
            item.setItemVisible(!hidden);
            itemList.add(item);
        }
        comboReceiveEdit.setComboItems(itemList);
    }

    private void setAddShareFlag() {
        boolean addShareFlag = (Boolean)this.getModel().getValue("addshareflag");
        this.getView().setVisible(Boolean.valueOf(addShareFlag), new String[]{"tabflag"});
    }

    private void closeChildPage(String pageId) {
        IFormView view;
        IFormView childView;
        String childPageId = this.getPageCache().get(pageId);
        if (StringUtils.isNotBlank((CharSequence)childPageId) && !Objects.isNull(childView = (view = this.getView()).getView(childPageId))) {
            childView.close();
            view.sendFormAction(childView);
            this.getPageCache().remove(pageId);
        }
    }

    private void openLimitView(String valueStr) {
        FormShowParameter paramEdit = new FormShowParameter();
        paramEdit.setFormId("pa_sharerulelimitcomb");
        paramEdit.getOpenStyle().setTargetKey("limitsubflex");
        paramEdit.getOpenStyle().setShowType(ShowType.InContainer);
        List<Map<String, Object>> params = this.setParameter();
        paramEdit.setCustomParam("params", (Object)SerializationUtils.toJsonString(params));
        paramEdit.setCustomParam("detailParams", (Object)valueStr);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object enable = parameter.getCustomParam("showEnable");
        if (enable != null && ((Boolean)enable).booleanValue()) {
            paramEdit.setCustomParam("showEnable", enable);
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("showPageLimit", paramEdit.getPageId());
        this.getView().showForm(paramEdit);
    }

    private void openRuleView(String valueStr) {
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setFormId("pa_sharerulereceiveshow");
        parameEdit.getOpenStyle().setTargetKey("receivesubflex");
        parameEdit.getOpenStyle().setShowType(ShowType.InContainer);
        List<Map<String, Object>> params = this.getAllParams();
        parameEdit.setCustomParam("params", (Object)SerializationUtils.toJsonString(params));
        parameEdit.setCustomParam("shareType", this.getModel().getValue("receiverule"));
        parameEdit.setCustomParam("detailParams", (Object)valueStr);
        parameEdit.setCustomParam("factortype", (Object)this.getShareFactorType());
        this.setLimitParams(parameEdit);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("showPage", parameEdit.getPageId());
        this.getView().showForm(parameEdit);
    }

    private void setLimitParams(FormShowParameter paramEdit) {
        boolean limit = (Boolean)this.getModel().getValue("limitbox");
        if (!limit) {
            return;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity("savesublimit");
        if (!entity.isEmpty() && StringUtils.isNotBlank((CharSequence)((DynamicObject)entity.get(0)).get("subdataidlimit").toString())) {
            ArrayList<String> idsStr = new ArrayList<String>();
            for (DynamicObject dy : entity) {
                Object subdataidlimit = dy.get("subdataidlimit");
                idsStr.add(subdataidlimit.toString());
            }
            if (idsStr.isEmpty()) {
                return;
            }
            paramEdit.setCustomParam("limitParams", (Object)SerializationUtils.toJsonString(idsStr));
            paramEdit.setCustomParam("limittype", this.getModel().getValue("limittype"));
            return;
        }
        List<String> receiveField = this.getReceiveField();
        if (receiveField.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String showPage = pageCache.get("showPageLimit");
        IFormView view = this.getView().getView(showPage);
        if (Objects.isNull(view)) {
            return;
        }
        IDataModel model = view.getModel();
        boolean dataLoaded = model.isDataLoaded();
        if (!dataLoaded) {
            return;
        }
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentitylimit");
        if (Objects.isNull(dynamicObjects) || dynamicObjects.isEmpty()) {
            return;
        }
        ArrayList<String> keyValue = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < receiveField.size(); ++i) {
                Object obj = dynamicObject.get(receiveField.get(i));
                if (Objects.isNull(obj) || StringUtils.isBlank((CharSequence)obj.toString())) continue;
                if (obj instanceof DynamicObject) {
                    DynamicObject dynamic = (DynamicObject)obj;
                    Object id = dynamic.get("id");
                    stringBuilder.append(',').append(id);
                    continue;
                }
                stringBuilder.append(',').append(obj);
            }
            if (!StringUtils.isNotBlank((CharSequence)stringBuilder)) continue;
            keyValue.add(stringBuilder.substring(1));
        }
        if (keyValue.isEmpty()) {
            return;
        }
        paramEdit.setCustomParam("limitParams", (Object)SerializationUtils.toJsonString(keyValue));
        paramEdit.setCustomParam("limittype", this.getModel().getValue("limittype"));
    }

    private List<String> getReceiveField() {
        ArrayList<String> params = new ArrayList<String>(16);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("receiveentryentity");
        if (Objects.isNull(entryEntity) || entryEntity.isEmpty()) {
            return params;
        }
        int i = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            Object receivedimension = dynamicObject.get("receivedimension");
            Object dimValue = dynamicObject.get("receivedimvalue");
            if (Objects.isNull(receivedimension) || Objects.isNull(dimValue) || StringUtils.isBlank((CharSequence)dimValue.toString())) continue;
            DynamicObject base = (DynamicObject)receivedimension;
            Object dimensionsource_number = base.get("number");
            params.add(dimensionsource_number.toString() + "_" + i);
            ++i;
        }
        return params;
    }

    private List<Map<String, Object>> setParameter() {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("receiveentryentity");
        if (Objects.isNull(entryEntity) || entryEntity.isEmpty()) {
            return params;
        }
        for (DynamicObject dynamicObject : entryEntity) {
            List<String> receiveDimensionValue;
            HashMap<String, Object> param = new HashMap<String, Object>();
            Object receivedimension = dynamicObject.get("receivedimension_id");
            DimensionTypeEnum receiveDimType = DimensionTypeEnum.getEnum((String)dynamicObject.getString("receivedimtype"));
            Object receiveMateName = dynamicObject.get("receivematename");
            String receiveCondition = dynamicObject.getString("comboreceive");
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)receiveCondition);
            String receivedimvalue = "";
            String receivedimid = "";
            String text = dynamicObject.getString("receivedimensiontext_tag");
            if (StringUtils.isNotBlank((CharSequence)text)) {
                if (DimensionTypeEnum.OTHER == receiveDimType) {
                    receivedimvalue = text;
                    receiveDimensionValue = Arrays.asList(text.split("\n"));
                } else {
                    HashMap map = (HashMap)JSON.parseObject((String)text, (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
                    receivedimvalue = String.join((CharSequence)",", map.values());
                    receivedimid = String.join((CharSequence)",", map.keySet());
                    receiveDimensionValue = new ArrayList(map.keySet());
                }
            } else {
                receivedimvalue = dynamicObject.getString("receivedimvalue");
                receivedimid = dynamicObject.getString("receivedimid");
                List<String> list = receiveDimensionValue = DimensionTypeEnum.OTHER == receiveDimType ? Arrays.asList(receivedimvalue.split(",")) : Arrays.asList(receivedimid.split(","));
            }
            if (StringUtils.isBlank((Object)receivedimension) || conditionEnum == FilterConditionEnum.IN && StringUtils.isBlank((CharSequence)receivedimvalue)) continue;
            DynamicObject base = PADimensionHelper.loadDimension((Object)receivedimension);
            Object dimensionSourceName = base.get("name");
            Object dimensionSourceNumber = base.get("number");
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)dimensionSourceName;
            param.put("columnKey", receiveMateName);
            param.put("columnName", ormLocaleValue.getLocaleValue());
            param.put("columnNumber", dimensionSourceNumber.toString().toLowerCase());
            param.put("receivedimvalue", receivedimvalue);
            param.put("receivedimid", receivedimid);
            param.put("receivedimtype", dynamicObject.getString("receivedimtype"));
            param.put("receivematename", receiveMateName);
            param.put("receiveDimensionValue", SerializationUtils.toJsonString(receiveDimensionValue));
            param.put("receivedimensiontext_tag", text);
            param.put("comboreceive", receiveCondition);
            params.add(param);
        }
        return params;
    }

    private List<Map<String, Object>> setPublic() {
        String ruleType = this.getModel().getValue("receiverule").toString();
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>();
        if (ShareTypeEnum.SHARE_FACTOR.getType().equalsIgnoreCase(ruleType)) {
            this.shareFactorPub(paramsList);
        } else if (ShareTypeEnum.SHARE_FIXED.getType().equalsIgnoreCase(ruleType)) {
            HashMap<String, String> paramPublic2 = new HashMap<String, String>();
            paramPublic2.put("columnName", ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b(%)", (String)"PAShareRuleFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            paramPublic2.put("columnNumber", "sharerate");
            paramPublic2.put("receivedimtype", "decimal");
            paramPublic2.put("receivematename", "decimal");
            paramsList.add(paramPublic2);
        } else {
            return paramsList;
        }
        return paramsList;
    }

    private List<Map<String, Object>> shareFactorPubPeriod() {
        String ruleType = this.getModel().getValue("receiverule").toString();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (!ShareTypeEnum.SHARE_FACTOR.getType().equalsIgnoreCase(ruleType)) {
            return list;
        }
        Object value = this.getModel().getValue("sharefactor");
        if (Objects.isNull(value)) {
            return list;
        }
        DynamicObject dynamicObject0 = (DynamicObject)value;
        Object pkValue = dynamicObject0.getPkValue();
        String metaName = dynamicObject0.getDataEntityType().getName();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)metaName, (QFilter[])new QFilter("id", "=", pkValue).toArray());
        Object factorType = dynamicObject.get("factortype");
        if (!Objects.isNull(factorType) && factorType.equals(ShareFactorTypeEnum.PERIOD.getCode())) {
            HashMap<String, String> paramPublic1 = new HashMap<String, String>();
            paramPublic1.put("columnName", ResManager.loadKDString((String)"\u671f\u95f4", (String)"PAShareRuleFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            paramPublic1.put("columnNumber", "period");
            paramPublic1.put("receivedimid", this.getNowPeriodIds());
            paramPublic1.put("receivedimvalue", this.getNowPeriodNumber());
            paramPublic1.put("receivedimtype", DimensionTypeEnum.DATABASE.getTypeString());
            paramPublic1.put("receivematename", "bd_period");
            paramPublic1.put("columnKey", "bd_period");
            list.add(paramPublic1);
            return list;
        }
        return list;
    }

    private String getNowPeriodNumber() {
        String numberStr = "period";
        QFilter qFilter = this.getQFilter2Select();
        DynamicObject dynamicObjectPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{qFilter});
        if (Objects.isNull(dynamicObjectPeriod)) {
            return numberStr;
        }
        return dynamicObjectPeriod.getString("number");
    }

    private String getNowPeriodIds() {
        String pkStr = "0";
        QFilter qFilter = this.getQFilter2Select();
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (QFilter[])new QFilter[]{qFilter});
        if (objectDynamicObjectMap.isEmpty()) {
            return pkStr;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set objects = objectDynamicObjectMap.keySet();
        for (Object pk : objects) {
            stringBuilder.append(',').append(pk);
        }
        if (StringUtils.isNotBlank((CharSequence)stringBuilder.toString())) {
            pkStr = stringBuilder.substring(1);
        }
        return pkStr;
    }

    private QFilter getQFilter2Select() {
        LocalDate date = LocalDate.now();
        QFilter qFilter = new QFilter("begindate", "<=", (Object)date);
        qFilter.and("enddate", ">", (Object)date);
        Object dysObj = this.getModel().getDataEntity().get("analysismodel_id");
        DynamicObject dys = PAAnalysisModelHelper.loadAnalysisModel((Object)dysObj);
        Object dimensionId = dys.getDynamicObjectCollection("dimension_entry").stream().filter(p -> DimensionNecessityEnum.PERIOD.getCode().equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject("dimension").getPkValue()).findFirst().orElse(null);
        DynamicObject dynamicObject = PADimensionHelper.loadDimension(dimensionId);
        if (Objects.isNull(dynamicObject)) {
            return qFilter;
        }
        QFilter typeQFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)dynamicObject);
        if (!Objects.isNull(typeQFilter)) {
            qFilter.and(typeQFilter);
        }
        return qFilter;
    }

    private void shareFactorPub(List<Map<String, Object>> paramsList) {
        Object value = this.getModel().getValue("sharefactor");
        if (Objects.isNull(value)) {
            return;
        }
        HashMap<String, String> paramPublic = new HashMap<String, String>();
        paramPublic.put("columnName", ResManager.loadKDString((String)"\u503c", (String)"PAShareRuleFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        paramPublic.put("columnNumber", "sharevalue");
        paramPublic.put("receivedimtype", "decimal");
        paramPublic.put("receivematename", "decimal");
        paramsList.add(paramPublic);
        HashMap<String, String> paramPublic2 = new HashMap<String, String>();
        paramPublic2.put("columnName", ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b(%)", (String)"PAShareRuleFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        paramPublic2.put("columnNumber", "sharerate");
        paramPublic2.put("receivedimtype", "decimal");
        paramPublic2.put("receivematename", "decimal");
        paramsList.add(paramPublic2);
    }

    private boolean checkSendEntity() {
        IDataModel model = this.getModel();
        boolean flag = ObjectUtils.isEmpty((Object)model.getValue("senddimension")) && ObjectUtils.isEmpty((Object)model.getValue("combofield")) && StringUtils.isBlank((Object)model.getValue("dimensionvalue"));
        PARuleHelper.processCache((AbstractFormPlugin)this, (boolean)flag);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sendentryentity");
        for (DynamicObject dy : entryEntity) {
            Object dim = dy.get("senddimension");
            String condition = dy.getString("combofield");
            String dimValue = dy.getString("dimensionvalue");
            if (Objects.isNull(dim)) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53d1\u9001\u65b9\u7ef4\u5ea6\u3002", (String)"PAShareRuleFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (Objects.isNull(condition) || StringUtils.isBlank((CharSequence)condition)) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53d1\u9001\u65b9\u6761\u4ef6\u3002", (String)"PAShareRuleFormPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!Arrays.asList(ShareTypeEnum.SHARE_FACTOR.getType(), ShareTypeEnum.SHARE_SUBJECT.getType()).contains(condition) || !Objects.isNull(dimValue) && !StringUtils.isBlank((CharSequence)dimValue)) continue;
            this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53d1\u9001\u65b9\u7ef4\u5ea6\u503c\u3002", (String)"PAShareRuleFormPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkRelatedGroupDim() {
        DynamicObjectCollection relatedGroupDims = (DynamicObjectCollection)this.getModel().getValue("relatedgroupdim");
        if (relatedGroupDims != null && relatedGroupDims.size() > 5) {
            this.addFormCache(ResManager.loadKDString((String)"\u5173\u8054\u5206\u7ec4\u7ef4\u5ea6\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc75\u4e2a\u3002", (String)"PAShareRuleFormPlugin_19", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkReceiveEntity() {
        long modelId = this.getModel().getDataEntity().getLong("analysismodel_id");
        DynamicObject analysisModelDy = PAAnalysisModelHelper.loadAnalysisModelFromCache((Object)modelId);
        String orgDimNum = PAAnalysisModelHelper.getOrgDimNum((DynamicObject)analysisModelDy);
        if (StringUtils.isEmpty((CharSequence)orgDimNum)) {
            throw new KDBizException("orgDim is null");
        }
        this.getModel().setValue("multiorgshare", (Object)MultiOrgShareEnum.NO.getCode());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("receiveentryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            Object dimValue = dynamicObject.get("receivedimvalue");
            Object dim = dynamicObject.get("receivedimension");
            String receiveCondition = dynamicObject.getString("comboreceive");
            FilterConditionEnum conditionEnum = FilterConditionEnum.getFilterConditionEnum((String)receiveCondition);
            if (FilterConditionEnum.IN == conditionEnum && !Objects.isNull(dim) && StringUtils.isNotBlank((CharSequence)dim.toString()) && (Objects.isNull(dimValue) || StringUtils.isBlank((CharSequence)dimValue.toString()))) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u63a5\u6536\u65b9\u7ef4\u5ea6\u503c\u3002", (String)"PAShareRuleFormPlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (dim == null || !orgDimNum.equals(((DynamicObject)dim).getString("number"))) continue;
            this.getModel().setValue("multiorgshare", (Object)MultiOrgShareEnum.YES.getCode());
        }
        return true;
    }

    private boolean checkShareFactor(String shareType, BeforeDoOperationEventArgs args) {
        Object value;
        if (ShareTypeEnum.SHARE_FACTOR.getType().equals(shareType) && Objects.isNull(value = this.getModel().getValue("sharefactor"))) {
            this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u644a\u56e0\u5b50\u3002", (String)"PAShareRuleFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkSubjects(String shareType) {
        if (shareType.equals(ShareTypeEnum.SHARE_SUBJECT.getType())) {
            Object measure = this.getModel().getValue("measure");
            if (Objects.isNull(measure) || StringUtils.isBlank((CharSequence)measure.toString())) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u53c2\u8003\u5ea6\u91cf\u503c\u3002", (String)"PAShareRuleFormPlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            Object filterAccount = this.getModel().getValue("accfilterclick");
            if (Objects.isNull(filterAccount) || StringUtils.isBlank((CharSequence)filterAccount.toString())) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u79d1\u76ee\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"PAShareRuleFormPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            Object limitType = this.getModel().getValue("limittype");
            if (Objects.isNull(limitType) || StringUtils.isBlank((CharSequence)limitType.toString())) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9650\u5b9a\u65b9\u5f0f\u3002", (String)"PAShareRuleFormPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean checkFlagEntry() {
        boolean addShareFlag = (Boolean)this.getModel().getValue("addshareflag");
        if (addShareFlag) {
            DynamicObjectCollection flagEntryDyCol = this.getModel().getEntryEntity("flagentryentity");
            if (flagEntryDyCol == null || flagEntryDyCol.isEmpty()) {
                this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8f93\u5165\u4e00\u884c\u201c\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u201d\u5206\u5f55\u3002", (String)"PAShareRuleFormPlugin_21", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (flagEntryDyCol.size() > 5) {
                this.addFormCache(ResManager.loadKDString((String)"\u201c\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u201d\u5206\u5f55\u5e94\u5c0f\u4e8e\u7b49\u4e8e5\u884c\u3002", (String)"PAShareRuleFormPlugin_22", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (int i = 0; i < flagEntryDyCol.size(); ++i) {
                DynamicObject sourceDy;
                String value;
                DynamicObject flagEntryDy = (DynamicObject)flagEntryDyCol.get(i);
                int rowIndex = i + 1;
                DynamicObject targetDy = flagEntryDy.getDynamicObject("f_targetdim");
                if (targetDy == null) {
                    this.addFormCache(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u5206\u5f55\u4e2d\u7b2c%s\u884c\u7684\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7ef4\u5ea6\u3002", (String)"PAShareRuleFormPlugin_27", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                    return false;
                }
                String flagType = flagEntryDy.getString("f_flagtype");
                if (StringUtils.equals((CharSequence)AllocationFlagEnum.VALUE.getCode(), (CharSequence)flagType) && StringUtils.isEmpty((CharSequence)(value = flagEntryDy.getString("f_value")))) {
                    this.addFormCache(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u5206\u5f55\u4e2d\u7b2c%s\u884c\u7684\u5e38\u91cf\u3002", (String)"PAShareRuleFormPlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                    return false;
                }
                if (!StringUtils.equals((CharSequence)AllocationFlagEnum.SENDER.getCode(), (CharSequence)flagType) || (sourceDy = flagEntryDy.getDynamicObject("f_sourcedim")) != null) continue;
                this.addFormCache(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u644a\u6807\u8bc6\u8bbe\u7f6e\u5206\u5f55\u4e2d\u7b2c%s\u884c\u7684\u53d1\u9001\u65b9\u7ef4\u5ea6\u3002", (String)"PAShareRuleFormPlugin_26", (String)"fi-pa-formplugin", (Object[])new Object[0]), rowIndex));
                return false;
            }
            Set flagDimIdSet = flagEntryDyCol.stream().map(dy -> dy.getLong("f_targetdim_id")).collect(Collectors.toSet());
            if (flagDimIdSet.size() != flagEntryDyCol.size()) {
                this.addFormCache(ResManager.loadKDString((String)"\u201c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7684\u7ef4\u5ea6\u201d\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PAShareRuleFormPlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection receiveEntryDyCol = this.getModel().getEntryEntity("receiveentryentity");
            Set receiveDimIdSet = receiveEntryDyCol.stream().map(dy -> dy.getLong("receivedimension_id")).collect(Collectors.toSet());
            for (Long receiveDimId : receiveDimIdSet) {
                if (!flagDimIdSet.contains(receiveDimId)) continue;
                this.addFormCache(ResManager.loadKDString((String)"\u201c\u8bb0\u5f55\u5206\u644a\u6807\u8bc6\u7684\u7ef4\u5ea6\u201d\u6240\u9009\u7684\u7ef4\u5ea6\u4e0e\u63a5\u6536\u65b9\u6761\u4ef6\u4e2d\u7684\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PAShareRuleFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void checkAndSaveSubData(String shareType, BeforeDoOperationEventArgs args) {
        if (!ShareTypeEnum.SHARE_FIXED.getType().equals(shareType)) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String showPage = pageCache.get("showPage");
        IFormView view = this.getView().getView(showPage);
        if (Objects.isNull(view)) {
            this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5206\u644a\u6bd4\u4f8b\u3002", (String)"PAShareRuleFormPlugin_17", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        IDataModel model = view.getModel();
        boolean dataLoaded = model.isDataLoaded();
        if (!dataLoaded) {
            return;
        }
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        if (Objects.isNull(dynamicObjects) || dynamicObjects.isEmpty()) {
            this.addFormCache(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5206\u644a\u6bd4\u4f8b\u3002", (String)"PAShareRuleFormPlugin_17", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List<Map<String, Object>> paramsAll = this.getAllParams();
        args.setCancel(this.checkSubRate(shareType, dynamicObjects, paramsAll));
        List<String> jsonList = this.getSubValue(dynamicObjects, paramsAll);
        if (jsonList.isEmpty()) {
            return;
        }
        this.saveSubDataToEntry(jsonList, jsonList.size());
        this.getView().setVisible(Boolean.TRUE, new String[]{"receivesubflex"});
        this.getModel().setValue("inputratiobox", (Object)Boolean.TRUE);
    }

    private List<Map<String, Object>> getAllParams() {
        ArrayList<Map<String, Object>> paramsAll = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> maps = this.shareFactorPubPeriod();
        if (!CollectionUtils.isEmpty(maps)) {
            paramsAll.addAll(maps);
        }
        List<Map<String, Object>> paramsList = this.setParameter();
        paramsAll.addAll(paramsList);
        paramsAll.addAll(this.setPublic());
        return paramsAll;
    }

    private boolean checkSubRate(String shareType, DynamicObjectCollection dynamicObjects, List<Map<String, Object>> paramsAll) {
        if (!ShareTypeEnum.SHARE_FIXED.getType().equals(shareType)) {
            return false;
        }
        BigDecimal total = new BigDecimal(0);
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            int j = 0;
            for (Map<String, Object> map : paramsAll) {
                Object columnNumber = map.get("columnNumber");
                String column = columnNumber.toString() + "_" + j;
                if (column.contains("sharerate")) {
                    Object rate = dynamicObject.get(column);
                    total = total.add((BigDecimal)rate);
                }
                ++j;
            }
        }
        if (total.compareTo(new BigDecimal("100")) == 0) {
            return false;
        }
        this.addFormCache(ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u603b\u548c\u53ea\u80fd\u4e3a100%\u3002", (String)"PAShareRuleFormPlugin_18", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        return true;
    }

    private void saveSubDataToEntry(List<String> jsonList, int count) {
        IDataModel model = this.getModel();
        model.deleteEntryData("savesubflexdata");
        model.beginInit();
        model.batchCreateNewEntryRow("savesubflexdata", count);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("savesubflexdata");
        DynamicProperty subdataid = dynamicObjects.getDynamicObjectType().getProperty("subdataid");
        DynamicProperty subvalue = dynamicObjects.getDynamicObjectType().getProperty("subvalue_tag");
        DynamicProperty subvalue2 = dynamicObjects.getDynamicObjectType().getProperty("subvalue");
        for (int i = 0; i < count; ++i) {
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            subdataid.setValueFast((Object)entry, (Object)i);
            subvalue.setValueFast((Object)entry, (Object)jsonList.get(i));
            subvalue2.setValueFast((Object)entry, (Object)jsonList.get(i).substring(0, 10));
        }
        model.endInit();
    }

    private void checkAndSaveSubLimitData() {
        this.getModel().setValue("limitbox", (Object)Boolean.TRUE);
        IPageCache pageCache = this.getView().getPageCache();
        String showPage = pageCache.get("showPageLimit");
        IFormView view = this.getView().getView(showPage);
        if (Objects.isNull(view)) {
            return;
        }
        IDataModel model = view.getModel();
        boolean dataLoaded = model.isDataLoaded();
        if (!dataLoaded) {
            return;
        }
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentitylimit");
        if (Objects.isNull(dynamicObjects) || dynamicObjects.isEmpty()) {
            return;
        }
        List<Map<String, Object>> params = this.setParameter();
        List<String> jsonList = this.getSubValue(dynamicObjects, params);
        List<String> keyList = this.getSubValueStr(dynamicObjects, params);
        if (jsonList.isEmpty()) {
            return;
        }
        this.saveSubLimitDataToEntry(keyList, jsonList);
    }

    private void saveSubLimitDataToEntry(List<String> keyList, List<String> jsonList) {
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("savesublimit", jsonList.size());
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("savesublimit");
        DynamicProperty subdataid = dynamicObjects.getDynamicObjectType().getProperty("subdataidlimit");
        DynamicProperty subvalue = dynamicObjects.getDynamicObjectType().getProperty("subvaluelimit_tag");
        DynamicProperty subvalue2 = dynamicObjects.getDynamicObjectType().getProperty("subvaluelimit");
        for (int i = 0; i < jsonList.size(); ++i) {
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            subdataid.setValueFast((Object)entry, (Object)keyList.get(i));
            subvalue.setValueFast((Object)entry, (Object)jsonList.get(i));
            subvalue2.setValueFast((Object)entry, (Object)jsonList.get(i).substring(0, 10));
        }
        model.endInit();
    }

    private List<String> getSubValue(DynamicObjectCollection dynamicObjects, List<Map<String, Object>> paramsAll) {
        ArrayList<String> jsonList = new ArrayList<String>();
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            int j = 0;
            for (Map<String, Object> map : paramsAll) {
                Object columnNumber = map.get("columnNumber");
                Object mateType = map.get("receivedimtype");
                String column = columnNumber.toString() + "_" + j;
                if (Objects.isNull(mateType) || "3".equalsIgnoreCase(mateType.toString()) || "decimal".equalsIgnoreCase(mateType.toString()) || "6".equalsIgnoreCase(mateType.toString())) {
                    String string = dynamicObject.getString(column);
                    if (StringUtils.isBlank((CharSequence)string)) {
                        jsonMap = new LinkedHashMap();
                        break;
                    }
                    jsonMap.put(column, string);
                } else {
                    Object value = dynamicObject.get(column);
                    if (Objects.isNull(value)) {
                        jsonMap = new LinkedHashMap();
                        break;
                    }
                    Object id = ((DynamicObject)dynamicObject.get(column)).get("id");
                    jsonMap.put(column, id);
                }
                ++j;
            }
            if (jsonMap.isEmpty()) continue;
            jsonList.add(JSON.toJSONString(jsonMap));
        }
        return jsonList;
    }

    private List<String> getSubValueStr(DynamicObjectCollection dynamicObjects, List<Map<String, Object>> paramsAll) {
        ArrayList<String> jsonList = new ArrayList<String>();
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            int j = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (Map<String, Object> map : paramsAll) {
                Object mateType = map.get("receivedimtype");
                Object columnNumber = map.get("columnNumber");
                String column = columnNumber.toString() + "_" + j;
                if (Objects.isNull(mateType) || "3".equalsIgnoreCase(mateType.toString()) || "6".equalsIgnoreCase(mateType.toString()) || "decimal".equalsIgnoreCase(mateType.toString())) {
                    String string = dynamicObject.getString(column);
                    if (StringUtils.isBlank((CharSequence)string)) {
                        stringBuilder.setLength(0);
                        break;
                    }
                    stringBuilder.append(',').append(string);
                } else {
                    if (Objects.isNull(dynamicObject.get(column))) {
                        stringBuilder.setLength(0);
                        break;
                    }
                    Object id = ((DynamicObject)dynamicObject.get(column)).get("id");
                    stringBuilder.append(',').append(id);
                }
                ++j;
            }
            if (!StringUtils.isNotBlank((CharSequence)stringBuilder)) continue;
            jsonList.add(stringBuilder.substring(1));
        }
        return jsonList;
    }

    private void addFormCache(String errorMess) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.remove("shareRuleErrorKey");
        pageCache.put("shareRuleErrorKey", errorMess);
    }

    private void delFormCache() {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.remove("shareRuleErrorKey");
    }
}

