/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PAShareSendEntryPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"dimensionvalue"});
        BasedataEdit measureBaseDataEdit = (BasedataEdit)this.getView().getControl("senddimension");
        measureBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("senddimension".equals(name)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sendentryentity");
            if (Objects.isNull(entryEntity) || entryEntity.isEmpty()) {
                return;
            }
            ArrayList<Object> dims = new ArrayList<Object>();
            for (DynamicObject dynamicObject : entryEntity) {
                Object dim = dynamicObject.get("senddimension");
                if (Objects.isNull(dim) || StringUtils.isBlank((CharSequence)dim.toString())) continue;
                DynamicObject dimObj = (DynamicObject)dim;
                dims.add(dimObj.get("id"));
            }
            QFilter idFilter = new QFilter("id", "not in", dims);
            evt.addCustomQFilter(idFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"dimensionvalue")) {
            int index = model.getEntryCurrentRowIndex("sendentryentity");
            DynamicObject entryEntity = model.getEntryEntity("sendentryentity", index);
            long dimId = entryEntity.getLong("senddimension_id");
            if (dimId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareSendEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject clickDimension = PADimensionHelper.loadDimension((Object)dimId);
            if (Objects.isNull(clickDimension)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareSendEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            String dimensionType = clickDimension.getString("dimensiontype");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
            if (dimensionTypeEnum == null) {
                return;
            }
            switch (dimensionTypeEnum) {
                case DATABASE: {
                    Object pkValue;
                    DynamicObject dimensionsource = clickDimension.getDynamicObject("dimensionsource");
                    if (Objects.isNull(dimensionsource) || Objects.isNull(pkValue = dimensionsource.getPkValue())) break;
                    Object[] selected = null;
                    Object ids = entryEntity.get("dimensionid");
                    HashMap map = (HashMap)JSON.parseObject((String)entryEntity.get("dimensiontext_tag").toString(), HashMap.class);
                    if (map == null && !Objects.isNull(ids) && StringUtils.isNotBlank((CharSequence)ids.toString())) {
                        selected = ids.toString().split(",");
                    } else if (map != null) {
                        selected = map.keySet().toArray();
                    }
                    String pkStr = pkValue.toString();
                    QFilter filter = this.setFilter(pkStr);
                    QFilter dimensionTypeQFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)clickDimension);
                    if (!Objects.isNull(dimensionTypeQFilter)) {
                        filter = Objects.isNull(filter) ? dimensionTypeQFilter : filter.and(dimensionTypeQFilter);
                    }
                    this.openListView(pkStr, selected, filter);
                    break;
                }
                case ASSISTANTDATA: {
                    DynamicObject dimensionsource = clickDimension.getDynamicObject("assistantsource");
                    Object number = dimensionsource.get("number");
                    if (Objects.isNull(number)) break;
                    Object[] selected = null;
                    Object ids = entryEntity.get("dimensionid");
                    HashMap map = (HashMap)JSON.parseObject((String)entryEntity.get("dimensiontext_tag").toString(), HashMap.class);
                    if (map == null && !Objects.isNull(ids) && StringUtils.isNotBlank((CharSequence)ids.toString())) {
                        selected = ids.toString().split(",");
                    } else if (map != null) {
                        selected = map.keySet().toArray();
                    }
                    QFilter filter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
                    this.openFuListView(number.toString(), selected, filter);
                    break;
                }
                case OTHER: {
                    String dimensionValueTag = entryEntity.getString("dimensiontext_tag");
                    String dimensionName = entryEntity.getString("senddimension.name");
                    String dimensionValue = entryEntity.getString("dimensionvalue");
                    if (StringUtils.isNotBlank((CharSequence)dimensionValue)) {
                        if (StringUtils.isBlank((CharSequence)dimensionValueTag)) {
                            dimensionValueTag = dimensionValue.replace(",", "\n");
                        }
                    } else {
                        dimensionValueTag = "";
                    }
                    PARuleHelper.openView((AbstractFormPlugin)this, (String)dimensionName, (String)dimensionValueTag);
                    break;
                }
                case DENUMS: {
                    String text = entryEntity.getString("dimensiontext_tag");
                    if (StringUtils.isNotBlank((CharSequence)text)) {
                        Map map = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        text = String.join((CharSequence)",", map.keySet());
                    }
                    PARuleHelper.openDimensionInfoView((AbstractFormPlugin)this, (String)text, (long)clickDimension.getLong("id"), (String)clickDimension.getString("name"), (String)"senderdimensioninfo", (boolean)true);
                    break;
                }
            }
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "dimensionvalue": {
                this.dimensionValueChange(rowIndex, propValue);
                break;
            }
            case "senddimension": {
                this.senddimensionChangeReset(rowIndex);
                break;
            }
            case "combofield": {
                this.changeCondition(rowIndex, propValue.toString());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object result = evt.getReturnData();
        switch (actionId) {
            case "bosAssCallBack": {
                this.callBackFormula(evt, false);
                break;
            }
            case "otherCallBack": {
                this.callBackFormula(evt, true);
                break;
            }
            case "senderdimensioninfo": {
                PARuleHelper.processDimensionInfoCloseBack((AbstractFormPlugin)this, (Object)result, (String)"sendentryentity", (String)"dimensionid", (String)"dimensionvalue", (String)"dimensiontext");
                break;
            }
        }
    }

    private QFilter setFilter(String pkValue) {
        QFilter qFilter = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)pkValue);
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"enable")) {
            qFilter = new QFilter("enable", "=", (Object)"1");
        }
        if (properties.containsKey((Object)"status")) {
            QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
            qFilter = qFilter == null ? qFilterStatus : qFilter.and(qFilterStatus);
        }
        return qFilter;
    }

    private void callBackFormula(ClosedCallBackEvent e, boolean isStr) {
        String content;
        String dimensionValue;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("sendentryentity");
        if (isStr) {
            dimensionValue = returnData.toString().replace("\n", ",");
            content = returnData.toString();
        } else {
            ListSelectedRowCollection data = (ListSelectedRowCollection)returnData;
            ArrayList<String> names = new ArrayList<String>(data.size());
            HashMap<Object, String> map = new HashMap<Object, String>(data.size());
            for (ListSelectedRow datum : data) {
                map.put(datum.getPrimaryKeyValue(), datum.getName());
                names.add(datum.getName());
            }
            dimensionValue = String.join((CharSequence)",", names);
            content = SerializationUtils.toJsonString(map);
        }
        this.getModel().setValue("dimensionvalue", (Object)(dimensionValue.length() > 1024 ? dimensionValue.substring(0, 1024) : dimensionValue), row);
        this.getModel().setValue("dimensiontext", (Object)(content.length() > 255 ? content.substring(0, 255) : content), row);
        this.getModel().setValue("dimensiontext_tag", (Object)content, row);
    }

    private void changeCondition(int rowIndex, String propValue) {
        switch (propValue) {
            case "A": 
            case "B": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"dimensionvalue"});
                this.getView().updateView("dimensionvalue", rowIndex);
                break;
            }
            case "C": 
            case "D": 
            case "E": {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"dimensionvalue"});
                this.getView().updateView("dimensionvalue", rowIndex);
                break;
            }
        }
        this.conditionChangeReset(rowIndex);
    }

    private void dimensionValueChange(int rowIndex, Object propValue) {
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (Objects.isNull(propValue) || StringUtils.isBlank((CharSequence)propValue.toString())) {
            model.setValue("dimensionid", null, rowIndex);
            model.setValue("dimensionvalue", null, rowIndex);
            model.setValue("dimensiontext", null, rowIndex);
            model.setValue("dimensiontext_tag", null, rowIndex);
            view.updateView("dimensionid", rowIndex);
            view.updateView("dimensionvalue", rowIndex);
            view.updateView("dimensiontext", rowIndex);
            view.updateView("dimensiontext_tag", rowIndex);
            return;
        }
        DynamicObject entryEntity = model.getEntryEntity("sendentryentity", rowIndex);
        long dimId = entryEntity.getLong("senddimension_id");
        if (dimId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareSendEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dimDy = PADimensionHelper.loadDimension((Object)dimId);
        if (Objects.isNull(dimDy)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PAShareSendEntryPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        String dimensionType = dimDy.getString("dimensiontype");
        model.setValue("senddimtype", (Object)dimensionType, rowIndex);
        view.updateView("senddimtype", rowIndex);
        DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimensionType);
        if (dimensionTypeEnum != null) {
            switch (dimensionTypeEnum) {
                case DATABASE: {
                    Object pkValue;
                    DynamicObject dimensionsource = dimDy.getDynamicObject("dimensionsource");
                    if (Objects.isNull(dimensionsource) || Objects.isNull(pkValue = dimensionsource.getPkValue())) break;
                    entryEntity.set("sendmatename", pkValue);
                    break;
                }
                case ASSISTANTDATA: {
                    DynamicObject dimensionsource = dimDy.getDynamicObject("assistantsource");
                    Object number = dimensionsource.get("number");
                    if (Objects.isNull(number)) break;
                    entryEntity.set("sendmatename", (Object)"bos_assistantdata_detail");
                    break;
                }
            }
        }
    }

    private void conditionChangeReset(int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.setValue("dimensionid", null, rowIndex);
        model.setValue("dimensionvalue", null, rowIndex);
        model.setValue("sendmatename", null, rowIndex);
        model.setValue("dimensiontext", null, rowIndex);
        model.setValue("dimensiontext_tag", null, rowIndex);
        view.updateView("dimensionid", rowIndex);
        view.updateView("dimensionvalue", rowIndex);
        view.updateView("sendmatename", rowIndex);
        view.updateView("dimensiontext", rowIndex);
        view.updateView("dimensiontext_tag", rowIndex);
    }

    private void senddimensionChangeReset(int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.setValue("dimensionid", null, rowIndex);
        model.setValue("dimensionvalue", null, rowIndex);
        model.setValue("sendmatename", null, rowIndex);
        model.setValue("senddimtype", null, rowIndex);
        model.setValue("combofield", (Object)"A", rowIndex);
        model.setValue("dimensiontext", null, rowIndex);
        model.setValue("dimensiontext_tag", null, rowIndex);
        view.updateView("dimensionid", rowIndex);
        view.updateView("dimensionvalue", rowIndex);
        view.updateView("sendmatename", rowIndex);
        view.updateView("senddimtype", rowIndex);
        view.updateView("combofield", rowIndex);
        view.updateView("dimensiontext", rowIndex);
        view.updateView("dimensiontext_tag", rowIndex);
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)model;
        DynamicObject entryEntity = abstractFormDataModel.getEntryEntity("sendentryentity", rowIndex);
        long aLong = entryEntity.getLong("senddimension_id");
        if (aLong == 0L) {
            return;
        }
        DynamicObject clickDimension = PADimensionHelper.loadDimension((Object)aLong);
        if (Objects.isNull(clickDimension)) {
            return;
        }
        String dimensionType = clickDimension.getString("dimensiontype");
        model.setValue("senddimtype", (Object)dimensionType, rowIndex);
        view.updateView("senddimtype", rowIndex);
    }

    private void openFuListView(String name, Object[] selected, QFilter orgFilter) {
        ListShowParameter para = CoreShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)true);
        para.setHasRight(true);
        para.setLookUp(true);
        para.setUseOrgId(0L);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setShowQuickFilter(true);
        para.setIsolationOrg(true);
        if (!Objects.isNull(selected)) {
            para.setSelectedRows(selected);
        }
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bosAssCallBack"));
        orgFilter.and("group.number", "=", (Object)name);
        para.getListFilterParameter().getQFilters().add(orgFilter);
        this.getView().showForm((FormShowParameter)para);
    }

    private void openListView(String name, Object[] selected, QFilter filter) {
        ListShowParameter para = CoreShowFormHelper.createShowListForm((String)name, (boolean)true);
        para.setHasRight(true);
        para.setLookUp(true);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setShowUsed(true);
        para.setShowTitle(false);
        para.setShowQuickFilter(true);
        if (!Objects.isNull(selected)) {
            para.setSelectedRows(selected);
        }
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        para.setListFilterParameter(listFilterParameter);
        para.setIsolationOrg(true);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bosAssCallBack"));
        this.getView().showForm((FormShowParameter)para);
    }
}

