/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.EventObject;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.ExecuteOperationEnum;
import kd.fi.pa.enums.TimeTypeEnum;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.helper.OrgHelper;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PACustomParamHelper;
import kd.fi.pa.helper.PARuleHelper;

public class PASyncDataParamEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_OPERATION = "operation";
    private static final String KEY_SYSTEM = "system";
    private static final String KEY_MODEL = "model";
    private static final String KEY_ORG = "org";
    private static final String KEY_TIME_TYPE = "timetype";
    private static final String KEY_PERIOD_BASEDATA = "periodbasedata";
    private static final String KEY_BUSINESS_PLAN = "businessplan";
    private static final String KEY_BUSINESS_RULE = "businessrule";

    public void registerListener(EventObject e) {
        BasedataEdit businessRule;
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbmain"});
        BasedataEdit model = (BasedataEdit)this.getControl(KEY_MODEL);
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl(KEY_ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit businessPlan = (BasedataEdit)this.getControl(KEY_BUSINESS_PLAN);
        if (businessPlan != null) {
            businessPlan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((businessRule = (BasedataEdit)this.getControl(KEY_BUSINESS_RULE)) != null) {
            businessRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String appId = view.getFormShowParameter().getAppId();
        String key = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)KEY_MODEL, (CharSequence)key)) {
            Long systemId = (Long)model.getValue("system_id");
            if (systemId == null || systemId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"PASyncDataParamEditPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("analysis_system", "=", (Object)systemId));
            listFilterParameter.setFilter(new QFilter("enable", "=", (Object)"1"));
            listFilterParameter.setFilter(new QFilter("tablenumber", "!=", (Object)" "));
            String operation = (String)this.getModel().getValue(KEY_OPERATION);
            ExecuteOperationEnum executeOperationEnum = ExecuteOperationEnum.getExecuteOperationEnum((String)operation);
            switch (executeOperationEnum) {
                case RULE_EXECUTE: {
                    QFilter analysisPeriodFilter = PARuleHelper.getAnalysisPeriodFilter();
                    listFilterParameter.setFilter(analysisPeriodFilter);
                    break;
                }
            }
            listFilterParameter.setOrderBy("createtime desc");
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_ORG, (CharSequence)key)) {
            Long systemId = (Long)model.getValue("system_id");
            if (systemId == null || systemId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"PASyncDataParamEditPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long modelId = (Long)model.getValue("model_id");
            if (modelId == null || modelId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"PASyncDataParamEditPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            String operation = (String)this.getModel().getValue(KEY_OPERATION);
            ExecuteOperationEnum executeOperationEnum = ExecuteOperationEnum.getExecuteOperationEnum((String)operation);
            OrgHelper.PermOrgResult permOrgResult = null;
            switch (executeOperationEnum) {
                case RULE_EXECUTE: {
                    permOrgResult = OrgHelper.getPermOrgSet((String)"pa_businessexecute", (String)appId);
                    if (permOrgResult.hasAllOrgPerm()) break;
                    QFilter executeOrgIdFilter = new QFilter("id", "in", (Object)permOrgResult.getPermOrgs());
                    listFilterParameter.setFilter(executeOrgIdFilter);
                    break;
                }
                case FETCH_DATA: {
                    permOrgResult = OrgHelper.getPermOrgSet((String)"pa_dataextracting", (String)appId);
                    if (permOrgResult.hasAllOrgPerm()) break;
                    QFilter fetchDataOrgIdFilter = new QFilter("id", "in", (Object)permOrgResult.getPermOrgs());
                    listFilterParameter.setFilter(fetchDataOrgIdFilter);
                    break;
                }
            }
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_BUSINESS_PLAN, (CharSequence)key)) {
            Long systemId = (Long)model.getValue("system_id");
            if (systemId == null || systemId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"PASyncDataParamEditPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long modelId = (Long)model.getValue("model_id");
            if (modelId == null || modelId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"PASyncDataParamEditPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection orgDyCol = (DynamicObjectCollection)model.getValue(KEY_ORG);
            if (orgDyCol == null || orgDyCol.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u7ec4\u7ec7\u201d\u3002", (String)"PASyncDataParamEditPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter modelFilter = new QFilter("analysismodel", "=", (Object)modelId);
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            listFilterParameter.setFilter(modelFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_BUSINESS_RULE, (CharSequence)key)) {
            Long systemId = (Long)model.getValue("system_id");
            if (systemId == null || systemId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u4f53\u7cfb\u201d\u3002", (String)"PASyncDataParamEditPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long modelId = (Long)model.getValue("model_id");
            if (modelId == null || modelId == 0L) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5206\u6790\u6a21\u578b\u201d\u3002", (String)"PASyncDataParamEditPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection orgDyCol = (DynamicObjectCollection)model.getValue(KEY_ORG);
            if (orgDyCol == null || orgDyCol.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u7ec4\u7ec7\u201d\u3002", (String)"PASyncDataParamEditPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter modelFilter = new QFilter("analysismodel", "=", (Object)modelId);
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            listFilterParameter.setFilter(modelFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String appId = view.getFormShowParameter().getAppId();
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (StringUtils.equals((CharSequence)KEY_OPERATION, (CharSequence)key)) {
            model.setValue(KEY_MODEL, null);
            DynamicObjectCollection orgDyCol = (DynamicObjectCollection)model.getValue(KEY_ORG);
            if (orgDyCol == null || orgDyCol.isEmpty()) {
                return;
            }
            String operation = (String)model.getValue(KEY_OPERATION);
            ExecuteOperationEnum executeOperationEnum = ExecuteOperationEnum.getExecuteOperationEnum((String)operation);
            Set orgIdSet = orgDyCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
            OrgHelper.PermOrgResult permOrgResult = null;
            switch (executeOperationEnum) {
                case FETCH_DATA: {
                    permOrgResult = OrgHelper.getPermOrgSet((String)"pa_dataextracting", (String)appId);
                    if (permOrgResult.hasAllOrgPerm() || permOrgResult.getPermOrgs().containsAll(orgIdSet)) break;
                    model.setValue(KEY_ORG, null);
                    break;
                }
                case RULE_EXECUTE: {
                    permOrgResult = OrgHelper.getPermOrgSet((String)"pa_businessexecute", (String)appId);
                    if (!permOrgResult.hasAllOrgPerm() && !permOrgResult.getPermOrgs().containsAll(orgIdSet)) {
                        model.setValue(KEY_ORG, null);
                        return;
                    }
                    int orgCountLimit = PACustomParamHelper.getRuleExecOrgCountLimit();
                    DynamicObjectCollection orgIds = (DynamicObjectCollection)this.getModel().getValue(KEY_ORG);
                    if (orgIds == null || orgIds.size() <= orgCountLimit) break;
                    model.setValue(KEY_ORG, null);
                    return;
                }
                default: {
                    model.setValue(KEY_ORG, null);
                }
            }
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_SYSTEM, (CharSequence)key)) {
            model.setValue(KEY_MODEL, null);
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_MODEL, (CharSequence)key)) {
            Long modelId = (Long)this.getModel().getValue("model_id");
            if (modelId == null || modelId == 0L) {
                return;
            }
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId);
            if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                model.setValue(KEY_MODEL, null);
                view.showTipNotification(modelNewVersionMsg);
                return;
            }
            DynamicObject timeDimension = PAAnalysisModelHelper.queryModelNecessityTimeDimension((Long)modelId);
            String dimType = timeDimension.getString("dimension_entry.dimension.dimensiontype");
            String dimBaseData = timeDimension.getString("dimension_entry.dimension.dimensionsource");
            DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimType);
            if (dimensionTypeEnum == null) {
                model.setValue(KEY_MODEL, null);
                return;
            }
            switch (dimensionTypeEnum) {
                case DATABASE: 
                case ASSISTANTDATA: 
                case PERIOD: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.PERIOD.getCode());
                    model.setValue(KEY_PERIOD_BASEDATA, (Object)dimBaseData);
                    break;
                }
                case DATE: {
                    model.setValue(KEY_TIME_TYPE, (Object)TimeTypeEnum.DATE.getCode());
                    break;
                }
                default: {
                    model.setValue(KEY_MODEL, null);
                }
            }
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_ORG, (CharSequence)key)) {
            String operation = (String)model.getValue(KEY_OPERATION);
            ExecuteOperationEnum executeOperationEnum = ExecuteOperationEnum.getExecuteOperationEnum((String)operation);
            if (ExecuteOperationEnum.RULE_EXECUTE == executeOperationEnum) {
                DynamicObjectCollection orgIds = (DynamicObjectCollection)newValue;
                int orgCountLimit = PACustomParamHelper.getRuleExecOrgCountLimit();
                if (orgIds != null && orgIds.size() > orgCountLimit) {
                    if (oldValue != null && ((DynamicObjectCollection)oldValue).size() <= orgCountLimit) {
                        model.setValue(KEY_ORG, oldValue);
                    } else {
                        model.setValue(KEY_ORG, null);
                    }
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52fe\u9009%1$s\u5bb6\u7ec4\u7ec7\u8fdb\u884c\u89c4\u5219\u6267\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PASyncDataParamEditPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), orgCountLimit));
                    return;
                }
            }
            model.setValue(KEY_BUSINESS_PLAN, null);
            model.setValue(KEY_BUSINESS_RULE, null);
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_BUSINESS_PLAN, (CharSequence)key)) {
            if (Objects.nonNull(newValue)) {
                model.setValue(KEY_BUSINESS_RULE, null);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)KEY_BUSINESS_RULE, (CharSequence)key) && Objects.nonNull(newValue)) {
            model.setValue(KEY_BUSINESS_PLAN, null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String key = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            Long modelId = (Long)model.getValue("model_id");
            String operation = (String)model.getValue(KEY_OPERATION);
            Long businessPlanId = (Long)model.getValue("businessplan_id");
            Long businessRuleId = (Long)model.getValue("businessrule_id");
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(modelId);
            if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                model.setValue(KEY_MODEL, null);
                view.showTipNotification(modelNewVersionMsg);
                args.setCancel(true);
                return;
            }
            ExecuteOperationEnum executeOperationEnum = ExecuteOperationEnum.getExecuteOperationEnum((String)operation);
            switch (executeOperationEnum) {
                case RULE_EXECUTE: {
                    if (businessPlanId != 0L || businessRuleId != 0L) break;
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u89c4\u5219\u7ec4\u6216\u4e1a\u52a1\u89c4\u5219\u3002", (String)"PASyncDataParamEditPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }
}

