/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.helper.PAAnalysisModelHelper;

public class PASyncDataParamListPlugin
extends AbstractListPlugin {
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        SchemeFilterColumn modelSchemeFilterColumn = args.getSchemeFilterColumns().stream().filter(v -> v.getFieldName().equals("model.name")).findFirst().orElse(null);
        if (modelSchemeFilterColumn == null) {
            return;
        }
        modelSchemeFilterColumn.setComboItems(this.getComboItemList());
    }

    private List<ComboItem> getComboItemList() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        if (controlFilters == null) {
            return comboItemList;
        }
        List filterList = controlFilters.getFilter("system.id");
        if (filterList == null || filterList.isEmpty()) {
            return comboItemList;
        }
        String systemId = (String)filterList.get(0);
        if (StringUtils.isEmpty((CharSequence)systemId)) {
            return comboItemList;
        }
        DynamicObjectCollection dyCol = PAAnalysisModelHelper.queryModelByAnaSystem((Object[])new Object[]{Long.parseLong(systemId)});
        dyCol.forEach(dy -> {
            long id = dy.getLong("id");
            String name = dy.getString("name");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(name));
            item.setValue(String.valueOf(id));
            item.setItemVisible(true);
            comboItemList.add(item);
        });
        return comboItemList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object primaryKeyValue;
        DynamicObject dynObj;
        String modelNewVersionMsg;
        StatusConvert source;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof StatusConvert && "enable".equals((source = (StatusConvert)args.getSource()).getOperateKey()) && StringUtils.isNotEmpty((CharSequence)(modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion((dynObj = BusinessDataServiceHelper.loadSingle((Object)(primaryKeyValue = source.getListSelectedData().get(0).getPrimaryKeyValue()), (String)"pa_syncdataparam")).getLong("model_id"))))) {
            this.getView().showTipNotification(modelNewVersionMsg);
            args.setCancel(true);
        }
    }
}

