/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.pa.export.excel.ExportParam;
import kd.fi.pa.export.excel.ImportFile;
import kd.fi.pa.export.excel.ShareFactorExportHandler;
import kd.fi.pa.formplugin.PAUploadResShowFormPlugin;
import kd.fi.pa.model.impl.ThreeValueTuple;

public class PAUploadFileFormPlugin
extends AbstractFormPlugin {
    private static final String CONTROL_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String CONTROL_OK = "btnok";
    private static final String LAB_DOWNTEMPLATE = "downtemplate";
    private static final String CUS_ANALYSISMODEL = "analysisModelId";
    private static final String CALLBACK_CLOSEVIEW = "closeView";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_OK, LAB_DOWNTEMPLATE});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CONTROL_OK.equals(key)) {
            this.importData();
        } else if (LAB_DOWNTEMPLATE.equals(key)) {
            this.downTemplate();
        }
    }

    private void importData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(CONTROL_ATTACHMENTPANELAP);
        List list = attachmentPanel.getAttachmentData();
        if (list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"PAUploadFileFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (list.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u6b21\u53ea\u5141\u8bb8\u4e0a\u4f20\u4e00\u4e2a\u6587\u4ef6\u3002", (String)"PAUploadFileFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        Map fileMap = (Map)list.get(0);
        String url = (String)fileMap.get("url");
        String name = (String)fileMap.get("name");
        ShareFactorExportHandler sfeh = new ShareFactorExportHandler();
        ExportParam ep = this.createExportParam();
        ImportFile importFile = ImportFile.createTempAttachmentFile((String)url, (String)name);
        ThreeValueTuple message = sfeh.importData(importFile, ep);
        OperationResult or = (OperationResult)message.getElement();
        if (or.getSuccessPkIds().size() > 0) {
            ((ListView)this.getView().getParentView()).refresh();
            this.getView().sendFormAction(this.getView().getParentView());
        }
        ArrayList<String> errorMsgList = new ArrayList<String>();
        Map errorMessageMap = (Map)message.getValue();
        if (errorMessageMap != null && !errorMessageMap.isEmpty()) {
            Set errorKeySet = errorMessageMap.keySet();
            ArrayList indexList = new ArrayList(10);
            indexList.addAll(errorKeySet);
            indexList.sort(Integer::compareTo);
            indexList.forEach(index -> {
                StringBuilder errorRow = new StringBuilder();
                List errorList = (List)errorMessageMap.get(index);
                if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                    if (index >= 0) {
                        String header = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"PAUploadFileFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), index + 5);
                        errorRow.append(header).append("\uff0c");
                    }
                    errorRow.append(String.join((CharSequence)"\uff0c", errorList));
                    errorMsgList.add(errorRow.toString());
                }
            });
        }
        PAUploadResShowFormPlugin.openForm(this, (String)message.getKey(), errorMsgList, CALLBACK_CLOSEVIEW);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals(CALLBACK_CLOSEVIEW)) {
            this.getView().close();
        }
    }

    private void downTemplate() {
        ExportParam ep = this.createExportParam();
        ShareFactorExportHandler handler = new ShareFactorExportHandler();
        String url = handler.downloadTemplate(ep);
        this.getView().download(url);
    }

    private ExportParam createExportParam() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String analysisModelId = (String)fsp.getCustomParam(CUS_ANALYSISMODEL);
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(analysisModelId), (String)"pa_analysismodel");
        ExportParam ep = ExportParam.createTemplateExportParam((DynamicObject)analysisModelObj);
        return ep;
    }

    public static void openForm(Long analysisModel, String closeBackId, AbstractFormPlugin parentFormPlugin) {
        if (analysisModel == null || parentFormPlugin == null) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pa_uploadfile");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCaption(ResManager.loadKDString((String)"\u5206\u644a\u56e0\u5b50\u6570\u636e\u5bfc\u5165", (String)"PAUploadFileFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam(CUS_ANALYSISMODEL, (Object)String.valueOf(analysisModel));
        if (StringUtils.isNotEmpty((String)closeBackId)) {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)parentFormPlugin, closeBackId));
        }
        parentFormPlugin.getView().showForm(fsp);
    }
}

