/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.common.util.EntityTreeUtil;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.util.DimensionDyUtil;

public class PaIncomeDefineEditFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener {
    public static final String ANALYSISMODEL = "analysismodel";
    public static final String DIMENSION = "dimension";
    public static final String COL_ENTRY = "col_entry";
    public static final String ROW_ENTRY = "row_entry";
    public static final String TREENODES = "treenodes";
    public static final String NUMBER = "number";
    public static final String PA_ANALYSIS_MODEL = "pa_analysismodel";
    public static final String FI_PA_FORMPLUGIN = "fi-pa-formplugin";
    public static final String DIMNUMBER = "dimnumber";
    public static final String DIMENSION_ENTRY = "dimension_entry";
    public static final String ANALYSIS_SYSTEM = "analysis_system";
    public static final String MEASURE = "measure";
    public static final String DIMENSIONTYPE = "dimensiontype";
    private QFilter[] qFilterssys = new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))};

    private void initCreateInEntry() {
        this.getModel().deleteEntryData(ROW_ENTRY);
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(ROW_ENTRY, 12);
        for (int i = 0; i < 12; ++i) {
            model.setValue("dseq", (Object)(i + 1), i);
        }
        String reportitem = "reportitem";
        String item = ResManager.loadKDString((String)"\u51c0\u9500\u552e\u6536\u5165", (String)"PaIncomeDefineEditFormPlugin_0", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 0);
        item = ResManager.loadKDString((String)"\u4ea7\u54c1\u6536\u5165", (String)"PaIncomeDefineEditFormPlugin_1", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 1);
        item = ResManager.loadKDString((String)"\u670d\u52a1\u6536\u5165", (String)"PaIncomeDefineEditFormPlugin_2", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 2);
        item = ResManager.loadKDString((String)"\u5176\u4ed6\u6536\u5165", (String)"PaIncomeDefineEditFormPlugin_3", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 3);
        item = ResManager.loadKDString((String)"\u9500\u552e\u6210\u672c", (String)"PaIncomeDefineEditFormPlugin_4", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 4);
        item = ResManager.loadKDString((String)"\u4ea7\u54c1\u6210\u672c", (String)"PaIncomeDefineEditFormPlugin_5", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 5);
        item = ResManager.loadKDString((String)"\u8bbe\u5907\u6210\u672c", (String)"PaIncomeDefineEditFormPlugin_6", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 6);
        item = ResManager.loadKDString((String)"\u671f\u95f4\u6210\u672c", (String)"PaIncomeDefineEditFormPlugin_7", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 7);
        item = ResManager.loadKDString((String)"\u670d\u52a1\u6210\u672c", (String)"PaIncomeDefineEditFormPlugin_8", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 8);
        item = ResManager.loadKDString((String)"\u5176\u4ed6\u6210\u672c", (String)"PaIncomeDefineEditFormPlugin_9", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 9);
        item = ResManager.loadKDString((String)"\u9500\u552e\u6bdb\u5229", (String)"PaIncomeDefineEditFormPlugin_10", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 10);
        item = ResManager.loadKDString((String)"\u9500\u552e\u6bdb\u5229\u7387", (String)"PaIncomeDefineEditFormPlugin_11", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue("reportitem", (Object)item, 11);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminorgEdit = (BasedataEdit)this.getView().getControl(ANALYSISMODEL);
        BasedataEdit measure = (BasedataEdit)this.getView().getControl(MEASURE);
        BasedataEdit dimension = (BasedataEdit)this.getView().getControl(DIMENSION);
        adminorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        measure.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        dimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ROW_ENTRY);
        entryGrid.addCellClickListener((CellClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initCreateInEntry();
        Long systemByMinNumber = this.getSystemByMinNumber();
        this.getModel().setValue(ANALYSIS_SYSTEM, (Object)systemByMinNumber);
        Long modelFromSystem = this.getModelFromSystem(systemByMinNumber);
        this.getModel().setValue(ANALYSISMODEL, (Object)modelFromSystem);
        Long dimensionFromSystem = this.getDimensionFromModel(modelFromSystem);
        this.getModel().setValue(DIMENSION, (Object)dimensionFromSystem);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "analysis_system": {
                if (newValue == null) break;
                long id = ((DynamicObject)newValue).getLong("id");
                Long modelFromSystem = this.getModelFromSystem(id);
                this.getModel().setValue(ANALYSISMODEL, (Object)modelFromSystem);
                break;
            }
            case "analysismodel": {
                this.getModel().setValue(DIMENSION, null);
                this.getModel().setValue(MEASURE, null);
                this.getModel().deleteEntryData(COL_ENTRY);
                if (newValue == null) break;
                long id = ((DynamicObject)newValue).getLong("id");
                Long dimensionFromSystem = this.getDimensionFromModel(id);
                this.getModel().setValue(DIMENSION, (Object)dimensionFromSystem);
                break;
            }
            case "dimension": {
                DynamicObject dimsionOb = (DynamicObject)newValue;
                if (dimsionOb != null) {
                    this.getPageCache().remove(TREENODES + dimsionOb.getString(NUMBER));
                    this.deleteColEntryRow(dimsionOb.getString(NUMBER));
                }
                this.initCreateInEntry();
                break;
            }
        }
    }

    private Long getModelFromSystem(Long analysisSystem) {
        QFilter qFilter = new QFilter(ANALYSIS_SYSTEM, "=", (Object)analysisSystem);
        DynamicObjectCollection query = QueryServiceHelper.query((String)PA_ANALYSIS_MODEL, (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)NUMBER, (int)1);
        if (!CollectionUtils.isEmpty((Collection)query)) {
            return ((DynamicObject)query.get(0)).getLong("id");
        }
        return null;
    }

    private Stream<DynamicObject> getDimensionStreamFromModel(Long analysismodel) {
        if (analysismodel == null) {
            return Stream.empty();
        }
        DynamicObject modelDynamicObject = BusinessDataServiceHelper.loadSingle((Object)analysismodel, (String)PA_ANALYSIS_MODEL);
        DynamicObjectCollection dimensionEntry = modelDynamicObject.getDynamicObjectCollection(DIMENSION_ENTRY);
        return dimensionEntry.stream().map(p -> p.getDynamicObject(DIMENSION)).filter(Objects::nonNull);
    }

    private Long getDimensionFromModel(Long analysismodel) {
        if (analysismodel == null) {
            return null;
        }
        DynamicObject modelDynamicObject = BusinessDataServiceHelper.loadSingle((Object)analysismodel, (String)PA_ANALYSIS_MODEL);
        DynamicObjectCollection dimensionEntry = modelDynamicObject.getDynamicObjectCollection(DIMENSION_ENTRY);
        DynamicObject dynamicObject = dimensionEntry.stream().filter(p -> "2".equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject(DIMENSION)).filter(p -> "0".equals(p.get(DIMENSIONTYPE)) || "1".equals(p.get(DIMENSIONTYPE))).findFirst().orElse(null);
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    private Long getSystemByMinNumber() {
        List query = QueryServiceHelper.queryPrimaryKeys((String)"pa_anasystemsetting", (QFilter[])this.qFilterssys, (String)NUMBER, (int)1);
        if (!CollectionUtils.isEmpty((Collection)query)) {
            return (Long)query.get(0);
        }
        return null;
    }

    private void selectAnalysismodel(BeforeF7SelectEvent evt, String filterName) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(ANALYSIS_SYSTEM);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"PaIncomeDefineEditFormPlugin_12", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            long id = model.getLong("id");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter(filterName, "=", (Object)id));
        }
    }

    private void selectDimmensionByModel(BeforeF7SelectEvent evt, String entryName, String dimname) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(ANALYSISMODEL);
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PaIncomeDefineEditFormPlugin_13", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)model.getLong("id"), (String)PA_ANALYSIS_MODEL);
            DynamicObjectCollection dimensionEntry = dynamicObject.getDynamicObjectCollection(entryName);
            List id = dimensionEntry.stream().map(p -> p.getDynamicObject(dimname)).filter(Objects::nonNull).filter(p -> this.dimensiontypeFilter((DynamicObject)p, dimname)).map(p -> p.getLong("id")).collect(Collectors.toList());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", id));
        }
    }

    private boolean dimensiontypeFilter(DynamicObject dy, String dimname) {
        if (!dimname.equals(DIMENSION)) {
            return true;
        }
        return DimensionTypeEnum.getEnum((String)dy.getString(DIMENSIONTYPE)) == DimensionTypeEnum.DATABASE || DimensionTypeEnum.getEnum((String)dy.getString(DIMENSIONTYPE)) == DimensionTypeEnum.ASSISTANTDATA;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "analysismodel": {
                this.selectAnalysismodel(evt, ANALYSIS_SYSTEM);
                break;
            }
            case "measure": {
                this.selectDimmensionByModel(evt, "measure_entry", MEASURE);
                break;
            }
            case "dimension": {
                this.selectDimmensionByModel(evt, DIMENSION_ENTRY, DIMENSION);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKy = evt.getItemKey();
        IDataModel model = this.getModel();
        if ("adddim".equals(operationKy)) {
            Object analysismodel = model.getValue(ANALYSISMODEL);
            if (analysismodel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"PaIncomeDefineEditFormPlugin_13", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection colEntry = model.getEntryEntity(COL_ENTRY);
            List filterNumbers = colEntry.stream().map(p -> p.getString(DIMNUMBER)).collect(Collectors.toList());
            Object dimensionDy = model.getValue(DIMENSION);
            if (dimensionDy != null) {
                String dimmensionNumber = ((DynamicObject)dimensionDy).getString(NUMBER);
                filterNumbers.add(dimmensionNumber);
            }
            List ids = this.getDimensionStreamFromModel(((DynamicObject)analysismodel).getLong("id")).map(p -> p.getLong("id")).collect(Collectors.toList());
            ListShowParameter bsp = CoreShowFormHelper.createShowListForm((String)"pa_dimension", (boolean)true);
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addDimCloseBack"));
            bsp.setLookUp(true);
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("800");
            css.setHeight("500");
            bsp.getOpenStyle().setInlineStyleCss(css);
            List qFilters = bsp.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", ids));
            if (!CollectionUtils.isEmpty(filterNumbers)) {
                qFilters.add(new QFilter(NUMBER, "not in", filterNumbers));
            }
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "addDimCloseBack": {
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
                    return;
                }
                for (ListSelectedRow listSelectedRow : listSelectedRows) {
                    Object id = listSelectedRow.getPrimaryKeyValue();
                    String name = listSelectedRow.getName();
                    String number = listSelectedRow.getNumber();
                    int colEntry = this.getModel().createNewEntryRow(COL_ENTRY);
                    this.getModel().setValue("coldimension", id, colEntry);
                    this.getModel().setValue("dimname", (Object)name, colEntry);
                    this.getModel().setValue(DIMNUMBER, (Object)number, colEntry);
                }
                break;
            }
            case "calculationruleCallback": {
                JSONObject jsonObject = JSON.parseObject((String)((String)returnData));
                String expression = jsonObject.getString("expression");
                String description = jsonObject.getJSONObject("description").getString("zh_CN");
                int currentRow = Integer.parseInt(this.getPageCache().get("currentRow"));
                this.getModel().setValue("calculationrule", (Object)(expression.length() > 255 ? expression.substring(0, 255) : expression), currentRow);
                this.getModel().setValue("calculationdesc", (Object)(description.length() > 255 ? description.substring(0, 255) : description), currentRow);
                this.getModel().setValue("calculationrule_tag", (Object)expression, currentRow);
                this.getModel().setValue("calculationdesc_tag", (Object)description, currentRow);
                this.getView().updateView("calculationdesc", currentRow);
                break;
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        DynamicObject dimensionOb = (DynamicObject)this.getModel().getValue(DIMENSION);
        if (dimensionOb == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u3002", (String)"PaIncomeDefineEditFormPlugin_14", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String fieldKey = cellClickEvent.getFieldKey();
        if ("button".equals(fieldKey)) {
            int row = cellClickEvent.getRow();
            this.getPageCache().put("currentRow", String.valueOf(row));
            DynamicObject rowEntry = this.getModel().getEntryRowEntity(ROW_ENTRY, row);
            String calculationrule = rowEntry.getString("calculationrule_tag");
            String desc = rowEntry.getString("calculationdesc_tag");
            CRFormula crFormula = new CRFormula();
            crFormula.setExpression(calculationrule);
            crFormula.setDescription(new LocaleString(desc));
            this.showConditionForm(crFormula);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void showConditionForm(CRFormula crFormula) {
        String treeNodeString;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dynamicObject = (DynamicObject)model.getValue(DIMENSION);
        Tuple2<String, QFilter[]> dimensionSourceNumberFromDimension = DimensionDyUtil.getDimensionSourceNumberFromDimension(dynamicObject);
        String entity = (String)dimensionSourceNumberFromDimension.t1;
        QFilter[] qFilters = (QFilter[])dimensionSourceNumberFromDimension.t2;
        if (entity == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u6216\u8005\u8f85\u52a9\u8d44\u6599\u7684\u7ef4\u5ea6\u3002", (String)"PaIncomeDefineEditFormPlugin_15", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject dimensionOb = (DynamicObject)model.getValue(DIMENSION);
        String dimensionNumber = dimensionOb.getString(NUMBER);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(false);
        showParameter.setFormId("pa_expression");
        showParameter.getCustomParams().put("formula", SerializationUtils.toJsonString((Object)crFormula));
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get(TREENODES + entity) != null) {
            treeNodeString = pageCache.get(TREENODES + dimensionNumber);
        } else {
            treeNodeString = this.dyCollection2TreeNodeString(entity, qFilters, dimensionOb.getString("name"));
            pageCache.put(TREENODES + dimensionNumber, treeNodeString);
        }
        showParameter.getCustomParams().put(TREENODES, treeNodeString);
        showParameter.getCustomParams().put("PROXY_CLASS", "kd.fi.pa.formplugin.verification.PaIncomeProxy");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calculationruleCallback"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private String dyCollection2TreeNodeString(String entity, QFilter[] qFilters, String dimName) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)PaIncomeDefineEditFormPlugin.class.getName(), (String)entity, (String)"name,number", (QFilter[])qFilters, null);
        HashSet<String> set = new HashSet<String>(16);
        ArrayList<TreeNode> rootNode = new ArrayList<TreeNode>(Collections.singleton(new TreeNode("", "0", dimName)));
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String number = next.getString(NUMBER);
            if (set.contains(number)) continue;
            String name = next.getString("name");
            set.add(number);
            rootNode.add(new TreeNode("0", number, number + " " + name));
        }
        TreeNode treeNode = EntityTreeUtil.buildBillTree(rootNode);
        return SerializationUtils.toJsonString((Object)treeNode);
    }

    private void deleteColEntryRow(String number) {
        DynamicObjectCollection colEntry = this.getModel().getEntryEntity(COL_ENTRY);
        for (int i = 0; i < colEntry.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)colEntry.get(i);
            String dimnumber = dynamicObject.getString(DIMNUMBER);
            if (!dimnumber.equals(number)) continue;
            this.getModel().deleteEntryRow(COL_ENTRY, i);
            break;
        }
    }
}

