/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.formplugin.util.CalculateUtils;
import kd.fi.pa.formplugin.util.DimensionDyUtil;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PaIncomeReportListPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(PaIncomeReportListPlugin.class);
    private static final String DIMENSION = "dimension";
    private static final String ANALYSISMODEL = "analysismodel";
    private static final String NUMBER = "number";
    private static final String DIMENSIONTYPE = "dimensiontype";
    private static final String ID = "id";
    public static final String FI_PA_FORMPLUGIN = "fi-pa-formplugin";
    private final String logClassName = ((Object)((Object)this)).getClass().getName();
    protected static final String ORG = "org";
    private Field[] fileds = null;
    private boolean hasBuildField = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObject dynamicObjectFilter = (DynamicObject)filter.getFilterItem("income").getValue();
        long incomeDefine = dynamicObjectFilter.getLong(ID);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)incomeDefine, (String)"pa_income_define");
        DynamicObject dimension = dynamicObject.getDynamicObject(DIMENSION);
        String number = dimension.getString(NUMBER);
        long modelId = dynamicObject.getLong("analysismodel_id");
        DynamicObject analysismodel = PAAnalysisModelHelper.loadAnalysisModel((Object)modelId);
        DynamicObject measure = dynamicObject.getDynamicObject("measure");
        String measureNumber = measure.getString(NUMBER);
        DynamicObjectCollection row_entry = dynamicObject.getDynamicObjectCollection("row_entry");
        DynamicObjectCollection col_entry = dynamicObject.getDynamicObjectCollection("col_entry");
        if (CollectionUtils.isEmpty((Collection)col_entry)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e3a\u8be5\u62a5\u8868\u5b9a\u4e49\u6dfb\u52a0\u5217\u7ef4\u3002", (String)"PaIncomeReportListPlugin_0", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
        }
        LinkedHashMap<String, String> itemCalculationMap = new LinkedHashMap<String, String>(12);
        row_entry.forEach(p -> {
            String calculationrule = p.getString("calculationrule_tag").replaceAll("\\s+", "");
            if (StringUtils.isNotEmpty((CharSequence)calculationrule)) {
                String reportitem = p.getString("reportitem");
                itemCalculationMap.put(reportitem, calculationrule);
            }
        });
        LinkedHashMap<String, Tuple2<String, QFilter[]>> numberEntityFilter = new LinkedHashMap<String, Tuple2<String, QFilter[]>>(16);
        HashSet otherDim = new HashSet(16);
        col_entry.forEach(p -> {
            DynamicObject coldimension = p.getDynamicObject("coldimension");
            String dimensiontype = coldimension.getString(DIMENSIONTYPE);
            String dimnumber = p.getString("dimnumber");
            if ("1".equals(dimensiontype) || "2".equals(dimensiontype)) {
                Tuple2<String, QFilter[]> dimensionSourceNumberFromDimension = DimensionDyUtil.getDimensionSourceNumberFromDimension(coldimension);
                numberEntityFilter.put(dimnumber, dimensionSourceNumberFromDimension);
            } else if ("3".equals(dimensiontype)) {
                otherDim.add(dimnumber);
            }
        });
        LinkedHashSet<String> dimnumberList = new LinkedHashSet<String>(numberEntityFilter.keySet());
        dimnumberList.addAll(otherDim);
        dimnumberList.add(number);
        dimnumberList.add(measureNumber);
        String selectField = StringUtils.join(dimnumberList, (String)",");
        List<String> numbers = this.resolveRule(itemCalculationMap);
        String dimensionsourceEntity = this.getDimensionSourceEntity(dimension);
        Map<String, List<Long>> numberIdsMap = this.changeNumber2Id(dimensionsourceEntity, numbers);
        Set ids = numberIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        String tablenumberEntity = "pa_" + analysismodel.getString("tablenumber");
        QFilter[] qFilters = this.buildQFilter(filter, analysismodel, new QFilter[]{new QFilter(number, "in", ids), new QFilter("collectstatus", "=", (Object)0)});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.logClassName, (String)tablenumberEntity, (String)selectField, (QFilter[])qFilters, null);
        logger.debug("QFilter:" + Arrays.asList(qFilters).stream().map(p -> p.getProperty() + p.getCP() + p.getValue()).collect(Collectors.joining(",")));
        DataSet dimensionSourceDataSet = QueryServiceHelper.queryDataSet((String)this.logClassName, (String)dimensionsourceEntity, (String)("id,number as " + number), (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)}, null);
        ArrayList<List<Object>> buildDataSetList = new ArrayList<List<Object>>();
        try (DataSet join = null;){
            join = this.join(dataSet, dimensionSourceDataSet, number, dimnumberList);
            Map<String, DataSet> datasetMap = this.getDataSet(numberEntityFilter);
            for (Map.Entry<String, DataSet> stringDataSetEntry : datasetMap.entrySet()) {
                join = this.join(join, stringDataSetEntry.getValue(), stringDataSetEntry.getKey(), dimnumberList);
            }
            dimnumberList.add(number);
            dimnumberList.remove(measureNumber);
            try (DataSet finish = join.groupBy(dimnumberList.toArray(new String[dimnumberList.size()])).sum(measureNumber).finish();){
                RowMeta rowMeta = finish.getRowMeta();
                Field[] fields = rowMeta.getFields();
                while (finish.hasNext()) {
                    Row next = finish.next();
                    ArrayList<Object> objects = new ArrayList<Object>(rowMeta.getFieldCount());
                    objects.add(next.getString(number));
                    for (int i = 0; i < fields.length; ++i) {
                        String fieldName = fields[i].getName();
                        if (fieldName.equals(number) || fieldName.equals(measureNumber)) continue;
                        String colNmae = next.getString(fieldName);
                        objects.add(colNmae);
                    }
                    objects.add(next.getBigDecimal(measureNumber));
                    buildDataSetList.add(objects);
                }
            }
        }
        logger.debug("buildDataSetList:" + JSONObject.toJSONString(buildDataSetList));
        if (CollectionUtils.isEmpty(buildDataSetList)) {
            Algo algo = Algo.create((String)this.logClassName);
            return algo.createDataSet(Collections.emptyIterator(), new RowMeta(new Field[]{new Field("nothing", (DataType)DataType.NullType)}));
        }
        List<Object[]> list = this.dataSet2List(buildDataSetList, col_entry.size(), itemCalculationMap);
        Algo algo = Algo.create((String)this.logClassName);
        return algo.createDataSet(list.iterator(), new RowMeta(this.fileds));
    }

    private List<Object[]> dataSet2List(List<List<Object>> buildDataSetList, int colEntrySize, Map<String, String> itemCalculationMap) {
        HashMap<String, Map> groupByCol = new HashMap<String, Map>(1 << colEntrySize);
        buildDataSetList.forEach(p -> {
            String colCombile = StringUtils.join(p.subList(1, p.size() - 1), (String)"!,!");
            groupByCol.merge(colCombile, new HashMap<String, BigDecimal>(Collections.singletonMap((String)p.get(0), (BigDecimal)p.get(p.size() - 1))), (oldValue, value) -> {
                oldValue.put((String)p.get(0), (BigDecimal)p.get(p.size() - 1));
                return oldValue;
            });
        });
        logger.debug("groupByCol:" + JSONObject.toJSONString(groupByCol));
        ArrayList reports = new ArrayList(16);
        groupByCol.forEach((col, value) -> {
            CalculateUtils bigDecimalCalculateUtils = new CalculateUtils(value);
            itemCalculationMap.forEach((item, cacular) -> {
                BigDecimal bigDecimal = (BigDecimal)bigDecimalCalculateUtils.calculate((String)cacular).get(0);
                reports.add(new Report((String)item, (String)col, bigDecimal));
            });
        });
        LinkedHashMap<String, List> excMap = new LinkedHashMap<String, List>(16);
        for (Report report : reports) {
            String itemName = report.getItemName();
            excMap.merge(itemName, new ArrayList<Report>(Collections.singletonList(report)), (oldv, n) -> {
                oldv.add(report);
                return oldv;
            });
        }
        Iterator iterator = excMap.entrySet().iterator();
        ArrayList<Object[]> list = new ArrayList<Object[]>(16);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            String key = (String)next.getKey();
            List value2 = (List)next.getValue();
            Object[] objects = new Object[value2.size() + 1];
            objects[0] = key;
            this.buildField(value2);
            for (int i = 0; i < value2.size(); ++i) {
                Report report = (Report)value2.get(i);
                objects[i + 1] = report.getValue();
            }
            list.add(objects);
        }
        return list;
    }

    private QFilter[] buildQFilter(FilterInfo filter, DynamicObject dynamicObjectModelFilter, QFilter[] qFilters) {
        ArrayList<QFilter> listQfilter = new ArrayList<QFilter>(4);
        String periodNumber = dynamicObjectModelFilter.getDynamicObjectCollection("dimension_entry").stream().filter(p -> "1".equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject(DIMENSION).getString(NUMBER)).findFirst().orElse(null);
        DynamicObject dynamicObjectPeriodFilter = (DynamicObject)filter.getFilterItem("period").getValue();
        if (periodNumber != null && dynamicObjectPeriodFilter != null) {
            Object periodId = dynamicObjectPeriodFilter.getPkValue();
            listQfilter.add(new QFilter(periodNumber, "=", periodId));
        }
        String orgNumber = dynamicObjectModelFilter.getDynamicObjectCollection("dimension_entry").stream().filter(p -> "0".equals(p.getString("necessity_dim"))).map(p -> p.getDynamicObject(DIMENSION).getString(NUMBER)).findFirst().orElse(null);
        DynamicObject dynamicObjectOrgFilter = (DynamicObject)filter.getFilterItem(ORG).getValue();
        if (periodNumber != null && dynamicObjectOrgFilter != null) {
            Object orgId = dynamicObjectOrgFilter.getPkValue();
            listQfilter.add(new QFilter(orgNumber, "=", orgId));
        }
        if (qFilters != null && qFilters.length > 0) {
            listQfilter.addAll(Arrays.asList(qFilters));
        }
        return listQfilter.toArray(new QFilter[listQfilter.size()]);
    }

    private Field[] buildField(List<Report> value) {
        if (!this.hasBuildField) {
            this.fileds = new Field[value.size() + 1];
            this.fileds[0] = new Field(ResManager.loadKDString((String)"\u62a5\u8868\u9879", (String)"PaIncomeReportListPlugin_1", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]), (DataType)new StringType());
            for (int i = 0; i < value.size(); ++i) {
                this.fileds[i + 1] = new Field(value.get(i).getColName(), (DataType)new BigDecimalType());
            }
        }
        return this.fileds;
    }

    private String getDimensionSourceEntity(@NotNull DynamicObject dynamicObject) {
        DynamicObject dimensionsource = null;
        String dimensiontype = dynamicObject.getString(DIMENSIONTYPE);
        String entity = null;
        if ("1".equals(dimensiontype)) {
            dimensionsource = dynamicObject.getDynamicObject("dimensionsource");
            entity = dimensionsource.getString(NUMBER);
        } else if ("2".equals(dimensiontype)) {
            entity = "bos_assistantdata_detail";
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u5b9a\u4e49\u4e2d\u7ef4\u5ea6\u5e94\u8be5\u9009\u62e9\u7ef4\u5ea6\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6216\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u7684\u7ef4\u5ea6\u3002", (String)"PaIncomeReportListPlugin_2", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet join(DataSet dataSet, DataSet right, String onLeftField, Set<String> dimnumberList) {
        try {
            JoinDataSetBuilder joinDataSet = (JoinDataSetBuilder)dataSet.join(right);
            joinDataSet.on(onLeftField, ID);
            dimnumberList.remove(onLeftField);
            joinDataSet.select(dimnumberList.toArray(new String[dimnumberList.size()]), new String[]{onLeftField});
            dimnumberList.add(onLeftField);
            DataSet dataSet2 = joinDataSet.finish();
            return dataSet2;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (right != null) {
                right.close();
            }
        }
    }

    private Map<String, DataSet> getDataSet(Map<String, Tuple2<String, QFilter[]>> numberEntityFilter) {
        Collection<Tuple2<String, QFilter[]>> values = numberEntityFilter.values();
        HashMap<String, DataSet> map = new HashMap<String, DataSet>(values.size());
        for (Map.Entry<String, Tuple2<String, QFilter[]>> next : numberEntityFilter.entrySet()) {
            String key = next.getKey();
            Tuple2<String, QFilter[]> value = next.getValue();
            DataSet rows = QueryServiceHelper.queryDataSet((String)this.logClassName, (String)((String)value.t1), (String)("id,name as " + key), (QFilter[])((QFilter[])value.t2), null);
            map.put(key, rows);
        }
        return map;
    }

    private List<String> resolveRule(Map<String, String> itemCalculationMap) {
        ArrayList<String> numbers = new ArrayList<String>(16);
        itemCalculationMap.forEach((k, v) -> {
            StringBuilder newCaculation = new StringBuilder();
            String[] split = v.trim().split("[+\\-\\*/\\(\\)\\s]+");
            for (int i = 0; i < split.length; ++i) {
                String number = split[i];
                if ("".equals(number)) continue;
                String newNumber = "[" + number + "]";
                String afterReplace = v.replaceFirst(number, newNumber);
                int index = afterReplace.indexOf(newNumber) + newNumber.length();
                newCaculation.append(afterReplace.substring(0, index));
                v = afterReplace.substring(index);
                numbers.add(number);
            }
            if (v.length() > 0) {
                newCaculation.append((String)v);
            }
            itemCalculationMap.put((String)k, newCaculation.toString());
        });
        return numbers;
    }

    private Map<String, List<Long>> changeNumber2Id(String entity, List<String> number) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(16);
        QFilter[] qFilters = new QFilter[]{new QFilter(NUMBER, "in", number)};
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.logClassName, (String)entity, (String)"id,number", (QFilter[])qFilters, null);
        while (queryDataSet.hasNext()) {
            Row next = queryDataSet.next();
            String numberKey = next.getString(NUMBER);
            Long idsValue = next.getLong(ID);
            map.merge(numberKey, new ArrayList<Long>(Collections.singletonList(idsValue)), (oldValue, n) -> {
                oldValue.addAll(n);
                return oldValue;
            });
        }
        return map;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (this.fileds == null || this.fileds.length == 1) {
            return columns;
        }
        ReportColumn column = new ReportColumn();
        column.setFieldKey(ResManager.loadKDString((String)"\u62a5\u8868\u9879", (String)"PaIncomeReportListPlugin_1", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
        column.setFieldType("text");
        column.setCurrencyField("reportItem");
        column.setZeroShow(true);
        column.setFreeze(true);
        column.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868\u9879", (String)"PaIncomeReportListPlugin_1", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0])));
        columns.add((AbstractReportColumn)column);
        List<Field> fields = Arrays.asList(this.fileds);
        ArrayList<String> fieldName = new ArrayList<String>(fields.size() - 1);
        for (int i = 1; i < fields.size(); ++i) {
            fieldName.add(fields.get(i).getName());
        }
        ColLevel colLevel = ColLevel.buildLevel(fieldName);
        List<ColLevel> children = colLevel.getChildren();
        for (ColLevel child : children) {
            AbstractReportColumn build = this.build(child);
            columns.add(build);
        }
        return columns;
    }

    private AbstractReportColumn build(ColLevel colLevel) {
        if (CollectionUtils.isEmpty(colLevel.getChildren())) {
            return this.addReportColumn(colLevel.getLongName(), colLevel.getName());
        }
        ReportColumnGroup reportColumnGroup1 = this.addReportColumnGroup(colLevel.getLongName(), colLevel.getName(), new AbstractReportColumn[0]);
        for (ColLevel child : colLevel.getChildren()) {
            AbstractReportColumn build = this.build(child);
            reportColumnGroup1.getChildren().add(build);
        }
        return reportColumnGroup1;
    }

    private ReportColumn addReportColumn(String columnKey, String columnCaption) {
        DecimalReportColumn col = new DecimalReportColumn();
        col.setFieldKey(columnKey);
        col.setCaption(new LocaleString(columnCaption));
        col.setHideSingleColumnRow(false);
        col.setFieldType("decimal");
        return col;
    }

    private ReportColumnGroup addReportColumnGroup(String groupKey, String groupCaption, AbstractReportColumn ... column) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(groupKey);
        group.setCaption(new LocaleString(groupCaption));
        group.setHideSingleColumnRow(false);
        for (int i = 0; i < column.length; ++i) {
            group.getChildren().add(column[i]);
        }
        return group;
    }

    public static class ColLevel {
        private String name;
        private String longName;
        private String parentName;
        private List<ColLevel> children = new ArrayList<ColLevel>(16);

        public ColLevel(String name, String parentName, String longName) {
            this.name = name;
            this.parentName = parentName;
            this.longName = longName;
        }

        public ColLevel() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColLevel colLevel = (ColLevel)o;
            return this.name.equals(colLevel.name) && this.longName.equals(colLevel.longName);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.longName);
        }

        private void buildChildren(List<ColLevel> colLevels) {
            for (ColLevel colLevel : colLevels) {
                if (colLevel.parentName.equals(this.longName)) {
                    this.children.add(colLevel);
                    continue;
                }
                for (ColLevel child : this.children) {
                    if (!colLevel.longName.startsWith(child.longName)) continue;
                    child.buildChildren(Collections.singletonList(colLevel));
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getLongName() {
            return this.longName;
        }

        public List<ColLevel> getChildren() {
            return this.children;
        }

        public static ColLevel buildLevel(List<String> longNames) {
            int index = 0;
            ArrayList<ColLevel> list = new ArrayList<ColLevel>(16);
            for (String longName : longNames) {
                ColLevel colLevel;
                while ((index = longName.lastIndexOf("!,!")) > -1) {
                    String name = longName.substring(index + 3);
                    String levelLongName = longName;
                    ColLevel colLevel2 = new ColLevel(name, longName = longName.substring(0, index), levelLongName);
                    if (list.contains(colLevel2)) continue;
                    list.add(colLevel2);
                }
                if ("".equals(longName) || list.contains(colLevel = new ColLevel(longName, "", longName))) continue;
                list.add(colLevel);
            }
            list.sort((a, b) -> a.longName.compareTo(b.longName));
            ColLevel colLevel = new ColLevel("", "", "");
            colLevel.buildChildren(list);
            return colLevel;
        }
    }

    private static class Report {
        String itemName;
        String colName;
        BigDecimal value;

        public Report(String itemName, String colName, BigDecimal value) {
            this.itemName = itemName;
            this.colName = colName;
            this.value = value;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getColName() {
            return this.colName;
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }
}

