/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PaIncomeReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final String ANALYSISMODEL = "analysismodel";
    public static final String FI_PA_FORMPLUGIN = "fi-pa-formplugin";
    public static final String ANALYSIS_SYSTEM = "analysis_system";
    private static Map<String, String> numberMapName = new HashMap<String, String>(5);
    protected static final String PERIOD = "period";
    public static final String INCOME = "income";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        List filterItems = queryParam.getFilter().getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItems)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u67e5\u8be2\u64cd\u4f5c\u3002", (String)"PaIncomeReportPlugin_3", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        List collect = filterItems.stream().filter(p -> p.getValue() == null).map(p -> numberMapName.get(p.getPropName())).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            DynamicObject dynamicObject = (DynamicObject)queryParam.getFilter().getFilterItem(ANALYSISMODEL).getValue();
            if (StringUtils.isEmpty((CharSequence)dynamicObject.getString("tablenumber"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"PaIncomeReportPlugin_4", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        String join = StringUtils.join(collect, (String)",");
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fc7\u6ee4\u6761\u4ef6:%s\u3002", (String)"PaIncomeReportPlugin_5", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]), join));
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "analysis_system": {
                if (newValue != null && this.needToChange((DynamicObject)newValue, ANALYSISMODEL, ANALYSIS_SYSTEM)) {
                    this.getModel().setValue(ANALYSISMODEL, null);
                }
                if (newValue == null || !this.needToChange((DynamicObject)newValue, INCOME, ANALYSIS_SYSTEM)) break;
                this.getModel().setValue(INCOME, null);
                break;
            }
            case "analysismodel": {
                if (newValue != null) {
                    this.getModel().setValue(ANALYSIS_SYSTEM, (Object)((DynamicObject)newValue).getLong("analysis_system_id"));
                }
                if (newValue == null || !this.needToChange((DynamicObject)newValue, INCOME, ANALYSISMODEL)) break;
                this.getModel().setValue(INCOME, null);
                break;
            }
            case "income": {
                if (newValue == null) break;
                this.getModel().setValue(ANALYSIS_SYSTEM, (Object)((DynamicObject)newValue).getLong("analysis_system_id"));
                this.getModel().setValue(ANALYSISMODEL, (Object)((DynamicObject)newValue).getLong("analysismodel_id"));
                break;
            }
            case "periodtype": {
                this.getModel().setValue(PERIOD, null);
                break;
            }
        }
    }

    private boolean needToChange(@NotNull DynamicObject newValue, @NotNull String bs, @NotNull String bsEntity) {
        DynamicObject value = (DynamicObject)this.getModel().getValue(bs);
        if (value == null) {
            return false;
        }
        DynamicObject bsEntity1 = value.getDynamicObject(bsEntity);
        long id = bsEntity1.getLong("id");
        return newValue.getLong("id") != id;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminorgEdit = (BasedataEdit)this.getView().getControl(ANALYSISMODEL);
        adminorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit income = (BasedataEdit)this.getView().getControl(INCOME);
        income.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getView().getControl(PERIOD);
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "analysismodel": {
                this.selectAnalysismodel(evt, ANALYSIS_SYSTEM);
                break;
            }
            case "income": {
                this.selectIncome(evt);
                break;
            }
            case "period": {
                this.mustSelectAnalysismodel(evt);
                break;
            }
        }
    }

    private void mustSelectAnalysismodel(BeforeF7SelectEvent evt) {
        DynamicObject model = (DynamicObject)this.getModel().getValue("periodtype");
        if (model != null) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("periodtype", "=", model.getPkValue()));
        }
    }

    private void selectAnalysismodel(BeforeF7SelectEvent evt, String filterName) {
        DynamicObject model = (DynamicObject)this.getModel().getValue(ANALYSIS_SYSTEM);
        if (model != null) {
            long id = model.getLong("id");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter(filterName, "=", (Object)id));
        }
    }

    private void selectIncome(BeforeF7SelectEvent evt) {
        DynamicObject analysisSystem = (DynamicObject)this.getModel().getValue(ANALYSIS_SYSTEM);
        DynamicObject analysismodel = (DynamicObject)this.getModel().getValue(ANALYSISMODEL);
        QFilter q = null;
        if (analysisSystem != null) {
            q = new QFilter(ANALYSIS_SYSTEM, "=", (Object)analysisSystem.getLong("id"));
        }
        if (analysismodel != null) {
            q = new QFilter(ANALYSISMODEL, "=", (Object)analysismodel.getLong("id"));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(q);
    }

    static {
        numberMapName.put(INCOME, ResManager.loadKDString((String)"\u62a5\u8868\u5b9a\u4e49", (String)"PaIncomeReportPlugin_0", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
        numberMapName.put("org", ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"PaIncomeReportPlugin_1", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
        numberMapName.put(PERIOD, ResManager.loadKDString((String)"\u671f\u95f4", (String)"PaIncomeReportPlugin_2", (String)FI_PA_FORMPLUGIN, (Object[])new Object[0]));
    }
}

