/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.control;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.dto.PADynamicEntryDTO;
import kd.fi.pa.helper.PAAnalysisModelHelper;

public class AdjustSourceEntryGrid
extends EntryGrid {
    private static final Log logger = LogFactory.getLog(AdjustSourceEntryGrid.class);
    private final PADynamicEntryDTO paDynamicEntryDTO;

    public AdjustSourceEntryGrid(PADynamicEntryDTO paDynamicEntryDTO) {
        this.paDynamicEntryDTO = paDynamicEntryDTO;
    }

    protected boolean onFetchPageData(int pageIndex, int pageRows) {
        try {
            int realTotalPageCount;
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(this.getKey());
            entryEntity.clear();
            String[][] columnsCopy = this.paDynamicEntryDTO.getColumns();
            String entityNumber = this.paDynamicEntryDTO.getEntityNumber();
            String fields = this.paDynamicEntryDTO.getFields();
            QFilter filter = QFilter.fromSerializedString((String)this.paDynamicEntryDTO.getqFilterStr());
            FilterGrid filterGrid = (FilterGrid)view.getControl("filtergridap");
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, true);
            filterBuilder.buildFilter(false);
            filterCondition.setFilter(filterBuilder.getFilterObject().getFilter());
            QFilter gridFilter = filterBuilder.getFilterObject().getQFilter();
            if (gridFilter != null) {
                filter.and(gridFilter);
            }
            String[][] filterColumn = (String[][])Arrays.stream(columnsCopy).filter(columnArr -> !"remark".equals(columnArr[1]) && !"valid".equals(columnArr[1])).collect(Collectors.toList()).toArray((T[])new String[0][0]);
            Object[][] dataArr = PAAnalysisModelHelper.queryModelSumPage((String[][])filterColumn, (String)entityNumber, (String)fields, (QFilter[])new QFilter[]{filter}, (int)0, (int)-1);
            int realStartRowIndex = pageIndex * pageRows > dataArr.length ? dataArr.length / pageRows * pageRows : (pageIndex - 1) * pageRows;
            int n = realTotalPageCount = dataArr.length % pageRows > 0 ? dataArr.length / pageRows + 1 : dataArr.length / pageRows;
            if (pageIndex > realTotalPageCount) {
                this.getEntryState().setCurrentPageIndex(Integer.valueOf(realTotalPageCount));
            }
            int rowIndex = 0;
            int hasBuildData = 0;
            for (Object[] data : dataArr) {
                if (rowIndex >= realStartRowIndex) {
                    DynamicObject entry = entryEntity.addNew();
                    for (int i = 0; i < data.length; ++i) {
                        entry.set(filterColumn[i][1], data[i]);
                    }
                    if (++hasBuildData >= pageRows) break;
                }
                ++rowIndex;
            }
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            dataEntityState.setEntryStartRowIndex(this.getKey(), realStartRowIndex);
            dataEntityState.setEntryPageSize(this.getKey(), pageRows);
            dataEntityState.setEntryRowCount(this.getKey(), dataArr.length);
        }
        catch (Exception exc) {
            logger.error("AdjustSourceEntryGrid onFetchPageData error", (Throwable)exc);
        }
        return true;
    }
}

