/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.dataquery;

import java.math.BigDecimal;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.fi.pa.utils.AlgoUtil;

public class SumQueryCalMapFunction
extends MapFunction {
    private static final long serialVersionUID = 7207934981255822604L;
    private static final BigDecimal MIN_VALUE = new BigDecimal(-999999999999999999L);
    private final RowMeta rowMeta;

    public SumQueryCalMapFunction(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    public Object[] map(Row row) {
        Object[] oldDataObj = AlgoUtil.rowToObjects((Row)row, (RowMeta)this.rowMeta);
        Object[] addDataObj = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        BigDecimal beforeAllocation = row.getBigDecimal("beforeallocation");
        BigDecimal send = row.getBigDecimal("send");
        BigDecimal receive = row.getBigDecimal("receive");
        BigDecimal afterAllocation = beforeAllocation.subtract(send).add(receive);
        int index = this.rowMeta.getFieldIndex("afterallocation");
        oldDataObj[index] = afterAllocation;
        addDataObj[0] = beforeAllocation.compareTo(BigDecimal.ZERO) == 0 ? MIN_VALUE : beforeAllocation;
        addDataObj[1] = send.compareTo(BigDecimal.ZERO) == 0 ? MIN_VALUE : send;
        addDataObj[2] = receive.compareTo(BigDecimal.ZERO) == 0 ? MIN_VALUE : receive;
        Object[] newDataObj = new Object[oldDataObj.length + addDataObj.length];
        System.arraycopy(oldDataObj, 0, newDataObj, 0, oldDataObj.length);
        System.arraycopy(addDataObj, 0, newDataObj, oldDataObj.length, addDataObj.length);
        return newDataObj;
    }

    public RowMeta getResultRowMeta() {
        Field beforeAllocationSortField = new Field("beforeallocationsort", (DataType)DataType.BigDecimalType);
        Field sendSortField = new Field("sendsort", (DataType)DataType.BigDecimalType);
        Field receiveSortField = new Field("receivesort", (DataType)DataType.BigDecimalType);
        Field[] fields = this.rowMeta.getFields();
        Field[] addFields = new Field[]{beforeAllocationSortField, sendSortField, receiveSortField};
        Field[] newFields = new Field[fields.length + addFields.length];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        System.arraycopy(addFields, 0, newFields, fields.length, addFields.length);
        return new RowMeta(newFields);
    }
}

