/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.dataquery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.enums.MultiOrgShareEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PARuleHelper;

public class SumQueryDataModel
implements Serializable {
    private static final long serialVersionUID = -2549509421408501608L;
    private Long analysisModelId;
    private Long businessRuleId;
    private Long ruleStepId;
    private Long measureId;
    private Long execLogId;
    private List<Long> orgIdList;
    private Long periodId;
    private List<Long> accountIdList;
    private String dimensionStr;
    private List<QFilter> commonQFilterList;
    private DynamicObject analysisModelDy = null;
    private DynamicObject businessRuleDy = null;
    private DynamicObject ruleStepDy = null;
    private DynamicObject measureDy = null;
    private Set<Long> accountSetData = null;
    private Set<String> dimSetData = null;
    private String orgDimNum;

    public SumQueryDataModel(ReportQueryParam reportQueryParam) {
        DynamicObjectCollection filterAccountDyCol;
        DynamicObject filterPeriodDy;
        DynamicObjectCollection filterOrgDyCol;
        String execLogIdStr;
        DynamicObject filterMeasureDy;
        DynamicObject filterStepDy;
        DynamicObject filterRuleDy;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject filterModelDy = filterInfo.getDynamicObject("analysismodel");
        if (filterModelDy != null) {
            this.analysisModelId = filterModelDy.getLong("id");
        }
        if ((filterRuleDy = filterInfo.getDynamicObject("businessrule")) != null) {
            this.businessRuleId = filterRuleDy.getLong("id");
        }
        if ((filterStepDy = filterInfo.getDynamicObject("rulestep")) != null) {
            this.ruleStepId = filterStepDy.getLong("id");
        }
        if ((filterMeasureDy = filterInfo.getDynamicObject("measure")) != null) {
            this.measureId = filterMeasureDy.getLong("id");
        }
        if (StringUtils.isNotEmpty((CharSequence)(execLogIdStr = filterInfo.getString("execlogid")))) {
            this.execLogId = Long.valueOf(execLogIdStr);
        }
        if ((filterOrgDyCol = filterInfo.getDynamicObjectCollection("org")) != null) {
            this.orgIdList = filterOrgDyCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        if ((filterPeriodDy = filterInfo.getDynamicObject("period")) != null) {
            this.periodId = filterPeriodDy.getLong("id");
        }
        if ((filterAccountDyCol = filterInfo.getDynamicObjectCollection("account")) != null) {
            this.accountIdList = filterAccountDyCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        this.dimensionStr = filterInfo.getString("dimension");
        this.commonQFilterList = new ArrayList(filterInfo.getCommFilter().values());
        this.init();
    }

    private void init() {
        this.analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.analysisModelId, (String)"pa_analysismodel");
        this.businessRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.businessRuleId, (String)"pa_businessrule");
        this.ruleStepDy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.ruleStepId, (String)"pa_sharerulenew");
        this.measureDy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.measureId, (String)"pa_measure");
        if (this.analysisModelDy != null) {
            this.orgDimNum = PAAnalysisModelHelper.getOrgDimNum((DynamicObject)this.analysisModelDy);
        }
    }

    public Long getAnalysisModelId() {
        return this.analysisModelId;
    }

    public Long getBusinessRuleId() {
        return this.businessRuleId;
    }

    public Long getRuleStepId() {
        return this.ruleStepId;
    }

    public Long getMeasureId() {
        return this.measureId;
    }

    public Long getExecLogId() {
        return this.execLogId;
    }

    public List<Long> getOrgIdList() {
        return this.orgIdList;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public List<Long> getAccountIdList() {
        return this.accountIdList;
    }

    public String getDimensionStr() {
        return this.dimensionStr;
    }

    public List<QFilter> getCommonQFilterList() {
        return this.commonQFilterList;
    }

    public DynamicObject getAnalysisModelDy() {
        return this.analysisModelDy;
    }

    public DynamicObject getBusinessRuleDy() {
        return this.businessRuleDy;
    }

    public DynamicObject getRuleStepDy() {
        return this.ruleStepDy;
    }

    public DynamicObject getMeasureDy() {
        return this.measureDy;
    }

    public Set<Long> getAccountSetData() {
        if (this.accountSetData == null) {
            this.accountSetData = this.processAccountSetData();
        }
        return this.accountSetData;
    }

    private Set<Long> processAccountSetData() {
        QFilter allocationRuleAccountFilter;
        QFilter businessRuleAccountFilter;
        if (this.analysisModelDy == null || this.businessRuleDy == null || this.ruleStepDy == null) {
            return new HashSet<Long>();
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        DynamicObject accountDimDy = PAAnalysisModelHelper.queryModelNecessityAccountDimension((Long)this.analysisModelId);
        DynamicObject dimDy = BusinessDataServiceHelper.loadSingleFromCache((Object)accountDimDy.get("dimension_entry.dimension.id"), (String)"pa_dimension");
        QFilter accountTypeFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)dimDy);
        if (accountTypeFilter != null) {
            qFilterList.add(accountTypeFilter);
        }
        if (this.accountIdList != null && !this.accountIdList.isEmpty()) {
            QFilter accountIdFilter = new QFilter("id", "in", this.accountIdList);
            qFilterList.add(accountIdFilter);
        }
        if ((businessRuleAccountFilter = PARuleHelper.getBusinessRuleAccountFilter((Long)this.businessRuleId, (Long)this.analysisModelId)) != null) {
            qFilterList.add(businessRuleAccountFilter);
        }
        if ((allocationRuleAccountFilter = PARuleHelper.getAllocationRuleAccountFilter((Long)this.ruleStepId, (Long)this.analysisModelId)) != null) {
            qFilterList.add(allocationRuleAccountFilter);
        }
        Map accountDyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (QFilter[])qFilterList.toArray(new QFilter[0]));
        this.accountSetData = accountDyMap.keySet().stream().map(pkId -> (Long)pkId).collect(Collectors.toSet());
        return this.accountSetData;
    }

    public Set<String> getDimSetData() {
        if (this.dimSetData == null) {
            this.dimSetData = this.processDimSetData();
        }
        return this.dimSetData;
    }

    private Set<String> processDimSetData() {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        MultiOrgShareEnum multiOrgShare = PARuleHelper.computeAllocationMultiOrgShare((Long)this.ruleStepId, (String)this.orgDimNum);
        if (MultiOrgShareEnum.YES == multiOrgShare) {
            DynamicObject orgDimDy = PAAnalysisModelHelper.queryModelNecessityOrgDimension((Long)this.analysisModelId);
            String orgNumber = orgDimDy.getString("dimension_entry.dimension.number") + ".name";
            fieldSet.add(orgNumber);
        }
        LinkedHashSet<String> dimSet = new LinkedHashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)this.dimensionStr)) {
            String[] dimNumbers;
            for (String dimNumber : dimNumbers = this.dimensionStr.split(",")) {
                if (!StringUtils.isNotEmpty((CharSequence)dimNumber)) continue;
                dimSet.add(dimNumber);
            }
        }
        if (dimSet.isEmpty()) {
            if (this.ruleStepId != null && this.ruleStepId != 0L) {
                List receiveDimIdList = PARuleHelper.getAllocationRuleReceiverDimList((Long)this.ruleStepId);
                Set dimNameSet = PAAnalysisModelHelper.getDimNameFieldSet((Long)this.analysisModelId, (List)receiveDimIdList);
                fieldSet.addAll(dimNameSet);
            }
        } else {
            fieldSet.addAll(dimSet);
        }
        return fieldSet;
    }
}

