/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.dataquery;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.pa.enums.DataStatusEnum;
import kd.fi.pa.utils.AlgoUtil;

public class SumQueryRateMapFunction
extends MapFunction {
    private static final long serialVersionUID = -8284178489227819447L;
    private final String measureNumber;
    private final RowMeta rowMeta;

    public SumQueryRateMapFunction(String measureNumber, RowMeta rowMeta) {
        this.measureNumber = measureNumber;
        this.rowMeta = rowMeta;
    }

    public Object[] map(Row row) {
        Object[] oldDataObj = AlgoUtil.rowToObjects((Row)row, (RowMeta)this.rowMeta);
        Object[] addDataObj = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        BigDecimal measureData = row.getBigDecimal(this.measureNumber);
        if (measureData == null) {
            measureData = BigDecimal.ZERO;
        }
        String dataStatus = row.getString("datastatus");
        if (StringUtils.equals((CharSequence)DataStatusEnum.ALLOCATE.getCodeString(), (CharSequence)dataStatus)) {
            addDataObj[2] = measureData;
        } else if (StringUtils.equals((CharSequence)DataStatusEnum.OFF_ALLOCATE.getCodeString(), (CharSequence)dataStatus)) {
            BigDecimal sendRateData = row.getBigDecimal("sendrate");
            addDataObj[0] = sendRateData == null || sendRateData.compareTo(BigDecimal.ZERO) == 0 || sendRateData.compareTo(new BigDecimal(100)) == 0 ? measureData.negate() : measureData.negate().multiply(new BigDecimal(100)).divide(sendRateData, 8, RoundingMode.HALF_UP);
            addDataObj[1] = measureData.negate();
        }
        Object[] newDataObj = new Object[oldDataObj.length + addDataObj.length];
        System.arraycopy(oldDataObj, 0, newDataObj, 0, oldDataObj.length);
        System.arraycopy(addDataObj, 0, newDataObj, oldDataObj.length, addDataObj.length);
        return newDataObj;
    }

    public RowMeta getResultRowMeta() {
        Field beforeAllocationField = new Field("beforeallocation", (DataType)DataType.BigDecimalType);
        Field sendField = new Field("send", (DataType)DataType.BigDecimalType);
        Field receiveField = new Field("receive", (DataType)DataType.BigDecimalType);
        Field afterAllocationField = new Field("afterallocation", (DataType)DataType.BigDecimalType);
        Field[] fields = this.rowMeta.getFields();
        Field[] addFields = new Field[]{beforeAllocationField, sendField, receiveField, afterAllocationField};
        Field[] newFields = new Field[fields.length + addFields.length];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        System.arraycopy(addFields, 0, newFields, fields.length, addFields.length);
        return new RowMeta(newFields);
    }
}

