/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.dataquery;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.IReportTreeModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportTree;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.pa.formplugin.dataquery.SumQueryReportFilter;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PALogHelper;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class SumQueryReportFormDataPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener,
SearchEnterListener {
    private static final Log logger = LogFactory.getLog(SumQueryReportFormDataPlugin.class);

    public void initialize() {
        this.getView().addCustomControls(new String[]{"reportfilterap"});
    }

    public void onGetControl(OnGetControlArgs e) {
        Control control;
        String key = e.getKey();
        if ("reportfilterap".equals(key) && (control = e.getControl()) != null && !(control instanceof SumQueryReportFilter)) {
            e.setControl((Control)SumQueryReportFilter.create((ReportFilter)control));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.resetSummaryDim();
        this.resetFilterCondition();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean mustInputResult;
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        boolean bl = mustInputResult = this.validateModel() && this.validateBusinessRule() && this.validateRuleStep() && this.validateMeasure() && this.validateOrg() && this.validatePeriod() && this.validateBatch();
        if (mustInputResult) {
            Long modelId = (Long)model.getValue("analysismodel_id");
            boolean modelExist = PAAnalysisModelHelper.isExist((Object)modelId);
            if (!modelExist) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"SumQueryReportFormDataPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            String execLogId = (String)model.getValue("execlogid");
            boolean logExist = QueryServiceHelper.exists((String)"pa_executionlog", (Object)Long.valueOf(execLogId));
            if (!logExist) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6267\u884c\u6279\u6b21\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SumQueryReportFormDataPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"execnumber"});
        BasedataEdit analysisModelEdit = (BasedataEdit)this.getControl("analysismodel");
        analysisModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit businessRuleEdit = (BasedataEdit)this.getControl("businessrule");
        businessRuleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleStepEdit = (BasedataEdit)this.getControl("rulestep");
        ruleStepEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit measureEdit = (BasedataEdit)this.getControl("measure");
        measureEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("period");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountEdit = (BasedataEdit)this.getControl("account");
        accountEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"execnumber", (CharSequence)key) && this.validateModel() && this.validateBusinessRule() && this.validateRuleStep()) {
            this.openExecLogF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"execLogF7", (CharSequence)actionId)) {
            ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)event.getReturnData();
            if (selectedRowCollection == null || selectedRowCollection.isEmpty()) {
                return;
            }
            ListSelectedRow selectedRow = selectedRowCollection.get(0);
            Long execLogId = (Long)selectedRow.getPrimaryKeyValue();
            QFilter idFilter = new QFilter("id", "=", (Object)execLogId);
            DynamicObject logDy = QueryServiceHelper.queryOne((String)"pa_executionlog", (String)"id,number", (QFilter[])new QFilter[]{idFilter});
            this.getModel().setValue("execnumber", (Object)logDy.getString("number"));
            this.getModel().setValue("execlogid", (Object)logDy.getLong("id"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataModel model = this.getModel();
        String fieldKey = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)fieldKey)) {
            List modelIdList = PAAnalysisModelHelper.getSummaryQueryModelIdList();
            evt.addCustomQFilter(new QFilter("id", "in", (Object)modelIdList));
            return;
        }
        if (StringUtils.equals((CharSequence)"businessrule", (CharSequence)fieldKey)) {
            if (!this.validateModel()) {
                evt.setCancel(true);
                return;
            }
            HasPermOrgResult permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)"pa", (String)"pa_businessrule", (String)"47150e89000000ac");
            if (!permOrgResult.hasAllOrgPerm()) {
                List orgIdList = permOrgResult.getHasPermOrgs();
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pa_businessrule", (List)orgIdList, (boolean)true);
                evt.addCustomQFilter(baseDataFilter);
            }
            Long modelId = (Long)model.getValue("analysismodel_id");
            evt.addCustomQFilter(new QFilter("analysismodel", "=", (Object)modelId));
            return;
        }
        if (StringUtils.equals((CharSequence)"rulestep", (CharSequence)fieldKey)) {
            if (!this.validateModel()) {
                evt.setCancel(true);
                return;
            }
            if (!this.validateBusinessRule()) {
                evt.setCancel(true);
                return;
            }
            Long businessRuleId = (Long)model.getValue("businessrule_id");
            List allocationRuleIdList = PARuleHelper.getAllocationRuleIdList((Long)businessRuleId);
            evt.addCustomQFilter(new QFilter("id", "in", (Object)allocationRuleIdList));
            return;
        }
        if (StringUtils.equals((CharSequence)"measure", (CharSequence)fieldKey)) {
            if (!this.validateModel()) {
                evt.setCancel(true);
                return;
            }
            if (!this.validateBusinessRule()) {
                evt.setCancel(true);
                return;
            }
            if (!this.validateRuleStep()) {
                evt.setCancel(true);
                return;
            }
            Long ruleStepId = (Long)model.getValue("rulestep_id");
            DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleStepId, (String)"pa_sharerulenew");
            if (allocationRuleDy != null) {
                DynamicObjectCollection measureDyCol = allocationRuleDy.getDynamicObjectCollection("mulbasedatafield");
                List measureIdList = measureDyCol.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                evt.addCustomQFilter(new QFilter("id", "in", measureIdList));
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"org", (CharSequence)fieldKey)) {
            Long modelId;
            Long ruleStepId;
            QFilter orgFilter;
            if (!this.validateModel()) {
                evt.setCancel(true);
                return;
            }
            if (!this.validateBusinessRule()) {
                evt.setCancel(true);
                return;
            }
            if (!this.validateRuleStep()) {
                evt.setCancel(true);
                return;
            }
            HasPermOrgResult permResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)"pa", (String)"pa_sumquery", (String)"47150e89000000ac");
            if (!permResult.hasAllOrgPerm()) {
                List orgIdList = permResult.getHasPermOrgs();
                evt.addCustomQFilter(new QFilter("id", "in", (Object)orgIdList));
            }
            if ((orgFilter = PARuleHelper.getAllocationRuleOrgFilter((Long)(ruleStepId = (Long)model.getValue("rulestep_id")), (Long)(modelId = (Long)model.getValue("analysismodel_id")))) != null) {
                evt.addCustomQFilter(orgFilter);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"period", (CharSequence)fieldKey)) {
            Long modelId;
            if (!this.validateModel()) {
                evt.setCancel(true);
                return;
            }
            if (!this.validateBusinessRule()) {
                evt.setCancel(true);
                return;
            }
            Long businessRuleId = (Long)model.getValue("businessrule_id");
            QFilter periodFilter = PARuleHelper.getBusinessRulePeriodFilter((Long)businessRuleId, (Long)(modelId = (Long)model.getValue("analysismodel_id")));
            if (periodFilter != null) {
                evt.addCustomQFilter(periodFilter);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"account", (CharSequence)fieldKey)) {
            if (!this.validateModel()) {
                evt.setCancel(true);
                return;
            }
            Long modelId = (Long)model.getValue("analysismodel_id");
            DynamicObject accountDimDy = PAAnalysisModelHelper.queryModelNecessityAccountDimension((Long)modelId);
            DynamicObject dimDy = BusinessDataServiceHelper.loadSingleFromCache((Object)accountDimDy.get("dimension_entry.dimension.id"), (String)"pa_dimension");
            QFilter accountTypeFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)dimDy);
            if (accountTypeFilter != null) {
                evt.addCustomQFilter(accountTypeFilter);
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        QFilter systemFilter;
        QFilter numberFilter;
        DynamicObject dimDy;
        QFilter dimGroupFilter;
        Long modelId;
        DynamicObject modelDy;
        String[] fieldNameSplit = evt.getFieldName().split("\\.");
        if (fieldNameSplit.length == 2 && (modelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)(modelId = (Long)this.getModel().getValue("analysismodel_id")), (String)"pa_analysismodel")) != null && (dimGroupFilter = PADimensionHelper.getDimGroupFilter((DynamicObject)(dimDy = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{numberFilter = new QFilter("number", "=", (Object)fieldNameSplit[0]), systemFilter = new QFilter("system", "=", modelDy.getDynamicObject("analysis_system").getPkValue())})))) != null) {
            evt.addCustomQFilter(dimGroupFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"analysismodel", (CharSequence)name)) {
            model.setValue("businessrule", null);
            model.setValue("account", null);
            this.processSummaryDim();
            this.processFilterCondition();
            return;
        }
        if (StringUtils.equals((CharSequence)"businessrule", (CharSequence)name)) {
            model.setValue("rulestep", null);
            model.setValue("period", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"rulestep", (CharSequence)name)) {
            model.setValue("org", null);
            this.processMeasure();
            this.processExecNumber();
        }
        if (StringUtils.equals((CharSequence)"execnumber", (CharSequence)name) && StringUtils.isEmpty((CharSequence)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            model.setValue("execlogid", null);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.resetPageCache();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"reset", (CharSequence)operateKey)) {
            this.resetSummaryDim();
            this.resetFilterCondition();
        }
    }

    public void search(SearchEnterEvent evt) {
        List dataTreeNodeList;
        IReportView view = this.getView();
        String searchText = evt.getText();
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SumQueryReportFormDataPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportTree reportTree = (ReportTree)this.getControl("reporttreeap");
        IReportTreeModel reportModel = reportTree.getReportModel();
        List treeNodeList = reportModel.getTreeModel().getNodes();
        Map<String, List<TreeNode>> treeNodeMap = treeNodeList.stream().collect(Collectors.groupingBy(TreeNode::getParentid));
        for (TreeNode treeNode2 : treeNodeList) {
            String id = treeNode2.getId();
            List<TreeNode> childTreeNodeList = treeNodeMap.get(id);
            if (childTreeNodeList == null || childTreeNodeList.isEmpty()) continue;
            treeNode2.setChildren(childTreeNodeList);
        }
        List matchTreeNodeList = treeNodeList.stream().filter(treeNode -> treeNode.getText().contains(searchText) && !StringUtils.equals((CharSequence)treeNode.getId(), (CharSequence)"-1")).collect(Collectors.toList());
        TreeNode rootTreeNode = treeNodeList.stream().filter(treeNode -> StringUtils.equals((CharSequence)treeNode.getId(), (CharSequence)"-1")).findAny().orElse(null);
        IPageCache pageCache = view.getPageCache();
        String pageId = pageCache.getPageId();
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String searchIndexCacheKey = pageId + "_searchIndex";
        String matchNodesCacheKey = pageId + "_matchNodes";
        String searchNodesCacheKey = pageId + "_searchNodes";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (StringUtils.isNotEmpty((CharSequence)oldSearchText) && !StringUtils.equals((CharSequence)oldSearchText, (CharSequence)searchText) || StringUtils.isEmpty((CharSequence)matchNodesCache)) {
            dataTreeNodeList = matchTreeNodeList;
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(dataTreeNodeList));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(dataTreeNodeList));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            dataTreeNodeList = StringUtils.isEmpty((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (dataTreeNodeList.isEmpty()) {
            dataTreeNodeList = matchTreeNodeList;
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)dataTreeNodeList));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)dataTreeNodeList));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6709\u6ca1\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"SumQueryReportFormDataPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        } else {
            String indexStr = pageCache.get(searchIndexCacheKey);
            if (StringUtils.isNotEmpty((CharSequence)indexStr)) {
                int index = Integer.parseInt(indexStr);
                if (index == dataTreeNodeList.size()) {
                    index = 0;
                }
                this.focusTreeNode(reportTree, rootTreeNode, (TreeNode)dataTreeNodeList.get(index));
                pageCache.put(searchIndexCacheKey, String.valueOf(++index));
            } else {
                this.focusTreeNode(reportTree, rootTreeNode, (TreeNode)dataTreeNodeList.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)dataTreeNodeList));
        }
    }

    private boolean validateModel() {
        DynamicObject analysisModelDy = (DynamicObject)this.getModel().getValue("analysismodel");
        if (analysisModelDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"SumQueryReportFormDataPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateBusinessRule() {
        DynamicObject businessRuleDy = (DynamicObject)this.getModel().getValue("businessrule");
        if (businessRuleDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u89c4\u5219\u3002", (String)"SumQueryReportFormDataPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateRuleStep() {
        DynamicObject ruleStepDy = (DynamicObject)this.getModel().getValue("rulestep");
        if (ruleStepDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219\u6b65\u9aa4\u3002", (String)"SumQueryReportFormDataPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateMeasure() {
        DynamicObject measureDy = (DynamicObject)this.getModel().getValue("measure");
        if (measureDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u644a\u5ea6\u91cf\u503c\u3002", (String)"SumQueryReportFormDataPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateOrg() {
        DynamicObjectCollection orgDyCol = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgDyCol == null || orgDyCol.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"SumQueryReportFormDataPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validatePeriod() {
        DynamicObject periodDy = (DynamicObject)this.getModel().getValue("period");
        if (periodDy == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"SumQueryReportFormDataPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateBatch() {
        String execNumber = (String)this.getModel().getValue("execnumber");
        String execLogId = (String)this.getModel().getValue("execlogid");
        if (StringUtils.isEmpty((CharSequence)execNumber) || StringUtils.isEmpty((CharSequence)execLogId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6267\u884c\u6279\u6b21\u3002", (String)"SumQueryReportFormDataPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<ComboItem> createComboItemList(Map<String, String> map) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(entry.getValue()));
            comboItem.setValue(entry.getKey());
            comboItemList.add(comboItem);
        }
        return comboItemList;
    }

    private List<Map<String, Object>> createCommonFilter(String modelNumber, Set<String> dimNumberSet) {
        if (dimNumberSet == null || dimNumberSet.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        LinkedHashMap<String, Map> colMap = new LinkedHashMap<String, Map>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)modelNumber);
        List filterColumnList = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        for (Map filterColumnMap : filterColumnList) {
            String fieldName = (String)filterColumnMap.get("fieldName");
            if (dimNumberSet.contains(fieldName)) {
                colMap.put(fieldName, filterColumnMap);
                continue;
            }
            int charIndex = fieldName.indexOf(46);
            String baseFieldNumber = charIndex > -1 ? fieldName.substring(0, charIndex) : fieldName;
            if (!dimNumberSet.contains(baseFieldNumber)) continue;
            colMap.put(fieldName, filterColumnMap);
        }
        return new ArrayList<Map<String, Object>>(colMap.values());
    }

    private void processMeasure() {
        IDataModel model = this.getModel();
        Long ruleStepId = (Long)model.getValue("rulestep_id");
        DynamicObject allocationRuleDy = BusinessDataServiceHelper.loadSingleFromCache((Object)ruleStepId, (String)"pa_sharerulenew");
        if (allocationRuleDy == null) {
            model.setValue("measure", null);
            return;
        }
        DynamicObjectCollection measureDyCol = allocationRuleDy.getDynamicObjectCollection("mulbasedatafield");
        if (measureDyCol == null || measureDyCol.isEmpty()) {
            model.setValue("measure", null);
            return;
        }
        Long measureId = measureDyCol.stream().map(dy -> dy.getLong("fbasedataid.id")).findFirst().orElse(0L);
        model.setValue("measure", (Object)measureId);
    }

    private void processExecNumber() {
        IDataModel model = this.getModel();
        Long modelId = (Long)this.getModel().getValue("analysismodel_id");
        Long businessRuleId = (Long)model.getValue("businessrule_id");
        Long ruleStepId = (Long)model.getValue("rulestep_id");
        if (modelId == null || modelId == 0L) {
            model.setValue("execnumber", null);
            return;
        }
        if (businessRuleId == null || businessRuleId == 0L) {
            model.setValue("execnumber", null);
            return;
        }
        if (ruleStepId == null || ruleStepId == 0L) {
            model.setValue("execnumber", null);
            return;
        }
        List execLogIdList = PALogHelper.getExecLogIdList((Long)modelId, (Long)businessRuleId);
        QFilter idFilter = new QFilter("id", "in", (Object)execLogIdList);
        DynamicObjectCollection execLogDyCol = QueryServiceHelper.query((String)"pa_executionlog", (String)"id,number", (QFilter[])new QFilter[]{idFilter}, (String)"execution_time desc", (int)1);
        if (execLogDyCol == null || execLogDyCol.isEmpty()) {
            model.setValue("execnumber", null);
            return;
        }
        DynamicObject execLogDy = (DynamicObject)execLogDyCol.get(0);
        model.setValue("execnumber", (Object)execLogDy.getString("number"));
        model.setValue("execlogid", (Object)execLogDy.getLong("id"));
    }

    private void processSummaryDim() {
        IDataModel model = this.getModel();
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("dimension");
        Long modelId = (Long)model.getValue("analysismodel_id");
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            model.setValue("dimension", null);
            mulComboEdit.setComboItems(new ArrayList());
            return;
        }
        Map dimFieldMap = PAAnalysisModelHelper.getDimFieldMap((Long)modelId);
        List<ComboItem> comboItemList = this.createComboItemList(dimFieldMap);
        model.setValue("dimension", null);
        mulComboEdit.setComboItems(comboItemList);
    }

    private void processFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        Long modelId = (Long)this.getModel().getValue("analysismodel_id");
        DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
        if (analysisModelDy == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            this.getView().updateView("filtergridap");
            return;
        }
        String modelNumber = AnalysisModelUtil.buildEntityNumber((String)analysisModelDy.getString("tablenumber"));
        Set dimNumberList = PAAnalysisModelHelper.getNoNecDimNumberList((Long)modelId);
        List<Map<String, Object>> commonFilterList = this.createCommonFilter(modelNumber, dimNumberList);
        filterGrid.SetValue(new FilterCondition());
        filterGrid.setEntityNumber(modelNumber);
        filterGrid.setFilterColumns(commonFilterList);
        this.getView().updateView("filtergridap");
    }

    private void resetSummaryDim() {
        IDataModel model = this.getModel();
        MulComboEdit mulComboEdit = (MulComboEdit)this.getControl("dimension");
        Long modelId = (Long)model.getValue("analysismodel_id");
        if (modelId == null || modelId == 0L) {
            model.setValue("dimension", null);
            mulComboEdit.setComboItems(new ArrayList());
            return;
        }
        boolean exist = PAAnalysisModelHelper.isExist((Object)modelId);
        if (exist) {
            Map dimFieldMap = PAAnalysisModelHelper.getDimFieldMap((Long)modelId);
            List<ComboItem> comboItemList = this.createComboItemList(dimFieldMap);
            mulComboEdit.setComboItems(comboItemList);
        } else {
            model.setValue("dimension", null);
            mulComboEdit.setComboItems(new ArrayList());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"SumQueryReportFormDataPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    private void resetFilterCondition() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        Long modelId = (Long)this.getModel().getValue("analysismodel_id");
        if (modelId == null || modelId == 0L) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            this.getView().updateView("filtergridap");
            return;
        }
        boolean exist = PAAnalysisModelHelper.isExist((Object)modelId);
        if (exist) {
            DynamicObject analysisModelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"pa_analysismodel");
            String modelNumber = AnalysisModelUtil.buildEntityNumber((String)analysisModelDy.getString("tablenumber"));
            Set dimNumberList = PAAnalysisModelHelper.getNoNecDimNumberList((Long)modelId);
            List<Map<String, Object>> commonFilterList = this.createCommonFilter(modelNumber, dimNumberList);
            filterGrid.setEntityNumber(modelNumber);
            filterGrid.setFilterColumns(commonFilterList);
            this.getView().updateView("filtergridap");
        } else {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            this.getView().updateView("filtergridap");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u8fd8\u6ca1\u6709\u6570\u636e\u8868\uff0c\u8bf7\u5148\u5efa\u8868\u3002", (String)"SumQueryReportFormDataPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    private void focusTreeNode(ReportTree reportTree, TreeNode rootNode, TreeNode treeNode) {
        this.expandParentTreeNodes(reportTree, rootNode, treeNode);
        reportTree.showNode(treeNode.getParentid());
        reportTree.focusNode(treeNode);
        reportTree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParentTreeNodes(ReportTree reportTree, TreeNode rootNode, TreeNode treeNode) {
        String parentId = treeNode.getParentid();
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            TreeNode pTreeNode = rootNode.getTreeNode(parentId);
            if (pTreeNode != null) {
                this.expandParentTreeNodes(reportTree, rootNode, pTreeNode);
                reportTree.expand(parentId);
                if (pTreeNode == rootNode) {
                    reportTree.updateNode(treeNode);
                }
            } else {
                reportTree.updateNode(treeNode);
            }
        } else {
            reportTree.updateNode(treeNode);
        }
    }

    private void resetPageCache() {
        IPageCache pageCache = this.getView().getPageCache();
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        pageCache.put(matchNodesCacheKey, null);
        pageCache.put(searchNodesCacheKey, null);
        pageCache.put(searchIndexCacheKey, String.valueOf(0));
    }

    private void openExecLogF7() {
        List execLogIdList;
        IDataModel model = this.getModel();
        Long modelId = (Long)this.getModel().getValue("analysismodel_id");
        Long businessRuleId = (Long)model.getValue("businessrule_id");
        ListShowParameter lsp = CoreShowFormHelper.createShowListForm((String)"pa_executionlog", (boolean)false);
        lsp.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7\u5217\u8868", (String)"SumQueryReportFormDataPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        lsp.setShowTitle(false);
        lsp.setLookUp(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580px");
        styleCss.setWidth("960px");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.getOpenStyle().setInlineStyleCss(styleCss);
        String execLogId = (String)this.getModel().getValue("execlogid");
        if (StringUtils.isNotEmpty((CharSequence)execLogId)) {
            lsp.setSelectedRow((Object)execLogId);
        }
        if ((execLogIdList = PALogHelper.getExecLogIdList((Long)modelId, (Long)businessRuleId)).isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u89c4\u5219\u672a\u6267\u884c\u8fc7\u6216\u6267\u884c\u65e5\u5fd7\u88ab\u5220\u9664\u3002", (String)"SumQueryReportFormDataPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)execLogIdList);
        lsp.getListFilterParameter().setFilter(idFilter);
        lsp.getListFilterParameter().setOrderBy("execution_time desc");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "execLogF7"));
        this.getView().showForm((FormShowParameter)lsp);
    }
}

