/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.dataquery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.MapFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TextReportColumn;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.dataquery.SumQueryAccountMapFunction;
import kd.fi.pa.formplugin.dataquery.SumQueryCalMapFunction;
import kd.fi.pa.formplugin.dataquery.SumQueryDataModel;
import kd.fi.pa.formplugin.dataquery.SumQueryRateMapFunction;
import kd.fi.pa.helper.AccountHelper;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.utils.AnalysisModelUtil;

public class SumQueryReportListDataPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(SumQueryReportListDataPlugin.class);
    private SumQueryDataModel sumQueryDataModel;

    public Map<String, String> getOriginalFixedColumn() {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>(8);
        tmp.put("beforeallocation", ResManager.loadKDString((String)"\u5206\u644a\u524d\u6570\u636e", (String)"SumQueryReportListDataPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        tmp.put("send", ResManager.loadKDString((String)"\u53d1\u9001\u6570\u636e", (String)"SumQueryReportListDataPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        tmp.put("receive", ResManager.loadKDString((String)"\u63a5\u6536\u6570\u636e", (String)"SumQueryReportListDataPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        tmp.put("afterallocation", ResManager.loadKDString((String)"\u5206\u644a\u540e\u6570\u636e", (String)"SumQueryReportListDataPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        return Collections.unmodifiableMap(tmp);
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object selectedTreeNode) throws Throwable {
        try {
            this.sumQueryDataModel = new SumQueryDataModel(reportQueryParam);
            String[] groupField = this.getGroupFields(this.sumQueryDataModel);
            boolean isExclude = this.isExcludeAccountDim(this.sumQueryDataModel);
            Map<String, Object> accountMap = this.getAccountMap(this.sumQueryDataModel, selectedTreeNode);
            DataSet summaryDataSet = this.getSummaryDataSet(this.sumQueryDataModel, selectedTreeNode);
            DataSet detailDataSet = this.getDetailDataSet(this.sumQueryDataModel);
            DataSet logDataSet = this.getLogDataSet(this.sumQueryDataModel);
            DataSet joinLogDataSet = detailDataSet.join(logDataSet, JoinType.INNER).on("subexeclogid", "logid").select(detailDataSet.getRowMeta().getFieldNames(), logDataSet.getRowMeta().getFieldNames()).finish();
            DataSet joinSummaryDataSet = joinLogDataSet.join(summaryDataSet, JoinType.INNER).on("execparentbillid", "summaryid").select(joinLogDataSet.getRowMeta().getFieldNames(), summaryDataSet.getRowMeta().getFieldNames()).finish();
            DataSet accountDataSet = joinSummaryDataSet.map((MapFunction)new SumQueryAccountMapFunction(isExclude, accountMap, joinSummaryDataSet.getRowMeta()));
            DataSet rateDataSet = accountDataSet.map((MapFunction)new SumQueryRateMapFunction(this.sumQueryDataModel.getMeasureDy().getString("number"), accountDataSet.getRowMeta()));
            DataSet groupDataSet = rateDataSet.groupBy(groupField).sum("beforeallocation").sum("send").sum("receive").sum("afterallocation").finish();
            return groupDataSet.map((MapFunction)new SumQueryCalMapFunction(groupDataSet.getRowMeta())).orderBy(new String[]{"beforeallocationsort desc", "sendsort desc", "receivesort desc"});
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"SumQueryReportListDataPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), ex.getMessage())});
        }
    }

    private List<AbstractReportColumn> fixedColumnListBuild(int precision) {
        return this.getOriginalFixedColumn().entrySet().stream().map(entry -> {
            DecimalReportColumn column = new DecimalReportColumn();
            column.setFieldType("decimal");
            column.setScale(precision);
            column.setSummary(1);
            column.setZeroShow(true);
            column.setFieldKey((String)entry.getKey());
            column.setCaption(new LocaleString((String)entry.getValue()));
            return column;
        }).collect(Collectors.toList());
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> fixedColumnList) throws Throwable {
        try {
            Long analysisModelId = this.sumQueryDataModel.getAnalysisModelId();
            Map dimFieldDyMap = PAAnalysisModelHelper.getDimFieldDyMap((Long)analysisModelId);
            Map dimFieldMap = PAAnalysisModelHelper.getDimFieldMap((Long)analysisModelId);
            DynamicObject measureDy = this.sumQueryDataModel.getMeasureDy();
            int precision = 2;
            if (measureDy.getDataEntityType().getProperties().get((Object)"precision") != null) {
                precision = measureDy.getInt("precision");
            }
            fixedColumnList = this.fixedColumnListBuild(precision);
            ArrayList<AbstractReportColumn> columnList = new ArrayList<AbstractReportColumn>();
            Set<String> dimSetData = this.sumQueryDataModel.getDimSetData();
            block5: for (String dimNumber : dimSetData) {
                String dimName = (String)dimFieldMap.get(dimNumber);
                DynamicObject dimDy = (DynamicObject)dimFieldDyMap.get(dimNumber);
                if (dimDy == null) continue;
                DimensionTypeEnum dimensionTypeEnum = DimensionTypeEnum.getEnum((String)dimDy.getString("dimensiontype"));
                switch (dimensionTypeEnum) {
                    case DENUMS: {
                        List<ValueMapItem> comboItems = dimDy.getDynamicObjectCollection("entryentityenums").stream().map(dy -> new ValueMapItem(null, dy.getString("value"), new LocaleString(dy.getString("title")))).collect(Collectors.toList());
                        columnList.add(this.createComboColumn(dimNumber, dimName, comboItems));
                        continue block5;
                    }
                }
                columnList.add(this.createTextColumn(dimNumber, dimName, false, false));
            }
            if (columnList.isEmpty()) {
                return fixedColumnList;
            }
            columnList.addAll(fixedColumnList);
            return columnList;
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5217\u6784\u5efa\u5931\u8d25\uff1a%s", (String)"SumQueryReportListDataPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), ex.getMessage())});
        }
    }

    private DataSet getSummaryDataSet(SumQueryDataModel sumQueryDataModel, Object selectedTreeNode) {
        String entityNumber = AnalysisModelUtil.buildEntityNumber((String)sumQueryDataModel.getAnalysisModelDy().getString("tablenumber"));
        String selectFields = "id summaryid";
        QFilter[] qFilters = this.getSummaryQFilters(sumQueryDataModel, selectedTreeNode);
        return QueryServiceHelper.queryDataSet((String)"SumQuery.SummaryDataSet", (String)entityNumber, (String)selectFields, (QFilter[])qFilters, null);
    }

    private QFilter[] getSummaryQFilters(SumQueryDataModel sumQueryDataModel, Object selectedTreeNode) {
        String selectedTreeNodeStr;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        List<Long> orgIdList = sumQueryDataModel.getOrgIdList();
        Long periodId = sumQueryDataModel.getPeriodId();
        Long analysisModelId = sumQueryDataModel.getAnalysisModelId();
        Set<Long> accountIdSet = sumQueryDataModel.getAccountSetData();
        List<QFilter> commonQFilterList = sumQueryDataModel.getCommonQFilterList();
        if (orgIdList != null && !orgIdList.isEmpty()) {
            DynamicObject orgDimDy = PAAnalysisModelHelper.queryModelNecessityOrgDimension((Long)analysisModelId);
            QFilter orgFilter = new QFilter(orgDimDy.getString("dimension_entry.dimension.number"), "in", orgIdList);
            qFilterList.add(orgFilter);
        }
        if (periodId != null && periodId != 0L) {
            DynamicObject periodDimDy = PAAnalysisModelHelper.queryModelNecessityTimeDimension((Long)analysisModelId);
            QFilter periodFilter = new QFilter(periodDimDy.getString("dimension_entry.dimension.number"), "=", (Object)periodId);
            qFilterList.add(periodFilter);
        }
        if (!StringUtils.isEmpty((CharSequence)(selectedTreeNodeStr = (String)selectedTreeNode))) {
            DynamicObject accountDimDy = PAAnalysisModelHelper.queryModelNecessityAccountDimension((Long)analysisModelId);
            if (StringUtils.equals((CharSequence)"-1", (CharSequence)selectedTreeNodeStr)) {
                Set parentAccountIdSet = AccountHelper.getAllParentIds(accountIdSet);
                Set childAccountIdSet = AccountHelper.getAllChildIds(accountIdSet);
                HashSet<Long> idSet = new HashSet<Long>();
                idSet.addAll(accountIdSet);
                idSet.addAll(parentAccountIdSet);
                idSet.addAll(childAccountIdSet);
                QFilter accountFilter = new QFilter(accountDimDy.getString("dimension_entry.dimension.number"), "in", idSet);
                qFilterList.add(accountFilter);
            } else {
                Set<Long> selectedIdSet = Collections.singleton(Long.valueOf(selectedTreeNodeStr));
                Set childAccountIdSet = AccountHelper.getAllChildIds(selectedIdSet);
                HashSet<Long> idSet = new HashSet<Long>();
                idSet.addAll(selectedIdSet);
                idSet.addAll(childAccountIdSet);
                QFilter accountFilter = new QFilter(accountDimDy.getString("dimension_entry.dimension.number"), "in", idSet);
                qFilterList.add(accountFilter);
            }
        }
        if (commonQFilterList != null && !commonQFilterList.isEmpty()) {
            qFilterList.addAll(commonQFilterList);
        }
        return qFilterList.toArray(new QFilter[0]);
    }

    private DataSet getDetailDataSet(SumQueryDataModel sumQueryDataModel) {
        String entityNumber = AnalysisModelUtil.buildDetailEntityNumber((String)sumQueryDataModel.getAnalysisModelDy().getString("tablenumber"));
        String selectFields = this.getDetailSelectFields(sumQueryDataModel);
        QFilter[] qFilters = this.getDetailQFilters(sumQueryDataModel);
        return QueryServiceHelper.queryDataSet((String)"SumQuery.DetailDataSet", (String)entityNumber, (String)selectFields, (QFilter[])qFilters, null);
    }

    private String getDetailSelectFields(SumQueryDataModel sumQueryDataModel) {
        HashSet<String> fieldSet = new HashSet<String>();
        Set<String> dimSetData = sumQueryDataModel.getDimSetData();
        fieldSet.addAll(dimSetData);
        Set dimPKFieldSet = PAAnalysisModelHelper.getDimPkFieldSet(dimSetData);
        fieldSet.addAll(dimPKFieldSet);
        DynamicObject measureDy = sumQueryDataModel.getMeasureDy();
        String measureNumber = measureDy.getString("number");
        fieldSet.add(measureNumber);
        HashSet<String> extraSet = new HashSet<String>();
        extraSet.add("id");
        extraSet.add("execparentbillid");
        extraSet.add("subexeclogid");
        extraSet.add("datastatus");
        fieldSet.addAll(extraSet);
        return String.join((CharSequence)",", fieldSet);
    }

    private QFilter[] getDetailQFilters(SumQueryDataModel sumQueryDataModel) {
        QFilter logPkFilter = new QFilter("execution_logpk", "=", (Object)sumQueryDataModel.getExecLogId());
        QFilter rulePkFilter = new QFilter("rule_pk", "=", (Object)sumQueryDataModel.getRuleStepId());
        QFilter ruleTypeFilter = new QFilter("rule_type", "=", (Object)"B");
        QFilter execStatusFilter = new QFilter("execution_status", "=", (Object)"2");
        List subExecLogIdList = QueryServiceHelper.queryPrimaryKeys((String)"SumQuery.LogDataSet", (String)"pa_ruleexeclog", (QFilter[])new QFilter[]{logPkFilter, rulePkFilter, ruleTypeFilter, execStatusFilter}, null, (int)-1);
        QFilter execLogFilter = new QFilter("execlogid", "=", (Object)sumQueryDataModel.getExecLogId());
        QFilter subExecLogFilter = new QFilter("subexeclogid", "in", (Object)subExecLogIdList);
        return new QFilter[]{execLogFilter, subExecLogFilter};
    }

    private DataSet getLogDataSet(SumQueryDataModel sumQueryDataModel) {
        QFilter logPkFilter = new QFilter("execution_logpk", "=", (Object)sumQueryDataModel.getExecLogId());
        QFilter rulePkFilter = new QFilter("rule_pk", "=", (Object)sumQueryDataModel.getRuleStepId());
        QFilter ruleTypeFilter = new QFilter("rule_type", "=", (Object)"B");
        QFilter execStatusFilter = new QFilter("execution_status", "=", (Object)"2");
        return QueryServiceHelper.queryDataSet((String)"SumQuery.LogDataSet", (String)"pa_ruleexeclog", (String)"id logid,sendrate", (QFilter[])new QFilter[]{logPkFilter, rulePkFilter, ruleTypeFilter, execStatusFilter}, null);
    }

    private boolean isExcludeAccountDim(SumQueryDataModel sumQueryDataModel) {
        Long analysisModelId = sumQueryDataModel.getAnalysisModelId();
        DynamicObject accountDimDy = PAAnalysisModelHelper.queryModelNecessityAccountDimension((Long)analysisModelId);
        String[] groupFields = this.getGroupFields(sumQueryDataModel);
        boolean flag = false;
        String accountNumber = accountDimDy.getString("dimension_entry.dimension.number");
        for (String field : groupFields) {
            String number;
            String[] strings;
            if (!field.contains(".") || (strings = field.split("\\.")).length <= 0 || !StringUtils.equals((CharSequence)(number = strings[0]), (CharSequence)accountNumber)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private Map<String, Object> getAccountMap(SumQueryDataModel sumQueryDataModel, Object selectedTreeNode) {
        if (selectedTreeNode == null) {
            return new HashMap<String, Object>();
        }
        long accountId = Long.parseLong((String)selectedTreeNode);
        if (accountId == 0L || accountId == -1L) {
            return new HashMap<String, Object>();
        }
        Long analysisModelId = sumQueryDataModel.getAnalysisModelId();
        DynamicObject accountDimDy = PAAnalysisModelHelper.queryModelNecessityAccountDimension((Long)analysisModelId);
        DynamicObject accountDy = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview");
        String accountNumber = accountDimDy.getString("dimension_entry.dimension.number");
        String[] groupFields = this.getGroupFields(sumQueryDataModel);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : groupFields) {
            String number;
            String[] strings;
            if (!field.contains(".") || (strings = field.split("\\.", 2)).length <= 1 || !StringUtils.equals((CharSequence)(number = strings[0]), (CharSequence)accountNumber)) continue;
            String attr = strings[1];
            Object attrValue = accountDy.get(attr);
            if (attrValue instanceof OrmLocaleValue) {
                map.put(field, ((OrmLocaleValue)attrValue).getLocaleValue());
                continue;
            }
            map.put(field, attrValue);
        }
        return map;
    }

    private String[] getGroupFields(SumQueryDataModel sumQueryDataModel) {
        Set<String> dimDataSet = sumQueryDataModel.getDimSetData();
        Set dimPKFieldSet = PAAnalysisModelHelper.getDimPkFieldSet(dimDataSet);
        dimPKFieldSet.addAll(dimDataSet);
        return dimPKFieldSet.toArray(new String[0]);
    }

    private AbstractReportColumn createTextColumn(String columnKey, String columnCaption, boolean isHyperlink, boolean isHide) {
        TextReportColumn textReportColumn = new TextReportColumn();
        textReportColumn.setFieldKey(columnKey);
        textReportColumn.setCaption(new LocaleString(columnCaption));
        textReportColumn.setFieldType("text");
        textReportColumn.setHyperlink(isHyperlink);
        textReportColumn.setHide(isHide);
        return textReportColumn;
    }

    private AbstractReportColumn createComboColumn(String columnKey, String columnCaption, List<ValueMapItem> comboItems) {
        ComboReportColumn comboReportColumn = new ComboReportColumn();
        comboReportColumn.setFieldKey(columnKey);
        comboReportColumn.setCaption(new LocaleString(columnCaption));
        comboReportColumn.setFieldType("combofield");
        if (!CollectionUtils.isEmpty(comboItems)) {
            comboReportColumn.setComboItems(comboItems);
        }
        return comboReportColumn;
    }
}

