/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.dataquery;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.formplugin.dataquery.SumQueryDataModel;
import kd.fi.pa.helper.AccountHelper;

public class SumQueryReportTreeDataPlugin
extends AbstractReportTreeDataPlugin {
    private static final Log logger = LogFactory.getLog(SumQueryReportTreeDataPlugin.class);

    public List<TreeNode> query(ReportQueryParam reportQueryParam, String s) throws Throwable {
        try {
            SumQueryDataModel sumQueryDataModel = new SumQueryDataModel(reportQueryParam);
            Set<Long> accountIdSet = sumQueryDataModel.getAccountSetData();
            Set parentAccountIdSet = AccountHelper.getAllParentIds(accountIdSet);
            Set childAccountIdSet = AccountHelper.getAllChildIds(accountIdSet);
            HashSet<Long> idSet = new HashSet<Long>();
            idSet.addAll(accountIdSet);
            idSet.addAll(parentAccountIdSet);
            idSet.addAll(childAccountIdSet);
            Map accountDyMap = BusinessDataServiceHelper.loadFromCache((Object[])idSet.toArray(), (String)"bd_accountview");
            List<TreeNode> treeNodeList = accountDyMap.values().stream().map(this::createTreeNode).collect(Collectors.toList());
            TreeNode rootTreeNode = this.createRootTreeNode();
            treeNodeList.add(rootTreeNode);
            return treeNodeList;
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, BosErrorCode.reportQueryError, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5de6\u4fa7\u6811\u6784\u5efa\u5931\u8d25\uff1a%s", (String)"SumQueryReportTreeDataPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), ex.getMessage())});
        }
    }

    private TreeNode createRootTreeNode() {
        TreeNode rootTreeNode = new TreeNode();
        rootTreeNode.setId("-1");
        rootTreeNode.setText(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee", (String)"SumQueryReportTreeDataPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        rootTreeNode.setLongText(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee", (String)"SumQueryReportTreeDataPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        rootTreeNode.setIsOpened(true);
        return rootTreeNode;
    }

    private TreeNode createTreeNode(DynamicObject accountDy) {
        String id = accountDy.getString("id");
        String name = accountDy.getString("name");
        String parentId = "-1";
        DynamicObject parentDy = accountDy.getDynamicObject("parent");
        if (parentDy != null && parentDy.getLong("id") != 0L) {
            parentId = parentDy.getString("id");
        }
        TreeNode treeNode = new TreeNode();
        treeNode.setId(id);
        treeNode.setText(name);
        treeNode.setLongText(name);
        treeNode.setParentid(parentId);
        treeNode.setIsOpened(true);
        return treeNode;
    }
}

