/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.execute;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.helper.OrgHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PARuleHelper;

public abstract class DefaultExecuteFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit systemControl = (BasedataEdit)this.getControl("analysis_system");
        systemControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit analysisModelEdit = (BasedataEdit)this.getControl("analysis_model");
        analysisModelEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ItemClassEdit startPeriod = (ItemClassEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org_field");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        IDataModel model = this.getModel();
        Long analysisSystemId = (Long)model.getValue("analysis_system_id");
        Long analysisModelId = (Long)model.getValue("analysis_model_id");
        switch (key) {
            case "analysis_system": {
                filterParameter.setFilter(PAExecutorHelper.getEnableFilter());
                break;
            }
            case "analysis_model": {
                if (!this.verificationAnalysisSystem()) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter filter = new QFilter("analysis_system", "=", (Object)analysisSystemId).and(new QFilter("tablenumber", "!=", (Object)" ")).and(new QFilter("tablenumber", "!=", (Object)"")).and(new QFilter("tablenumber", "is not null", null)).and(PAExecutorHelper.getEnableFilter()).and(PARuleHelper.getAnalysisPeriodFilter());
                filterParameter.setFilter(filter);
                break;
            }
            case "startperiod": {
                if (!this.verificationAnalysisModel()) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
                QFilter periodTypeQFilter = FormPluginUtil.getBaseQFilter(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                filterParameter.setFilter(periodTypeQFilter);
                break;
            }
            case "org_field": {
                OrgHelper.PermOrgResult permOrgResult = OrgHelper.getPermOrgSet((String)this.getEntityNumber());
                if (permOrgResult.hasAllOrgPerm()) break;
                filterParameter.setFilter(new QFilter("id", "in", (Object)permOrgResult.getPermOrgs()));
                break;
            }
        }
    }

    protected abstract String getEntityNumber();

    protected abstract boolean verificationAnalysisSystem();

    protected abstract boolean verificationAnalysisModel();

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "analysis_system": {
                model.setValue("analysis_model", null);
                model.setValue("startperiod", null);
                break;
            }
            case "analysis_model": {
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    model.setValue("itemclasstypefield", null);
                    model.setValue("startperiod", null);
                    return;
                }
                long analysisModelId = ((DynamicObject)newValue).getLong("id");
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
                if (StringUtils.isEmpty((CharSequence)analysisModelObj.getString("tablenumber"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6a21\u578b\u6ca1\u6709\u521b\u5efa\u6570\u636e\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DefaultExecuteFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (FormPluginUtil.processDateDim(this, analysisModelObj)) {
                    return;
                }
                String baseEntityId = FormPluginUtil.getBaseEntityId(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("itemclasstypefield");
                model.setValue("itemclasstypefield", (Object)baseEntityId);
                ItemClassTypeProp prop = (ItemClassTypeProp)selectDimTypeFields.getProperty();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                prop.setItemType((DynamicObjectType)mainEntityType);
                prop.setBaseEntityIds(Collections.singletonList(baseEntityId));
                break;
            }
        }
    }
}

