/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.execute;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.model.TaskInst;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.TaskExecuteEngineService;
import kd.fi.pa.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.ExecutionTypeEnum;
import kd.fi.pa.enums.WriteOffTypeEnum;
import kd.fi.pa.formplugin.execute.SupportProcessExecuteFromPlugin;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.utils.DateUtil;

public class PAOffExecuteFormPlugin
extends SupportProcessExecuteFromPlugin {
    private static final Log logger = LogFactory.getLog(PAOffExecuteFormPlugin.class);
    private static final String DETAIL_FLEX_PANEL = "detailfp";
    private static final String RIGHT_FLEX_PANEL = "rightfp";
    private static final String gifUrl = "/icons/pc/other/zncw_sjtb_214_214.gif";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"apportionment_execute", "executelog_list", "executelogdetail_list", "close"});
        super.registerListener(e);
    }

    @Override
    protected String getEntityNumber() {
        return "pa_reversalexecute";
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Long analysisSystem = (Long)model.getValue("analysis_system_id");
        Long analysisModel = (Long)model.getValue("analysis_model_id");
        Long orgId = (Long)model.getValue("org_field_id");
        Long periodId = (Long)model.getValue("startperiod_id");
        Date startDate = (Date)model.getValue("range_startdate");
        Date endDate = (Date)model.getValue("range_enddate");
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModel, (String)"pa_analysismodel");
        DimensionTypeEnum dimType = FormPluginUtil.getDimensionTypeEnumByModelAndDim(analysisModelObj, "1");
        boolean isDatetimeDimType = DimensionTypeEnum.DATE == dimType;
        switch (key) {
            case "apportionment_execute": {
                if (!this.verificationAnalysisSystem() || !this.verificationAnalysisModel() || !this.verificationOrg() || !isDatetimeDimType && !this.verificationPeriod() || !this.processEnableValidation()) break;
                String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(analysisModel);
                if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                    view.showTipNotification(modelNewVersionMsg);
                    return;
                }
                view.showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u540e\u5c06\u6e05\u9664\u6240\u9009\u6761\u4ef6\u4e0b\u7684\u6240\u6709\u4e1a\u52a1\u5904\u7406\u7ed3\u679c\uff0c\u6062\u590d\u81f3\u6570\u636e\u540c\u6b65\u540e\u7684\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"PAOffExecuteFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("apportionment_execute", (IFormPlugin)this));
                break;
            }
            case "executelog_list": 
            case "executelogdetail_list": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setFormId("bos_list");
                listShowParameter.setBillFormId("pa_executionlog");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setParentFormId(view.getFormShowParameter().getFormId());
                listShowParameter.setCustomParam("analysis_system", (Object)analysisSystem);
                listShowParameter.setCustomParam("analysis_model", (Object)analysisModel);
                listShowParameter.setCustomParam("startperiod", (Object)periodId);
                listShowParameter.setCustomParam("range_startdate", (Object)startDate);
                listShowParameter.setCustomParam("range_enddate", (Object)endDate);
                listShowParameter.setCustomParam("org_field", (Object)orgId);
                view.showForm((FormShowParameter)listShowParameter);
                break;
            }
            case "close": {
                view.setVisible(Boolean.FALSE, new String[]{DETAIL_FLEX_PANEL});
                view.setVisible(Boolean.TRUE, new String[]{RIGHT_FLEX_PANEL});
                model.setValue("executioninfo", (Object)"");
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                bar.setPercent(0);
                bar.stop();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String result = messageBoxClosedEvent.getResultValue();
        if (StringUtils.equals((CharSequence)"apportionment_execute", (CharSequence)callBackId) && MessageBoxResult.Yes.name().equals(result)) {
            this.offExecute();
        }
    }

    private void init() {
        this.getView().setVisible(Boolean.FALSE, new String[]{DETAIL_FLEX_PANEL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"daterange"});
        BasedataEdit startPeriodEdit = (BasedataEdit)this.getView().getControl("startperiod");
        startPeriodEdit.setMustInput(true);
    }

    private void offExecute() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        try {
            Long analysisModelId = (Long)model.getValue("analysis_model_id");
            Long orgId = (Long)model.getValue("org_field_id");
            Long periodId = (Long)model.getValue("startperiod_id");
            if (FormPluginUtil.validatePrePeriodStatus(analysisModelId) && !FormPluginUtil.validatePeriodStatus(analysisModelId, orgId, periodId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u671f\u95f4\u3002", (String)"PAOffExecuteFormPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            ExecutionLogDTO executionLog = this.buildDto();
            TaskInst taskInst = new TaskInst(false, Long.valueOf(DB.genGlobalLongId()));
            TaskExecuteEngineService taskExecuteEngineService = (TaskExecuteEngineService)EngineServiceFactory.getTaskExecuteEngineService();
            String taskKey = taskExecuteEngineService.work(executionLog, taskInst);
            pageCache.put("syncTaskId", taskKey);
            view.setVisible(Boolean.TRUE, new String[]{DETAIL_FLEX_PANEL});
            view.setVisible(Boolean.FALSE, new String[]{RIGHT_FLEX_PANEL});
            bar.start();
            bar.setPercent(0);
            this.changeImage(gifUrl);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5f00\u59cb\u3002", (String)"PAOffExecuteFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("[FI-PA] PAOffExecuteFormPlugin offExecute error!", (Throwable)e);
            }
            view.showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u63d0\u4ea4\u5f02\u5e38\u3002", (String)"PAOffExecuteFormPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    private ExecutionLogDTO buildDto() {
        IDataModel model = this.getModel();
        ExecutionLogDTO dto = new ExecutionLogDTO();
        Long currentPeriodId = (Long)model.getValue("startperiod_id");
        Date startDate = (Date)model.getValue("range_startdate");
        Date endDate = (Date)model.getValue("range_enddate");
        if (!ObjectUtils.isEmpty((Object)endDate)) {
            endDate = DateUtil.getNextDay((Date)endDate, (int)1);
        }
        Long analysisSystemId = (Long)model.getValue("analysis_system_id");
        Long analysisModelId = (Long)model.getValue("analysis_model_id");
        Long orgId = (Long)model.getValue("org_field_id");
        dto.setAnalysisSystem(analysisSystemId);
        dto.setAnalysisModel(analysisModelId);
        dto.setOrgIds(new Long[]{orgId});
        dto.setExecutionMode(ExecutionModeEnum.writeOff);
        DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        String periodEntity = FormPluginUtil.getBaseEntityId(analysisModelObj, "1");
        dto.setItemClassTypeField(periodEntity);
        if (null == currentPeriodId || currentPeriodId == 0L) {
            dto.setStartDate(startDate);
            dto.setEndDate(endDate);
        } else {
            dto.setStartPeriod(currentPeriodId);
        }
        dto.setExecutionTime(new Date());
        dto.setDetailTime(Long.valueOf(System.currentTimeMillis()));
        dto.setExecutionStatus(PASyncLogStatusEnum.NEW);
        dto.setExecutionType(ExecutionTypeEnum.MANUAL.getCode());
        dto.setWriteOffType(WriteOffTypeEnum.BATCH.getCode());
        return dto;
    }

    @Override
    protected boolean verificationAnalysisSystem() {
        DynamicObject system = this.getModel().getDataEntity().getDynamicObject("analysis_system");
        return !this.processInputValidation(system, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u6790\u4f53\u7cfb\u3002", (String)"PAOffExecuteFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean verificationAnalysisModel() {
        DynamicObject model = this.getModel().getDataEntity().getDynamicObject("analysis_model");
        return !this.processInputValidation(model, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u6790\u6a21\u578b\u3002", (String)"PAOffExecuteFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
    }

    private boolean verificationPeriod() {
        IDataModel model = this.getModel();
        Long periodId = (Long)model.getValue("startperiod_id");
        if (periodId == null || periodId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u671f\u95f4\u3002", (String)"PAOffExecuteFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean verificationOrg() {
        Long orgId = (Long)this.getModel().getValue("org_field_id");
        if (orgId == null || orgId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"PAOffExecuteFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean processEnableValidation() {
        DynamicObject system = this.getModel().getDataEntity().getDynamicObject("analysis_system");
        DynamicObject model = this.getModel().getDataEntity().getDynamicObject("analysis_model");
        long systemId = system.getLong("id");
        long modelId = model.getLong("id");
        String systemEnable = this.getEnableById(systemId, "pa_anasystemsetting");
        String modelEnable = this.getEnableById(modelId, "pa_analysismodel");
        String systemEnableMsg = ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PAOffExecuteFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        String modelEnableMsg = ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PAOffExecuteFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]);
        return this.processEnableValidation(systemEnable, systemEnableMsg) && this.processEnableValidation(modelEnable, modelEnableMsg);
    }

    private boolean processEnableValidation(String enable, String msg) {
        if (StringUtils.equals((CharSequence)"0", (CharSequence)enable)) {
            this.getView().showTipNotification(msg);
            return false;
        }
        return true;
    }

    private boolean processInputValidation(DynamicObject model, String msg) {
        if (model == null) {
            this.getView().showTipNotification(msg);
            return true;
        }
        long id = model.getLong("id");
        if (id == 0L) {
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    private String getEnableById(long id, String entity) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dy = QueryServiceHelper.queryOne((String)entity, (String)"enable", (QFilter[])new QFilter[]{filter});
        return dy.getString("enable");
    }

    private void changeImage(String imageUrl) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageKey", imageUrl);
        IFormView view = this.getView();
        view.updateControlMetadata("imageap", data);
    }

    @Override
    protected double getTaskPercent(IDataSimpleWorkTaskStatisticStatus statisticStatus) {
        String periodName;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org_field");
        DynamicObject period = (DynamicObject)model.getValue("startperiod");
        String string = periodName = period == null ? "" : period.getString("name");
        if (statisticStatus != null) {
            int[] taskStatisticsPoints = statisticStatus.getTaskStatisticsPoints();
            long[] taskProcRecStatistics = statisticStatus.getTaskProcRecStatistics();
            String statusMessage = statisticStatus.getStatusMessage();
            double percent = (double)taskStatisticsPoints[0] / (double)taskStatisticsPoints[1] * 100.0;
            boolean taskEnd = statisticStatus.isTaskEnd();
            boolean withError = statisticStatus.isWithError();
            boolean interrupt = statisticStatus.isInterrupt();
            if (withError) {
                model.setValue("executioninfo", (Object)(statusMessage == null ? ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002", (String)"PAOffExecuteFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]) : statusMessage));
                percent = -1.0;
            } else if (interrupt) {
                model.setValue("executioninfo", (Object)ResManager.loadKDString((String)"\u6267\u884c\u4e2d\u65ad\u3002", (String)"PAOffExecuteFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                percent = -1.0;
            } else if (!taskEnd && Double.doubleToLongBits(taskProcRecStatistics[0]) == Double.doubleToLongBits(0.0)) {
                model.setValue("executioninfo", (Object)ResManager.loadKDString((String)"\u6b63\u5728\u521d\u59cb\u5316\u3002", (String)"PAOffExecuteFormPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            } else if (!taskEnd && 0.0 < percent && percent < 100.0) {
                model.setValue("executioninfo", (Object)String.format(ResManager.loadKDString((String)"\u51b2\u9500\u5b8c\u6210\uff1a%1$s\u4e2a\u7ec4\u7ec7\uff0c\u603b\u5171\uff1a%2$s\u4e2a\u7ec4\u7ec7", (String)"PAOffExecuteFormPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]), taskStatisticsPoints[0], taskStatisticsPoints[1]));
            } else if (taskEnd) {
                String endMsg = ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"PAOffExecuteFormPlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                if (Double.doubleToLongBits(taskProcRecStatistics[3]) > 0L) {
                    endMsg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25", (String)"PAOffExecuteFormPlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                }
                if (StringUtils.isEmpty((CharSequence)periodName)) {
                    model.setValue("executioninfo", (Object)String.format("%s\uff1a%s", endMsg, org.getString("name")));
                } else {
                    model.setValue("executioninfo", (Object)String.format("%s\uff1a%s\uff0c%s", endMsg, org.getString("name"), periodName));
                }
                percent = 100.0;
            }
            return percent;
        }
        return 0.0;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "analysis_model": {
                if (newValue != null) break;
                model.setValue("itemclasstypefield", (Object)"bd_period");
            }
        }
    }
}

