/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.GenericServiceResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.pa.common.enums.EnableStatusEnum;
import kd.fi.pa.common.enums.PASyncLogStatusEnum;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.lock.ModelTaskLock;
import kd.fi.pa.engine.model.TaskInst;
import kd.fi.pa.engine.mservice.TaskInstMService;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.ExecuteEngineService;
import kd.fi.pa.engine.service.TaskExecuteEngineService;
import kd.fi.pa.engine.task.status.IDataSimpleWorkTaskStatisticStatus;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.ExecutionTypeEnum;
import kd.fi.pa.enums.TaskInstExecEnum;
import kd.fi.pa.formplugin.execute.SupportProcessExecuteFromPlugin;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.helper.PACustomParamHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.utils.AnalysisModelUtil;
import kd.fi.pa.utils.DateUtil;

public class PARuleExecuteFormPlugin
extends SupportProcessExecuteFromPlugin
implements BeforeF7SelectListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(PARuleExecuteFormPlugin.class);
    private static final String PERIOD_TYPEID_CACHE = "periodTypeIdCache";
    private static final String BASE_ENTITYID_CACHE = "baseEntityIdCache";
    private static final String DETAIL_FLEX_PANEL = "detailfp";
    private static final String RIGHT_FLEX_PANEL = "rightfp";
    private static final String gifUrl = "/icons/pc/other/zncw_sjtb_214_214.gif";
    private static final String CALLBACKID_DATAREPORT = "dataReport";
    private static final String CALLBACKID_REGISTERTASK = "registerTask";
    private static final String CALLBACKID_ADJUST = "adjust";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    @Override
    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{"apportionment_execute", "executelog_list", "close", "viewlog", "viewtask"});
        super.registerListener(evt);
        BasedataEdit businessPlanEdit = (BasedataEdit)this.getControl("business_plan");
        businessPlanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit businessRuleEdit = (BasedataEdit)this.getControl("business_rule");
        businessRuleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    protected String getEntityNumber() {
        return "pa_businessexecute";
    }

    public void click(EventObject evt) {
        String clickKey = ((Control)evt.getSource()).getKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        RuleExecuteFormParam formParam = RuleExecuteFormParam.get(model);
        switch (clickKey) {
            case "apportionment_execute": {
                try {
                    if (!formParam.verifyRuleExec(view)) {
                        return;
                    }
                    this.ruleExecute(formParam);
                }
                catch (Exception e) {
                    logger.error("[FI-PA] PARuleExecuteFormPlugin execute error", (Throwable)e);
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u63d0\u4ea4\u5f02\u5e38\u3002", (String)"PARuleExecuteFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
                break;
            }
            case "executelog_list": 
            case "viewlog": {
                this.openExecutionLogListView(view, formParam);
                break;
            }
            case "viewtask": {
                this.openTaskListView(view, formParam);
                break;
            }
            case "close": {
                view.setVisible(Boolean.FALSE, new String[]{DETAIL_FLEX_PANEL});
                view.setVisible(Boolean.TRUE, new String[]{RIGHT_FLEX_PANEL});
                model.setValue("executioninfo", (Object)"");
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                if (bar == null) break;
                bar.setPercent(0);
                bar.stop();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        model.beginInit();
        switch (key) {
            case "analysis_system": {
                model.setValue("business_plan", null);
                model.setValue("business_rule", null);
                model.setValue("range_startdate", null);
                model.setValue("range_enddate", null);
                break;
            }
            case "analysis_model": {
                model.setValue("business_plan", null);
                model.setValue("business_rule", null);
                if (newValue == null) {
                    model.setValue("itemclasstypefield", (Object)"bd_period");
                    return;
                }
                Long analysisModelId = ((DynamicObject)newValue).getLong("id");
                String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(analysisModelId);
                if (StringUtils.isNotEmpty((String)modelNewVersionMsg)) {
                    view.showTipNotification(modelNewVersionMsg);
                    return;
                }
                DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
                String baseEntityId = FormPluginUtil.getBaseEntityId(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                pageCache.put(BASE_ENTITYID_CACHE, baseEntityId);
                if ("bd_period".equals(baseEntityId)) {
                    QFilter periodTypeQFilter = FormPluginUtil.getBaseQFilter(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                    DynamicObject periodTypeObj = QueryServiceHelper.queryOne((String)baseEntityId, (String)"id,periodtype", (QFilter[])periodTypeQFilter.toArray());
                    Long periodTypeId = periodTypeObj.getLong("periodtype");
                    pageCache.put(PERIOD_TYPEID_CACHE, periodTypeId.toString());
                    Date firstDayOfCurrentMonth = DateUtil.getMinMonthDate((Date)new Date());
                    Date lastDayOfNextMonth = DateUtil.getNextMonthLastDay();
                    QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodTypeId).and(new QFilter("begindate", ">=", (Object)firstDayOfCurrentMonth)).and(new QFilter("enddate", "<=", (Object)lastDayOfNextMonth));
                    DynamicObjectCollection currentDatePeriod = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray(), (String)"begindate");
                    if (currentDatePeriod == null || currentDatePeriod.isEmpty()) break;
                    model.setValue("startperiod", ((DynamicObject)currentDatePeriod.get(0)).get("id"));
                    break;
                }
                pageCache.remove(PERIOD_TYPEID_CACHE);
                break;
            }
            case "org_field": {
                if (newValue instanceof DynamicObjectCollection) {
                    DynamicObjectCollection orgIds = (DynamicObjectCollection)newValue;
                    int orgCountLimit = PACustomParamHelper.getRuleExecOrgCountLimit();
                    if (orgIds.size() > orgCountLimit) {
                        if (oldValue != null && ((DynamicObjectCollection)oldValue).size() <= orgCountLimit) {
                            model.setValue("org_field", oldValue);
                        } else {
                            model.setValue("org_field", null);
                        }
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52fe\u9009%1$s\u5bb6\u7ec4\u7ec7\u8fdb\u884c\u89c4\u5219\u6267\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PARuleExecuteFormPlugin_32", (String)"fi-pa-formplugin", (Object[])new Object[0]), orgCountLimit));
                        return;
                    }
                }
                model.setValue("business_plan", null);
                model.setValue("business_rule", null);
                break;
            }
            case "business_plan": {
                model.setValue("business_rule", null);
                break;
            }
            case "business_rule": {
                model.setValue("business_plan", null);
                break;
            }
        }
        model.endInit();
        view.updateView(RIGHT_FLEX_PANEL);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String key = beforeF7SelectEvent.getProperty().getName();
        ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        switch (key) {
            case "business_plan": 
            case "business_rule": {
                String entityNumber;
                RuleExecuteFormParam formParam = RuleExecuteFormParam.get(model);
                if (!(this.verificationAnalysisSystem() && this.verificationAnalysisModel() && formParam.verifyOrg(view))) {
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter baseFilter = new QFilter("analysissystem", "=", (Object)formParam.anaSystemId).and(new QFilter("analysismodel", "=", (Object)formParam.anaModelId));
                if ("business_plan".equals(key)) {
                    entityNumber = "pa_businessplan";
                    baseFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.enable.getCodeString()));
                } else {
                    entityNumber = "pa_businessrule";
                    baseFilter.and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)EnableStatusEnum.enable.getCodeString()));
                }
                ArrayList<Long> entityIdRetainList = new ArrayList<Long>(4);
                List supCtrOrgList = new BaseDataCommonService().getSupCtrlUnitIfIsUnCtrlUint(entityNumber, formParam.orgIds);
                for (Long orgId : supCtrOrgList) {
                    this.getRetainEntityIdList(entityNumber, orgId, baseFilter, entityIdRetainList);
                }
                QFilter idFilter = new QFilter("id", "in", entityIdRetainList);
                filterParameter.setFilter(idFilter);
                break;
            }
        }
    }

    private void getRetainEntityIdList(String entityNumber, Long orgId, QFilter baseFilter, List<Long> retainList) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityNumber, (Long)orgId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PARuleExecuteFormPlugin.getRetainEntityIdList", (String)entityNumber, (String)"id", (QFilter[])new QFilter[]{baseFilter, orgFilter}, null);){
            if (ds != null) {
                ArrayList<Long> currentEntityIdList = new ArrayList<Long>(4);
                while (ds.hasNext()) {
                    currentEntityIdList.add(ds.next().getLong("id"));
                }
                if (retainList.isEmpty()) {
                    retainList.addAll(currentEntityIdList);
                } else {
                    retainList.retainAll(currentEntityIdList);
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"F7\u8fc7\u6ee4\u5f02\u5e38\uff1a%s", (String)"PARuleExecuteFormPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String actionId = e.getCallBackId();
        MessageBoxResult messageBoxResult = e.getResult();
        if (MessageBoxResult.Yes == messageBoxResult && Arrays.asList(CALLBACKID_DATAREPORT, CALLBACKID_REGISTERTASK, CALLBACKID_ADJUST).contains(actionId)) {
            RuleExecuteFormParam formParam = RuleExecuteFormParam.get(this.getModel());
            if (!formParam.verifyRuleExec(this.getView())) {
                return;
            }
            if (CALLBACKID_DATAREPORT.equals(actionId)) {
                formParam.confirmedDataReport = true;
                this.ruleExecute(formParam);
                return;
            }
            formParam.confirmedDataReport = true;
            if (CALLBACKID_REGISTERTASK.equals(actionId)) {
                formParam.confirmedRegisterTask = true;
                this.ruleExecute(formParam);
                return;
            }
            formParam.confirmedRegisterTask = true;
            if (CALLBACKID_ADJUST.equals(actionId)) {
                formParam.confirmedAdjust = true;
                this.ruleExecute(formParam);
            }
        }
    }

    private void init() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        view.setVisible(Boolean.FALSE, new String[]{DETAIL_FLEX_PANEL});
        view.setVisible(Boolean.FALSE, new String[]{"itemclasstypefield"});
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long analysisSystemId = (Long)formShowParameter.getCustomParam("analysis_system");
        Long analysisModelId = (Long)formShowParameter.getCustomParam("analysis_model");
        Object orgId = formShowParameter.getCustomParam("org_field");
        Long businessPlanId = (Long)formShowParameter.getCustomParam("business_plan");
        Long businessRuleId = (Long)formShowParameter.getCustomParam("business_rule");
        model.beginInit();
        model.setValue("analysis_system", (Object)analysisSystemId);
        model.setValue("analysis_model", (Object)analysisModelId);
        if (orgId != null) {
            model.setValue("org_field", (Object)new Object[]{orgId});
        }
        if (businessRuleId != null) {
            model.setValue("business_rule", (Object)businessRuleId);
        } else {
            model.setValue("business_plan", (Object)businessPlanId);
        }
        if (analysisModelId != null) {
            DynamicObject analysisModelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
            String baseEntityId = FormPluginUtil.getBaseEntityId(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
            if (baseEntityId != null && !baseEntityId.isEmpty()) {
                pageCache.put(BASE_ENTITYID_CACHE, baseEntityId);
                if ("bd_period".equals(baseEntityId)) {
                    QFilter periodTypeQFilter = FormPluginUtil.getBaseQFilter(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
                    DynamicObject periodTypeObj = QueryServiceHelper.queryOne((String)baseEntityId, (String)"id,periodtype", (QFilter[])periodTypeQFilter.toArray());
                    pageCache.put(PERIOD_TYPEID_CACHE, Long.toString(periodTypeObj.getLong("periodtype")));
                }
                ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("itemclasstypefield");
                ArrayList<String> baseEntityIds = new ArrayList<String>(1);
                baseEntityIds.add(baseEntityId);
                ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(1);
                ComboItem comboItem = new ComboItem();
                comboItem.setId(baseEntityId);
                comboItem.setValue(baseEntityId);
                comboItem.setCaption(new LocaleString(baseEntityId));
                propertyItems.add(comboItem);
                selectDimTypeFields.setComboItems(propertyItems);
                model.setValue("itemclasstypefield", (Object)baseEntityId);
                ItemClassTypeProp prop = (ItemClassTypeProp)selectDimTypeFields.getProperty();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                prop.setItemType((DynamicObjectType)mainEntityType);
                prop.setBaseEntityIds(baseEntityIds);
            }
            FormPluginUtil.processDateDim(this, analysisModelObj);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"daterange"});
            BasedataEdit startPeriodEdit = (BasedataEdit)this.getView().getControl("startperiod");
            startPeriodEdit.setMustInput(true);
        }
        model.endInit();
        view.updateView(RIGHT_FLEX_PANEL);
    }

    private void ruleExecute(RuleExecuteFormParam formParam) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        try {
            if (!this.checkTaskLock(formParam, view, false)) {
                return;
            }
            if (!this.checkDataReport(formParam, view)) {
                return;
            }
            if (!this.checkRegisterTask(formParam, view)) {
                return;
            }
            if (!this.checkAndExecAdjust(formParam, view)) {
                return;
            }
            HashMap<String, Serializable> param = new HashMap<String, Serializable>(8);
            param.put("systemId", formParam.anaSystemId);
            param.put("modelId", formParam.anaModelId);
            param.put("orgIds", new HashSet(formParam.orgIds));
            param.put("rangeStartDate", formParam.rangeStartDate);
            if (formParam.rangeEndDate != null) {
                param.put("rangeEndDate", DateUtil.getNextDay((Date)formParam.rangeEndDate, (int)1));
            }
            param.put("startPeriodId", formParam.periodId);
            param.put("businessPlanId", formParam.businessPlanId);
            param.put("businessRuleId", formParam.businessRuleId);
            List executionLogDTOList = PAExecutorHelper.processRuleExecute(param);
            boolean includeMultiOrgShare = executionLogDTOList.stream().anyMatch(ExecutionLogDTO::isIncludeMultiOrgShare);
            if (includeMultiOrgShare && !this.checkTaskLock(formParam, view, true)) {
                return;
            }
            Tuple<Boolean, TaskInst> registerResult = this.registerTask(formParam, true, false, view);
            if (!((Boolean)registerResult.item1).booleanValue()) {
                return;
            }
            TaskInst taskInst = (TaskInst)registerResult.item2;
            TaskExecuteEngineService taskExecuteEngineService = (TaskExecuteEngineService)EngineServiceFactory.getTaskExecuteEngineService();
            String taskKey = taskExecuteEngineService.work((Collection)executionLogDTOList, taskInst);
            pageCache.put("syncTaskId", taskKey);
            view.setVisible(Boolean.TRUE, new String[]{DETAIL_FLEX_PANEL});
            view.setVisible(Boolean.FALSE, new String[]{RIGHT_FLEX_PANEL});
            bar.start();
            bar.setPercent(0);
            this.changeImage(gifUrl);
            logger.info("[FI-PA] PARuleExecuteFormPlugin ruleExecute success");
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5f00\u59cb\u3002", (String)"PARuleExecuteFormPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
        catch (KDBizException e) {
            logger.error("[FI-PA] PARuleExecuteFormPlugin ruleExecute error", (Throwable)e);
            view.showTipNotification(e.getMessage());
        }
        catch (Exception e) {
            logger.error("[FI-PA] PARuleExecuteFormPlugin ruleExecute error", (Throwable)e);
            view.showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u63d0\u4ea4\u5f02\u5e38\u3002", (String)"PARuleExecuteFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean shouldRegisterTask(DynamicObject analysisModel) {
        if (analysisModel == null) {
            return false;
        }
        DynamicObjectCollection dimensionDyCol = analysisModel.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dimensionEntryDy : dimensionDyCol) {
            String entityNumber;
            String necessityDim = dimensionEntryDy.getString("necessity_dim");
            if (!DimensionNecessityEnum.PERIOD.getCode().equals(necessityDim)) continue;
            DynamicObject dimensionDy = dimensionEntryDy.getDynamicObject("dimension");
            DimensionTypeEnum dimensionType = DimensionTypeEnum.getEnum((String)dimensionDy.getString("dimensiontype"));
            if (DimensionTypeEnum.DATABASE != dimensionType) break;
            DynamicObject dimensionSource = (DynamicObject)dimensionDy.get("dimensionsource");
            String string = entityNumber = dimensionSource != null ? dimensionSource.getString("number") : null;
            if (!"bd_period".equals(entityNumber)) break;
            return true;
        }
        return false;
    }

    private String getBusinessInfo() {
        IDataModel model = this.getModel();
        DynamicObject businessPlanDy = (DynamicObject)model.getValue("business_plan");
        DynamicObject businessRuleDy = (DynamicObject)model.getValue("business_rule");
        if (businessPlanDy != null) {
            return String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7ec4\uff1a%s", (String)"PARuleExecuteFormPlugin_27", (String)"fi-pa-formplugin", (Object[])new Object[0]), businessPlanDy.getString("name"));
        }
        if (businessRuleDy != null) {
            return String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\uff1a%s", (String)"PARuleExecuteFormPlugin_28", (String)"fi-pa-formplugin", (Object[])new Object[0]), businessRuleDy.getString("name"));
        }
        return null;
    }

    private String getBusinessKey() {
        IDataModel model = this.getModel();
        Long businessPlanId = (Long)model.getValue("business_plan_id");
        Long businessRuleId = (Long)model.getValue("business_rule_id");
        if (businessPlanId != null && businessPlanId != 0L) {
            return "R_" + businessPlanId;
        }
        if (businessRuleId != null && businessRuleId != 0L) {
            return "R_" + businessRuleId;
        }
        return null;
    }

    public ExecutionLogDTO buildDtoByAdjustType(List<Long> adjustIdList, Long analysisSystemId, Long analysisModelId, Long orgId, String baseEntity, Long periodId) {
        ExecutionLogDTO dto = new ExecutionLogDTO();
        dto.setBusinessIdList(adjustIdList);
        dto.setAnalysisSystem(analysisSystemId);
        dto.setAnalysisModel(analysisModelId);
        dto.setOrgIds(new Long[]{orgId});
        dto.setExecutionMode(ExecutionModeEnum.adjust);
        dto.setItemClassTypeField(baseEntity);
        dto.setStartPeriod(periodId);
        dto.setExecutionTime(new Date());
        dto.setDetailTime(Long.valueOf(System.currentTimeMillis()));
        dto.setExecutionStatus(PASyncLogStatusEnum.NEW);
        dto.setExecutionType(ExecutionTypeEnum.MANUAL.getCode());
        return dto;
    }

    @Override
    protected boolean verificationAnalysisSystem() {
        RuleExecuteFormParam formParam = RuleExecuteFormParam.get(this.getModel());
        return formParam.verifyAnalysisSystem(this.getView());
    }

    @Override
    protected boolean verificationAnalysisModel() {
        RuleExecuteFormParam formParam = RuleExecuteFormParam.get(this.getModel());
        return formParam.verifyAnalysisModel(this.getView());
    }

    private boolean checkTaskLock(RuleExecuteFormParam formParam, IFormView view, boolean includeMultiOrgShare) {
        ArrayList<Long> lockedOrgIdList;
        String detailEntityNum = AnalysisModelUtil.buildDetailEntityNumber((String)formParam.analysisModel.getString("tablenumber"));
        ModelTaskLock modelTaskLock = null;
        modelTaskLock = includeMultiOrgShare ? ModelTaskLock.create((String)detailEntityNum, (Long)formParam.anaModelId) : ModelTaskLock.create((String)detailEntityNum, (Long)formParam.anaModelId, (Long[])formParam.orgIds.toArray(new Long[0]), (Long)formParam.periodId);
        if (modelTaskLock.existsLock(lockedOrgIdList = new ArrayList<Long>(16))) {
            if (!lockedOrgIdList.isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u4ee5\u4e0b\u6240\u9009\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u5176\u5b83\u7684\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u6216\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"PARuleExecuteFormPlugin_30", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                view.showMessage(tips, this.buildOrgNumberAndName(lockedOrgIdList), MessageTypes.Default);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u6b63\u5728\u6267\u884c\u4efb\u52a1\uff0c\u65e0\u6cd5\u6267\u884c\u65b0\u7684\u4efb\u52a1\uff0c\u53ef\u524d\u5f80\u4efb\u52a1\u7ba1\u7406\u5217\u8868\u67e5\u770b\u4efb\u52a1\u60c5\u51b5\u3002", (String)"PARuleExecuteFormPlugin_29", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private String buildOrgNumberAndName(List<Long> orgIds) {
        Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIds.toArray(), (String)"bos_org");
        List orgNumberNames = orgMap.values().stream().map(dy -> String.format("%s: %s", dy.getString("number"), dy.getString("name"))).collect(Collectors.toList());
        return String.join((CharSequence)"\r\n", orgNumberNames);
    }

    private boolean checkAndExecAdjust(RuleExecuteFormParam formParam, IFormView view) {
        if (formParam.confirmedAdjust) {
            return true;
        }
        try {
            QFilter dealingFilter;
            boolean exists;
            QFilter statusFilter;
            DynamicObjectCollection adjustCol;
            Long analysisModelId = formParam.anaModelId;
            String periodBaseEntity = this.getPageCache().get(BASE_ENTITYID_CACHE);
            QFilter adjustFilter = new QFilter("analysissystem", "=", (Object)formParam.anaSystemId).and(new QFilter("analysismodel", "=", (Object)analysisModelId)).and(new QFilter("createorg", "in", (Object)formParam.orgIds)).and(new QFilter("periodbasetype", "=", (Object)periodBaseEntity));
            if (DimensionTypeEnum.DATE != formParam.periodDimType) {
                adjustFilter = adjustFilter.and("period", "=", (Object)formParam.periodId);
            }
            if ((adjustCol = QueryServiceHelper.query((String)"pa_dataadjust", (String)"id,createorg", (QFilter[])new QFilter[]{adjustFilter, statusFilter = new QFilter("billstatus", "=", (Object)"E").and("adjuststatus", "=", (Object)"1")})) != null && !adjustCol.isEmpty()) {
                HashMap<Long, List> orgMappingAdjust = new HashMap<Long, List>(4);
                for (DynamicObject adjustObj : adjustCol) {
                    Long adjustId = adjustObj.getLong("id");
                    Long createOrgId = adjustObj.getLong("createorg");
                    List adjustIdList = orgMappingAdjust.computeIfAbsent(createOrgId, orgId -> new ArrayList(4));
                    adjustIdList.add(adjustId);
                }
                for (Map.Entry entry : orgMappingAdjust.entrySet()) {
                    Long orgId2 = (Long)entry.getKey();
                    List adjustIdList = (List)entry.getValue();
                    ExecutionLogDTO executionLog = this.buildDtoByAdjustType(adjustIdList, formParam.anaSystemId, analysisModelId, orgId2, periodBaseEntity, formParam.periodId);
                    ExecuteEngineService executeEngineService = (ExecuteEngineService)EngineServiceFactory.getExecuteEngineService();
                    executeEngineService.work(executionLog);
                }
            }
            if (exists = QueryServiceHelper.exists((String)"pa_dataadjust", (QFilter[])new QFilter[]{adjustFilter, dealingFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"})})) {
                String message = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8c03\u6574\u5355\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"PARuleExecuteFormPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]);
                view.showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_ADJUST, (IFormPlugin)this));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("[FI-PA] PARuleExecuteFormPlugin checkAndExecAdjust execute error!", (Throwable)e);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u5ba1\u6838\u4f46\u672a\u66f4\u65b0\u5b9e\u9645\u6570\u7684\u8c03\u6574\u5355\uff0c\u6267\u884c\u8c03\u6574\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"PARuleExecuteFormPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]), e.getMessage()));
            return false;
        }
    }

    private boolean checkDataReport(RuleExecuteFormParam formParam, IFormView view) {
        boolean isDatetimeDimType;
        if (formParam.confirmedDataReport) {
            return true;
        }
        boolean bl = isDatetimeDimType = DimensionTypeEnum.DATE == formParam.periodDimType;
        if (isDatetimeDimType) {
            return true;
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)formParam.anaModelId);
        QFilter orgFilter = new QFilter("checkorg", "in", (Object)formParam.orgIds);
        QFilter periodFilter = new QFilter("checkperiod", "=", (Object)formParam.periodId);
        QFilter runModeFilter = new QFilter("runmode", "!=", (Object)"2");
        Map<String, List<DynamicObject>> dataCheckReportsGroupByOrgPeriod = QueryServiceHelper.query((String)"faf_datacheckreport", (String)"billno,checkorg,checkperiod,createtime,checkresult", (QFilter[])new QFilter[]{modelFilter, orgFilter, periodFilter, runModeFilter}).stream().collect(Collectors.groupingBy(t -> String.format("%1$s_%2$s", t.getString("checkorg"), t.getString("checkperiod"))));
        for (Map.Entry<String, List<DynamicObject>> entry : dataCheckReportsGroupByOrgPeriod.entrySet()) {
            DynamicObject latestReport;
            List orderlyReports = entry.getValue().stream().sorted(Comparator.comparing(dy -> dy.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orderlyReports) || !"3".equals((latestReport = (DynamicObject)orderlyReports.get(0)).getString("checkresult"))) continue;
            DynamicObject periodObj = (DynamicObject)this.getModel().getValue("startperiod");
            String confirmMessage = ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5728%s\u4e2d\u5b58\u5728\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u6570\u636e\u6821\u9a8c\u62a5\u544a\uff0c\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u6570\u636e\u5c06\u4f1a\u5f71\u54cd\u89c4\u5219\u6267\u884c\u7684\u7ed3\u679c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u7ee7\u7eed\u6267\u884c\uff1f", (String)"PARuleExecuteFormPlugin_31", (String)"fi-pa-formplugin", (Object[])new Object[0]);
            view.showConfirm(String.format(confirmMessage, periodObj != null ? periodObj.getString("name") : ""), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_DATAREPORT, (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private boolean checkRegisterTask(RuleExecuteFormParam formParam, IFormView view) {
        if (formParam.confirmedRegisterTask) {
            return true;
        }
        Tuple<Boolean, TaskInst> registerResult = this.registerTask(formParam, false, true, view);
        return (Boolean)registerResult.item1;
    }

    private Tuple<Boolean, TaskInst> registerTask(RuleExecuteFormParam formParam, boolean force, boolean testRegister, IFormView view) {
        Long requestId = DB.genGlobalLongId();
        boolean shouldRegisterTask = this.shouldRegisterTask(formParam.analysisModel);
        boolean taskInstRegistered = false;
        if (shouldRegisterTask) {
            Long creatorId = RequestContext.get().getCurrUserId();
            List orgPeriodList = formParam.orgIds.stream().map(orgId -> {
                HashMap<String, String> orgPeriodIdMap = new HashMap<String, String>(4);
                orgPeriodIdMap.put("orgId", String.valueOf(orgId));
                orgPeriodIdMap.put("periodId", String.valueOf(formParam.periodId));
                return orgPeriodIdMap;
            }).collect(Collectors.toList());
            String businessKey = this.getBusinessKey();
            String businessInfo = this.getBusinessInfo();
            GenericServiceResult registerTaskResult = TaskInstMService.registerTask((Long)formParam.anaModelId, (Long)requestId, orgPeriodList, (Long)creatorId, (boolean)force, (boolean)testRegister, (String)businessKey, (String)businessInfo, (String)TaskInstExecEnum.MANUAL.getCode());
            if (registerTaskResult.getSuccess() == null || !registerTaskResult.getSuccess().booleanValue()) {
                String errorCode = registerTaskResult.getCode();
                if (StringUtils.isEmpty((String)errorCode)) {
                    logger.error("[FI-PA] RuleExecute TaskInst register error");
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6267\u884c\u63d0\u4ea4\u5f02\u5e38\u3002", (String)"PARuleExecuteFormPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return new Tuple((Object)false, null);
                }
                switch (errorCode) {
                    case "201": {
                        view.showConfirm(registerTaskResult.getMessage(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(CALLBACKID_REGISTERTASK, (IFormPlugin)this));
                        break;
                    }
                    case "401": {
                        view.showConfirm(registerTaskResult.getMessage(), MessageBoxOptions.OK);
                        break;
                    }
                    default: {
                        view.showErrorNotification(registerTaskResult.getMessage());
                    }
                }
                return new Tuple((Object)false, null);
            }
            taskInstRegistered = true;
        }
        return new Tuple((Object)true, (Object)new TaskInst(taskInstRegistered, requestId));
    }

    @Override
    protected double getTaskPercent(IDataSimpleWorkTaskStatisticStatus statisticStatus) {
        IDataModel model = this.getModel();
        if (statisticStatus != null) {
            long[] taskProcRecStatistics = statisticStatus.getTaskProcRecStatistics();
            String statusMessage = statisticStatus.getStatusMessage();
            int percent = 0;
            boolean taskEnd = statisticStatus.isTaskEnd();
            boolean withError = statisticStatus.isWithError();
            model.setValue("tipsinfo", null);
            if (withError) {
                model.setValue("executioninfo", (Object)(statusMessage == null ? ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\u3002", (String)"PARuleExecuteFormPlugin_18", (String)"fi-pa-formplugin", (Object[])new Object[0]) : statusMessage));
                percent = -1;
            } else if (!taskEnd) {
                model.setValue("executioninfo", (Object)ResManager.loadKDString((String)"\u89c4\u5219\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u53ef\u524d\u5f80\u76c8\u5229\u80fd\u529b\u5206\u6790-\u4efb\u52a1\u7ba1\u7406\u67e5\u770b\u6267\u884c\u8fdb\u5ea6\u3002", (String)"PARuleExecuteFormPlugin_24", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            } else {
                if (taskProcRecStatistics[3] == 0L) {
                    model.setValue("executioninfo", (Object)ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210\u3002", (String)"PARuleExecuteFormPlugin_22", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                } else {
                    model.setValue("executioninfo", (Object)ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"PARuleExecuteFormPlugin_23", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
                percent = 100;
            }
            return percent;
        }
        return 0.0;
    }

    private void changeImage(String imageUrl) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageKey", imageUrl);
        IFormView view = this.getView();
        view.updateControlMetadata("imageap", data);
    }

    private void openExecutionLogListView(IFormView view, RuleExecuteFormParam formParam) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("pa_executionlog");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setParentFormId(view.getFormShowParameter().getFormId());
        if (formParam.orgIds != null && formParam.orgIds.size() == 1) {
            listShowParameter.setCustomParam("org_field", formParam.orgIds.get(0));
        }
        listShowParameter.setCustomParam("analysis_system", (Object)formParam.anaSystemId);
        listShowParameter.setCustomParam("analysis_model", (Object)formParam.anaModelId);
        listShowParameter.setCustomParam("startperiod", (Object)formParam.periodId);
        view.showForm((FormShowParameter)listShowParameter);
    }

    private void openTaskListView(IFormView view, RuleExecuteFormParam formParam) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("faf_taskmanagement");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setParentFormId(view.getFormShowParameter().getFormId());
        listShowParameter.setCustomParam("analysis_system", (Object)formParam.anaSystemId);
        listShowParameter.setCustomParam("analysis_model", (Object)formParam.anaModelId);
        view.showForm((FormShowParameter)listShowParameter);
    }

    private static class RuleExecuteFormParam {
        private Long anaSystemId;
        private DynamicObject analysisSystem;
        private Long anaModelId;
        private DynamicObject analysisModel;
        private List<Long> orgIds;
        private DynamicObjectCollection orgCol;
        private Long businessPlanId;
        private DynamicObject businessPlan;
        private Long businessRuleId;
        private DynamicObject businessRule;
        private Long periodId;
        private DimensionTypeEnum periodDimType;
        private Date rangeStartDate;
        private Date rangeEndDate;
        private boolean confirmedRegisterTask;
        private boolean confirmedDataReport;
        private boolean confirmedAdjust;

        private RuleExecuteFormParam() {
        }

        public static RuleExecuteFormParam get(IDataModel model) {
            RuleExecuteFormParam formParam = new RuleExecuteFormParam();
            formParam.anaSystemId = (Long)model.getValue("analysis_system_id");
            if (formParam.anaSystemId != null) {
                formParam.analysisSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)formParam.anaSystemId, (String)"pa_anasystemsetting");
            }
            formParam.anaModelId = (Long)model.getValue("analysis_model_id");
            if (formParam.anaModelId != null) {
                formParam.analysisModel = BusinessDataServiceHelper.loadSingleFromCache((Object)formParam.anaModelId, (String)"pa_analysismodel");
            }
            formParam.orgCol = (DynamicObjectCollection)model.getValue("org_field");
            if (formParam.orgCol != null) {
                formParam.orgIds = formParam.orgCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toCollection(ArrayList::new));
            }
            formParam.businessPlanId = (Long)model.getValue("business_plan_id");
            formParam.businessPlan = (DynamicObject)model.getValue("business_plan");
            formParam.businessRuleId = (Long)model.getValue("business_rule_id");
            formParam.businessRule = (DynamicObject)model.getValue("business_rule");
            formParam.periodId = (Long)model.getValue("startperiod_id");
            if (formParam.analysisModel != null) {
                formParam.periodDimType = FormPluginUtil.getDimensionTypeEnumByModelAndDim(formParam.analysisModel, DimensionNecessityEnum.PERIOD.getCode());
            }
            formParam.rangeStartDate = (Date)model.getValue("range_startdate");
            formParam.rangeEndDate = (Date)model.getValue("range_enddate");
            return formParam;
        }

        public boolean verifyRuleExec(IFormView view) {
            return this.verifyAnalysisSystem(view) && this.verifyAnalysisModel(view) && this.verifyOrg(view) && this.verifyBusiPlanOrRule(view) && this.verifyPeriod(view);
        }

        public boolean verifyAnalysisSystem(IFormView view) {
            if (this.analysisSystem == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u6790\u4f53\u7cfb\u3002", (String)"PARuleExecuteFormPlugin_6", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!EnableStatusEnum.enable.getCodeString().equals(this.analysisSystem.getString("enable"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u4f53\u7cfb\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PARuleExecuteFormPlugin_7", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }

        public boolean verifyAnalysisModel(IFormView view) {
            if (this.analysisModel == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u6790\u6a21\u578b\u3002", (String)"PARuleExecuteFormPlugin_8", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!EnableStatusEnum.enable.getCodeString().equals(this.analysisModel.getString("enable"))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5206\u6790\u6a21\u578b\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PARuleExecuteFormPlugin_9", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion(this.analysisModel.getLong("id"));
            if (StringUtils.isNotEmpty((String)modelNewVersionMsg)) {
                view.showTipNotification(modelNewVersionMsg);
                return false;
            }
            return true;
        }

        public boolean verifyOrg(IFormView view) {
            if (this.orgIds == null || this.orgIds.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"PARuleExecuteFormPlugin_11", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }

        private boolean verifyBusiPlanOrRule(IFormView view) {
            QFilter baseFilter = new QFilter("analysissystem", "=", (Object)this.anaSystemId).and(new QFilter("analysismodel", "=", this.analysisModel.get("id")));
            if (this.businessRule != null) {
                if (!"C".equals(this.businessRule.getString("status"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PARuleExecuteFormPlugin_12", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (!EnableStatusEnum.enable.getCodeString().equals(this.businessRule.getString("enable"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PARuleExecuteFormPlugin_13", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return false;
                }
                baseFilter.and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)EnableStatusEnum.enable.getCodeString()));
                Long businessRuleId = this.businessRule.getLong("id");
                String businessRuleName = ((OrmLocaleValue)this.businessRule.get("name")).get((Object)Lang.get().toString());
                for (DynamicObject dynObj : this.orgCol) {
                    if (this.verifyBusinessRule((DynamicObject)dynObj.get(1), baseFilter, businessRuleId, businessRuleName, view)) continue;
                    return false;
                }
                return true;
            }
            if (this.businessPlan != null) {
                if (!EnableStatusEnum.enable.getCodeString().equals(this.businessPlan.getString("enable"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u7ec4\u88ab\u66f4\u6539\u5df2\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PARuleExecuteFormPlugin_14", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                    return false;
                }
                baseFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.enable.getCodeString()));
                Long businessPlanId = this.businessPlan.getLong("id");
                String businessPlanName = ((OrmLocaleValue)this.businessPlan.get("name")).get((Object)Lang.get().toString());
                DynamicObject businessPlanObj = BusinessDataServiceHelper.loadSingleFromCache((Object)businessPlanId, (String)"pa_businessplan");
                DynamicObjectCollection businessPlanRuleEntry = businessPlanObj.getDynamicObjectCollection("pa_businessplan_rule");
                for (DynamicObject dynObj : this.orgCol) {
                    if (this.verifyBusinessPlan((DynamicObject)dynObj.get(1), baseFilter, businessPlanId, businessPlanName, businessPlanRuleEntry, view)) continue;
                    return false;
                }
                return true;
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u7ec4\u548c\u4e1a\u52a1\u89c4\u5219\u81f3\u5c11\u9700\u8981\u586b\u5199\u4e00\u4e2a\u3002", (String)"PARuleExecuteFormPlugin_15", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            return false;
        }

        private boolean verifyBusinessRule(DynamicObject orgDy, QFilter baseFilter, Long businessRuleId, String businessRuleName, IFormView view) {
            Long orgId = orgDy.getLong("id");
            String orgName = ((OrmLocaleValue)orgDy.get("name")).get((Object)Lang.get().toString());
            QFilter[] sumFilter = new QFilter[]{baseFilter, BaseDataServiceHelper.getBaseDataFilter((String)"pa_businessrule", (Long)orgId), new QFilter("id", "=", (Object)businessRuleId)};
            if (!QueryServiceHelper.exists((String)"pa_businessrule", (QFilter[])sumFilter)) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e1a\u52a1\u89c4\u5219\u5728{\u7ec4\u7ec7\uff1a%1$s}\u4e0b\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff1a{%2$s}", (String)"PARuleExecuteFormPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]), orgName, businessRuleName));
                return false;
            }
            return true;
        }

        private boolean verifyBusinessPlan(DynamicObject orgDy, QFilter baseFilter, Long businessPlanId, String businessPlanName, DynamicObjectCollection businessPlanRuleEntry, IFormView view) {
            Long orgId = orgDy.getLong("id");
            String orgName = ((OrmLocaleValue)orgDy.get("name")).get((Object)Lang.get().toString());
            QFilter[] sumFilter = new QFilter[]{baseFilter, BaseDataServiceHelper.getBaseDataFilter((String)"pa_businessplan", (Long)orgId), new QFilter("id", "=", (Object)businessPlanId)};
            if (!QueryServiceHelper.exists((String)"pa_businessplan", (QFilter[])sumFilter)) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u89c4\u5219\u7ec4\u5728{\u7ec4\u7ec7\uff1a%1$s}\u4e0b\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff1a{%2$s}", (String)"PARuleExecuteFormPlugin_17", (String)"fi-pa-formplugin", (Object[])new Object[0]), orgName, businessPlanName));
                return false;
            }
            QFilter[] ruleOrgFilter = new QFilter[]{baseFilter, new QFilter("status", "=", (Object)"C"), BaseDataServiceHelper.getBaseDataFilter((String)"pa_businessrule", (Long)orgId)};
            HashSet ruleIdSet = new HashSet(QueryServiceHelper.queryPrimaryKeys((String)"pa_businessrule", (QFilter[])ruleOrgFilter, null, (int)-1));
            StringBuilder notMatchingBusinessRuleName = new StringBuilder();
            for (DynamicObject entryObj : businessPlanRuleEntry) {
                DynamicObject entryBusinessRule = entryObj.getDynamicObject("rulenumber");
                if (!ruleIdSet.isEmpty() && ruleIdSet.contains(entryBusinessRule.getLong("id"))) continue;
                String businessRuleName = ((OrmLocaleValue)entryBusinessRule.get("name")).get((Object)Lang.get().toString());
                notMatchingBusinessRuleName.append(',').append(businessRuleName);
            }
            if (notMatchingBusinessRuleName.length() > 0) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4e1a\u52a1\u89c4\u5219\u5728{\u7ec4\u7ec7\uff1a%1$s}\u4e0b\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff1a{%2$s}", (String)"PARuleExecuteFormPlugin_16", (String)"fi-pa-formplugin", (Object[])new Object[0]), orgName, notMatchingBusinessRuleName.substring(1)));
                return false;
            }
            return true;
        }

        private boolean verifyPeriod(IFormView view) {
            boolean isDatetimeDimType;
            boolean bl = isDatetimeDimType = DimensionTypeEnum.DATE == this.periodDimType;
            if (!(isDatetimeDimType || this.periodId != null && this.periodId != 0L)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u671f\u95f4\u3002", (String)"PARuleExecuteFormPlugin_10", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (FormPluginUtil.validatePrePeriodStatus(this.anaModelId) && !FormPluginUtil.validatePeriodStatus(this.anaModelId, new HashSet<Long>(this.orgIds), Collections.singleton(this.periodId))) {
                if (this.orgIds.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u671f\u95f4\u4e2d\u6709\u5305\u542b\u5904\u4e8e\u5173\u95ed\u72b6\u6001\u7684\u671f\u95f4\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u76f8\u5e94\u7684\u671f\u95f4\u3002", (String)"PARuleExecuteFormPlugin_25", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5904\u4e8e\u5173\u95ed\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u57fa\u7840\u8bbe\u7f6e\u3011-\u3010\u671f\u95f4\u7ba1\u7406\u3011\u6253\u5f00\u671f\u95f4\u3002", (String)"PARuleExecuteFormPlugin_26", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
            return true;
        }
    }
}

