/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.index;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.pa.dto.DataExecuteParameterDTO;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;
import kd.fi.pa.helper.PAIndexHelper;
import kd.fi.pa.utils.CollectionBuildUtil;

public class DataExecuteHomeCardPlugin
extends GridCardPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"datasyc_success_panel", "datasyc_fail_panel"});
        BasedataEdit anaSystem = (BasedataEdit)this.getControl("anasystem");
        anaSystem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit anaModel = (BasedataEdit)this.getControl("anamodel");
        anaModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit org = (MulBasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DataExecuteParameterDTO dataExecuteParameterByCurUser;
        super.afterCreateNewData(e);
        try {
            dataExecuteParameterByCurUser = PAIndexHelper.getDataExecuteParameterByCurUser();
        }
        catch (Exception exception) {
            throw new KDBizException(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
        }
        List orgIds = dataExecuteParameterByCurUser.getOrgIds();
        this.getModel().setValue("anasystem", (Object)dataExecuteParameterByCurUser.getSystemId());
        this.getModel().setValue("anamodel", (Object)dataExecuteParameterByCurUser.getModelId());
        this.getModel().setValue("org", (Object)(CollectionUtils.isEmpty((Collection)orgIds) ? null : orgIds.toArray()));
        String periodNumber = dataExecuteParameterByCurUser.getPeriodNumber();
        if (StringUtils.isNotBlank((CharSequence)periodNumber)) {
            this.getModel().setValue("period_type", (Object)periodNumber);
            this.getModel().setValue("period", (Object)dataExecuteParameterByCurUser.getPeriod());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.validateParameter()) {
            try {
                this.initializeAdjustBillPanel();
                this.initializeDataSyncPieChart();
                this.initializeRuleExecutePieChart();
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage());
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"data_panel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"default_panel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_panel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"default_panel"});
        }
    }

    public void click(EventObject evt) {
        Map dataSyncMap;
        List fails;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("datasyc_success_panel".equals(key)) {
            Map dataSyncMap2 = PAIndexHelper.getDataSyncSuccessAndFailedIdsByFilter((Long)((Long)this.getModel().getValue("anamodel_id")));
            List successes = (List)dataSyncMap2.get("success");
            if (!CollectionUtils.isEmpty((Collection)successes)) {
                QFilter idFilter = new QFilter("id", "in", successes.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
                this.jumpToPageListWithFilter("pa_tasklog", idFilter);
            }
        } else if ("datasyc_fail_panel".equals(key) && !CollectionUtils.isEmpty((Collection)(fails = (List)(dataSyncMap = PAIndexHelper.getDataSyncSuccessAndFailedIdsByFilter((Long)((Long)this.getModel().getValue("anamodel_id")))).get("failed")))) {
            QFilter idFilter = new QFilter("id", "in", fails.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
            this.jumpToPageListWithFilter("pa_tasklog", idFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Tuple tuple;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("anasystem".equals(key)) {
            this.getModel().beginInit();
            this.getModel().setValue("anamodel", null);
            this.getModel().setValue("period", null);
            this.getModel().endInit();
            this.getView().updateView();
        } else if ("anamodel".equals(key) && (tuple = PAIndexHelper.getCurrentDatePeriodOfModel((DynamicObject)((DynamicObject)this.getModel().getValue("anamodel")))) != null) {
            this.getModel().beginInit();
            this.getModel().setValue("period_type", tuple.item1);
            this.getModel().setValue("period", tuple.item2);
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
            this.getView().updateView();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if ("anasystem".equals(key)) {
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.setSelectedRow(this.getModel().getValue("anasystem_id"));
        } else if ("anamodel".equals(key)) {
            DynamicObject analysisSystem = (DynamicObject)this.getModel().getValue("anasystem");
            if (analysisSystem == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u4f53\u7cfb\u3002", (String)"DataExecuteHomeCardPlugin_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            long anaSystemId = analysisSystem.getLong("id");
            QFilter filter = new QFilter("id", "in", (Object)PAAnalysisModelHelper.queryNonDateNecDimAnalysisModelIdsBySysTemId((Object)anaSystemId));
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.setSelectedRow(this.getModel().getValue("anamodel_id"));
            param.getListFilterParameter().setFilter(filter);
        } else if ("org".equals(key) && !PermissionServiceHelper.isSuperUser((long)this.getCurrentUserId())) {
            QFilter filter;
            if (PermissionServiceHelper.isSuperUser((long)this.getCurrentUserId())) {
                filter = new QFilter("id", "in", (Object)OrgUnitServiceHelper.getAllOrg((String)"15"));
            } else {
                HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)this.getCurrentUserId(), (String)"15", (String)"pa", (String)"pa_apphome_grid", (String)"47150e89000000ac");
                filter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            }
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(filter);
        } else if ("period".equals(key)) {
            DynamicObject anaModel = (DynamicObject)this.getModel().getValue("anamodel");
            if (anaModel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6790\u6a21\u578b\u3002", (String)"DataExecuteHomeCardPlugin_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Long periodDimensionId = anaModel.getDynamicObjectCollection("dimension_entry").stream().filter(dy -> "1".equals(dy.getString("necessity_dim"))).map(dy -> dy.getLong("dimension_id")).findFirst().orElseGet(() -> -1L);
            String periodType = (String)this.getModel().getValue("period_type");
            if ("bd_period".equals(periodType)) {
                QFilter periodTypeFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)PADimensionHelper.loadDimension((Object)periodDimensionId));
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.setSelectedRow(this.getModel().getValue("period_id"));
                param.getListFilterParameter().setFilter(periodTypeFilter);
            }
        }
    }

    private void initializeAdjustBillPanel() {
        int size = 0;
        size = this.getToAuditBillPKs().size();
        Label unAuditLabel = (Label)this.getControl("unaudit");
        unAuditLabel.setText(size + "");
        HashMap<String, String> style = new HashMap<String, String>();
        if (size > 0) {
            style.put("fc", "#666666");
        } else {
            style.put("fc", "#BBBBBB");
        }
        this.getView().updateControlMetadata("unaudit", style);
        size = this.getAdjustFailedBillPKs().size();
        Label failedLabel = (Label)this.getControl("failadjust");
        failedLabel.setText(size + "");
        style = new HashMap();
        if (size > 0) {
            style.put("fc", "#E1453E");
        } else {
            style.put("fc", "#BBBBBB");
        }
        this.getView().updateControlMetadata("failadjust", style);
    }

    private List<Long> getAdjustFailedBillPKs() {
        QFilter commonParameterFilter = this.getAdjustBillParameterFilter();
        QFilter adjustStatusFilter = new QFilter("adjuststatus", "=", (Object)"0");
        DynamicObjectCollection adjustFailedIds = QueryServiceHelper.query((String)"pa_dataadjust", (String)"id", (QFilter[])new QFilter[]{commonParameterFilter, adjustStatusFilter});
        return adjustFailedIds.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private List<Long> getToAuditBillPKs() {
        QFilter commonParameterFilter = this.getAdjustBillParameterFilter();
        QFilter auditStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        DynamicObjectCollection toAuditIds = QueryServiceHelper.query((String)"pa_dataadjust", (String)"id", (QFilter[])new QFilter[]{commonParameterFilter, auditStatusFilter});
        return toAuditIds.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private QFilter getAdjustBillParameterFilter() {
        QFilter systemFilter = new QFilter("analysissystem", "=", this.getModel().getValue("anasystem_id"));
        QFilter modelFilter = new QFilter("analysismodel", "=", this.getModel().getValue("anamodel_id"));
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        QFilter orgFilter = new QFilter("createorg", "in", orgs.stream().map(row -> Long.parseLong(row.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList()));
        QFilter periodFilter = new QFilter("period", "=", this.getModel().getValue("period_id"));
        return systemFilter.and(modelFilter).and(orgFilter).and(periodFilter);
    }

    private void initializeDataSyncPieChart() {
        Map dataSyncMap = PAIndexHelper.getDataSyncSuccessAndFailedIdsByFilter((Long)((Long)this.getModel().getValue("anamodel_id")));
        List successes = (List)dataSyncMap.get("success");
        List fails = (List)dataSyncMap.get("failed");
        int successCount = CollectionUtils.isEmpty((Collection)successes) ? 0 : successes.size();
        int failCount = CollectionUtils.isEmpty((Collection)fails) ? 0 : fails.size();
        Chart chart = (Chart)this.getControl("datasync_piechart");
        chart.setShowTooltip(false);
        chart.setShowLegend(false);
        chart.clearData();
        PieSeries pieSeries = chart.createPieSeries(ResManager.loadKDString((String)"\u6570\u636e\u83b7\u53d6", (String)"DataExecuteHomeCardPlugin_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        pieSeries.setPropValue("color", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"#3dccc0", "#ff8e43"}));
        pieSeries.setPropValue("itemStyle", (Object)CollectionBuildUtil.map((String)"normal", (Object)CollectionBuildUtil.map().kv("borderColor", (Object)"#fff").kv("borderWidth", (Object)5)));
        pieSeries.setPropValue("label", (Object)CollectionBuildUtil.map((String)"normal", (Object)CollectionBuildUtil.map((String)"show", (Object)false)));
        pieSeries.setData(new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u6210\u529f", (String)"DataExecuteHomeCardPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), (Number)successCount), new ItemValue(ResManager.loadKDString((String)"\u5931\u8d25", (String)"DataExecuteHomeCardPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), (Number)failCount)});
        this.getView().updateView("datasync_piechart");
        Label unAuditLabel = (Label)this.getControl("datasync_successes");
        unAuditLabel.setText(successCount + "");
        HashMap<String, String> style = new HashMap<String, String>();
        if (successCount > 0) {
            style.put("fc", "#666666");
        } else {
            style.put("fc", "#BBBBBB");
        }
        this.getView().updateControlMetadata("datasync_successes", style);
        this.getView().updateView("datasync_successes");
        Label failedLabel = (Label)this.getControl("datasync_fails");
        failedLabel.setText(failCount + "");
        style = new HashMap();
        if (failCount > 0) {
            style.put("fc", "#E1453E");
        } else {
            style.put("fc", "#BBBBBB");
        }
        this.getView().updateControlMetadata("datasync_fails", style);
        this.getView().updateView("datasync_fails");
    }

    private void initializeRuleExecutePieChart() {
        Long anaSystemId = (Long)this.getModel().getValue("anasystem_id");
        Long anaModelId = (Long)this.getModel().getValue("anamodel_id");
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        List orgIds = orgs.stream().map(row -> Long.parseLong(row.getDynamicObject("fbasedataid").getPkValue().toString())).collect(Collectors.toList());
        Long periodId = (Long)this.getModel().getValue("period_id");
        Map ruleExecuteSuccessAndFailedIdsByFilter = PAIndexHelper.getRuleExecuteSuccessAndFailedIdsByFilter((Long)anaSystemId, (Long)anaModelId, orgIds, (Long)periodId);
        List successes = (List)ruleExecuteSuccessAndFailedIdsByFilter.get("success");
        List fails = (List)ruleExecuteSuccessAndFailedIdsByFilter.get("failed");
        int successCount = CollectionUtils.isEmpty((Collection)successes) ? 0 : successes.size();
        int failCount = CollectionUtils.isEmpty((Collection)fails) ? 0 : fails.size();
        PieChart chart = (PieChart)this.getControl("ruleexecute_piechart");
        chart.setShowTooltip(false);
        chart.setShowLegend(false);
        chart.clearData();
        chart.setTitlePropValue("text", (Object)("{val|" + (successCount + failCount) + "}"));
        chart.setTitlePropValue("top", (Object)"center");
        chart.setTitlePropValue("left", (Object)"center");
        chart.setTitlePropValue("textStyle", (Object)CollectionBuildUtil.map().kv("rich", (Object)CollectionBuildUtil.map().kv("val", (Object)CollectionBuildUtil.map().kv("fontSize", (Object)16).kv("fontWeight", (Object)"bolder").kv("color", (Object)"#000"))));
        PieSeries pieSeries = chart.createPieSeries(ResManager.loadKDString((String)"\u89c4\u5219\u6267\u884c", (String)"DataExecuteHomeCardPlugin_5", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        pieSeries.setPropValue("color", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"#219CF9", "#ff8e43"}));
        pieSeries.setPropValue("radius", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"75%", "55%"}));
        pieSeries.setPropValue("center", (Object)CollectionBuildUtil.arraylist((Object[])new Object[]{"50%", "50%"}));
        pieSeries.setPropValue("itemStyle", (Object)CollectionBuildUtil.map((String)"normal", (Object)CollectionBuildUtil.map().kv("borderColor", (Object)"#fff").kv("borderWidth", (Object)5)));
        pieSeries.setPropValue("label", (Object)CollectionBuildUtil.map((String)"normal", (Object)CollectionBuildUtil.map((String)"show", (Object)false)));
        pieSeries.setData(new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u6210\u529f", (String)"DataExecuteHomeCardPlugin_3", (String)"fi-pa-formplugin", (Object[])new Object[0]), (Number)successCount), new ItemValue(ResManager.loadKDString((String)"\u5931\u8d25", (String)"DataExecuteHomeCardPlugin_4", (String)"fi-pa-formplugin", (Object[])new Object[0]), (Number)failCount)});
        this.getView().updateView("ruleexecute_piechart");
        Label unAuditLabel = (Label)this.getControl("ruleexecute_success");
        unAuditLabel.setText(successCount + "");
        HashMap<String, String> style = new HashMap<String, String>();
        if (successCount > 0) {
            style.put("fc", "#666666");
        } else {
            style.put("fc", "#BBBBBB");
        }
        this.getView().updateControlMetadata("ruleexecute_success", style);
        this.getView().updateView("ruleexecute_success");
        Label failedLabel = (Label)this.getControl("ruleexecute_fails");
        failedLabel.setText(failCount + "");
        style = new HashMap();
        if (failCount > 0) {
            style.put("fc", "#E1453E");
        } else {
            style.put("fc", "#BBBBBB");
        }
        this.getView().updateControlMetadata("ruleexecute_fails", style);
        this.getView().updateView("ruleexecute_fails");
    }

    private boolean validateParameter() {
        DynamicObject anaSystemId = (DynamicObject)this.getModel().getValue("anasystem");
        DynamicObject anaModelId = (DynamicObject)this.getModel().getValue("anamodel");
        DynamicObjectCollection orgIds = (DynamicObjectCollection)this.getModel().getValue("org");
        DynamicObject periodId = (DynamicObject)this.getModel().getValue("period");
        return anaSystemId != null && anaModelId != null && !CollectionUtils.isEmpty((Collection)orgIds) && periodId != null;
    }

    private Long getCurrentUserId() {
        return RequestContext.get().getCurrUserId();
    }

    private void jumpToPageListWithFilter(String billFormId, QFilter filter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(billFormId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.getListFilterParameter().setFilter(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

