/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.dto.ExecutionLogDTO;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.ExecuteEngineService;
import kd.fi.pa.enums.ExecutionModeEnum;
import kd.fi.pa.enums.ExecutionTypeEnum;
import kd.fi.pa.formplugin.util.ValidatorTipsUtil;
import kd.fi.pa.servicehelper.PeriodServiceHelper;
import kd.fi.pa.utils.ExecutionLogUtil;

public class PAAdjustScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PAAdjustScheduleTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("[FI-PA] PA\u5b9a\u65f6\u8c03\u6574\u5f00\u59cb\uff0c\u5b9a\u65f6\u5165\u53c2\uff1a" + map);
        QFilter filter = new QFilter("billstatus", "=", (Object)"E").and("adjuststatus", "in", (Object)new String[]{"0", "1"});
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pa_dataadjust", (String)"id,analysissystem,analysismodel,createorg,periodbasetype,period,billno", (QFilter[])filter.toArray());
        if (dyoCol != null && dyoCol.size() > 0) {
            HashMap<String, List> dyoMap = new HashMap<String, List>(16);
            HashMap<String, List> idMap = new HashMap<String, List>(16);
            for (DynamicObject dyo : dyoCol) {
                String analysisSystemId = String.valueOf(dyo.get("analysissystem"));
                Object analysisModelId = dyo.get("analysismodel");
                Object createOrgId = dyo.get("createorg");
                Object periodBaseType = dyo.get("periodbasetype");
                Object periodId = dyo.get("period");
                String modelNewVersionMsg = ValidatorTipsUtil.isModelNewVersion((Long)analysisModelId);
                if (StringUtils.isNotEmpty((CharSequence)modelNewVersionMsg)) {
                    logger.info(String.format("[FI-PA] PA-\u5b9a\u65f6\u8c03\u6574\uff1a \u6a21\u578bID\u4e3a {%s} \u662f\u65e7\u6a21\u578b,\u4e0d\u5141\u8bb8\u8c03\u6574.", analysisModelId));
                    continue;
                }
                boolean isOpenPeriod = PeriodServiceHelper.checkSingle((long)((Long)analysisModelId), (long)((Long)createOrgId), (long)((Long)periodId));
                if (!isOpenPeriod) {
                    logger.info(String.format("[FI-PA] PA-\u5b9a\u65f6\u8c03\u6574\uff1a \u7ec4\u7ec7ID\u4e3a {%s} \u7684\u671f\u95f4- {%s} \u5df2\u5173\u95ed, \u4e0d\u5141\u8bb8\u8c03\u6574.", createOrgId, periodId));
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(analysisSystemId).append('|');
                stringBuilder.append(analysisModelId).append('|');
                stringBuilder.append(createOrgId).append('|');
                stringBuilder.append(periodBaseType).append('|');
                stringBuilder.append(periodId).append('|');
                List dyoList = dyoMap.computeIfAbsent(stringBuilder.toString(), k -> new ArrayList(8));
                dyoList.add(dyo);
                List idList = idMap.computeIfAbsent(stringBuilder.toString(), k -> new ArrayList(8));
                idList.add(dyo.getLong("id"));
            }
            ArrayList errorList = new ArrayList(8);
            for (Map.Entry entry : dyoMap.entrySet()) {
                try {
                    ExecutionLogDTO executionLog = ExecutionLogUtil.buildLogDTOByPlainObject((DynamicObject)((DynamicObject)((List)entry.getValue()).get(0)), (String)ExecutionTypeEnum.SYSTEM.getCode(), (List)((List)idMap.get(entry.getKey())), (ExecutionModeEnum)ExecutionModeEnum.adjust);
                    ExecuteEngineService executeEngineService = (ExecuteEngineService)EngineServiceFactory.getExecuteEngineService();
                    executeEngineService.work(executionLog);
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                    errorList.add(entry.getKey());
                }
            }
            if (!errorList.isEmpty()) {
                logger.error(String.format("[FI-PA] PA\u5b9a\u65f6\u8c03\u6574\u6267\u884c\u5b58\u5728\u5931\u8d25\u7684\u7ec4\uff1a%s", String.join((CharSequence)"&&", errorList)));
            }
        } else {
            logger.info("[FI-PA] PA\u5b9a\u65f6\u8c03\u6574\u6682\u65e0\u8c03\u6574\u5355\u9700\u8981\u8c03\u6574\u3002");
        }
    }
}

