/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.pa.enums.ExecuteOperationEnum;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PASyncDataParamHelper;

public class PAFetchDataScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PAFetchDataScheduleTask.class);
    private static final String PARAM_KEY = "syncdataparam";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info(String.format("[FI-PA] FetchData ScheduleTask execute success! map:%s", map));
        if (!this.validate(map)) {
            logger.info("[FI-PA] FetchData ScheduleTask validate error!");
            return;
        }
        Map paramMap = (Map)JSON.parseObject((String)((String)map.get(PARAM_KEY)), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if (paramMap == null) {
            logger.error(String.format("[FI-PA] FetchData the input parameter is null, requestParam:{%s}, paramKey:{%s}", map, PARAM_KEY));
            return;
        }
        Map syncDataParamMap = PASyncDataParamHelper.querySyncDataParam((Long)((Long)paramMap.get("id")), (String)ExecuteOperationEnum.FETCH_DATA.getCode());
        ArrayList paramIds = new ArrayList(syncDataParamMap.size());
        for (Map.Entry entry : syncDataParamMap.entrySet()) {
            Long analysisModelId = ((DynamicObject)entry.getValue()).getLong("model_id");
            if (PAAnalysisModelHelper.isModelNewVersionIgnoreTableNumber((Long)analysisModelId)) continue;
            paramIds.add(entry.getKey());
        }
        if (!paramIds.isEmpty()) {
            Object[] banSyncDataParamDys;
            for (DynamicObject dynamicObject : banSyncDataParamDys = BusinessDataServiceHelper.load((Object[])paramIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pa_syncdataparam"))) {
                syncDataParamMap.remove(dynamicObject.get("id"));
                dynamicObject.set("enable", (Object)"0");
            }
            BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pa_syncdataparam"), (Object[])banSyncDataParamDys);
            logger.info("[FI-PA] FetchData ScheduleTask saveEnable success!");
        }
        DispatchServiceHelper.invokeBizService((String)"macc", (String)"faf", (String)"FAFFetchDataScheduleService", (String)"createManageDataViewTask", (Object[])new Object[]{syncDataParamMap});
    }

    private boolean validate(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        String syncDataParam = (String)map.get(PARAM_KEY);
        if (StringUtils.isEmpty((CharSequence)syncDataParam)) {
            return false;
        }
        Map resultMap = (Map)JSON.parseObject((String)syncDataParam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        String number = (String)resultMap.get("number");
        return !StringUtils.isEmpty((CharSequence)number) && "pa_syncdataparam".equals(number);
    }
}

