/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.pa.dto.DataProcessDTO;
import kd.fi.pa.engine.model.TaskInst;
import kd.fi.pa.engine.service.EngineServiceFactory;
import kd.fi.pa.engine.service.TaskExecuteEngineService;
import kd.fi.pa.enums.ExecuteOperationEnum;
import kd.fi.pa.formplugin.util.FormPluginUtil;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PASyncDataParamHelper;
import kd.fi.pa.servicehelper.PeriodServiceHelper;

public class PARuleExecuteScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PARuleExecuteScheduleTask.class);
    private static final String PARAM_KEY = "syncdataparam";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info(String.format("[FI-PA] RuleExecute ScheduleTask execute success! map:%s", map));
        if (!this.validate(map)) {
            logger.info("[FI-PA] RuleExecute ScheduleTask validate error!");
            return;
        }
        Map paramMap = (Map)JSON.parseObject((String)((String)map.get(PARAM_KEY)), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if (paramMap == null) {
            logger.error(String.format("[FI-PA] RuleExecute the input parameter is null, requestParam:{%s}, paramKey:{%s}", map, PARAM_KEY));
            return;
        }
        Map syncDataParamMap = PASyncDataParamHelper.querySyncDataParam((Long)((Long)paramMap.get("id")), (String)ExecuteOperationEnum.RULE_EXECUTE.getCode());
        ArrayList paramIds = new ArrayList(syncDataParamMap.size());
        for (Map.Entry entry : syncDataParamMap.entrySet()) {
            Long analysisModelId = ((DynamicObject)entry.getValue()).getLong("model_id");
            if (PAAnalysisModelHelper.isModelNewVersionIgnoreTableNumber((Long)analysisModelId)) continue;
            paramIds.add(entry.getKey());
        }
        if (!paramIds.isEmpty()) {
            Object[] banSyncDataParamDys;
            for (DynamicObject dynamicObject : banSyncDataParamDys = BusinessDataServiceHelper.load((Object[])paramIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pa_syncdataparam"))) {
                syncDataParamMap.remove(dynamicObject.get("id"));
                dynamicObject.set("enable", (Object)"0");
            }
            BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pa_syncdataparam"), (Object[])banSyncDataParamDys);
            logger.info("[FI-PA] RuleExecute ScheduleTask saveEnable success!");
        }
        ArrayList executionLogDTOList = new ArrayList();
        List list = DataProcessDTO.batchParseSyncDataParam(syncDataParamMap.values());
        for (DataProcessDTO dataProcessDTO : list) {
            Long l = dataProcessDTO.getAnalysisSystemId();
            Long analysisModelId = dataProcessDTO.getAnalysisModelId();
            Set orgIdSet = dataProcessDTO.getOrgIdSet();
            Set periodIdSet = dataProcessDTO.getPeriodIdSet();
            Date startDate = dataProcessDTO.getStartDate();
            Date endDate = dataProcessDTO.getEndDate();
            Long businessPlanId = dataProcessDTO.getBusinessPlanId();
            Long businessRuleId = dataProcessDTO.getBusinessRuleId();
            boolean validatePrePeriod = FormPluginUtil.validatePrePeriodStatus(analysisModelId);
            if (validatePrePeriod && !PeriodServiceHelper.batchCheckPeriod((long)analysisModelId, (Set)orgIdSet, (Set)periodIdSet)) {
                logger.info("[FI-PA] RuleExecute periodManager check failed");
                continue;
            }
            HashMap<String, Object> logParamMap = new HashMap<String, Object>(10);
            logParamMap.put("systemId", l);
            logParamMap.put("modelId", analysisModelId);
            logParamMap.put("orgIds", orgIdSet);
            if (periodIdSet != null && !periodIdSet.isEmpty()) {
                logParamMap.put("startPeriodId", periodIdSet.iterator().next());
            }
            logParamMap.put("rangeStartDate", startDate);
            logParamMap.put("rangeEndDate", endDate);
            logParamMap.put("businessPlanId", businessPlanId);
            logParamMap.put("businessRuleId", businessRuleId);
            logParamMap.put("executionType", "2");
            try {
                List logDTOList = PAExecutorHelper.processRuleExecute(logParamMap);
                executionLogDTOList.addAll(logDTOList);
            }
            catch (Exception e) {
                logger.error(String.format("[FI-PA] RuleExecute processRuleExecute occur an error, exception:%s", e));
            }
        }
        if (executionLogDTOList.isEmpty()) {
            logger.error("[FI-PA] RuleExecute executionLogDTOList is empty");
            return;
        }
        TaskInst taskInst = new TaskInst(false, Long.valueOf(DB.genGlobalLongId()));
        TaskExecuteEngineService taskExecuteEngineService = (TaskExecuteEngineService)EngineServiceFactory.getTaskExecuteEngineService();
        taskExecuteEngineService.work(executionLogDTOList, taskInst);
    }

    private boolean validate(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return false;
        }
        String syncDataParam = (String)map.get(PARAM_KEY);
        if (StringUtils.isEmpty((CharSequence)syncDataParam)) {
            return false;
        }
        Map resultMap = (Map)JSON.parseObject((String)syncDataParam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        String number = (String)resultMap.get("number");
        return !StringUtils.isEmpty((CharSequence)number) && "pa_syncdataparam".equals(number);
    }
}

