/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.helper.EntityMetaHelper;
import kd.fi.pa.helper.PAExecutorHelper;
import kd.fi.pa.helper.PARuleHelper;
import kd.fi.pa.servicehelper.PeriodServiceHelper;

public class FormPluginUtil {
    private static final QFilter enableFilter = new QFilter("enable", "=", (Object)"1");

    public static DynamicObject getDimension(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null || necessityDim == null) {
            return null;
        }
        DynamicObjectCollection dimEntryCol = anaModel.getDynamicObjectCollection("dimension_entry");
        long dimId = 0L;
        for (DynamicObject dyo : dimEntryCol) {
            if (!necessityDim.equals(dyo.getString("necessity_dim"))) continue;
            dimId = dyo.getLong("dimension_id");
            break;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)dimId, (String)"pa_dimension");
    }

    public static String getBaseEntityId(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null || necessityDim == null) {
            return null;
        }
        DynamicObject dimension = FormPluginUtil.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return null;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
        switch (dimType) {
            case PERIOD: 
            case DATABASE: {
                return dimension.getDynamicObject("dimensionsource").getString("number");
            }
            case ASSISTANTDATA: {
                return "bos_assistantdata_detail";
            }
        }
        return "";
    }

    public static DimensionTypeEnum getDimensionTypeEnumByModelAndDim(DynamicObject anaModel, String necessityDim) {
        DynamicObject dimension = FormPluginUtil.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return DimensionTypeEnum.NOTHING;
        }
        return DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
    }

    public static String getBaseEntityIdByDimension(DynamicObject dimension) {
        if (dimension == null) {
            return null;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
        return DimensionTypeEnum.DATABASE == dimType ? dimension.getDynamicObject("dimensionsource").getString("number") : "bos_assistantdata_detail";
    }

    public static QFilter getBaseQFilter(DynamicObject anaModel, String necessityDim) {
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (anaModel == null || necessityDim == null) {
            return qFilter;
        }
        DynamicObject dimension = FormPluginUtil.getDimension(anaModel, necessityDim);
        if (dimension == null) {
            return qFilter;
        }
        DimensionTypeEnum dimType = DimensionTypeEnum.getEnum((String)dimension.getString("dimensiontype"));
        if (DimensionTypeEnum.DATABASE == dimType) {
            String typeField = dimension.getString("typefield");
            Object groupId = dimension.get("group_id");
            if (StringUtils.isNotEmpty((CharSequence)typeField)) {
                qFilter = new QFilter(typeField, "=", groupId);
            }
        } else if (DimensionTypeEnum.ASSISTANTDATA == dimType) {
            Object groupId = dimension.get("assistantsource_id");
            qFilter = new QFilter("group", "=", groupId);
        }
        return qFilter;
    }

    public static String getBaseEntityColumn(DynamicObject anaModel, String necessityDim) {
        if (anaModel == null) {
            return null;
        }
        String baseEntityId = FormPluginUtil.getBaseEntityId(anaModel, necessityDim);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        List columns = EntityMetaHelper.parseEntryeEtityFields((IDataEntityType)dt, null, null);
        ArrayList<Object> columnList = new ArrayList<Object>(columns.size());
        for (Map map : columns) {
            columnList.add(map.get("shownumber"));
        }
        if (!columnList.contains("id")) {
            columnList.add("id");
        }
        return String.join((CharSequence)",", columnList);
    }

    public static void setItemClassTypeEntityId(Set<String> baseEntityIdSet, DynamicObject anaModel, String necessityDim, String itemClassKey, IDataModel model, IFormView view) {
        if (anaModel == null) {
            return;
        }
        String baseEntityId = FormPluginUtil.getBaseEntityId(anaModel, necessityDim);
        if (StringUtils.isBlank((CharSequence)baseEntityId)) {
            return;
        }
        ItemClassTypeEdit itemClassTypeEdit = (ItemClassTypeEdit)view.getControl(itemClassKey);
        ItemClassTypeProp itemClassTypeProp = (ItemClassTypeProp)itemClassTypeEdit.getProperty();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(baseEntityIdSet.size() + 1);
        for (String entityId : baseEntityIdSet) {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(entityId);
            comboItem.setValue(entityId);
            comboItem.setCaption(EntityMetadataCache.getDataEntityType((String)entityId).getDisplayName());
            items.add(comboItem);
        }
        itemClassTypeEdit.setComboItems(items);
        itemClassTypeProp.setItemType((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)baseEntityId));
        model.setValue(itemClassKey, (Object)baseEntityId);
    }

    public static void processDefaultSysAndModel(IDataModel model, IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object anaSysId = customParams.get("customParamAnaSysId");
        Object anaModelId = customParams.get("customParamAnaModelId");
        if (anaSysId != null) {
            model.setValue("analysissystem", anaSysId);
            if (anaModelId != null) {
                DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", (Object)Long.parseLong((String)anaSysId)).and(enableFilter).and("id", "=", (Object)Long.parseLong((String)anaModelId)).and(PARuleHelper.getAnalysisPeriodFilter())}, (String)"number", (int)1);
                if (anaModel != null && !anaModel.isEmpty()) {
                    model.setValue("analysismodel", (Object)Long.parseLong((String)anaModelId));
                } else {
                    anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", (Object)Long.parseLong((String)anaSysId)).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter())}, (String)"number", (int)1);
                    if (anaModel != null && !anaModel.isEmpty()) {
                        model.setValue("analysismodel", ((DynamicObject)anaModel.get(0)).get("id"));
                    }
                }
            } else {
                DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", (Object)Long.parseLong((String)anaSysId)).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter())}, (String)"number", (int)1);
                if (anaModel != null && !anaModel.isEmpty()) {
                    model.setValue("analysismodel", ((DynamicObject)anaModel.get(0)).get("id"));
                }
            }
        } else {
            DynamicObjectCollection anaSystem = QueryServiceHelper.query((String)"pa_anasystemsetting", (String)"id", (QFilter[])enableFilter.toArray(), (String)"number", (int)1);
            if (anaSystem == null || anaSystem.isEmpty()) {
                return;
            }
            DynamicObjectCollection anaModel = QueryServiceHelper.query((String)"pa_analysismodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("analysis_system", "=", ((DynamicObject)anaSystem.get(0)).get("id")).and(enableFilter).and(PARuleHelper.getAnalysisPeriodFilter())}, (String)"number", (int)1);
            model.setValue("analysissystem", ((DynamicObject)anaSystem.get(0)).get("id"));
            if (anaModel != null && !anaModel.isEmpty()) {
                model.setValue("analysismodel", ((DynamicObject)anaModel.get(0)).get("id"));
            }
        }
    }

    public static Map<String, Map<Object, DynamicObject>> getBaseEntityDataMap(Map<String, Set<Object>> periodIdMap) {
        HashMap<String, Map<Object, DynamicObject>> periodMap = new HashMap<String, Map<Object, DynamicObject>>(periodIdMap.size());
        periodIdMap.forEach((k, v) -> {
            if (!v.isEmpty()) {
                periodMap.put((String)k, BusinessDataServiceHelper.loadFromCache((Object[])v.toArray(), (String)k));
            }
        });
        return periodMap;
    }

    public static boolean exists(String entityName, QFilter[] qFilters) {
        return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
    }

    public static boolean processDateDim(AbstractFormPlugin plugin, DynamicObject analysisModelObj) {
        boolean isDataTime;
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        DimensionTypeEnum dimType = FormPluginUtil.getDimensionTypeEnumByModelAndDim(analysisModelObj, DimensionNecessityEnum.PERIOD.getCode());
        BasedataEdit startPeriodEdit = (BasedataEdit)view.getControl("startperiod");
        FieldEdit dataRangeEdit = (FieldEdit)view.getControl("daterange");
        switch (dimType) {
            case DATE: {
                isDataTime = true;
                model.setValue("startperiod", (Object)"");
                break;
            }
            default: {
                isDataTime = false;
                model.setValue("range_startdate", (Object)"");
                model.setValue("range_enddate", (Object)"");
            }
        }
        view.setVisible(Boolean.valueOf(isDataTime), new String[]{"daterange"});
        view.setVisible(Boolean.valueOf(!isDataTime), new String[]{"startperiod"});
        dataRangeEdit.setMustInput(isDataTime);
        startPeriodEdit.setMustInput(!isDataTime);
        return isDataTime;
    }

    public static boolean validatePeriodStatus(Long analysisModelId, Long orgId, Long periodId) {
        return FormPluginUtil.validatePeriodStatus(analysisModelId, Collections.singleton(orgId), Collections.singleton(periodId));
    }

    public static boolean validatePrePeriodStatus(long analysisModelId) {
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        String entityId = PAExecutorHelper.getBaseEntityId((DynamicObject)model, (String)DimensionNecessityEnum.PERIOD.getCode());
        List<String> entityArr = Arrays.asList("bd_period", "pa_analysisperiod");
        return entityArr.contains(entityId);
    }

    public static boolean validatePeriodStatus(Long analysisModelId, Set<Long> orgIds, Set<Long> periodId) {
        return PeriodServiceHelper.batchCheckPeriod((long)analysisModelId, orgIds, periodId);
    }
}

