/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.pa.enums.DimensionNecessityEnum;
import kd.fi.pa.formplugin.verification.IPaConditionEditProxy;
import kd.fi.pa.formplugin.verification.PaConditionEdit;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;

public class PaAllocationProxy
extends IPaConditionEditProxy {
    private static final Log logger = LogFactory.getLog(PaAllocationProxy.class);

    @Override
    public void afterBindData(EventObject e) {
        FilterCondition filterCondition;
        IFormView view = this.paConditionEdit.getView();
        String conditionJson = (String)view.getFormShowParameter().getCustomParam("customParamConditionJson");
        if (StringUtils.isNotEmpty((CharSequence)conditionJson) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class)) != null) {
            FilterGrid filterGrid = (FilterGrid)view.getControl("ffiltergrid");
            filterGrid.SetValue(filterCondition);
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        IFormView view = this.paConditionEdit.getView();
        IDataModel model = view.getModel();
        if ("btnok".equalsIgnoreCase(control.getKey())) {
            FilterGrid filterGrid = (FilterGrid)view.getControl("ffiltergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition fc = filterGridState.getFilterCondition();
            List filterRow = fc.getFilterRow();
            if (filterRow != null && !filterRow.isEmpty()) {
                String filterFormId = (String)view.getFormShowParameter().getCustomParam("customParamFilterForm");
                MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)filterFormId);
                FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, model);
                filterBuilder.buildFilter(false);
                FilterObject fo = filterBuilder.getFilterObject();
                fc.setFilter(fo.getFilter());
                view.returnDataToParent((Object)SerializationUtils.toJsonString((Object)fc));
                view.close();
                return;
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6709\u6548\u7684\u53d6\u503c\u6761\u4ef6\u3002", (String)"PaAllocationProxy_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.paConditionEdit.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap_expression"});
        String entityNumber = (String)this.paConditionEdit.getView().getFormShowParameter().getCustomParam("customParamFilterForm");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            FilterGrid filterGrid = (FilterGrid)this.paConditionEdit.getView().getControl("ffiltergrid");
            filterGrid.setEntityNumber(entityNumber);
            this.addFilterFieldKeys(filterGrid);
        }
    }

    private void addFilterFieldKeys(FilterGrid filterGrid) {
        ArrayList<String> keys = new ArrayList<String>(8);
        String accountNumber = this.getAccountNumber();
        if (StringUtils.isBlank((CharSequence)accountNumber)) {
            return;
        }
        keys.add(accountNumber + ".number");
        keys.add(accountNumber + ".name");
        List<String> accountField = this.getAccountField();
        if (null == accountField || accountField.isEmpty()) {
            return;
        }
        for (String field : accountField) {
            keys.add(accountNumber + "." + field);
        }
        filterGrid.setFilterFieldKeys(keys);
    }

    private List<String> getAccountField() {
        Object modelId = this.paConditionEdit.getView().getFormShowParameter().getCustomParam("analysismodel");
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModel((Object)modelId);
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dynamicObject : dimensionEntry) {
            if (!"2".equals(dynamicObject.getString("necessity_dim"))) continue;
            return Arrays.stream(dynamicObject.getString("field_number_tag").split(",")).map(String::new).collect(Collectors.toList());
        }
        return null;
    }

    private String getAccountNumber() {
        DynamicObject account = this.getAccount();
        if (!Objects.isNull(account)) {
            return account.getString("number");
        }
        return "";
    }

    private DynamicObject getAccount() {
        Object modelId = this.paConditionEdit.getView().getFormShowParameter().getCustomParam("analysismodel");
        DynamicObject analysisModel = PAAnalysisModelHelper.loadAnalysisModel((Object)modelId);
        DynamicObjectCollection dimensionEntry = analysisModel.getDynamicObjectCollection("dimension_entry");
        for (DynamicObject dynamicObject : dimensionEntry) {
            if (!DimensionNecessityEnum.ACCOUNT.getCode().equals(dynamicObject.getString("necessity_dim"))) continue;
            return dynamicObject.getDynamicObject("dimension");
        }
        return null;
    }

    @Override
    public void beforeF7Select(BeforeFilterF7SelectEvent beforeF7SelectEvent) {
        QFilter dimensionTypeQFilter;
        DynamicObject account = this.getAccount();
        if (Objects.isNull(account)) {
            return;
        }
        String fieldName = beforeF7SelectEvent.getFieldName();
        if (StringUtils.isNotEmpty((CharSequence)fieldName) && (fieldName.split("\\.").length == 2 || fieldName.contains("parent")) && !Objects.isNull(dimensionTypeQFilter = PADimensionHelper.getDimensionTypeQFilter((DynamicObject)account))) {
            List qFilters = beforeF7SelectEvent.getCustomQFilters();
            qFilters.add(dimensionTypeQFilter);
        }
    }

    public PaAllocationProxy(PaConditionEdit paConditionEdit) {
        this.paConditionEdit = paConditionEdit;
    }
}

