/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.verification;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConditionEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.fi.pa.common.util.EntityTreeUtil;
import kd.fi.pa.formplugin.verification.IPaConditionEditProxy;

public class PaConditionEdit
extends ConditionEdit
implements BeforeFilterF7SelectListener {
    public static final String PROXY_CLASS = "PROXY_CLASS";
    IPaConditionEditProxy iproxy;
    IPaConditionEditProxy iproxyCopy;
    BiFunction<TreeNode, String, Boolean> searchExtraJudge;

    public void setSearchExtraJudge(BiFunction<TreeNode, String, Boolean> searchExtraJudge) {
        this.searchExtraJudge = searchExtraJudge;
    }

    public void afterCreateNewData(EventObject e) {
        if (this.iproxy != null) {
            this.iproxy.afterCreateNewData(e);
        } else {
            this.iproxy = this.iproxyCopy;
            super.afterCreateNewData(e);
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
            if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
                filterGrid.setEntityNumber(entityNumber);
            }
        }
    }

    public void initialize() {
        Object proxyClass = this.getView().getFormShowParameter().getCustomParam(PROXY_CLASS);
        if (proxyClass instanceof String) {
            try {
                Class<?> aClass = Class.forName((String)proxyClass);
                if (IPaConditionEditProxy.class.isAssignableFrom(aClass)) {
                    Constructor<?> constructor = aClass.getConstructor(PaConditionEdit.class);
                    this.iproxyCopy = this.iproxy = (IPaConditionEditProxy)constructor.newInstance(new Object[]{this});
                }
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570PROXY_CLASS\u9700\u4e3a\u7ee7\u627fIPaConditionEditProxy\u7684\u4ee3\u7406\u7c7b\u5168\u7c7b\u540d", (String)"PaConditionEdit_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
            catch (NoSuchMethodException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u7c7b\u9700\u63d0\u4f9b\u5165\u53c2PaConditionEdit\u6784\u9020\u65b9\u6cd5", (String)"PaConditionEdit_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u7c7b\u6784\u9020\u5f02\u5e38", (String)"PaConditionEdit_2", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
        }
        if (this.iproxy != null) {
            this.iproxy.initialize();
        }
        super.initialize();
    }

    public void click(EventObject evt) {
        if (this.iproxy != null) {
            this.iproxy.click(evt);
        } else {
            this.iproxy = this.iproxyCopy;
            try {
                super.click(evt);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.iproxy != null) {
            this.iproxy.treeNodeClick(e);
        } else {
            this.iproxy = this.iproxyCopy;
            String nodeId = e.getNodeId().toString();
            String nonFdStr = (String)this.getView().getFormShowParameter().getCustomParam("nonFields");
            if (StringUtils.isNotBlank((CharSequence)nonFdStr)) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                if (!nonSet.contains(nodeId)) {
                    FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeId);
                }
            } else {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeId);
            }
        }
    }

    public void setIproxy(IPaConditionEditProxy iproxy) {
        this.iproxy = iproxy;
    }

    public IPaConditionEditProxy getIproxy() {
        return this.iproxy;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeF7SelectEvent) {
        if (this.iproxy == null) {
            return;
        }
        this.iproxy.beforeF7Select(beforeF7SelectEvent);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(var1 -> {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)var1.getText())) {
                this.searchTreeNode(var1.getText().toLowerCase().trim());
            } else {
                this.rebuildTree(null);
            }
        });
    }

    private void searchTreeNode(String text) {
        String treeNodeString = (String)this.getView().getFormShowParameter().getCustomParams().get("treenodes");
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeString, TreeNode.class);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        boolean hasNode = this.getTreeNodeListByText(node, treeNodes, text);
        TreeView mTree = (TreeView)this.getControl("tv_fields");
        mTree.deleteAllNodes();
        if (hasNode) {
            TreeNode treeNode = EntityTreeUtil.buildBillTree(treeNodes);
            mTree.addNode(treeNode);
            treeNodes.forEach(nod -> {
                List children = nod.getChildren();
                if (children != null && children.size() > 0 && !nod.isExpend()) {
                    nod.setIsOpened(true);
                    mTree.expand(nod.getId());
                }
            });
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u65e0\u7ed3\u679c\u3002", (String)"PaConditionEdit_3", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
    }

    private void rebuildTree(TreeNode treeNode) {
        if (treeNode == null) {
            String treeNodeString = (String)this.getView().getFormShowParameter().getCustomParams().get("treenodes");
            treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeString, TreeNode.class);
        }
        TreeView mTree = (TreeView)this.getControl("tv_fields");
        mTree.deleteAllNodes();
        mTree.addNode(treeNode);
    }

    private boolean getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        boolean extraJudge = true;
        if (this.searchExtraJudge != null) {
            extraJudge = this.searchExtraJudge.apply(node, text);
        }
        boolean sftj = false;
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                boolean hasChild = this.getTreeNodeListByText(child, treeNodes, text);
                sftj = sftj || hasChild;
            }
        }
        if (sftj || node.getText().toLowerCase().contains(text.toLowerCase()) && extraJudge) {
            treeNodes.add(new TreeNode(node.getParentid(), node.getId(), node.getText(), node.getData()));
            return true;
        }
        return false;
    }

    public void afterBindData(EventObject e) {
        if (this.iproxy != null) {
            this.iproxy.afterBindData(e);
        } else {
            this.iproxy = this.iproxyCopy;
            try {
                super.afterBindData(e);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
        }
    }

    protected String tranExpression(String expression) {
        String tranExpressionReturnData = "";
        if (this.iproxy != null) {
            tranExpressionReturnData = this.iproxy.tranExpression(expression);
        } else {
            this.iproxy = this.iproxyCopy;
            tranExpressionReturnData = super.tranExpression(expression);
        }
        return tranExpressionReturnData;
    }
}

