/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.verification;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.JavaTypeParseChecker;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.pa.enums.DimensionTypeEnum;
import kd.fi.pa.formplugin.verification.IPaConditionEditProxy;
import kd.fi.pa.formplugin.verification.PaConditionEdit;
import kd.fi.pa.helper.PAAnalysisModelHelper;
import kd.fi.pa.helper.PADimensionHelper;

public class PaDerivationProxy
extends IPaConditionEditProxy {
    private static final Log logger = LogFactory.getLog(PaDerivationProxy.class);
    private static final Set<String> excludeSet = new HashSet<String>();

    public PaDerivationProxy(PaConditionEdit paConditionEdit) {
        this.paConditionEdit = paConditionEdit;
    }

    @Override
    public void afterCreateNewData(EventObject evt) {
        IFormView view = this.paConditionEdit.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"tabpageap_expression"});
        Long analysisModelId = (Long)view.getFormShowParameter().getCustomParam("analysismodel");
        String entityNumber = (String)view.getFormShowParameter().getCustomParam("customParamFilterForm");
        if (analysisModelId != null && analysisModelId != 0L && StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            FilterGrid filterGrid = (FilterGrid)view.getControl("ffiltergrid");
            this.initFilterGrid(filterGrid, analysisModelId, entityNumber);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        IFormView view = this.paConditionEdit.getView();
        String conditionJson = (String)view.getFormShowParameter().getCustomParam("customParamConditionJson");
        if (StringUtils.isNotEmpty((CharSequence)conditionJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionJson, FilterCondition.class);
            if (filterCondition == null) {
                return;
            }
            FilterGrid filterGrid = (FilterGrid)view.getControl("ffiltergrid");
            filterGrid.SetValue(filterCondition);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        IFormView view = this.paConditionEdit.getView();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            FilterGrid filterGrid = (FilterGrid)view.getControl("ffiltergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            List filterRowList = filterCondition.getFilterRow();
            if (filterRowList == null || filterRowList.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6709\u6548\u7684\u53d6\u503c\u6761\u4ef6\u3002", (String)"PaDerivationProxy_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            String filterFormId = (String)view.getFormShowParameter().getCustomParam("customParamFilterForm");
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)filterFormId);
            FilterBuilder filterBuilder = new FilterBuilder(dataType, filterCondition, true);
            filterBuilder.setUserService((IUserService)view.getService(IUserService.class));
            filterBuilder.buildFilter(false);
            FilterObject filterObject = filterBuilder.getFilterObject();
            filterCondition.setFilter(filterObject.getFilter());
            List filterRow = filterCondition.getFilterRow();
            Map allFilterFields = filterObject.getAllFilterFields();
            for (SimpleFilterRow row : filterRow) {
                String valueOf;
                FilterValue filterValue;
                List value;
                FilterField filterField = (FilterField)allFilterFields.get(row.getFieldName());
                IDataEntityProperty fieldProp = filterField.getFieldProp();
                if (fieldProp.getClass() == DecimalProp.class) {
                    value = row.getValue();
                    filterValue = (FilterValue)value.get(0);
                    valueOf = String.valueOf(filterValue.getValue());
                    if (!valueOf.contains(".")) {
                        filterValue.setValue((Object)(valueOf + ".00"));
                        continue;
                    }
                    if (!valueOf.endsWith(".")) continue;
                    filterValue.setValue((Object)(valueOf + "00"));
                    continue;
                }
                if (fieldProp.getClass() != IntegerProp.class) continue;
                value = row.getValue();
                filterValue = (FilterValue)value.get(0);
                valueOf = String.valueOf(filterValue.getValue());
                try {
                    JavaTypeParseChecker.parseInt((String)valueOf);
                }
                catch (KDBizException kex) {
                    view.showTipNotification(String.format("%1$s\uff1a%2$s", filterField.getCaption(), kex.getMessage()));
                    return;
                }
            }
            view.returnDataToParent((Object)SerializationUtils.toJsonString((Object)filterCondition));
            view.close();
        }
    }

    @Override
    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
        IFormView view = this.paConditionEdit.getView();
        String fieldName = evt.getFieldName();
        Long analysisModelId = (Long)view.getFormShowParameter().getCustomParam("analysismodel");
        DynamicObject modelDy = BusinessDataServiceHelper.loadSingleFromCache((Object)analysisModelId, (String)"pa_analysismodel");
        if (modelDy == null) {
            return;
        }
        String dimNumber = fieldName.split("\\.")[0];
        Long systemId = modelDy.getLong("analysis_system_id");
        QFilter numberFilter = new QFilter("number", "=", (Object)dimNumber);
        QFilter systemFilter = new QFilter("system", "=", (Object)systemId);
        DynamicObject dimDy = BusinessDataServiceHelper.loadSingle((String)"pa_dimension", (QFilter[])new QFilter[]{numberFilter, systemFilter});
        if (dimDy == null) {
            return;
        }
        QFilter dimGroupFilter = PADimensionHelper.getDimGroupFilter((DynamicObject)dimDy);
        if (dimGroupFilter != null) {
            evt.addCustomQFilter(dimGroupFilter);
        }
    }

    private void initFilterGrid(FilterGrid filterGrid, Long analysisModelId, String entityNumber) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        filterGrid.setMainEntityType(mainEntityType);
        filterGrid.setEntityNumber(entityNumber);
        List entityFilterColumnList = EntityTypeUtil.getInstance().createFilterColumns((IDataEntityType)mainEntityType, false);
        Map<String, Map> entityFilterColumnMap = entityFilterColumnList.stream().collect(Collectors.toMap(map -> (String)map.get("fieldName"), map -> map));
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        Set modelFieldSet = PAAnalysisModelHelper.getModelFieldSet((Long)analysisModelId);
        Set dateFieldSet = PAAnalysisModelHelper.getSpecialDimNumberSet((Long)analysisModelId, (DimensionTypeEnum)DimensionTypeEnum.DATE);
        for (String modelField : modelFieldSet) {
            String[] strings;
            if (dateFieldSet != null && !dateFieldSet.isEmpty() && dateFieldSet.contains(modelField)) continue;
            if (modelField.contains(".") && (strings = modelField.split("\\.")).length > 0) {
                fieldSet.add(strings[0] + ".id");
            }
            fieldSet.add(modelField);
        }
        Set textFieldSet = PAAnalysisModelHelper.getSpecialDimNumberSet((Long)analysisModelId, (DimensionTypeEnum)DimensionTypeEnum.OTHER);
        ArrayList<Map> filterColumnList = new ArrayList<Map>();
        for (String field : fieldSet) {
            Map filterColumnMap;
            if (field.endsWith(".id")) {
                Map<String, Object> idFilterColumnMap = this.createIdFilterColumnMap(mainEntityType, field);
                if (idFilterColumnMap == null || idFilterColumnMap.isEmpty()) continue;
                filterColumnList.add(idFilterColumnMap);
                continue;
            }
            if (field.contains(".") || textFieldSet != null && !textFieldSet.isEmpty() && textFieldSet.contains(field)) {
                filterColumnMap = entityFilterColumnMap.get(field);
                if (filterColumnMap == null) continue;
                List compareTypeDtoList = (List)filterColumnMap.get("compareTypes");
                if (compareTypeDtoList != null) {
                    compareTypeDtoList.removeIf(dto -> excludeSet.contains(dto.getId()));
                }
                filterColumnList.add(filterColumnMap);
                continue;
            }
            filterColumnMap = entityFilterColumnMap.get(field);
            if (filterColumnMap == null) continue;
            filterColumnList.add(filterColumnMap);
        }
        filterGrid.setFilterColumns(filterColumnList);
    }

    public Map<String, Object> createIdFilterColumnMap(MainEntityType mainEntityType, String field) {
        String[] strings = field.split("\\.");
        if (strings.length <= 0) {
            return null;
        }
        String propName = strings[0];
        DynamicProperty property = mainEntityType.getProperty(propName);
        List compareTypeDtoList = FilterMetadata.get().getCompareTypes("9");
        if (compareTypeDtoList != null) {
            compareTypeDtoList.removeIf(dto -> !StringUtils.equals((CharSequence)"-1", (CharSequence)dto.getId()) && !StringUtils.equals((CharSequence)"-2", (CharSequence)dto.getId()));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryEntity", mainEntityType.getName());
        map.put("fieldName", field);
        map.put("compareGroupID", "9,");
        map.put("fieldCaption", property.getDisplayName().getLocaleValue());
        map.put("compareTypes", compareTypeDtoList);
        map.put("fieldType", "-5");
        map.put("type", "text");
        return map;
    }

    static {
        excludeSet.add("21");
        excludeSet.add("36");
        excludeSet.add("19");
        excludeSet.add("65");
    }
}

