/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.formplugin.verification;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.formula.excel.FormulaException;
import kd.fi.pa.formplugin.util.CalculateUtils;
import kd.fi.pa.formplugin.verification.IPaConditionEditProxy;
import kd.fi.pa.formplugin.verification.PaConditionEdit;

public class PaIncomeProxy
extends IPaConditionEditProxy {
    @Override
    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        String ctlSourceKey = ctlSource.getKey();
        if ("btnok".equals(ctlSourceKey)) {
            IFormView view = this.paConditionEdit.getView();
            IDataModel model = view.getModel();
            String fexpression = (String)model.getValue("fexpression");
            String ftranexpr = (String)model.getValue("ftranexpr");
            String fextraexpression = (String)model.getValue("fextraexpression");
            String fdescription = (String)model.getValue("fdescription");
            if ("".equals(fexpression)) {
                this.paConditionEdit.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u516c\u5f0f\u8868\u8fbe\u5f0f\u3002", (String)"PaIncomeProxy_0", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!fexpression.equals(ftranexpr)) {
                this.paConditionEdit.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef\u3002", (String)"PaIncomeProxy_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                this.tranExpression(fexpression);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef\u3002", (String)"PaIncomeProxy_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, String> formulaObj = new HashMap<String, String>(3);
            formulaObj.put("expression", fexpression);
            formulaObj.put("fextraexpression", fextraexpression);
            formulaObj.put("description", fdescription);
            this.paConditionEdit.getView().returnDataToParent((Object)SerializationUtils.toJsonString(formulaObj));
            this.paConditionEdit.getView().close();
        }
        if ("btncancel".contains(ctlSourceKey)) {
            this.paConditionEdit.setIproxy(null);
            this.paConditionEdit.click(evt);
        } else if ("clr".equalsIgnoreCase(ctlSourceKey)) {
            this.paConditionEdit.getView().getModel().setValue("fextraexpression", (Object)"");
            this.paConditionEdit.getView().getModel().setValue("fexpression", (Object)"");
            this.paConditionEdit.getView().getModel().setValue("fdescription", (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.paConditionEdit.getView(), (String)"fextraexpression", (int)0);
            FormulaEditHelper.setCursorIndex((IFormView)this.paConditionEdit.getView(), (String)"fexpression", (int)0);
            FormulaEditHelper.setCursorIndex((IFormView)this.paConditionEdit.getView(), (String)"fdescription", (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSourceKey, (CharSequence)"backspace")) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.paConditionEdit.getView(), (String)"backspace", (String)"fextraexpression");
            FormulaEditHelper.backSpaceExpression((IFormView)this.paConditionEdit.getView(), (String)"backspace", (String)"fexpression");
            FormulaEditHelper.backSpaceExpression((IFormView)this.paConditionEdit.getView(), (String)"backspace", (String)"fdescription");
        } else {
            this.clickCompareButton(ctlSourceKey);
        }
    }

    @Override
    public void treeNodeClick(TreeNodeEvent e) {
        String treenodes = (String)this.paConditionEdit.getView().getFormShowParameter().getCustomParam("treenodes");
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treenodes, TreeNode.class);
        String str = e.getNodeId().toString();
        TreeNode clickNode = treeNode.getTreeNode(str, Integer.MAX_VALUE);
        String text = clickNode.getText();
        String name = text.substring(text.indexOf(" ") + 1);
        FormulaEditHelper.insertExpression((IFormView)this.paConditionEdit.getView(), (String)"tv_fields", (String)"fexpression", (String)str);
        FormulaEditHelper.insertExpression((IFormView)this.paConditionEdit.getView(), (String)"tv_fields", (String)"fdescription", (String)name);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.paConditionEdit.setIproxy(null);
        this.paConditionEdit.afterCreateNewData(e);
        this.paConditionEdit.getView().setVisible(Boolean.valueOf(false), new String[]{"tabpageap_condition", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnfunction"});
        this.paConditionEdit.getView().setEnable(Boolean.valueOf(false), new String[]{"fexpression", "fdescription"});
    }

    @Override
    void afterBindData(EventObject e) {
        String fextraexpression = (String)this.paConditionEdit.getView().getFormShowParameter().getCustomParam("fextraexpression");
        if (StringUtils.isBlank((CharSequence)fextraexpression)) {
            fextraexpression = (String)this.paConditionEdit.getView().getModel().getValue("fexpression");
        }
        this.paConditionEdit.getView().getModel().setValue("fextraexpression", (Object)fextraexpression);
        this.paConditionEdit.setIproxy(null);
        this.paConditionEdit.afterBindData(e);
    }

    public PaIncomeProxy(PaConditionEdit paConditionEdit) {
        this.paConditionEdit = paConditionEdit;
    }

    @Override
    public String tranExpression(String expression) {
        this.paConditionEdit.setIproxy(null);
        String expression_desc = expression;
        String fextraexpression = (String)this.paConditionEdit.getView().getModel().getValue("fextraexpression");
        String expression_new = CalculateUtils.format(fextraexpression, p -> "(A" + p + ")");
        String tranExpressionReturnData = "";
        try {
            tranExpressionReturnData = this.paConditionEdit.tranExpression(expression_new);
        }
        catch (Exception e) {
            throw new FormulaException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u9519\u8bef\u3002", (String)"PaIncomeProxy_1", (String)"fi-pa-formplugin", (Object[])new Object[0]));
        }
        if (tranExpressionReturnData.equals(expression_new)) {
            return expression_desc;
        }
        return tranExpressionReturnData;
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        int var4 = -1;
        switch (compareKey.hashCode()) {
            case -1378808635: {
                if (!compareKey.equals("btnadd")) break;
                var4 = 0;
                break;
            }
            case -1378808325: {
                if (!compareKey.equals("btnand")) break;
                var4 = 10;
                break;
            }
            case -1179832642: {
                if (!compareKey.equals("btndivison")) break;
                var4 = 3;
                break;
            }
            case -997791075: {
                if (!compareKey.equals("btnnotequal")) break;
                var4 = 5;
                break;
            }
            case -845487581: {
                if (!compareKey.equals("btnmoreequal")) break;
                var4 = 9;
                break;
            }
            case -616237854: {
                if (!compareKey.equals("btnmultiplication")) break;
                var4 = 2;
                break;
            }
            case -489169518: {
                if (!compareKey.equals("btnlessthen")) break;
                var4 = 6;
                break;
            }
            case 94070079: {
                if (!compareKey.equals("btnor")) break;
                var4 = 11;
                break;
            }
            case 206934115: {
                if (!compareKey.equals("btnleft")) break;
                var4 = 12;
                break;
            }
            case 1497184590: {
                if (!compareKey.equals("btnmorethen")) break;
                var4 = 7;
                break;
            }
            case 1859708056: {
                if (!compareKey.equals("btnsubtraction")) break;
                var4 = 1;
                break;
            }
            case 2002044511: {
                if (!compareKey.equals("btnlessequal")) break;
                var4 = 8;
                break;
            }
            case 2113897048: {
                if (!compareKey.equals("btnequal")) break;
                var4 = 4;
                break;
            }
            case 2125651264: {
                if (!compareKey.equals("btnright")) break;
                var4 = 13;
            }
        }
        switch (var4) {
            case 0: {
                compareValue = "+";
                break;
            }
            case 1: {
                compareValue = "-";
                break;
            }
            case 2: {
                compareValue = "*";
                break;
            }
            case 3: {
                compareValue = "/";
                break;
            }
            case 4: {
                compareValue = "=";
                break;
            }
            case 5: {
                compareValue = "<>";
                break;
            }
            case 6: {
                compareValue = "<";
                break;
            }
            case 7: {
                compareValue = ">";
                break;
            }
            case 8: {
                compareValue = "<=";
                break;
            }
            case 9: {
                compareValue = ">=";
                break;
            }
            case 10: {
                compareValue = "and";
                break;
            }
            case 11: {
                compareValue = "or";
                break;
            }
            case 12: {
                compareValue = "(";
                break;
            }
            case 13: {
                compareValue = ")";
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.paConditionEdit.getView(), (String)compareKey, (String)"fextraexpression", (String)compareValue);
            FormulaEditHelper.insertExpression((IFormView)this.paConditionEdit.getView(), (String)compareKey, (String)"fexpression", (String)compareValue);
            FormulaEditHelper.insertExpression((IFormView)this.paConditionEdit.getView(), (String)compareKey, (String)"fdescription", (String)compareValue);
        }
    }
}

