/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.pa.util;

import java.util.Arrays;
import java.util.Objects;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.list.ListShowParameter;

public class BaseDataUtil {
    public static ListShowParameter createFieldF7ShowParameter(String entitynumber, String propName, boolean isMultiSelect, String selectedRow) {
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entitynumber);
            DynamicProperty property = dataEntityType.getProperty(propName);
            return BaseDataUtil.createF7ShowParameter(((BasedataProp)property).getBaseEntityId(), ((BasedataProp)property).getLayoutId(), isMultiSelect, selectedRow);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public static ListShowParameter createF7ShowParameter(String baseEntityId, boolean isMultiSelect, String selectedRow) {
        return BaseDataUtil.createF7ShowParameter(baseEntityId, baseEntityId, isMultiSelect, selectedRow);
    }

    public static ListShowParameter createF7ShowParameter(String baseEntityId, String layoutId, boolean isMultiSelect, String selectedRow) {
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            layoutId = baseEntityId;
        }
        ListShowParameter lsp = CoreShowFormHelper.createShowListForm((String)layoutId, (boolean)isMultiSelect);
        if (StringUtils.isNotBlank((CharSequence)selectedRow) && !Objects.equals("null", selectedRow)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            ISimpleProperty primaryKey = dataEntityType.getPrimaryKey();
            if (isMultiSelect) {
                Object[] pkIds = Arrays.stream(selectedRow.split(",")).filter(StringUtils::isNotBlank).map(row -> {
                    if (primaryKey instanceof VarcharProp) {
                        return String.valueOf(row);
                    }
                    if (primaryKey instanceof LongProp) {
                        return Long.valueOf(String.valueOf(row));
                    }
                    return null;
                }).distinct().toArray();
                lsp.setSelectedRows(pkIds);
            } else if (primaryKey instanceof VarcharProp) {
                lsp.setSelectedRow((Object)selectedRow);
            } else if (primaryKey instanceof LongProp) {
                lsp.setSelectedRow((Object)Long.valueOf(selectedRow));
            }
        }
        return lsp;
    }
}

