/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.IPropRelPropService;
import kd.hdtc.hrbm.mservice.IHrbmPropreInfoQueryService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class HrbmPropreInfoQueryService
implements IHrbmPropreInfoQueryService {
    private static final Log LOGGER = LogFactory.getLog(HrbmPropreInfoQueryService.class);
    private final IPropRelPropService iPropRelPropService = (IPropRelPropService)ServiceFactory.getService(IPropRelPropService.class);
    private final IPropEntityService propEntityService = (IPropEntityService)ServiceFactory.getService(IPropEntityService.class);
    private final ILogicEntityEntityService logicEntityEntityService = (ILogicEntityEntityService)ServiceFactory.getService(ILogicEntityEntityService.class);

    public Map<String, Object> queryHrbmPropreInfoByNumber(String number) {
        LOGGER.info(String.format(Locale.ROOT, "queryHrbmPropreInfoByNumber start : number %s", number));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (HRStringUtils.isEmpty((String)number)) {
            this.bulidErrorMsg(resultMap, "Input parameter number is null");
            return resultMap;
        }
        QFilter qFilter = new QFilter("number", "in", (Object)number);
        qFilter.and("deleted", "=", (Object)"0");
        List logicEntityDyList = this.logicEntityEntityService.queryOriginalList("id,pid,mainentity", qFilter.and(QFilterConstants.Q_ENABLE).toArray());
        if (CollectionUtils.isEmpty((Collection)logicEntityDyList)) {
            this.bulidErrorMsg(resultMap, "number is not exists");
            return resultMap;
        }
        DynamicObject logicEntityDy = (DynamicObject)logicEntityDyList.get(0);
        long pid = logicEntityDy.getLong("pid");
        if (logicEntityDy.getBoolean("mainentity")) {
            pid = logicEntityDy.getLong("id");
        }
        qFilter = new QFilter("logicentity.pid", "=", (Object)pid);
        qFilter.and("logicentity.deleted", "=", (Object)"0");
        List propDyList = this.propEntityService.queryOriginalList("id", qFilter.and(QFilterConstants.Q_ENABLE).toArray());
        if (CollectionUtils.isEmpty((Collection)propDyList)) {
            this.bulidErrorMsg(resultMap, "result is null");
            return resultMap;
        }
        DynamicObject[] propRelDyArr = this.iPropRelPropService.getPropRelByPropIds(propDyList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList()), "B1");
        ArrayList propRelList = new ArrayList();
        if (propRelDyArr != null && propRelDyArr.length > 0) {
            for (DynamicObject propRelDy : propRelDyArr) {
                HashMap<String, Object> propRelMap = new HashMap<String, Object>();
                propRelMap.put("sourceProp", HRDyObjectPropUtil.getId((DynamicObject)propRelDy.getDynamicObject("sourceprop")));
                propRelMap.put("targetProp", HRDyObjectPropUtil.getId((DynamicObject)propRelDy.getDynamicObject("targetprop")));
                propRelMap.put("sourceEntityNumber", propRelDy.getDynamicObject("sourceprop").getDynamicObject("logicentity") != null ? propRelDy.getString("sourceprop.logicentity.number") : "");
                propRelMap.put("targetEntityNumber", propRelDy.getDynamicObject("targetprop").getDynamicObject("logicentity") != null ? propRelDy.getString("targetprop.logicentity.number") : "");
                propRelList.add(propRelMap);
            }
        }
        resultMap.put("data", propRelList);
        resultMap.put("success", true);
        LOGGER.info("queryHrbmPropreInfoByNumber end");
        return resultMap;
    }

    private void bulidErrorMsg(Map<String, Object> resultMap, String errorMsg) {
        resultMap.put("errorMsg", errorMsg);
        resultMap.put("success", false);
    }
}

