/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.common;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.interceptor.ExceptionInterceptor;
import kd.hdtc.hrdbs.common.util.ServiceFactoryUtils;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public class ServiceFactory {
    private static final Log LOG = LogFactory.getLog(ServiceFactory.class);
    private static final boolean USE_PROXY = true;
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();
    private static volatile boolean inited = false;
    private static final Map<String, String> SCAN_PACKAGE_MAP = ImmutableMap.builder().put((Object)"kd.hdtc.hrbm.business.domain.model", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.task", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.model.entity", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.task.entity", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.file", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.tool", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.tool.entity", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.task.tools", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.extcase", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.extcase.entity", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.extcase.wtc", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.extcase.entity.wtc", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.extcase.entity.sihc", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.baseconfig", (Object)"").put((Object)"kd.hdtc.hrbm.business.domain.baseconfig.entity", (Object)"").put((Object)"kd.hdtc.hrbm.business.application.external", (Object)"").put((Object)"kd.hdtc.hrbm.business.application.external.entity", (Object)"").build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initServiceMap() {
        if (inited) return;
        Class<ServiceFactory> clazz = ServiceFactory.class;
        synchronized (ServiceFactory.class) {
            if (inited) return;
            SERVICE_MAP.putAll(ServiceFactoryUtils.getServiceInfo(SCAN_PACKAGE_MAP));
            inited = true;
            LOG.info("ServiceFactory inited, {} service inited", (Object)SERVICE_MAP.size());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static <T> T getService(Class<T> clazz) {
        return ServiceFactory.createProxyService(ServiceFactory.getService(clazz.getSimpleName()), clazz);
    }

    public static <T> T createInstance(Class<T> clazz) {
        return ServiceFactory.createProxyService(TypesContainer.createInstance((String)ServiceFactory.getServiceName(clazz.getSimpleName())), clazz);
    }

    public static Object getService(String serviceName) {
        return TypesContainer.getOrRegisterSingletonInstance((String)ServiceFactory.getServiceName(serviceName));
    }

    private static String getServiceName(String serviceName) {
        ServiceFactory.initServiceMap();
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"hrmp-hric-common", (Object[])new Object[0]), serviceName));
        }
        return className;
    }

    private static <T> T createProxyService(Object obj, Class<T> clazz) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)new ExceptionInterceptor(obj));
        return (T)enhancer.create();
    }
}

