/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.common.metadatafield.parse;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class BaseDataMetaDataFieldParser
implements IMetaDataFieldParser<Map<String, Object>> {
    @Override
    public Map<String, Object> parseItems(String fieldConfig) {
        if (StringUtils.isEmpty((String)fieldConfig)) {
            return null;
        }
        Map items = (Map)SerializationUtils.fromJsonString((String)fieldConfig, Map.class);
        return items;
    }

    @Override
    public String parseAlias(String fieldConfig) {
        Object items = this.parseItems(fieldConfig);
        if (CollectionUtils.isNotEmpty((Map)items)) {
            Map alias = (Map)items.get("caption");
            return (String)alias.get(Lang.get().toString());
        }
        return null;
    }

    @Override
    public String getMetaDataNumber() {
        return "hrbm_database_page";
    }

    @Override
    public String fieldConfigContent(EntityItem<?> entityItem) {
        HashMap<String, Object> items = new HashMap<String, Object>(16);
        if (entityItem instanceof BasedataField) {
            BasedataField basedataField = (BasedataField)entityItem;
            this.getDataBaseItem(items, basedataField);
        } else if (entityItem instanceof AdminDivisionField) {
            this.getAdminDivisionItem(items);
        } else if (entityItem instanceof MulBasedataField) {
            MulBasedataField mulBasedataField = (MulBasedataField)entityItem;
            this.getMulDataBaseItem(items, mulBasedataField);
        }
        return SerializationUtils.toJsonString(items);
    }

    private void getAdminDivisionItem(Map<String, Object> items) {
        String id = MetadataDao.getIdByNumber((String)"bd_admindivision", (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
        items.put("value", id);
        if (entityMetadata != null) {
            items.put("caption", entityMetadata.getName());
            items.put("id", entityMetadata.getKey());
        }
    }

    private void getDataBaseItem(Map<String, Object> items, BasedataField basedataField) {
        items.put("value", basedataField.getBaseEntityId());
        EntityMetadata entityMetadata = basedataField.getRefBaseEntityMeta();
        if (entityMetadata != null) {
            items.put("caption", entityMetadata.getName());
            items.put("id", entityMetadata.getKey());
        } else {
            items.put("caption", basedataField.getName());
        }
    }

    private void getMulDataBaseItem(Map<String, Object> items, MulBasedataField mulBasedataField) {
        String baseEntityId = mulBasedataField.getBaseEntityId();
        FormMetadata metadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)baseEntityId, (MetaCategory)MetaCategory.Form);
        items.put("value", baseEntityId);
        items.put("id", metadata.getKey());
        items.put("caption", metadata.getName());
    }
}

