/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.common.metadatafield.parse;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.metadatafield.parse.BaseDataMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.BaseDataPropMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.ComboMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.DecimalMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.TextMetaDataFieldParser;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class MetaDataFieldParserFactory {
    public static final Map<String, String> META_FIELD_MAP = ImmutableMap.builder().put((Object)"kd.bos.metadata.entity.commonfield.TextField", (Object)"TextField").put((Object)"kd.bos.metadata.entity.commonfield.TelephoneField", (Object)"TextField").put((Object)"kd.bos.metadata.entity.businessfield.BillNoField", (Object)"TextField").put((Object)"kd.bos.metadata.entity.commonfield.TextAreaField", (Object)"TextField").put((Object)"kd.bos.metadata.entity.commonfield.MuliLangTextField", (Object)"MuliLangTextField").put((Object)"kd.bos.metadata.entity.commonfield.LargeTextField", (Object)"LargeTextField").put((Object)"kd.bos.metadata.entity.businessfield.BasedataField", (Object)"BasedataField").put((Object)"kd.bos.metadata.entity.businessfield.UserField", (Object)"BasedataField").put((Object)"kd.bos.ext.hr.metadata.field.PersonField", (Object)"BasedataField").put((Object)"kd.bos.ext.hr.metadata.field.HisModelBasedataField", (Object)"BasedataField").put((Object)"kd.bos.metadata.entity.businessfield.MulBasedataField", (Object)"MulBasedataField").put((Object)"kd.bos.metadata.entity.commonfield.DateField", (Object)"DateField").put((Object)"kd.bos.metadata.entity.commonfield.DateTimeField", (Object)"DateTimeField").put((Object)"kd.bos.metadata.entity.commonfield.ComboField", (Object)"ComboField").put((Object)"kd.bos.metadata.entity.commonfield.RadioGroupField", (Object)"ComboField").put((Object)"kd.bos.metadata.entity.commonfield.MulComboField", (Object)"MulComboField").put((Object)"kd.bos.metadata.entity.commonfield.CheckBoxField", (Object)"CheckBoxField").put((Object)"kd.bos.metadata.entity.commonfield.IntegerField", (Object)"IntegerField").put((Object)"kd.bos.metadata.entity.commonfield.BigIntField", (Object)"BigIntField").put((Object)"kd.bos.metadata.entity.commonfield.DecimalField", (Object)"DecimalField").put((Object)"kd.bos.metadata.entity.businessfield.AmountField", (Object)"AmountField").put((Object)"kd.bos.metadata.entity.commonfield.AttachmentField", (Object)"AttachmentField").put((Object)"kd.bos.metadata.form.control.AttachmentPanelAp", (Object)"AttachmentPanelAp").put((Object)"kd.bos.metadata.entity.commonfield.PictureField", (Object)"PictureField").put((Object)"kd.bos.metadata.entity.businessfield.CreaterField", (Object)"CreaterField").put((Object)"kd.bos.metadata.entity.businessfield.CreateDateField", (Object)"CreateDateField").put((Object)"kd.bos.metadata.entity.businessfield.ModifierField", (Object)"ModifierField").put((Object)"kd.bos.metadata.entity.businessfield.ModifyDateField", (Object)"ModifyDateField").put((Object)"kd.bos.metadata.entity.businessfield.BillStatusField", (Object)"BillStatusField").put((Object)"kd.bos.metadata.entity.businessfield.MasterIdField", (Object)"MasterIdField").put((Object)"kd.bos.metadata.entity.businessfield.OrgField", (Object)"BasedataField").put((Object)"kd.bos.metadata.entity.commonfield.TimeField", (Object)"TimeField").build();
    public static String ATTACHMENT_PANEL_AP_CLASS = "kd.bos.metadata.form.control.AttachmentPanelAp";

    public static IMetaDataFieldParser getMetaDataFieldParserByFieldType(EntityItem<?> item) {
        if (item instanceof TextField || item instanceof TelephoneField || item instanceof EmailField) {
            return new TextMetaDataFieldParser();
        }
        if (item instanceof BasedataField || item instanceof MulBasedataField || item instanceof AdminDivisionField) {
            return new BaseDataMetaDataFieldParser();
        }
        if (item instanceof DecimalField) {
            return new DecimalMetaDataFieldParser();
        }
        if (item instanceof ComboField) {
            return new ComboMetaDataFieldParser();
        }
        if (item instanceof BasedataPropField) {
            return new BaseDataPropMetaDataFieldParser();
        }
        return null;
    }

    public static IMetaDataFieldParser getMetaDataFieldParser(String fieldType) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldType(fieldType);
        if (FieldTypeEnum.TEXTFIELD == fieldTypeEnum || FieldTypeEnum.MULILANGTEXTFIELD == fieldTypeEnum || FieldTypeEnum.LARGETEXTFIELD == fieldTypeEnum) {
            return new TextMetaDataFieldParser();
        }
        if (FieldTypeEnum.HISBASEDATAFIELD == fieldTypeEnum) {
            return new BaseDataMetaDataFieldParser();
        }
        if (FieldTypeEnum.BASEDATAFIELD == fieldTypeEnum || FieldTypeEnum.MULBASEDATAFIELD == fieldTypeEnum) {
            return new BaseDataMetaDataFieldParser();
        }
        if (FieldTypeEnum.DECIMALFIELD == fieldTypeEnum || FieldTypeEnum.AMOUNTFIELD == fieldTypeEnum) {
            return new DecimalMetaDataFieldParser();
        }
        if (FieldTypeEnum.COMBOFIELD == fieldTypeEnum || FieldTypeEnum.MULCOMBOFIELD == fieldTypeEnum || FieldTypeEnum.BILLSTATUSFIELD == fieldTypeEnum) {
            return new ComboMetaDataFieldParser();
        }
        if (FieldTypeEnum.BASEDATAPROPFIELD == fieldTypeEnum) {
            return new BaseDataPropMetaDataFieldParser();
        }
        return null;
    }

    public static IMetaDataFieldParser getMetaDataFieldParserByClassName(String fieldClassName) {
        String fieldType = META_FIELD_MAP.get(fieldClassName);
        if (StringUtils.isEmpty((String)fieldType)) {
            return null;
        }
        return MetaDataFieldParserFactory.getMetaDataFieldParser(fieldType);
    }

    public static String getAttachmentPanelClassName() {
        return ATTACHMENT_PANEL_AP_CLASS;
    }
}

